/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.ninepatch;

import com.miui.theme.tool.ninepatch.NinePatchDecoder;
import com.miui.theme.tool.ninepatch.NinePatchEncoder;
import com.miui.theme.tool.ninepatch.NinePatchPngFormatException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NinePatchUtils {
    public static void compile(String fn1) throws NinePatchPngFormatException, IOException {
        File f = new File(fn1);
        if (f.isDirectory()) {
            File[] listFile;
            File[] fileArray = listFile = f.listFiles();
            int n = listFile.length;
            int n2 = 0;
            while (n2 < n) {
                File ea = fileArray[n2];
                NinePatchUtils.compile(ea.getAbsolutePath());
                ++n2;
            }
        } else if (f.isFile() && f.getName().toLowerCase().endsWith(".9.png")) {
            NinePatchEncoder d = new NinePatchEncoder();
            d.encode(fn1, fn1);
        }
    }

    public static void decompile(String fn) {
        block4: {
            File f;
            block3: {
                File[] listFile;
                f = new File(fn);
                if (!f.isDirectory()) break block3;
                File[] fileArray = listFile = f.listFiles();
                int n = listFile.length;
                int n2 = 0;
                while (n2 < n) {
                    File ea = fileArray[n2];
                    NinePatchUtils.decompile(ea.getAbsolutePath());
                    ++n2;
                }
                break block4;
            }
            if (!f.isFile() || !f.getName().toLowerCase().endsWith(".9.png")) break block4;
            try {
                NinePatchDecoder.decode(fn, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean compileSinglePng(String inputFileName, OutputStream out) throws IOException, NinePatchPngFormatException {
        FileInputStream in = new FileInputStream(inputFileName);
        NinePatchEncoder en = new NinePatchEncoder();
        return en.encode(in, out);
    }

    public static ByteArrayInputStream compileSinglePng(InputStream in) throws NinePatchPngFormatException, IOException {
        ByteArrayInputStream in2 = null;
        NinePatchEncoder en = new NinePatchEncoder();
        in2 = en.encode(in);
        return in2;
    }

    public static void getBytesFromInt(byte[] targets, int start_pos, int N) {
        targets[start_pos + 3] = (byte)(N & 0xFF);
        targets[start_pos + 2] = (byte)(N >> 8 & 0xFF);
        targets[start_pos + 1] = (byte)(N >> 16 & 0xFF);
        targets[start_pos] = (byte)(N >>> 24);
    }
}

