/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.resourceeditor;

import com.miui.theme.tool.gui.MainFrame;
import com.miui.theme.tool.gui.ResourceReplacePanel;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.resourceeditor.ImageReplacePanel;
import com.miui.theme.tool.resourceeditor.NinePJPanel;
import com.miui.theme.tool.resourceeditor.Notifier;
import com.miui.theme.tool.resourceeditor.Resource;
import com.miui.theme.tool.resourceeditor.ResourceMainPanel;
import com.miui.theme.tool.resourceeditor.ScreenshotXml;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.GridBagHelper;
import com.miui.theme.tool.util.ThemeHelper;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class CenterReplacePanel
extends JPanel
implements Observer,
WindowFocusListener {
    private ResourceMainPanel mResourceMainPanel;
    private ScreenshotXml mScreenshotXml;
    private BufferedImage mScreenshotImage;
    private ImageReplacePanel mImageReplacePanel;
    private JPanel mRightPanel;
    private Notifier mNotifier;
    private Vector<Resource> mSelectedResources;
    private JScrollPane mImageReplacePanelScroll;
    String mRightLastTitle;
    HashMap<String, JPanel> mFolderPanelMap;
    ResourceReplacePanel.ReplaceActionListener ral = new ResourceReplacePanel.ReplaceActionListener(){

        @Override
        public void onWait() {
            CenterReplacePanel.this.mRightPanel.setCursor(Cursor.getPredefinedCursor(3));
        }

        @Override
        public void onRefresh() {
            CenterReplacePanel.this.refreshRight();
        }
    };
    private JTabbedPane mRightTabbedPane;

    public CenterReplacePanel(ResourceMainPanel rep) {
        this.mResourceMainPanel = rep;
        this.loadImage();
        this.mImageReplacePanel = new ImageReplacePanel(this.mScreenshotImage);
        this.mImageReplacePanelScroll = new JScrollPane();
        this.mImageReplacePanelScroll.setViewportView(this.mImageReplacePanel);
        this.mImageReplacePanel.bindResources(this.mScreenshotXml.mResources);
        this.mRightPanel = this.mResourceMainPanel.mRightPanel;
        this.initRightPanelWithAnnotation();
        this.initNotifier();
        this.mImageReplacePanel.bindNotifier(this.mNotifier);
        this.bindWindowFocusListener();
        this.setLayout(new GridBagLayout());
        GridBagHelper.addComponent(this, this.mImageReplacePanelScroll, 0, 0, 1, 1, 0, 0, 0, 0, 1.0, 1.0, 1, 11);
    }

    public static void unbindWindowFocusListener() {
        WindowFocusListener[] wfl;
        WindowFocusListener[] windowFocusListenerArray = wfl = MainFrame.getInstance().getWindowFocusListeners();
        int n = wfl.length;
        int n2 = 0;
        while (n2 < n) {
            WindowFocusListener w = windowFocusListenerArray[n2];
            MainFrame.getInstance().removeWindowFocusListener(w);
            ++n2;
        }
    }

    public void bindWindowFocusListener() {
        MainFrame.getInstance().addWindowFocusListener(this);
    }

    private void initRightPanel() {
        this.mRightPanel.removeAll();
        this.mRightPanel.setLayout(new GridBagLayout());
        int gap = 0;
        this.mRightTabbedPane = new JTabbedPane();
        for (String key : this.mFolderPanelMap.keySet()) {
            JPanel p = this.mFolderPanelMap.get(key);
            this.mRightTabbedPane.addTab(key, new JScrollPane(p));
            GridBagHelper.addComponent(p, new JLabel(""), 0, 100, 1, 1, 0, 0, 0, gap, 0.0, 1.0, 1, 17);
        }
        GridBagHelper.addComponent(this.mRightPanel, this.mRightTabbedPane, 0, 0, 1, 1, 0, 0, gap, gap, 1.0, 1.0, 1, 17);
        if (this.mRightLastTitle != null) {
            int i = 0;
            while (i < this.mRightTabbedPane.getTabCount()) {
                if (this.mRightTabbedPane.getTitleAt(i).equals(this.mRightLastTitle)) {
                    this.mRightTabbedPane.setSelectedIndex(i);
                }
                ++i;
            }
        }
        this.mRightPanel.validate();
        this.mRightPanel.repaint();
    }

    private void initRightPanelWithAnnotation() {
        int gap = 20;
        this.mRightPanel.removeAll();
        this.mRightPanel.setLayout(new GridBagLayout());
        JLabel label = new JLabel(ResourceFactory.getString("screenshot_annotation"));
        JLabel annotation = new JLabel("<html>" + this.mScreenshotXml.mAnnotation + "<br/><br/></html>");
        GridBagHelper.addComponent(this.mRightPanel, label, 0, 0, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 0, 17);
        GridBagHelper.addComponent(this.mRightPanel, annotation, 0, 1, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 0, 17);
        JLabel lb = new JLabel();
        GridBagHelper.addComponent(this.mRightPanel, lb, 0, 2, 1, 1, 0, 0, 0, 0, 1.0, 1.0, 0, 11);
        this.mRightPanel.validate();
        this.mRightPanel.repaint();
    }

    public void initNotifier() {
        this.mNotifier = new Notifier();
        this.mNotifier.addObserver(this);
    }

    private void loadImage() {
        this.mScreenshotXml = this.mResourceMainPanel.mCurrentScreenshotXml;
        if (this.mScreenshotXml == null) {
            return;
        }
        File f = this.mScreenshotXml.mFile;
        try {
            FileInputStream fis = new FileInputStream(f);
            this.mScreenshotImage = ImageIO.read(f);
            fis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof Vector) {
            this.mSelectedResources = (Vector)arg;
        }
        this.refreshRight();
    }

    public void refreshRight() {
        this.mRightPanel.setCursor(Cursor.getPredefinedCursor(0));
        if (this.mSelectedResources == null) {
            return;
        }
        if (this.mSelectedResources.size() > 0) {
            if (this.mRightTabbedPane != null) {
                this.mRightLastTitle = this.mRightTabbedPane.getTitleAt(this.mRightTabbedPane.getSelectedIndex());
            }
            this.showResourcePaths(this.mSelectedResources);
        } else {
            this.initRightPanelWithAnnotation();
        }
    }

    private void defaultResourceSelection() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (((CenterReplacePanel)CenterReplacePanel.this).mScreenshotXml.mResources.size() <= 0) {
                    return;
                }
            }
        });
    }

    public JPanel getFolderPanel(String path) {
        String panelName = ThemeHelper.getFolderName(path);
        if (!this.mFolderPanelMap.containsKey(panelName)) {
            NinePJPanel p = new NinePJPanel();
            p.setLayout(new GridBagLayout());
            this.mFolderPanelMap.put(panelName, p);
        }
        return this.mFolderPanelMap.get(panelName);
    }

    public void showResourcePaths(Vector<Resource> resources) {
        int level = 1;
        int gap = 15;
        this.mFolderPanelMap = new HashMap();
        int i = 0;
        while (i < resources.size()) {
            Resource resource = resources.get(i);
            Vector<String> mPaths = resource.mPaths;
            Vector<String> mPathDescriptions = resource.mPathDescriptions;
            int j = 0;
            while (j < mPaths.size()) {
                JPanel p = this.getFolderPanel(mPaths.get(j));
                String catalogResourcePath = String.valueOf(this.mResourceMainPanel.mPackageResourceCatalogPath) + File.separator + mPaths.get(j);
                String replaceResourcePath = String.valueOf(this.mResourceMainPanel.mPackageReplacePath) + File.separator + mPaths.get(j);
                File catalogResourceFile = new File(catalogResourcePath);
                File replaceResourceFile = new File(replaceResourcePath);
                String description = String.valueOf(resource.mWidth) + "x" + resource.mHeight;
                if (catalogResourceFile.exists()) {
                    BufferedImage image = GUIUtil.getImage(catalogResourceFile);
                    description = String.valueOf(image.getWidth()) + "x" + image.getHeight();
                }
                if (!mPathDescriptions.get(j).isEmpty()) {
                    description = String.valueOf(description) + "," + mPathDescriptions.get(j);
                }
                ResourceReplacePanel rrp = new ResourceReplacePanel(String.valueOf(catalogResourceFile.getName()) + "," + description, catalogResourceFile, replaceResourceFile, this.ral);
                GridBagHelper.addComponent(p, rrp, 0, level++, 1, 1, 0, 0, 0, gap, 1.0, 0.0, 0, 17);
                ++j;
            }
            ++i;
        }
        this.initRightPanel();
        this.mRightPanel.validate();
        this.mRightPanel.repaint();
        this.mRightPanel.updateUI();
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        this.refreshRight();
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
    }
}

