/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.resourceeditor;

import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.resourceeditor.Notifier;
import com.miui.theme.tool.resourceeditor.PointRectangle;
import com.miui.theme.tool.resourceeditor.Resource;
import com.miui.theme.tool.resourceeditor.SelectableJPanel;
import com.miui.theme.tool.util.GUIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class ImageEditorPanel
extends SelectableJPanel
implements Observer {
    protected BufferedImage mImage;
    private int mWidth;
    private int mHeight;
    protected double mScale;
    protected Vector<Resource> mSelected;
    int active = 0;
    private Resource mCurrentResource;
    protected PointRectangle[] mSelections;
    protected Vector<Resource> mResources;
    protected Notifier mNotifier;
    private boolean lockResource = false;
    boolean mDragingFlag = false;
    MouseAdapter rma = new MouseAdapter(){

        @Override
        public void mouseDragged(MouseEvent e) {
            ImageEditorPanel.this.mDragingFlag = true;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!ImageEditorPanel.this.mDragingFlag) {
                ImageEditorPanel.this.mSelected = new Vector();
                int i = 0;
                while (i < ImageEditorPanel.this.mSelections.length) {
                    if (ImageEditorPanel.this.mSelections[i].contains(e.getX(), e.getY())) {
                        ImageEditorPanel.this.mSelected.add(ImageEditorPanel.this.mResources.get(i));
                    }
                    ++i;
                }
                Collections.sort(ImageEditorPanel.this.mSelected);
                if (ImageEditorPanel.this.mSelected.size() > 0) {
                    Vector<Resource> toShow = new Vector<Resource>();
                    toShow.add(ImageEditorPanel.this.mSelected.get(0));
                    int i2 = 1;
                    while (i2 < ImageEditorPanel.this.mSelected.size()) {
                        if (ImageEditorPanel.this.mSelected.get(i2).compareTo(ImageEditorPanel.this.mSelected.get(0)) != 0) break;
                        toShow.add(ImageEditorPanel.this.mSelected.get(i2));
                        ++i2;
                    }
                    ImageEditorPanel.this.mSelected = toShow;
                }
                ImageEditorPanel.this.mNotifier.doNotify(ImageEditorPanel.this.mSelected);
            }
            ImageEditorPanel.this.repaint();
            ImageEditorPanel.this.mDragingFlag = false;
        }
    };

    public ImageEditorPanel(BufferedImage image) {
        this.mImage = image;
        this.mScale = 0.5;
        this.fixSize();
        this.setToolTipText(ResourceFactory.getString("scroll_to_zoom"));
        this.bindScaleAction();
    }

    private void fixSize() {
        int w = (int)((double)this.mImage.getWidth() * this.mScale);
        int h = (int)((double)this.mImage.getHeight() * this.mScale);
        GUIUtil.fixSize(this, new Dimension(w, h));
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.paintSelectImage(g);
    }

    @Override
    public void paintSelectImage(Graphics g) {
        if (this.mImage == null) {
            return;
        }
        this.mWidth = this.getWidth();
        this.mHeight = this.getHeight();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.mWidth, this.mHeight);
        int w = (int)((double)this.mImage.getWidth() * this.mScale);
        int h = (int)((double)this.mImage.getHeight() * this.mScale);
        g.drawImage(this.mImage, 0, 0, w, h, null);
    }

    @Override
    protected void drawSelection(PointRectangle selection) {
        int w = (int)((double)this.mImage.getWidth() * this.mScale);
        int h = (int)((double)this.mImage.getHeight() * this.mScale);
        if (selection.x + selection.width > w) {
            selection.x = w - selection.width;
        }
        if (selection.y + selection.height > h) {
            selection.y = h - selection.height;
        }
        if (selection.x < 0) {
            selection.x = 0;
        }
        if (selection.y < 0) {
            selection.y = 0;
        }
        super.drawSelection(selection);
        if (this.lockResource) {
            return;
        }
        if (this.mCurrentResource == null) {
            return;
        }
        if (selection != null) {
            this.mCurrentResource.mX = (int)Math.round((double)selection.x / this.mScale);
            this.mCurrentResource.mY = (int)Math.round((double)selection.y / this.mScale);
            this.mCurrentResource.mWidth = (int)Math.round((double)selection.width / this.mScale);
            this.mCurrentResource.mHeight = (int)Math.round((double)selection.height / this.mScale);
            this.mNotifier.doNotify(this);
        }
    }

    protected void drawSelected() {
        this.mSelections = new PointRectangle[this.mResources.size()];
        int i = 0;
        while (i < this.mResources.size()) {
            Resource resource = this.mResources.get(i);
            this.mSelections[i] = new PointRectangle(new Rectangle((int)Math.round((double)resource.mX * this.mScale), (int)Math.round((double)resource.mY * this.mScale), (int)Math.round((double)resource.mWidth * this.mScale), (int)Math.round((double)resource.mHeight * this.mScale)));
            if (!resource.equals(this.mCurrentResource)) {
                if (this.mSelected != null && this.mSelected.contains(this.mResources.get(i))) {
                    this.selection_color = Color.BLUE;
                    this.drawOneSelected(this.mSelections[i]);
                } else {
                    this.selection_color = Color.RED;
                    this.drawOneSelected(this.mSelections[i]);
                }
            }
            ++i;
        }
    }

    protected void drawOneSelected(PointRectangle selection) {
        Graphics2D graphics = (Graphics2D)this.getGraphics().create();
        graphics.setPaint(this.selection_color);
        graphics.setStroke(new BasicStroke(1.0f, 0, 1, 1.0f, new float[]{5.0f}, 0.0f));
        graphics.draw(selection);
    }

    @Override
    public void paintComponent(Graphics g) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImageEditorPanel.this.resizeImage();
            }
        });
    }

    public void resizeImage() {
        if (this.mCurrentResource == null) {
            return;
        }
        if (this.mSelection != null) {
            this.wipeSelection();
        }
        this.mSelection = new PointRectangle(new Rectangle((int)Math.round((double)this.mCurrentResource.mX * this.mScale), (int)Math.round((double)this.mCurrentResource.mY * this.mScale), (int)Math.round((double)this.mCurrentResource.mWidth * this.mScale), (int)Math.round((double)this.mCurrentResource.mHeight * this.mScale)));
        if (this.mSelection != null) {
            this.lockResource = true;
            this.drawSelected();
            this.drawSelection(this.mSelection);
            this.lockResource = false;
            this.confirmSelection(this.mSelection);
        }
    }

    public void bindResource(Resource resource) {
        if (resource == null) {
            return;
        }
        if (this.mCurrentResource == null) {
            this.bindSelection();
        }
        this.mCurrentResource = resource;
        this.resizeImage();
    }

    public void unbindResource() {
        this.mCurrentResource = null;
        this.unbindSelection();
    }

    public void bindResources(Vector<Resource> resources) {
        if (resources == null) {
            return;
        }
        this.mResources = resources;
        this.mSelections = new PointRectangle[this.mResources.size()];
        this.bindScaleAction();
        this.bindSelect();
    }

    public void bindNotifier(Notifier notifier) {
        this.mNotifier = notifier;
        notifier.addObserver(this);
    }

    protected void bindSelect() {
        this.addMouseListener(this.rma);
        this.addMouseMotionListener(this.rma);
    }

    protected void bindScaleAction() {
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                ImageEditorPanel.this.mScale = e.getWheelRotation() < 0 ? (ImageEditorPanel.this.mScale += 0.1) : (ImageEditorPanel.this.mScale -= 0.1);
                if (ImageEditorPanel.this.mScale >= 1.0) {
                    ImageEditorPanel.this.mScale = 1.0;
                }
                if (ImageEditorPanel.this.mScale <= 0.4) {
                    ImageEditorPanel.this.mScale = 0.4;
                }
                e.consume();
                ImageEditorPanel.this.fixSize();
            }
        });
    }

    @Override
    public void update(Observable o, Object source) {
        if (source instanceof JTextField) {
            this.lockResource = true;
            this.resizeImage();
            this.lockResource = false;
        }
    }
}

