/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.resourceeditor;

import com.miui.theme.tool.resourceeditor.Resource;
import com.miui.theme.tool.util.ThemeHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Vector;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class ScreenshotXml
implements Comparable<ScreenshotXml> {
    public static String SCREENSHOT_SUFFIX = ".jpg";
    public static float SCREENSHOT_QUALITY = 0.85f;
    String mVersion = "";
    String mDescription = "";
    String mAnnotation = "";
    String mTag = "";
    Vector<Resource> mResources = new Vector();
    File mFile;
    File mXmlFile;
    public static String SCREENSHOT_TAGNAME = "screenshot";
    public static String SCREENSHOT_DESCRIPTION = "description";
    public static String SCREENSHOT_ANNOTATION = "annotation";
    public static String SCREENSHOT_TAG = "tag";
    public static String SCREENSHOT_VERSION = "version";
    private boolean mIsLoaded = false;

    public ScreenshotXml(File file, File xmlFile) {
        this.mFile = file;
        this.mXmlFile = xmlFile;
    }

    public void parse() {
        SAXBuilder builder = new SAXBuilder();
        try {
            Document document = builder.build(this.mXmlFile);
            Element screenshotNode = document.getRootElement();
            this.mVersion = screenshotNode.getAttributeValue(SCREENSHOT_VERSION);
            this.mVersion = this.mVersion == null ? "" : this.mVersion;
            this.mDescription = screenshotNode.getAttributeValue(SCREENSHOT_DESCRIPTION);
            this.mDescription = this.mDescription == null ? "" : this.mDescription;
            this.mAnnotation = screenshotNode.getAttributeValue(SCREENSHOT_ANNOTATION);
            this.mAnnotation = this.mAnnotation == null ? "" : this.mAnnotation;
            this.mTag = screenshotNode.getAttributeValue(SCREENSHOT_TAG);
            this.mTag = this.mTag == null ? "" : this.mTag;
            for (Element r : screenshotNode.getChildren()) {
                Resource resource = new Resource();
                resource.parse(r);
                this.mResources.add(resource);
            }
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return String.valueOf(this.mDescription) + "(" + this.mVersion + ")";
    }

    public void save() {
        Element screenshot = new Element(SCREENSHOT_TAGNAME);
        screenshot.setAttribute(SCREENSHOT_DESCRIPTION, this.mDescription);
        screenshot.setAttribute(SCREENSHOT_VERSION, this.mVersion);
        screenshot.setAttribute(SCREENSHOT_ANNOTATION, this.mAnnotation);
        screenshot.setAttribute(SCREENSHOT_TAG, this.mTag);
        for (Resource mResource : this.mResources) {
            screenshot.addContent((Content)mResource.getElement());
        }
        XMLOutputter outputter = new XMLOutputter();
        try {
            FileOutputStream fos = new FileOutputStream(this.mXmlFile);
            Format format = Format.getPrettyFormat();
            format.setEncoding(ThemeHelper.CHARSET);
            format.setIndent("    ");
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, ThemeHelper.CHARSET);
            outputter.setFormat(format);
            outputter.output(new Document(screenshot), (Writer)osw);
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int compareTo(ScreenshotXml o) {
        return this.mDescription.compareTo(o.mDescription);
    }

    public synchronized void matchResource(String packageCatalogPath) {
        if (this.mIsLoaded) {
            return;
        }
        for (Resource r : this.mResources) {
            r.matchResource(packageCatalogPath);
        }
        this.mIsLoaded = true;
    }
}

