/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.tagTreeBuilder;

import com.miui.theme.tool.errorManager.Error;
import com.miui.theme.tool.errorManager.ErrorManager;
import com.miui.theme.tool.tagTreeBuilder.BaseElement;
import com.miui.theme.tool.tagTreeBuilder.ElementFactory;
import com.miui.theme.tool.tagTreeBuilder.TagElement;
import com.miui.theme.tool.xmlparser.Attributes;
import com.miui.theme.tool.xmlparser.ElementInfo;
import com.miui.theme.tool.xmlparser.Handler;
import com.miui.theme.tool.xmlparser.XMPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class TreeBuilder
extends Handler {
    private BaseElement mParentPoint = null;
    private BaseElement mCurrentPoint = null;
    private BaseElement mRootPoint = null;
    XMPullParser mParser = null;
    private ElementFactory mFactory = new ElementFactory();

    public TreeBuilder(String in) throws XmlPullParserException {
        this.init();
        this.load(in);
    }

    private void init() {
        this.mParser = new XMPullParser();
        TagElement tag = new TagElement("LockscreenTree", TagElement.TagKind.STARTTAG);
        this.mRootPoint = this.mFactory.createInstance(tag);
    }

    private void load(String in) throws XmlPullParserException {
        this.mParser.setHandler(this);
        this.mParser.parser(in);
    }

    private void constructTree(TagElement tag) {
        if (this.mCurrentPoint == null) {
            this.mCurrentPoint = this.mFactory.createInstance(tag);
            if (this.mCurrentPoint == null) {
                return;
            }
            this.mCurrentPoint.setStartRow(tag.getStartRow());
            this.mCurrentPoint.setStartPos(tag.getStartPos());
            this.mCurrentPoint.setChildStartPos(tag.getEndPos());
            this.mRootPoint = this.mCurrentPoint;
        } else {
            if (tag.getTagKind() == TagElement.TagKind.STARTTAG) {
                BaseElement ele = this.mCurrentPoint.addChild(tag);
                if (ele == null) {
                    System.out.println("node construct fail");
                    return;
                }
                this.mParentPoint = this.mCurrentPoint;
                this.mCurrentPoint = ele;
                this.mCurrentPoint.setFatherNode(this.mParentPoint);
                this.mCurrentPoint.setStartRow(tag.getStartRow());
                this.mCurrentPoint.setStartPos(tag.getStartPos());
                this.mCurrentPoint.setChildStartPos(tag.getEndPos());
            }
            if (tag.getTagKind() == TagElement.TagKind.ENDTAG) {
                if (!tag.getTagName().equals(this.mCurrentPoint.getTAG_NAME())) {
                    ErrorManager.getInstance().addError(Error.ErrorKind.SYTAX_ERROR, this.mCurrentPoint.getStartRow());
                    this.mCurrentPoint.setWrong(true);
                    BaseElement current = this.mCurrentPoint;
                    while (!tag.getTagName().equals(current.getTAG_NAME())) {
                        if ((current = current.getFatherNode()) == null) break;
                        current.setWrong(true);
                        ErrorManager.getInstance().addError(Error.ErrorKind.SYTAX_ERROR, current.getStartRow());
                    }
                    if (current != null && this.mCurrentPoint != this.mRootPoint) {
                        this.mCurrentPoint.childToBrother();
                        this.mCurrentPoint = this.mParentPoint;
                        this.mParentPoint = this.mParentPoint.getFatherNode();
                    }
                }
                this.mCurrentPoint.setEndRow(tag.getStartRow());
                this.mCurrentPoint.setEndPos(tag.getEndPos());
                this.mCurrentPoint.setChildEndPos(tag.getStartPos());
                this.mCurrentPoint = this.mParentPoint;
                if (this.mParentPoint != null) {
                    this.mParentPoint = this.mParentPoint.getFatherNode();
                }
            }
        }
    }

    @Override
    public void text(String t) {
        if (t.trim().length() > 0) {
            Attributes attrs = this.mCurrentPoint.getAttributes();
            attrs.addAttribute("_content", t);
        }
    }

    @Override
    public void startDocument(ElementInfo info) {
    }

    @Override
    public void startElement(String qName, Attributes atts, ElementInfo info) {
        TagElement tag = new TagElement(qName, atts, TagElement.TagKind.STARTTAG, info.getStartPos(), info.getEndPos(), info.getRow());
        this.constructTree(tag);
    }

    @Override
    public void endElement(String qName, ElementInfo info) {
        TagElement tag = new TagElement(qName, TagElement.TagKind.ENDTAG, info.getStartPos(), info.getEndPos(), info.getRow());
        this.constructTree(tag);
    }

    @Override
    public void endDocument(ElementInfo info) {
        while (this.mCurrentPoint != null) {
            TagElement tag;
            ErrorManager.getInstance().addError(Error.ErrorKind.SYTAX_ERROR, this.mCurrentPoint.getStartRow());
            this.mCurrentPoint.setWrong(true);
            if (this.mCurrentPoint != this.mRootPoint) {
                tag = new TagElement("xx", TagElement.TagKind.ENDTAG, info.getStartPos(), info.getEndPos(), info.getRow());
                this.constructTree(tag);
                continue;
            }
            tag = new TagElement(this.mCurrentPoint.getTAG_NAME(), TagElement.TagKind.ENDTAG, info.getStartPos(), info.getEndPos(), info.getRow());
            this.constructTree(tag);
        }
    }

    public BaseElement getRootPoint() {
        return this.mRootPoint;
    }

    public void setRootPoint(BaseElement mRootPoint) {
        this.mRootPoint = mRootPoint;
    }
}

