/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.util;

import com.android.ninepatch.GraphicsUtilities;
import com.miui.theme.tool.gui.CopyableDialog;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.SimilarImageSearch;
import com.miui.theme.tool.util.ThemeHelper;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class FullResolutionMatchManager {
    public static final String MATCH_FILE = "full_resolution_match.csv";
    public static final double HDPI2XHDPI_SCALE = 1.5;
    public static final double XHDPI2XXHDPI_SCALE = 1.4;
    public static final int WIDTH = 15;
    public static final int HEIGHT = 15;
    public static HashMap<String, Set<String>> sFullResolutionMatchManager = new HashMap();
    public static HashMap<String, Double> sHDPI2XHDPI_SCALE = new HashMap();
    public static HashMap<String, Double> sXHDPI2XXHDPI_SCALE = new HashMap();
    public static final String[] NORMAL_SUFFIX;
    public static final String[] PRESSED_SUFFIX;
    public static final String[] DISABLED_SUFFIX;

    static {
        String str = ThemeHelper.readFromFile(new File(ThemeHelper.getDataFolder() + File.separator + MATCH_FILE));
        if (str != null) {
            String[] strs = str.split("\r?\n");
            int i = 0;
            while (i < strs.length) {
                String s = strs[i];
                String[] kv = s.split(",");
                if (kv != null && kv.length >= 2) {
                    if (!sFullResolutionMatchManager.containsKey(kv[0])) {
                        sFullResolutionMatchManager.put(kv[0], new HashSet());
                    }
                    sFullResolutionMatchManager.get(kv[0]).add(kv[1]);
                    String key = FullResolutionMatchManager.getKeyFromNames(kv[0], kv[1]);
                    if (kv.length >= 3 && !kv[2].trim().isEmpty()) {
                        sHDPI2XHDPI_SCALE.put(key, Double.parseDouble(kv[2]));
                    }
                    if (kv.length >= 4 && !kv[3].trim().isEmpty()) {
                        sXHDPI2XXHDPI_SCALE.put(key, Double.parseDouble(kv[3]));
                    }
                }
                ++i;
            }
        }
        NORMAL_SUFFIX = new String[]{"_n", "_normal"};
        PRESSED_SUFFIX = new String[]{"_p", "_pressed"};
        DISABLED_SUFFIX = new String[]{"_d", "_disabled"};
    }

    private static boolean checkShouldMatch(String packageName, String resourceName) {
        if (!sFullResolutionMatchManager.containsKey(packageName)) {
            return false;
        }
        return sFullResolutionMatchManager.get(packageName).contains(resourceName);
    }

    public static boolean checkNeedFullResolutionMatch(File themeFile) {
        String[] subpaths = FullResolutionMatchManager.getInfoFromFile(themeFile);
        if (subpaths.length < 2) {
            return false;
        }
        return FullResolutionMatchManager.checkShouldMatch(subpaths[0], subpaths[subpaths.length - 1]);
    }

    public static String[] getInfoFromFile(File file) {
        String subpath = file.getAbsolutePath().substring(ThemeHelper.sThemeFolderPath.length() + 1);
        return ThemeHelper.assurePath(subpath).split("\\" + File.separator);
    }

    public static String getKeyFromNames(String packageName, String fileName) {
        return String.valueOf(packageName) + " " + fileName;
    }

    public static String getKeyFromFile(File file) {
        String[] subpaths = FullResolutionMatchManager.getInfoFromFile(file);
        return FullResolutionMatchManager.getKeyFromNames(subpaths[0], subpaths[subpaths.length - 1]);
    }

    public static File getHdpiPathFromXhdpiPath(File f) {
        return new File(f.getAbsolutePath().replace("drawable-xhdpi", "drawable-hdpi"));
    }

    public static File getXxhdpiPathFromXhdpiPath(File f) {
        return new File(f.getAbsolutePath().replace("drawable-xhdpi", "drawable-xxhdpi"));
    }

    public static void adaptXhdpiToHdpi(File f) {
        File hdpiF = FullResolutionMatchManager.getHdpiPathFromXhdpiPath(f);
        String key = FullResolutionMatchManager.getKeyFromFile(f);
        double scale = 0.6666666666666666;
        if (sHDPI2XHDPI_SCALE.containsKey(key)) {
            scale = 1.0 / sHDPI2XHDPI_SCALE.get(key);
        }
        FullResolutionMatchManager.adapt(f, hdpiF, scale);
    }

    public static void adaptXhdpiToXxhdpi(File f) {
        File xxhdpiF = FullResolutionMatchManager.getXxhdpiPathFromXhdpiPath(f);
        String key = FullResolutionMatchManager.getKeyFromFile(f);
        double scale = 1.4;
        if (sXHDPI2XXHDPI_SCALE.containsKey(key)) {
            scale = sXHDPI2XXHDPI_SCALE.get(key);
        }
        FullResolutionMatchManager.adapt(f, xxhdpiF, scale);
    }

    public static Vector<File> adaptAllXhdpi(String themePath, String targetResolution) {
        File themeFile = new File(themePath);
        File[] packages = themeFile.listFiles();
        Vector<File> adaptedFiles = new Vector<File>();
        if (packages == null) {
            return adaptedFiles;
        }
        int i = 0;
        while (i < packages.length) {
            if (sFullResolutionMatchManager.containsKey(packages[i].getName())) {
                for (String fileName : sFullResolutionMatchManager.get(packages[i].getName())) {
                    String xhdpiPath = String.valueOf(packages[i].getAbsolutePath()) + File.separator + "res" + File.separator + "drawable-xhdpi" + File.separator + fileName;
                    File xhdpiFile = new File(xhdpiPath);
                    if (!xhdpiFile.exists()) continue;
                    if (targetResolution.equals("drawable-hdpi")) {
                        if (FullResolutionMatchManager.getHdpiPathFromXhdpiPath(xhdpiFile).exists()) continue;
                        FullResolutionMatchManager.adaptXhdpiToHdpi(xhdpiFile);
                        adaptedFiles.add(FullResolutionMatchManager.getHdpiPathFromXhdpiPath(xhdpiFile));
                        continue;
                    }
                    if (!targetResolution.equals("drawable-xxhdpi") || FullResolutionMatchManager.getXxhdpiPathFromXhdpiPath(xhdpiFile).exists()) continue;
                    FullResolutionMatchManager.adaptXhdpiToXxhdpi(xhdpiFile);
                    adaptedFiles.add(FullResolutionMatchManager.getXxhdpiPathFromXhdpiPath(xhdpiFile));
                }
            }
            ++i;
        }
        return adaptedFiles;
    }

    public static void showAdaptResult(Vector<File> adaptedFiles) {
        StringBuilder sb = new StringBuilder(String.valueOf(ResourceFactory.getString("adapted")) + "\n");
        int i = 0;
        while (i < adaptedFiles.size()) {
            sb.append(adaptedFiles.get(i) + "\n");
            ++i;
        }
        CopyableDialog cd = new CopyableDialog(sb.toString());
        cd.setVisible(true);
    }

    public static void adaptAllPressed(File file, Set<File> adapted) {
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null) {
                return;
            }
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                FullResolutionMatchManager.adaptAllPressed(f, adapted);
                ++n2;
            }
        } else {
            if (!file.getAbsolutePath().endsWith(".png")) {
                return;
            }
            FullResolutionMatchManager.checkAdaptPressed(file, adapted);
        }
    }

    public static void checkAdaptPressed(File target, Set<File> adapted) {
        File catalog = ThemeHelper.getCatalogFileFromReplaceFile(target);
        if (catalog == null || !catalog.exists()) {
            return;
        }
        int i = 0;
        while (i < PRESSED_SUFFIX.length) {
            if (catalog.getAbsolutePath().endsWith(String.valueOf(PRESSED_SUFFIX[i]) + ".png")) {
                File targetD;
                File sourceD;
                File targetN;
                File sourceN = new File(catalog.getAbsolutePath().replace(PRESSED_SUFFIX[i], NORMAL_SUFFIX[i]));
                if (FullResolutionMatchManager.checkAndReplace(sourceN, targetN = new File(target.getAbsolutePath().replace(PRESSED_SUFFIX[i], NORMAL_SUFFIX[i])))) {
                    adapted.add(targetN);
                }
                if (FullResolutionMatchManager.checkAndReplace(sourceD = new File(catalog.getAbsolutePath().replace(PRESSED_SUFFIX[i], DISABLED_SUFFIX[i])), targetD = new File(target.getAbsolutePath().replace(PRESSED_SUFFIX[i], DISABLED_SUFFIX[i])))) {
                    adapted.add(targetN);
                }
            }
            ++i;
        }
    }

    private static boolean checkAndReplace(File s, File t) {
        if (s.exists() && !t.exists()) {
            try {
                ThemeHelper.copyFile(s, t);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    public static void adapt(File source, File dest, double scale) {
        int end;
        int start;
        if (scale == -1.0) {
            return;
        }
        BufferedImage sourceImage = GUIUtil.getImage(source);
        int sourceWidth = sourceImage.getWidth();
        int sourceHeight = sourceImage.getHeight();
        if (!source.getAbsolutePath().endsWith(ThemeHelper.NINE_PATCH_SUFFIX)) {
            int destWidth = FullResolutionMatchManager.scale(sourceWidth, scale);
            int destHeight = FullResolutionMatchManager.scale(sourceHeight, scale);
            if (sourceWidth <= 15) {
                destWidth = sourceWidth;
            }
            if (sourceHeight <= 15) {
                destHeight = sourceHeight;
            }
            if (destWidth <= 0 || destHeight <= 0) {
                return;
            }
            GUIUtil.saveImage(sourceImage.getScaledInstance(destWidth, destHeight, 4), dest);
            return;
        }
        int destWidth = FullResolutionMatchManager.scale(sourceWidth -= 2, scale);
        int destHeight = FullResolutionMatchManager.scale(sourceHeight -= 2, scale);
        if (sourceWidth <= 15) {
            destWidth = sourceWidth;
        }
        if (sourceHeight <= 15) {
            destHeight = sourceHeight;
        }
        int[] topRow = null;
        int[] leftColumn = null;
        int[] bottomRow = null;
        int[] rightColumn = null;
        topRow = GraphicsUtilities.getPixels((BufferedImage)sourceImage, (int)1, (int)0, (int)sourceWidth, (int)1, topRow);
        leftColumn = GraphicsUtilities.getPixels((BufferedImage)sourceImage, (int)0, (int)1, (int)1, (int)sourceHeight, leftColumn);
        boolean[] result = new boolean[1];
        Pair<List<Pair<Integer>>> left = FullResolutionMatchManager.getPatches(leftColumn, result);
        Pair<List<Pair<Integer>>> top = FullResolutionMatchManager.getPatches(topRow, result);
        bottomRow = GraphicsUtilities.getPixels((BufferedImage)sourceImage, (int)1, (int)(sourceHeight + 1), (int)sourceWidth, (int)1, bottomRow);
        rightColumn = GraphicsUtilities.getPixels((BufferedImage)sourceImage, (int)(sourceWidth + 1), (int)1, (int)1, (int)sourceHeight, rightColumn);
        Pair<List<Pair<Integer>>> bottom = FullResolutionMatchManager.getPatches(bottomRow, result);
        Pair<Integer> mHorizontalPadding = FullResolutionMatchManager.getPadding((List)bottom.mFirst);
        Pair<List<Pair<Integer>>> right = FullResolutionMatchManager.getPatches(rightColumn, result);
        Pair<Integer> mVerticalPadding = FullResolutionMatchManager.getPadding((List)right.mFirst);
        BufferedImage originImage = sourceImage.getSubimage(1, 1, sourceWidth, sourceHeight);
        BufferedImage scaledImage = new BufferedImage(destWidth, destHeight, originImage.getType());
        scaledImage.getGraphics().drawImage(originImage.getScaledInstance(destWidth, destHeight, 4), 0, 0, null);
        BufferedImage destImage = new BufferedImage(destWidth + 2, destHeight + 2, sourceImage.getType());
        Graphics g = destImage.getGraphics();
        g.drawImage(scaledImage, 1, 1, destWidth + 1, destHeight + 1, 0, 0, destWidth, destHeight, null);
        g.setColor(GUIUtil.BLACK);
        double s = sourceWidth > 15 ? scale : 1.0;
        for (Pair p : (List)top.mSecond) {
            start = FullResolutionMatchManager.getXFixedPoint((Integer)p.mFirst, originImage, scaledImage, s);
            end = FullResolutionMatchManager.getXFixedPoint((Integer)p.mSecond - 1, originImage, scaledImage, s);
            g.drawLine(1 + start, 0, 1 + end, 0);
        }
        for (Pair p : (List)bottom.mSecond) {
            start = FullResolutionMatchManager.getXFixedPoint((Integer)p.mFirst, originImage, scaledImage, s);
            end = FullResolutionMatchManager.getXFixedPoint((Integer)p.mSecond - 1, originImage, scaledImage, s);
            g.drawLine(1 + start, destHeight + 1, 1 + end, destHeight + 1);
        }
        s = sourceHeight > 15 ? scale : 1.0;
        for (Pair p : (List)left.mSecond) {
            start = FullResolutionMatchManager.getYFixedPoint((Integer)p.mFirst, originImage, scaledImage, s);
            end = FullResolutionMatchManager.getYFixedPoint((Integer)p.mSecond - 1, originImage, scaledImage, s);
            g.drawLine(0, 1 + start, 0, 1 + end);
        }
        for (Pair p : (List)right.mSecond) {
            start = FullResolutionMatchManager.getYFixedPoint((Integer)p.mFirst, originImage, scaledImage, s);
            end = FullResolutionMatchManager.getYFixedPoint((Integer)p.mSecond - 1, originImage, scaledImage, s);
            g.drawLine(destWidth + 1, 1 + start, destWidth + 1, 1 + end);
        }
        g.dispose();
        GUIUtil.saveImage(destImage, dest);
    }

    private static int getXFixedPoint(int x, BufferedImage originImage, BufferedImage scaledImage, double s) {
        if (x == 0) {
            return 0;
        }
        if (x == originImage.getWidth() - 1) {
            return scaledImage.getWidth() - 1;
        }
        int sx = FullResolutionMatchManager.scale(x, s);
        String originHash = SimilarImageSearch.produceFingerPrint(originImage.getSubimage(x, 0, 1, originImage.getHeight()));
        ArrayList<Pair<Integer>> candidates = new ArrayList<Pair<Integer>>();
        int i = sx - 1;
        while (i <= sx + 1) {
            if (i >= 0 && i <= scaledImage.getWidth() - 1) {
                String hash = SimilarImageSearch.produceFingerPrint(scaledImage.getSubimage(i, 0, 1, scaledImage.getHeight()));
                int distance = SimilarImageSearch.hammingDistance(originHash, hash);
                candidates.add(new Pair<Integer>(i, distance));
            }
            ++i;
        }
        return FullResolutionMatchManager.minDistance(candidates);
    }

    private static int getYFixedPoint(int y, BufferedImage originImage, BufferedImage scaledImage, double s) {
        if (y == 0) {
            return 0;
        }
        if (y == originImage.getHeight() - 1) {
            return scaledImage.getHeight() - 1;
        }
        int sy = FullResolutionMatchManager.scale(y, s);
        String originHash = SimilarImageSearch.produceFingerPrint(originImage.getSubimage(0, y, originImage.getWidth(), 1));
        ArrayList<Pair<Integer>> candidates = new ArrayList<Pair<Integer>>();
        int i = sy - 1;
        while (i <= sy + 1) {
            if (i >= 0 && i <= scaledImage.getHeight() - 1) {
                String hash = SimilarImageSearch.produceFingerPrint(scaledImage.getSubimage(0, i, scaledImage.getWidth(), 1));
                int distance = SimilarImageSearch.hammingDistance(originHash, hash);
                candidates.add(new Pair<Integer>(i, distance));
            }
            ++i;
        }
        return FullResolutionMatchManager.minDistance(candidates);
    }

    private static int minDistance(List<Pair<Integer>> candidates) {
        Pair<Integer> center = candidates.get(1);
        Collections.sort(candidates, new Comparator<Pair<Integer>>(){

            @Override
            public int compare(Pair<Integer> o1, Pair<Integer> o2) {
                return (Integer)o1.mSecond - (Integer)o2.mSecond;
            }
        });
        if (candidates.get((int)0).mSecond == center.mSecond) {
            return (Integer)center.mFirst;
        }
        return (Integer)candidates.get((int)0).mFirst;
    }

    private static Pair<Integer> getPadding(List<Pair<Integer>> pairs) {
        if (pairs.size() == 0) {
            return new Pair<Integer>(0, 0);
        }
        if (pairs.size() == 1) {
            if ((Integer)pairs.get((int)0).mFirst == 0) {
                return new Pair<Integer>((Integer)pairs.get((int)0).mSecond - (Integer)pairs.get((int)0).mFirst, 0);
            }
            return new Pair<Integer>(0, (Integer)pairs.get((int)0).mSecond - (Integer)pairs.get((int)0).mFirst);
        }
        int index = pairs.size() - 1;
        return new Pair<Integer>((Integer)pairs.get((int)0).mSecond - (Integer)pairs.get((int)0).mFirst, (Integer)pairs.get((int)index).mSecond - (Integer)pairs.get((int)index).mFirst);
    }

    private static int scale(double n, double s) {
        return (int)(n * s);
    }

    private static Pair<List<Pair<Integer>>> getPatches(int[] pixels, boolean[] startWithPatch) {
        int lastIndex = 0;
        int lastPixel = pixels[0];
        boolean first = true;
        ArrayList<Pair<Integer>> fixed = new ArrayList<Pair<Integer>>();
        ArrayList<Pair<Integer>> patches = new ArrayList<Pair<Integer>>();
        int i = 0;
        while (i < pixels.length) {
            int pixel = pixels[i];
            if (pixel != lastPixel) {
                if (lastPixel == -16777216) {
                    if (first) {
                        startWithPatch[0] = true;
                    }
                    patches.add(new Pair<Integer>(lastIndex, i));
                } else {
                    fixed.add(new Pair<Integer>(lastIndex, i));
                }
                first = false;
                lastIndex = i;
                lastPixel = pixel;
            }
            ++i;
        }
        if (lastPixel == -16777216) {
            if (first) {
                startWithPatch[0] = true;
            }
            patches.add(new Pair<Integer>(lastIndex, pixels.length));
        } else {
            fixed.add(new Pair<Integer>(lastIndex, pixels.length));
        }
        if (patches.size() == 0) {
            patches.add(new Pair<Integer>(1, pixels.length));
            startWithPatch[0] = true;
            fixed.clear();
        }
        return new Pair<List<Pair<Integer>>>(fixed, patches);
    }

    static class Pair<E>
    implements Serializable {
        private static final long serialVersionUID = -2204108979541762418L;
        E mFirst;
        E mSecond;

        Pair(E first, E second) {
            this.mFirst = first;
            this.mSecond = second;
        }

        public String toString() {
            return "Pair[" + this.mFirst + ", " + this.mSecond + "]";
        }
    }
}

