/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public final class GridBagHelper {
    private static final int MAXGRIDX = 511;
    private static final int MAXGRIDY = 511;
    private static final int VER_SEP_DIST = 4;
    private static final int HOR_FIELD_DIST = 4;
    private static final int VER_FIELD_DIST = 2;

    private GridBagHelper() {
    }

    public static void addComponent(Container container, Component c, int x, int y, int width, int height, int ipadx, int ipady, double weightx, double weighty, int fill, int anchor) {
        int dx = 0;
        int dy = 0;
        if (c instanceof JSeparator) {
            dy = 4;
        } else {
            dx = 4;
            dy = 2;
        }
        GridBagHelper.addComponent(container, c, x, y, width, height, ipadx, ipady, dx, dy, weightx, weighty, fill, anchor);
    }

    public static void addComponent(Container container, Component c, int x, int y, int width, int height, int ipadx, int ipady, int dx, int dy, double weightx, double weighty, int fill, int anchor) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.gridheight = height;
        gbc.ipadx = c instanceof JComboBox ? Math.max(4, ipadx) : ipadx;
        gbc.ipady = c instanceof JTextField ? Math.max(6, ipady) : ipady;
        gbc.insets = new Insets(dy, dx, dy, dx);
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.fill = fill;
        gbc.anchor = anchor;
        container.add(c, gbc);
    }

    public static void addComponent(Container container, Component c, int x, int y, int width, int height, int ipadx, int ipady, Insets insets, double weightx, double weighty, int fill, int anchor) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.gridheight = height;
        gbc.ipadx = c instanceof JComboBox ? Math.max(4, ipadx) : ipadx;
        gbc.ipady = c instanceof JTextField ? Math.max(6, ipady) : ipady;
        gbc.insets = insets;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.fill = fill;
        gbc.anchor = anchor;
        container.add(c, gbc);
    }

    public static void setMinColWidth(JPanel panel, int col, int width) {
        JPanel sizePanel = new JPanel();
        sizePanel.setOpaque(false);
        sizePanel.setMinimumSize(new Dimension(width, 1));
        sizePanel.setPreferredSize(new Dimension(width, 1));
        sizePanel.setMaximumSize(new Dimension(width, 1));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = col;
        gbc.gridy = 511;
        panel.add((Component)sizePanel, gbc);
    }

    public static void setMinRowHeight(JPanel panel, int row, int height) {
        JPanel sizePanel = new JPanel();
        sizePanel.setOpaque(false);
        sizePanel.setMinimumSize(new Dimension(1, height));
        sizePanel.setPreferredSize(new Dimension(1, height));
        sizePanel.setMaximumSize(new Dimension(1, height));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 511;
        gbc.gridy = row;
        panel.add((Component)sizePanel, gbc);
    }
}

