/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.util;

import com.miui.theme.tool.util.DownloadProgressListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;

public class InternetDownloadTask
extends SwingWorker {
    private DownloadProgressListener mDownloadProgressListener;
    private URL mUrl;
    private InputStream mUrlStream;
    private OutputStream mDestFileStream;
    private URLConnection mUrlConnection;
    public static final int BLOCK_SIZE = 4096;
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_TYPE = "content-type";
    public static final String CONTENT_TYPE_VALUE = "binary/data";
    public static final int DOWNLOAD_TIMEOUT = 5000;

    public InternetDownloadTask(String destUrl, OutputStream destStream) throws IOException {
        this(destUrl);
        this.mDestFileStream = destStream;
    }

    public InternetDownloadTask(String destUrl) throws IOException {
        this.mUrl = new URL(destUrl);
        this.mUrlConnection = this.mUrl.openConnection();
        this.mUrlConnection.setConnectTimeout(5000);
        this.mUrlConnection.setDoOutput(true);
        this.mUrlConnection.setDoInput(true);
        this.mUrlConnection.setRequestProperty(CONTENT_TYPE, CONTENT_TYPE_VALUE);
        this.mUrlStream = this.mUrl.openStream();
    }

    public void setDestFileStream(OutputStream destStream) {
        this.mDestFileStream = destStream;
    }

    public int getFileSize() {
        return this.mUrlConnection.getContentLength();
    }

    protected Object doInBackground() throws Exception {
        int readLen;
        int contentLength = this.mUrlConnection.getContentLength();
        byte[] buffer = new byte[4096];
        int current = 0;
        BufferedInputStream bis = new BufferedInputStream(this.mUrlStream);
        while ((readLen = bis.read(buffer)) != -1) {
            if (this.isCancelled()) break;
            this.mDestFileStream.write(buffer, 0, readLen);
            this.mDownloadProgressListener.progress(current += readLen, contentLength);
        }
        this.mUrlStream.close();
        return null;
    }

    @Override
    protected void done() {
        super.done();
        try {
            this.mDestFileStream.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (this.mDownloadProgressListener != null) {
            if (this.isCancelled()) {
                this.mDownloadProgressListener.cancelled();
                return;
            }
            try {
                this.mDownloadProgressListener.done(this.get());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    public void setDownloadProgressListener(DownloadProgressListener dpl) {
        this.mDownloadProgressListener = dpl;
    }
}

