/*
 * Decompiled with CFR 0.152.
 */
package miui.imagefilters;

import miui.imagefilters.IImageFilter;
import miui.imagefilters.ImageData;
import miui.imagefilters.ImageFilterUtils;

public class LevelsFilter
implements IImageFilter {
    private float mInputMin = 0.0f;
    private float mInputMiddle = 1.0f;
    private float mInputMax = 255.0f;
    private float mOutputMin = 0.0f;
    private float mOutputMax = 255.0f;
    private boolean mIsFilterR = true;
    private boolean mIsFilterG = true;
    private boolean mIsFilterB = true;

    public void setInputMin(float value) {
        this.mInputMin = ImageFilterUtils.clamp(0.0f, value, 253.0f);
    }

    public void setInputMiddle(float value) {
        this.mInputMiddle = ImageFilterUtils.clamp(1.0E-4f, value, 9.9999f);
    }

    public void setInputMax(float value) {
        this.mInputMax = ImageFilterUtils.clamp(2.0f, value, 255.0f);
    }

    public void setOutputMin(float value) {
        this.mOutputMin = ImageFilterUtils.clamp(0.0f, value, 255.0f);
    }

    public void setOutputMax(float value) {
        this.mOutputMax = ImageFilterUtils.clamp(0.0f, value, 255.0f);
    }

    public void setChannel(String channel) {
        this.mIsFilterR = false;
        this.mIsFilterG = false;
        this.mIsFilterB = false;
        if ("r".equalsIgnoreCase(channel) || "red".equalsIgnoreCase(channel)) {
            this.mIsFilterR = true;
        } else if ("g".equalsIgnoreCase(channel) || "green".equalsIgnoreCase(channel)) {
            this.mIsFilterG = true;
        } else if ("b".equalsIgnoreCase(channel) || "blue".equalsIgnoreCase(channel)) {
            this.mIsFilterB = true;
        } else {
            this.mIsFilterR = true;
            this.mIsFilterG = true;
            this.mIsFilterB = true;
        }
    }

    @Override
    public void process(ImageData imgData) {
        int width = imgData.width;
        int height = imgData.height;
        int[] pixels = imgData.pixels;
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                int colorIndex = y * width + x;
                int argb = pixels[colorIndex];
                int r = (argb & 0xFF0000) >>> 16;
                int g = (argb & 0xFF00) >>> 8;
                int b = argb & 0xFF;
                if (this.mIsFilterR) {
                    r = LevelsFilter.interpolate(this.mInputMin, this.mInputMiddle, this.mInputMax, this.mOutputMin, this.mOutputMax, r);
                }
                if (this.mIsFilterG) {
                    g = LevelsFilter.interpolate(this.mInputMin, this.mInputMiddle, this.mInputMax, this.mOutputMin, this.mOutputMax, g);
                }
                if (this.mIsFilterB) {
                    b = LevelsFilter.interpolate(this.mInputMin, this.mInputMiddle, this.mInputMax, this.mOutputMin, this.mOutputMax, b);
                }
                pixels[colorIndex] = r << 16 | g << 8 | b | argb & 0xFF000000;
                ++y;
            }
            ++x;
        }
    }

    private static int interpolate(float start, float gamma, float end, float outStart, float outEnd, int inputValue) {
        if ((float)inputValue <= start) {
            return (int)outStart;
        }
        if ((float)inputValue >= end) {
            return (int)outEnd;
        }
        if (gamma == 1.0f) {
            return (int)(outStart + ((float)inputValue - start) * (outEnd - outStart) / (end - start));
        }
        float inputRange = end - start;
        float outRange = outEnd - outStart;
        float factor = ((float)inputValue - start) / inputRange;
        factor = 1.0f - (float)Math.pow(1.0f - factor, gamma);
        return (int)(outStart + outRange * factor);
    }
}

