/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.apk;

import com.miui.theme.tool.apk.Activity;
import com.miui.theme.tool.upsidescene.screen.ComponentName;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;

public class CacheActivityManager {
    HashMap<String, Activity> mCachedActivitys = new HashMap();
    private static volatile CacheActivityManager single;

    private CacheActivityManager() {
        this.refresh();
    }

    public ArrayList<Activity> getActivityList() {
        return new ArrayList<Activity>(this.mCachedActivitys.values());
    }

    public void refresh() {
        File cachedDir = new File(Activity.getFakedIconDir());
        if (!cachedDir.exists()) {
            cachedDir.mkdirs();
            return;
        }
        this.mCachedActivitys.clear();
        File[] fileArray = cachedDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            Activity ac = Activity.getCachedActivityFromIcon(f.getName());
            if (ac != null) {
                this.mCachedActivitys.put(ComponentName.unflattenFromString(ac.getComponentName()).getClassName(), ac);
            }
            ++n2;
        }
    }

    public Activity getActivityByComponentName(ComponentName cn) {
        Activity ac = this.mCachedActivitys.get(cn.getClassName());
        return ac;
    }

    public String getIconPathByComponentName(ComponentName cn) {
        Activity ac = this.getActivityByComponentName(cn);
        if (ac == null) {
            return null;
        }
        return ac.getCacheIconPath();
    }

    public String getIconPathByComponentNameClassFirst(ComponentName cn) {
        Activity ac = this.getActivityByComponentName(cn);
        if (ac == null) {
            return null;
        }
        if (ac.isSameWithPackageIcon()) {
            return null;
        }
        return ac.getCacheIconPath();
    }

    public static void putCacheActivity(Activity ac, File f) {
        FileInputStream fi = null;
        FileOutputStream fo = null;
        String path = ac.getCacheIconPath();
        try {
            try {
                if (new File(path).exists()) {
                    new File(path).delete();
                }
                fi = new FileInputStream(f.getAbsolutePath());
                fo = new FileOutputStream(path);
                IOUtils.copy((InputStream)fi, (OutputStream)fo);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                try {
                    if (fi != null) {
                        fi.close();
                    }
                    if (fo != null) {
                        fo.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (fi != null) {
                        fi.close();
                    }
                    if (fo != null) {
                        fo.close();
                    }
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (fi != null) {
                    fi.close();
                }
                if (fo != null) {
                    fo.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CacheActivityManager getInstance() {
        if (single != null) return single;
        Class<CacheActivityManager> clazz = CacheActivityManager.class;
        synchronized (CacheActivityManager.class) {
            if (single != null) return single;
            single = new CacheActivityManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }
}

