/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.upsidescene;

import com.miui.theme.tool.upsidescene.NEWImageFrame;
import com.miui.theme.tool.upsidescene.screen.SceneData;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JPanel;

public class ScenePreviewPane
extends JPanel
implements Observer {
    private SceneData sd;
    private BufferedImage[] sgs;
    private Vector<NEWImageFrame> jfs = new Vector();
    private Vector<BufferedImage> selectedImages;
    private int width;
    private int pages;

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        Rectangle clip = g2.getClipBounds();
        if (this.sgs == null) {
            return;
        }
        this.pages = this.sgs.length;
        double scale = 1.0 * (double)clip.height / (double)this.sgs[0].getHeight();
        this.width = (int)((double)this.sgs[0].getWidth() * scale);
        this.setLayout(new GridLayout(1, this.sgs.length));
        int i = 0;
        while (i < this.sgs.length) {
            NEWImageFrame jf;
            g2.drawImage(this.sgs[i], (int)(scale * (double)this.sgs[i].getWidth()) * i + 1 * i, 0, (int)(scale * (double)this.sgs[i].getWidth()), (int)(scale * (double)this.sgs[i].getHeight()), null);
            try {
                jf = this.jfs.get(i);
                jf.resetFrameImage(this.sgs[i]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                jf = new NEWImageFrame(this.sgs[i]);
                this.jfs.add(jf);
            }
            ++i;
        }
        int leftLine = clip.width;
        int drawAbleWidth = clip.width - this.width * (this.sgs.length + 1);
        int i2 = 0;
        while (i2 < this.selectedImages.size()) {
            BufferedImage bi = this.selectedImages.get(i2);
            scale = 1.0;
            if (bi.getHeight() > clip.height) {
                scale = 1.0 * (double)clip.height / (double)bi.getHeight();
            }
            if (bi.getWidth() > drawAbleWidth) {
                double scale_tmp = 1.0 * (double)drawAbleWidth / (double)bi.getWidth();
                scale = scale < scale_tmp ? scale : scale_tmp;
            }
            leftLine = (int)((double)leftLine - scale * (double)bi.getWidth());
            g.drawImage(bi, leftLine, (int)((double)clip.height - scale * (double)bi.getHeight()), (int)(scale * (double)bi.getWidth()), (int)(scale * (double)bi.getHeight()), null);
            ++i2;
        }
    }

    public ScenePreviewPane() {
        this.setBackground(Color.gray);
        this.sd = SceneData.getInstance();
        this.sd.addObserver(this);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int x = e.getX() / (ScenePreviewPane.this.width + 1);
                if (x >= ScenePreviewPane.this.pages) {
                    return;
                }
                if (((NEWImageFrame)ScenePreviewPane.this.jfs.get(x)).isVisible()) {
                    ((NEWImageFrame)ScenePreviewPane.this.jfs.get(x)).setVisible(false);
                } else {
                    ((NEWImageFrame)ScenePreviewPane.this.jfs.get(x)).setVisible(true);
                }
            }
        });
    }

    @Override
    public void update(Observable o, Object arg) {
        this.sgs = this.sd.getImages();
        this.selectedImages = this.sd.selectedImages;
        this.repaint();
    }
}

