/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.upsidescene;

import com.miui.theme.tool.schema.Attribute;
import com.miui.theme.tool.schema.Variable;
import com.miui.theme.tool.tagTreeBuilder.BaseElement;
import com.miui.theme.tool.upsidescene.EditorListener;
import com.miui.theme.tool.upsidescene.Manager;
import com.miui.theme.tool.upsidescene.TextColouring;
import com.miui.theme.tool.upsidescene.TreeHelper;
import com.miui.theme.tool.upsidescene.screen.SceneData;
import com.miui.theme.tool.xmlparser.Attributes;
import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class TextArea
extends JTextPane
implements CaretListener,
KeyListener,
MouseListener,
Observer {
    protected Manager mManager;
    protected EditorListener mListener;
    private int mPos = 0;
    protected UndoManager undo = new UndoManager();
    protected UndoableEditListener undoHandler = new UndoHandler();
    private int mStart = 0;
    private int mEnd = 0;
    private String oldValue = new String();
    private boolean isNewFile = true;
    private File currentFile;
    private static int k;

    public TextArea() {
        this.mManager = null;
        this.addKeyListener(this);
        this.addCaretListener(this);
        this.addMouseListener(this);
        this.mListener = new EditorListener(this);
        this.getDocument().addDocumentListener(this.mListener);
        this.getDocument().addUndoableEditListener(this.undoHandler);
    }

    public TextArea(Manager mManager) {
        this.mManager = mManager;
        this.addKeyListener(this);
        this.addCaretListener(this);
        this.addMouseListener(this);
        this.mListener = new EditorListener(this);
        this.getDocument().addDocumentListener(this.mListener);
        this.getDocument().addUndoableEditListener(this.undoHandler);
    }

    @Override
    public void caretUpdate(CaretEvent arg0) {
        this.mPos = this.getCaretPosition() + 1;
        this.mManager.updateCurrent(this.mPos);
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void update(Observable o, Object arg) {
        block30: {
            if (arg == null) {
                return;
            }
            if (arg.getClass() == TreeHelper.MutableTreeNode.class) {
                TreeHelper.MutableTreeNode node = (TreeHelper.MutableTreeNode)arg;
                int start = node.getStartPos() - 3;
                int end = node.getEndPos() - 1;
                this.mStart = start;
                this.mEnd = end;
                this.mManager.updateCurrent(end - 3);
                try {
                    String text = this.getDocument().getText(start, end - start);
                    if (text.matches("^<sprite.+?>.*</sprite>$")) {
                        text = text.replaceFirst("^<sprite.+?>", "");
                        text = text.replaceFirst("</sprite>$", "");
                        text = text.trim();
                    } else {
                        text = "";
                    }
                    SceneData.getInstance().selectedResource = text;
                    SceneData.getInstance().selectedImages.clear();
                    SceneData.getInstance().refresh();
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                this.select(start, end);
                this.requestFocus();
            } else if (arg.getClass() == String.class) {
                String data = (String)arg;
                try {
                    this.getDocument().remove(0, this.getDocument().getLength());
                    this.getDocument().insertString(0, data, null);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            } else if (arg.getClass() == UndoManager.class) {
                this.requestFocus();
                if (this.undo.canUndo()) {
                    try {
                        this.undo.undo();
                    }
                    catch (CannotUndoException ex) {
                        System.out.println("Can not undo:" + ex);
                    }
                }
            } else if (arg.getClass() == ActionEvent.class) {
                ActionEvent e = (ActionEvent)arg;
                try {
                    if (e.getActionCommand().equals("delete")) {
                        this.actionDelete();
                        break block30;
                    }
                    if (e.getActionCommand().equals("up")) {
                        this.actionUp();
                        break block30;
                    }
                    if (e.getActionCommand().equals("down")) {
                        this.actionDown();
                        break block30;
                    }
                    if (e.getActionCommand().equals("new")) {
                        this.actionNew();
                        break block30;
                    }
                    if (e.getActionCommand().equals("open")) {
                        this.actionOpen();
                        break block30;
                    }
                    if (e.getActionCommand().equals("save")) {
                        this.actionSave();
                        break block30;
                    }
                    if (e.getActionCommand().equals("refresh")) {
                        this.mManager.setArticle(this.getDocument().getText(0, this.getDocument().getLength() + 1));
                        break block30;
                    }
                    this.addChild(e);
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            } else if (arg.getClass() == Attributes.class) {
                this.actionEditAttributes((Attributes)arg);
            } else if (arg.getClass() == JMenuItem.class) {
                this.find();
            }
        }
    }

    private void actionEditAttributes(Attributes arg) {
        try {
            int end;
            this.mManager.updateCurrent(this.mStart + 3);
            int start = this.mManager.getCurrentElement().getStartPos() + this.mManager.getCurrentElement().getTAG_NAME().length() - 2;
            ArrayList<Attribute> attributes = this.mManager.fetchAtributesSchema();
            boolean hasContentFlag = false;
            for (Attribute attribute : attributes) {
                if (!attribute.getName().equals("_content")) continue;
                hasContentFlag = true;
            }
            if (hasContentFlag) {
                end = this.mManager.getCurrentElement().getChildEndPos() - 3;
            } else {
                end = this.mManager.getCurrentElement().getChildStartPos() - 1;
                int spaces = end - start - this.getDocument().getText(start, end - start).trim().length();
                end -= spaces;
                ++end;
            }
            this.select(start, end);
            this.getDocument().remove(start, end - start);
            int tempPos = start;
            Attributes values = arg;
            this.actionAllAttrs(values, tempPos);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void actionSave() {
        this.requestFocus();
        this.save();
    }

    public void save() {
        if (!this.currentFile.exists()) {
            return;
        }
        try {
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(this.currentFile), "UTF-8");
            BufferedWriter bfw = new BufferedWriter(fw);
            bfw.write(this.getText(), 0, this.getText().length());
            bfw.flush();
            fw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void actionOpen() {
        boolean isTextChange;
        this.requestFocus();
        String currentValue = this.getText();
        boolean bl = isTextChange = !currentValue.equals(this.oldValue);
        if (isTextChange) {
            int saveChoose = JOptionPane.showConfirmDialog(this, "\u6587\u4ef6\u5185\u5bb9\u5df2\u7ecf\u6539\u53d8\u3002\n\u60f3\u4fdd\u5b58\u5417\uff1f", "\u8bb0\u4e8b\u672c", 1);
            if (saveChoose == 0) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.addChoosableFileFilter(new XMLFileFilter());
                fileChooser.setFileSelectionMode(0);
                fileChooser.setDialogTitle("\u53e6\u5b58\u4e3a");
                int result = fileChooser.showSaveDialog(this);
                if (result == 1) {
                    return;
                }
                File saveFileName = fileChooser.getSelectedFile();
                if (saveFileName == null || saveFileName.getName().equals("")) {
                    JOptionPane.showMessageDialog(this, "\u4e0d\u5408\u6cd5\u7684\u6587\u4ef6\u540d", "\u4e0d\u5408\u6cd5\u7684\u6587\u4ef6\u540d", 0);
                    return;
                } else {
                    try {
                        OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(saveFileName), "UTF-8");
                        BufferedWriter bfw = new BufferedWriter(fw);
                        bfw.write(this.getText(), 0, this.getText().length());
                        bfw.flush();
                        bfw.close();
                        this.isNewFile = false;
                        this.currentFile = saveFileName;
                        this.oldValue = this.getText();
                        return;
                    }
                    catch (IOException iOException) {}
                }
                return;
            } else {
                if (saveChoose != 1) return;
                this.openFile();
            }
            return;
        } else {
            this.openFile();
        }
    }

    private void actionNew() {
        boolean isTextChange;
        this.requestFocus();
        String currentValue = this.getText();
        boolean bl = isTextChange = !currentValue.equals(this.oldValue);
        if (isTextChange) {
            int saveChoose = JOptionPane.showConfirmDialog(this, "\u6587\u4ef6\u5185\u5bb9\u5df2\u7ecf\u6539\u53d8\u3002\n\u60f3\u4fdd\u5b58\u5417\uff1f", "\u8bb0\u4e8b\u672c", 1);
            if (saveChoose == 0) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.addChoosableFileFilter(new XMLFileFilter());
                fileChooser.setFileSelectionMode(0);
                fileChooser.setDialogTitle("\u53e6\u5b58\u4e3a");
                int result = fileChooser.showSaveDialog(this);
                if (result == 1) {
                    return;
                }
                File saveFileName = fileChooser.getSelectedFile();
                if (saveFileName == null || saveFileName.getName().equals("")) {
                    JOptionPane.showMessageDialog(this, "\u4e0d\u5408\u6cd5\u7684\u6587\u4ef6\u540d!", "\u4e0d\u5408\u6cd5\u7684\u6587\u4ef6\u540d!", 0);
                } else {
                    try {
                        OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(saveFileName), "UTF-8");
                        BufferedWriter bfw = new BufferedWriter(fw);
                        bfw.write(this.getText(), 0, this.getText().length());
                        bfw.flush();
                        bfw.close();
                        this.isNewFile = false;
                        this.currentFile = saveFileName;
                        this.oldValue = this.getText();
                    }
                    catch (IOException iOException) {}
                }
            } else if (saveChoose == 1) {
                String data = new String("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<Lockscreen version=\"1\" frameRate=\"30\">\n</Lockscreen>");
                this.replaceRange(data, 0, this.getText().length() + 1);
                this.isNewFile = true;
                this.undo.discardAllEdits();
                this.oldValue = this.getText();
            } else if (saveChoose == 2) {
                return;
            }
        } else {
            String data = new String("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<Lockscreen version=\"1\" frameRate=\"30\">\n</Lockscreen>");
            this.replaceRange(data, 0, this.getText().length() + 1);
            this.isNewFile = true;
            this.undo.discardAllEdits();
            this.oldValue = this.getText();
        }
    }

    private void actionDown() throws BadLocationException {
        this.mManager.updateCurrent(this.mStart + 3);
        if (this.mManager.getCurrentElement() == null) {
            return;
        }
        BaseElement brother = this.mManager.getCurrentElement().fetchBrotherBelow();
        if (brother == null) {
            return;
        }
        this.mStart = this.mManager.getCurrentElement().getStartPos() - 3;
        this.mEnd = this.mManager.getCurrentElement().getEndPos();
        int bStart = brother.getStartPos() - 3;
        int bEnd = brother.getEndPos();
        String brotherString = this.getDocument().getText(bStart, bEnd - bStart - 1);
        String currentString = this.getDocument().getText(this.mStart, this.mEnd - this.mStart - 1);
        this.replaceRange(currentString, bStart, bEnd);
        this.replaceRange(brotherString, this.mStart, this.mEnd);
        this.mListener.manuallyReSet(this.getDocument());
        this.mStart = brother.getStartPos() - 3 + (bEnd - bStart - 1 - (this.mEnd - this.mStart - 1)) + 1;
        this.mManager.updateCurrent(this.mStart + 3);
    }

    private void actionUp() throws BadLocationException {
        this.mManager.updateCurrent(this.mStart + 3);
        if (this.mManager.getCurrentElement() == null) {
            return;
        }
        BaseElement brother = this.mManager.getCurrentElement().fetchBrotherAbove();
        if (brother == null) {
            return;
        }
        this.mStart = this.mManager.getCurrentElement().getStartPos() - 3;
        this.mEnd = this.mManager.getCurrentElement().getEndPos();
        int bStart = brother.getStartPos() - 3;
        int bEnd = brother.getEndPos();
        String brotherString = this.getDocument().getText(bStart, bEnd - bStart - 1);
        String currentString = this.getDocument().getText(this.mStart, this.mEnd - this.mStart - 1);
        this.replaceRange(brotherString, this.mStart, this.mEnd);
        this.replaceRange(currentString, bStart, bEnd);
        this.mListener.manuallyReSet(this.getDocument());
        this.mStart = brother.getStartPos() - 3;
        this.mManager.updateCurrent(this.mStart + 3);
    }

    private void actionDelete() {
        if (this.mStart == 0 || this.mEnd == 0) {
            return;
        }
        if (this.mStart > this.mEnd) {
            return;
        }
        this.mManager.updateCurrent(this.mStart + 3);
        this.mStart = this.mManager.getCurrentElement().getStartPos() - 3;
        this.mEnd = this.mManager.getCurrentElement().getEndPos();
        this.replaceRange("", this.mStart - 1, this.mEnd);
        this.mListener.manuallyReSet(this.getDocument());
        this.mManager.updateCurrent(this.mStart + 3);
    }

    private void openFile() {
        Object str = null;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.addChoosableFileFilter(new XMLFileFilter());
        fileChooser.setFileSelectionMode(0);
        fileChooser.setDialogTitle("\u6253\u5f00\u6587\u4ef6");
        int result = fileChooser.showOpenDialog(this);
        if (result == 1) {
            return;
        }
        this.onFileSelected(fileChooser.getSelectedFile());
    }

    public void onFileSelected(File f) {
        if (!f.exists()) {
            return;
        }
        if (f == null || f.getName().equals("")) {
            JOptionPane.showMessageDialog(this, "\u4e0d\u5408\u6cd5\u7684\u6587\u4ef6\u540d\uff01", "\u4e0d\u5408\u6cd5\u7684\u6587\u4ef6\u540d\uff01", 0);
        } else {
            try {
                String str;
                InputStreamReader insReader = new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8");
                BufferedReader bfr = new BufferedReader(insReader);
                this.getDocument().remove(0, this.getDocument().getLength());
                String data = new String();
                while ((str = bfr.readLine()) != null) {
                    data = String.valueOf(data) + str;
                    data = String.valueOf(data) + "\n";
                }
                this.getDocument().insertString(0, data, null);
                insReader.close();
                this.isNewFile = false;
                this.currentFile = f;
                this.oldValue = this.getText();
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        this.mPos = this.getCaretPosition();
        this.mManager.updateCurrent(this.mPos);
        if (arg0.getButton() == 3) {
            JPopupMenu pop = new JPopupMenu();
            JMenu attributes = new JMenu("Attributes");
            JMenu childsTags = new JMenu("ChildsTags");
            JMenu variableTags = new JMenu("VariableTags");
            pop.add(childsTags);
            pop.add(attributes);
            pop.add(variableTags);
            ArrayList<String> childs = this.mManager.fetchChilds();
            if (childs != null && childs.size() != 0) {
                for (String child : childs) {
                    JMenuItem item = new JMenuItem(child);
                    item.setToolTipText(this.mManager.fetchChildrDescription(child));
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            try {
                                TextArea.this.actionchilds(e);
                            }
                            catch (BadLocationException e1) {
                                e1.printStackTrace();
                            }
                        }
                    });
                    childsTags.add(item);
                }
            } else {
                JMenuItem item = new JMenuItem("Nothing can be added!");
                childsTags.add(item);
            }
            ArrayList<Attribute> atrs = this.mManager.fetchAtributesSchema();
            if (atrs != null && atrs.size() != 0) {
                for (Attribute atr : atrs) {
                    JMenuItem item = new JMenuItem(atr.getName());
                    item.setToolTipText(this.mManager.fetchAttrDescription(atr.getName()));
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            try {
                                TextArea.this.actionAtrs(e);
                            }
                            catch (BadLocationException e1) {
                                e1.printStackTrace();
                            }
                        }
                    });
                    attributes.add(item);
                }
            } else {
                JMenuItem item = new JMenuItem("Nothing can be added!");
                attributes.add(item);
            }
            ArrayList<Variable> vars = this.mManager.getVariableList();
            for (final Variable var : vars) {
                JMenuItem item = new JMenuItem(var.getName());
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            TextArea.this.actionVar(e, var.isAttribute());
                        }
                        catch (BadLocationException e1) {
                            e1.printStackTrace();
                        }
                    }
                });
                variableTags.add(item);
            }
            pop.show(this, arg0.getX(), arg0.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    private void actionAtrs(ActionEvent e) throws BadLocationException {
        String action = e.getActionCommand();
        String insert = new String(" " + action + "=\"\" ");
        int insertPos = this.mManager.getCurrentElement().getStartPos() + this.mManager.getCurrentElement().getTAG_NAME().length() - 2;
        this.mListener.actionInsert(this.getStyledDocument(), insert, insertPos);
    }

    private void actionchilds(ActionEvent e) throws BadLocationException {
        String tempAction = e.getActionCommand();
        String action = new String();
        int i = 0;
        while (i < tempAction.length()) {
            if (tempAction.charAt(i) != ' ') {
                action = String.valueOf(action) + tempAction.charAt(i);
            }
            ++i;
        }
        int mLength = this.mManager.getCurrentElement().getmLength();
        String length = new String();
        while (mLength-- >= 0) {
            length = String.valueOf(length) + "    ";
        }
        String attributes = new String();
        if (this.mManager.fetchNecessaryAtr(action) != null) {
            for (Attribute atr : this.mManager.fetchNecessaryAtr(action)) {
                attributes = String.valueOf(attributes) + " " + atr.getName() + "=\"\" ";
            }
        }
        String insert = new String();
        insert = this.mManager.hasSubElement(action) ? new String("\n" + length + "<" + action + attributes + ">" + "\n" + length + "</" + action + ">") : new String("\n" + length + "<" + action + attributes + "/>");
        int insertPos = this.mManager.getCurrentElement().fetchChildPos(this.getCaretPosition()) - 1;
        this.mListener.actionInsert(this.getStyledDocument(), insert, insertPos);
    }

    private void actionVar(ActionEvent e, boolean isAttribute) throws BadLocationException {
        String action = e.getActionCommand();
        int pos = this.getCaretPosition();
        String insert = isAttribute ? new String("#[XXX]." + action) : new String(action);
        this.mListener.actionInsert(this.getStyledDocument(), insert, pos);
    }

    public Manager getmManager() {
        return this.mManager;
    }

    private void addChild(ActionEvent e) throws BadLocationException {
        String tempAction = e.getActionCommand();
        String action = new String();
        int i = 0;
        while (i < tempAction.length()) {
            if (tempAction.charAt(i) != ' ') {
                action = String.valueOf(action) + tempAction.charAt(i);
            }
            ++i;
        }
        int mLength = this.mManager.getCurrentElement().getmLength();
        String length = new String();
        while (mLength-- >= 0) {
            length = String.valueOf(length) + "    ";
        }
        String attributes = new String();
        if (this.mManager.fetchNecessaryAtr(action) != null) {
            for (Attribute atr : this.mManager.fetchNecessaryAtr(action)) {
                attributes = String.valueOf(attributes) + " " + atr.getName() + "=\"\" ";
            }
        }
        String insert = new String();
        insert = new String("\n" + length + "<" + action + attributes + ">" + "\n" + length + "</" + action + ">");
        int insertPos = this.mManager.getCurrentElement().getChildEndPos() - 3;
        this.getStyledDocument().insertString(insertPos, insert, null);
    }

    private void splitCurrentTag() {
        this.mStart = this.mManager.getCurrentElement().getStartPos() - 3;
        this.mEnd = this.mManager.getCurrentElement().getEndPos();
        int mLength = this.mManager.getCurrentElement().getmLength();
        String action = this.mManager.getCurrentElement().getTAG_NAME();
        String length = new String();
        String attributes = new String();
        Attributes attrs = this.mManager.getCurrentElement().getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            if (attrs.getValue(i) != "") {
                attributes = String.valueOf(attributes) + " ";
                attributes = String.valueOf(attributes) + attrs.getName(i);
                attributes = String.valueOf(attributes) + "=";
                attributes = String.valueOf(attributes) + "\"";
                attributes = String.valueOf(attributes) + attrs.getValue(i);
                attributes = String.valueOf(attributes) + "\"";
            }
            ++i;
        }
        while (mLength-- >= 0) {
            length = String.valueOf(length) + "    ";
        }
        String insert = new String(String.valueOf(length) + "<" + action + attributes + ">" + "\n" + length + "</" + action + ">" + "\n");
        this.replaceRange(insert, this.mStart, this.mEnd);
    }

    private void actionAllAttrs(Attributes values, int temp) throws BadLocationException {
        String insert = new String();
        int i = 0;
        while (i < values.getLength()) {
            if (!values.getValue(i).trim().equals("") && !values.getName(i).equals("_content")) {
                insert = String.valueOf(insert) + " ";
                insert = String.valueOf(insert) + values.getName(i);
                insert = String.valueOf(insert) + "=";
                insert = String.valueOf(insert) + "\"";
                insert = String.valueOf(insert) + values.getValue(i);
                insert = String.valueOf(insert) + "\"";
            }
            ++i;
        }
        insert = String.valueOf(insert) + ">";
        if (values.getValue("_content") != null) {
            insert = String.valueOf(insert) + values.getValue("_content");
        }
        this.getStyledDocument().insertString(this.mPos - 1, insert, null);
    }

    public void find() {
        final JDialog findDialog = new JDialog();
        Container con = findDialog.getContentPane();
        con.setLayout(new FlowLayout(0));
        JLabel findContentLabel = new JLabel("FIND\uff1a");
        JLabel replaceContentLabel = new JLabel("REPLACE\uff1a");
        final JTextField findText = new JTextField(15);
        final JTextField replaceText = new JTextField(15);
        final JButton findNextButton = new JButton("FIND NEXT");
        JButton replaceNextButton = new JButton("REPLACE / NEXT");
        final JCheckBox matchCheckBox = new JCheckBox("CASE-SENSITIVE");
        ButtonGroup bGroup = new ButtonGroup();
        final JRadioButton upButton = new JRadioButton("UP");
        final JRadioButton downButton = new JRadioButton("DOWN");
        downButton.setSelected(true);
        bGroup.add(upButton);
        bGroup.add(downButton);
        findText.setText(this.getSelectedText());
        JButton cancel = new JButton("CANCEL");
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                findDialog.dispose();
            }
        });
        findNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String strB;
                String strA;
                String str1 = TextArea.this.getText();
                String str2 = findText.getText();
                String str3 = str1.toUpperCase();
                String str4 = str2.toUpperCase();
                if (matchCheckBox.isSelected()) {
                    strA = str1;
                    strB = str2;
                } else {
                    strA = str3;
                    strB = str4;
                }
                if (upButton.isSelected()) {
                    if (TextArea.this.getSelectedText() == null) {
                        k = strA.lastIndexOf(strB, TextArea.this.getCaretPosition() - 1);
                    } else {
                        k = strA.lastIndexOf(strB, TextArea.this.getCaretPosition() - findText.getText().length() - 1);
                    }
                    if (k > -1) {
                        TextArea.this.setCaretPosition(k);
                        TextArea.this.select(k, k + strB.length());
                    }
                } else if (downButton.isSelected()) {
                    if (TextArea.this.getSelectedText() == null) {
                        k = strA.indexOf(strB, TextArea.this.getCaretPosition() + 1);
                    } else {
                        k = strA.indexOf(strB, TextArea.this.getCaretPosition() - findText.getText().length() + 1);
                    }
                    if (k > -1) {
                        TextArea.this.setCaretPosition(k);
                        TextArea.this.select(k, k + strB.length());
                    }
                }
                System.out.println("find over" + k);
            }
        });
        replaceNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String strB;
                String strA;
                String str1 = TextArea.this.getText();
                String str2 = findText.getText();
                String strR = replaceText.getText();
                String str3 = str1.toUpperCase();
                String str4 = str2.toUpperCase();
                if (matchCheckBox.isSelected()) {
                    strA = str1;
                    strB = str2;
                } else {
                    strA = str3;
                    strB = str4;
                }
                k = strA.indexOf(strB, TextArea.this.getCaretPosition() - findText.getText().length() - 1);
                if (k > -1) {
                    TextArea.this.replaceRange(strR, k, k + str2.length());
                }
                findNextButton.doClick();
            }
        });
        JPanel panel1 = new JPanel();
        JPanel panel2 = new JPanel();
        JPanel panel3 = new JPanel();
        JPanel panel4 = new JPanel();
        JPanel directionPanel = new JPanel();
        directionPanel.setBorder(BorderFactory.createTitledBorder("DIRECTION"));
        directionPanel.add(upButton);
        directionPanel.add(downButton);
        panel1.setLayout(new GridLayout(3, 2));
        panel1.add(findNextButton);
        panel1.add(replaceNextButton);
        panel1.add(cancel);
        panel4.setLayout(new GridLayout(2, 1));
        panel4.add(findContentLabel);
        panel4.add(findText);
        panel4.add(replaceContentLabel);
        panel4.add(replaceText);
        panel2.add(panel4);
        panel2.add(panel1);
        panel3.add(matchCheckBox);
        panel3.add(directionPanel);
        con.add(panel2);
        con.add(panel3);
        findDialog.setSize(600, 250);
        findDialog.setResizable(false);
        findDialog.setLocation(300, 272);
        findDialog.setVisible(true);
    }

    public void replaceRange(String str, int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException("end before start");
        }
        Document doc = this.getDocument();
        if (start < 0 || end - 1 > doc.getLength()) {
            return;
        }
        --end;
        if (doc != null) {
            try {
                if (doc instanceof AbstractDocument) {
                    ((AbstractDocument)doc).replace(start, end - start, str, null);
                } else {
                    doc.remove(start, end - start);
                    doc.insertString(start, str, null);
                }
            }
            catch (BadLocationException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    public void color(int start, int end) {
        Style mDebugStyle = ((StyledDocument)this.getDocument()).addStyle("DebugStyle", null);
        StyleConstants.setForeground(mDebugStyle, Color.GREEN);
        StyleConstants.setFontSize(mDebugStyle, 15);
        StyleConstants.setFontFamily(mDebugStyle, "lucida bright italic");
        SwingUtilities.invokeLater(new TextColouring((StyledDocument)this.getDocument(), start, end - start, mDebugStyle));
    }

    class UndoHandler
    implements UndoableEditListener {
        UndoHandler() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent uee) {
            if (TextArea.this.mListener.getChangeCount() == 0) {
                TextArea.this.undo.addEdit(uee.getEdit());
            } else {
                TextArea.this.mListener.decreaseChanged();
            }
        }
    }

    private static class XMLFileFilter
    extends FileFilter {
        private XMLFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file == null) {
                return false;
            }
            return file.isDirectory() || file.getName().toLowerCase().endsWith(".xml");
        }

        @Override
        public String getDescription() {
            return "XML files (*.xml)";
        }
    }
}

