/*
 * Decompiled with CFR 0.152.
 */
package miui.os;

import android.text.TextUtils;
import java.io.File;
import java.io.IOException;

public class ExtraFileUtils {
    private ExtraFileUtils() {
    }

    public static boolean mkdirs(File file, int mode, int uid, int gid) {
        if (file.exists()) {
            return false;
        }
        String parentDir = file.getParent();
        if (parentDir != null) {
            ExtraFileUtils.mkdirs(new File(parentDir), mode, uid, gid);
        }
        return file.mkdir();
    }

    public static boolean deleteDir(File fileOrFolder) {
        boolean isSuccess = true;
        if (fileOrFolder.isDirectory()) {
            String[] children = fileOrFolder.list();
            if (children == null) {
                return false;
            }
            int i = 0;
            while (i < children.length) {
                boolean success = ExtraFileUtils.deleteDir(new File(fileOrFolder, children[i]));
                if (!success) {
                    isSuccess = false;
                }
                ++i;
            }
        }
        if (!fileOrFolder.delete()) {
            isSuccess = false;
        }
        return isSuccess;
    }

    public static String getExtension(File file) {
        if (file == null) {
            return "";
        }
        String fileName = file.getName();
        return ExtraFileUtils.getExtension(fileName);
    }

    public static String getExtension(String fileName) {
        if (TextUtils.isEmpty(fileName)) {
            return "";
        }
        int index = fileName.lastIndexOf(".");
        if (index > -1) {
            return fileName.substring(index + 1);
        }
        return "";
    }

    public static String getFileTitle(File file) {
        if (file == null) {
            return "";
        }
        String fileName = file.getName();
        return ExtraFileUtils.getFileTitle(fileName);
    }

    public static String getFileTitle(String fileName) {
        if (TextUtils.isEmpty(fileName)) {
            return "";
        }
        int index = fileName.lastIndexOf(".");
        if (index > -1) {
            return fileName.substring(0, index);
        }
        return fileName;
    }

    public static void addNoMedia(String path) {
        File dir = new File(path);
        if (dir.isDirectory()) {
            try {
                new File(dir, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String getParentFolderPath(String filePath) {
        if (TextUtils.isEmpty(filePath)) {
            return "";
        }
        int index = filePath.lastIndexOf(File.separator);
        if (index > -1) {
            return filePath.substring(0, index);
        }
        return filePath;
    }

    public static String getFileName(String filePath) {
        if (TextUtils.isEmpty(filePath)) {
            return "";
        }
        int index = filePath.lastIndexOf(File.separator);
        if (index > -1) {
            return filePath.substring(index + 1);
        }
        return filePath;
    }

    public static String standardizeFolderPath(String path) {
        return path.endsWith(File.separator) ? path : String.valueOf(path) + File.separator;
    }
}

