/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.jaxp.validation;

import com.sun.org.apache.xerces.internal.jaxp.validation.JAXPValidationMessageFormatter;
import com.sun.org.apache.xerces.internal.jaxp.validation.ValidatorHandlerImpl;
import com.sun.org.apache.xerces.internal.jaxp.validation.ValidatorHelper;
import com.sun.org.apache.xerces.internal.jaxp.validation.XMLSchemaValidatorComponentManager;
import java.io.IOException;
import java.util.Locale;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stax.StAXResult;
import org.xml.sax.SAXException;

public final class StAXValidatorHelper
implements ValidatorHelper {
    private static final String DEFAULT_TRANSFORMER_IMPL = "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl";
    private XMLSchemaValidatorComponentManager fComponentManager;
    private Transformer identityTransformer1 = null;
    private TransformerHandler identityTransformer2 = null;
    private ValidatorHandlerImpl handler = null;

    public StAXValidatorHelper(XMLSchemaValidatorComponentManager xMLSchemaValidatorComponentManager) {
        this.fComponentManager = xMLSchemaValidatorComponentManager;
    }

    public void validate(Source source, Result result) throws SAXException, IOException {
        if (result == null || result instanceof StAXResult) {
            if (this.identityTransformer1 == null) {
                try {
                    SAXTransformerFactory sAXTransformerFactory = this.fComponentManager.getFeature("http://www.oracle.com/feature/use-service-mechanism") ? (SAXTransformerFactory)SAXTransformerFactory.newInstance() : (SAXTransformerFactory)TransformerFactory.newInstance(DEFAULT_TRANSFORMER_IMPL, StAXValidatorHelper.class.getClassLoader());
                    this.identityTransformer1 = sAXTransformerFactory.newTransformer();
                    this.identityTransformer2 = sAXTransformerFactory.newTransformerHandler();
                }
                catch (TransformerConfigurationException transformerConfigurationException) {
                    throw new TransformerFactoryConfigurationError(transformerConfigurationException);
                }
            }
            this.handler = new ValidatorHandlerImpl(this.fComponentManager);
            if (result != null) {
                this.handler.setContentHandler(this.identityTransformer2);
                this.identityTransformer2.setResult(result);
            }
            try {
                this.identityTransformer1.transform(source, new SAXResult(this.handler));
            }
            catch (TransformerException transformerException) {
                if (transformerException.getException() instanceof SAXException) {
                    throw (SAXException)transformerException.getException();
                }
                throw new SAXException(transformerException);
            }
            finally {
                this.handler.setContentHandler(null);
            }
            return;
        }
        throw new IllegalArgumentException(JAXPValidationMessageFormatter.formatMessage(Locale.getDefault(), "SourceResultMismatch", new Object[]{source.getClass().getName(), result.getClass().getName()}));
    }
}

