/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.filechooser;

import com.alee.extended.filechooser.DirectoryChooserListener;
import com.alee.extended.filechooser.PathFieldListener;
import com.alee.extended.filechooser.WebPathField;
import com.alee.extended.filefilter.DefaultFileFilter;
import com.alee.extended.tree.WebFileTree;
import com.alee.laf.GlobalConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.optionpane.WebOptionPane;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.scroll.WebScrollPane;
import com.alee.laf.toolbar.ToolbarStyle;
import com.alee.laf.toolbar.WebToolBar;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.tooltip.TooltipManager;
import com.alee.managers.tooltip.TooltipWay;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FileUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class WebDirectoryChooserPanel
extends WebPanel {
    private static final ImageIcon FOLDER_UP_ICON = new ImageIcon(WebDirectoryChooserPanel.class.getResource("icons/folder_up.png"));
    private static final ImageIcon FOLDER_HOME_ICON = new ImageIcon(WebDirectoryChooserPanel.class.getResource("icons/folder_home.png"));
    private static final ImageIcon FOLDER_NEW_ICON = new ImageIcon(WebDirectoryChooserPanel.class.getResource("icons/folder_new.png"));
    private static final ImageIcon REFRESH_ICON = new ImageIcon(WebDirectoryChooserPanel.class.getResource("icons/refresh.png"));
    private static final ImageIcon REMOVE_ICON = new ImageIcon(WebDirectoryChooserPanel.class.getResource("icons/remove.png"));
    public static DefaultFileFilter defaultFileFilter = GlobalConstants.DIRECTORIES_FILTER;
    private List<DirectoryChooserListener> listeners = new ArrayList<DirectoryChooserListener>();
    private File selectedFolder = FileUtils.getDiskRoots()[0];
    private WebPathField webPathField;
    private WebFileTree fileTree;
    private TreeSelectionListener fileTreeListener;
    private WebButton folderUp;
    private WebButton folderHome;
    private WebButton folderNew;
    private WebButton refresh;
    private WebButton remove;

    public WebDirectoryChooserPanel() {
        this.setOpaque(true);
        WebToolBar webToolBar = new WebToolBar(0);
        webToolBar.setToolbarStyle(ToolbarStyle.attached);
        webToolBar.setFloatable(false);
        this.folderUp = new WebButton(FOLDER_UP_ICON);
        this.folderUp.setLanguage("weblaf.ex.dirchooser.folderup", new Object[0]);
        this.folderUp.addHotkey(this, Hotkey.ALT_UP).setHotkeyDisplayWay(TooltipWay.down);
        this.folderUp.setRolloverDecoratedOnly(true);
        this.folderUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (WebDirectoryChooserPanel.this.selectedFolder != null) {
                    WebDirectoryChooserPanel.this.updateShownFolder(WebDirectoryChooserPanel.this.selectedFolder.getParentFile(), true, true);
                }
            }
        });
        webToolBar.add((Component)this.folderUp);
        this.folderHome = new WebButton(FOLDER_HOME_ICON);
        this.folderHome.setLanguage("weblaf.ex.dirchooser.home", new Object[0]);
        this.folderHome.addHotkey(this, Hotkey.ALT_H).setHotkeyDisplayWay(TooltipWay.trailing);
        this.folderHome.setRolloverDecoratedOnly(true);
        this.folderHome.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebDirectoryChooserPanel.this.updateShownFolder(FileUtils.getUserHome(), true, true);
            }
        });
        webToolBar.add((Component)this.folderHome);
        webToolBar.addSeparator();
        for (final File file : FileUtils.getDiskRoots()) {
            WebButton webButton = new WebButton(FileUtils.getFileIcon(file));
            TooltipManager.setTooltip((Component)webButton, FileUtils.getDisplayFileName(file));
            webButton.setRolloverDecoratedOnly(true);
            webButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WebDirectoryChooserPanel.this.updateShownFolder(file, true, true);
                }
            });
            webToolBar.add((Component)webButton);
        }
        this.refresh = new WebButton(REFRESH_ICON);
        this.refresh.setLanguage("weblaf.ex.dirchooser.refresh", new Object[0]);
        this.refresh.addHotkey(this, Hotkey.F5).setHotkeyDisplayWay(TooltipWay.leading);
        this.refresh.setRolloverDecoratedOnly(true);
        this.refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebDirectoryChooserPanel.this.fileTree.removeFile(WebDirectoryChooserPanel.this.selectedFolder);
                WebDirectoryChooserPanel.this.updateShownFolder(WebDirectoryChooserPanel.this.selectedFolder, true, true);
            }
        });
        webToolBar.add((Component)this.refresh, (Object)"END");
        this.folderNew = new WebButton(FOLDER_NEW_ICON);
        this.folderNew.setLanguage("weblaf.ex.dirchooser.newfolder", new Object[0]);
        this.folderNew.addHotkey(this, Hotkey.CTRL_N).setHotkeyDisplayWay(TooltipWay.down);
        this.folderNew.setRolloverDecoratedOnly(true);
        this.folderNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (WebDirectoryChooserPanel.this.selectedFolder != null) {
                    String string = LanguageManager.get("weblaf.ex.dirchooser.newfolder.name");
                    String string2 = FileUtils.getAvailableName(WebDirectoryChooserPanel.this.selectedFolder, string);
                    File file = new File(WebDirectoryChooserPanel.this.selectedFolder, string2);
                    if (file.mkdir()) {
                        WebDirectoryChooserPanel.this.fileTree.addFile(WebDirectoryChooserPanel.this.selectedFolder, file);
                        WebDirectoryChooserPanel.this.fileTree.setSelectedFile(file);
                        WebDirectoryChooserPanel.this.fileTree.startEditingAtPath(WebDirectoryChooserPanel.this.fileTree.getSelectionPath());
                    } else {
                        String string3 = LanguageManager.get("weblaf.ex.dirchooser.newfolder.error.text");
                        String string4 = LanguageManager.get("weblaf.ex.dirchooser.newfolder.error.title");
                        WebOptionPane.showMessageDialog(WebDirectoryChooserPanel.this, string3, string4, 0);
                    }
                }
            }
        });
        webToolBar.add((Component)this.folderNew, (Object)"END");
        this.remove = new WebButton(REMOVE_ICON);
        this.remove.setLanguage("weblaf.ex.dirchooser.delete", new Object[0]);
        this.remove.addHotkey(this, Hotkey.DELETE).setHotkeyDisplayWay(TooltipWay.down);
        this.remove.setRolloverDecoratedOnly(true);
        this.remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                File file = WebDirectoryChooserPanel.this.fileTree.getSelectedFile();
                if (file == null) {
                    return;
                }
                String string2 = LanguageManager.get("weblaf.ex.dirchooser.delete.confirm.text");
                int n = WebOptionPane.showConfirmDialog(WebDirectoryChooserPanel.this, string2, string = LanguageManager.get("weblaf.ex.dirchooser.delete.confirm.title"), 0, 3);
                if (n == 0) {
                    FileUtils.deleteFile(file);
                    WebDirectoryChooserPanel.this.fileTree.removeFile(file);
                    WebDirectoryChooserPanel.this.updateShownFolder(WebDirectoryChooserPanel.this.selectedFolder, true, true);
                }
            }
        });
        webToolBar.add((Component)this.remove, (Object)"END");
        this.webPathField = new WebPathField(this.selectedFolder);
        this.webPathField.setFileFilter(defaultFileFilter);
        this.webPathField.addWebPathFieldListener(new PathFieldListener(){

            @Override
            public void directoryChanged(File file) {
                WebDirectoryChooserPanel.this.updateShownFolder(WebDirectoryChooserPanel.this.webPathField.getSelectedPath(), false, true);
            }
        });
        this.fileTree = new WebFileTree();
        this.fileTree.setVisibleRowCount(15);
        this.fileTree.setFileFilter(defaultFileFilter);
        this.fileTree.setSelectedFile(this.selectedFolder, true);
        this.fileTree.setSelectionMode(1);
        this.fileTreeListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                WebDirectoryChooserPanel.this.updateShownFolder(WebDirectoryChooserPanel.this.fileTree.getSelectedFile(), true, false);
            }
        };
        this.fileTree.addTreeSelectionListener(this.fileTreeListener);
        this.fileTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                WebDirectoryChooserPanel.this.updateToolbar();
            }
        });
        WebScrollPane webScrollPane = new WebScrollPane(this.fileTree);
        webScrollPane.setPreferredWidth(400);
        this.updateToolbar();
        this.setLayout(new BorderLayout(0, 3));
        this.add((Component)webToolBar, (Object)"North");
        WebPanel webPanel = new WebPanel(new BorderLayout(0, 1));
        webPanel.setMargin(0, 3, 2, 3);
        webPanel.add((Component)this.webPathField, (Object)"North");
        webPanel.add((Component)webScrollPane, (Object)"Center");
        this.add((Component)webPanel, (Object)"Center");
    }

    private void updateToolbar() {
        File file = this.fileTree.getSelectedFile();
        this.folderUp.setEnabled(file != null && file.getParentFile() != null);
        this.folderNew.setEnabled(file != null && file.canWrite());
        this.remove.setEnabled(file != null && file.getParentFile() != null && file.canWrite());
    }

    public boolean allowHotkeys() {
        return !this.fileTree.isEditing() && !this.webPathField.isEditing();
    }

    private void updateShownFolder(File file, boolean bl, boolean bl2) {
        this.selectedFolder = file;
        if (bl) {
            this.webPathField.setSelectedPath(file);
        }
        if (bl2) {
            this.fileTree.removeTreeSelectionListener(this.fileTreeListener);
            this.fileTree.setSelectedFile(file, true);
            this.fileTree.addTreeSelectionListener(this.fileTreeListener);
        }
        this.fireSelectionChanged(this.selectedFolder);
    }

    public File getSelectedFolder() {
        return this.selectedFolder;
    }

    public void setSelectedFolder(File file) {
        this.updateShownFolder(file, true, true);
    }

    public void addWebDirectoryChooserListener(DirectoryChooserListener directoryChooserListener) {
        this.listeners.add(directoryChooserListener);
    }

    public void removeWebDirectoryChooserListener(DirectoryChooserListener directoryChooserListener) {
        this.listeners.remove(directoryChooserListener);
    }

    private void fireSelectionChanged(File file) {
        for (DirectoryChooserListener directoryChooserListener : CollectionUtils.copy(this.listeners)) {
            directoryChooserListener.selectionChanged(file);
        }
    }
}

