/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.image;

import com.alee.extended.image.WebDecoratedImageStyle;
import com.alee.graphics.filters.ImageFilterUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingConstants;

public class WebDecoratedImage
extends JComponent
implements SwingConstants,
ShapeProvider {
    private ImageIcon icon;
    private ImageIcon previewIcon;
    private int horizontalAlignment = WebDecoratedImageStyle.horizontalAlignment;
    private int verticalAlignment = WebDecoratedImageStyle.verticalAlignment;
    private boolean drawBorder = WebDecoratedImageStyle.drawBorder;
    private Color borderColor = WebDecoratedImageStyle.borderColor;
    private boolean drawGlassLayer = WebDecoratedImageStyle.drawGlassLayer;
    private int shadeWidth = WebDecoratedImageStyle.shadeWidth;
    private int round = WebDecoratedImageStyle.round;
    private float blurAlignX = WebDecoratedImageStyle.blurAlignX;
    private float blurAlignY = WebDecoratedImageStyle.blurAlignY;
    private boolean grayscale = WebDecoratedImageStyle.grayscale;
    private boolean blur = WebDecoratedImageStyle.blur;
    private float blurFactor = WebDecoratedImageStyle.blurFactor;
    private boolean zoomBlur = WebDecoratedImageStyle.zoomBlur;
    private float zoomBlurFactor = WebDecoratedImageStyle.zoomBlurFactor;
    private boolean rotationBlur = WebDecoratedImageStyle.rotationBlur;
    private float rotationBlurFactor = WebDecoratedImageStyle.rotationBlurFactor;

    public WebDecoratedImage() {
        this((ImageIcon)null);
    }

    public WebDecoratedImage(String string) {
        this(ImageUtils.loadImage(string));
    }

    public WebDecoratedImage(Class clazz, String string) {
        this(ImageUtils.loadImage(clazz, string));
    }

    public WebDecoratedImage(Image image) {
        SwingUtils.setOrientation(this);
        this.setImage(image);
    }

    public WebDecoratedImage(ImageIcon imageIcon) {
        SwingUtils.setOrientation(this);
        this.setIcon(imageIcon);
    }

    public ImageIcon getPreviewIcon() {
        return this.previewIcon;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void setImage(Image image) {
        this.setImage(image, true);
    }

    public void setImage(Image image, boolean bl) {
        this.setIcon(new ImageIcon(image), bl);
    }

    public void setIcon(ImageIcon imageIcon) {
        this.setIcon(imageIcon, true);
    }

    public void setIcon(ImageIcon imageIcon, boolean bl) {
        this.icon = imageIcon;
        if (bl) {
            this.updatePreview();
        }
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int n) {
        this.horizontalAlignment = n;
        this.repaintPreview();
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int n) {
        this.verticalAlignment = n;
        this.repaintPreview();
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean bl) {
        this.setDrawBorder(bl, true);
    }

    public void setDrawBorder(boolean bl, boolean bl2) {
        this.drawBorder = bl;
        if (bl2) {
            this.updatePreview();
        }
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.setBorderColor(color, true);
    }

    public void setBorderColor(Color color, boolean bl) {
        this.borderColor = color;
        if (bl) {
            this.updatePreview();
        }
    }

    public boolean isDrawGlassLayer() {
        return this.drawGlassLayer;
    }

    public void setDrawGlassLayer(boolean bl) {
        this.setDrawGlassLayer(bl, true);
    }

    public void setDrawGlassLayer(boolean bl, boolean bl2) {
        this.drawGlassLayer = bl;
        if (bl2) {
            this.updatePreview();
        }
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int n) {
        this.setShadeWidth(n, true);
    }

    public void setShadeWidth(int n, boolean bl) {
        this.shadeWidth = n;
        if (bl) {
            this.updatePreview();
        }
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int n) {
        this.setRound(n, true);
    }

    public void setRound(int n, boolean bl) {
        this.round = n;
        if (bl) {
            this.updatePreview();
        }
    }

    public boolean isGrayscale() {
        return this.grayscale;
    }

    public void setGrayscale(boolean bl) {
        this.setGrayscale(bl, true);
    }

    public void setGrayscale(boolean bl, boolean bl2) {
        this.grayscale = bl;
        if (bl2) {
            this.updatePreview();
        }
    }

    public boolean isBlur() {
        return this.blur;
    }

    public void setBlur(boolean bl) {
        this.setBlur(bl, true);
    }

    public void setBlur(boolean bl, boolean bl2) {
        this.blur = bl;
        if (bl2) {
            this.updatePreview();
        }
    }

    public float getBlurFactor() {
        return this.blurFactor;
    }

    public void setBlurFactor(float f) {
        this.setBlurFactor(f, true);
    }

    public void setBlurFactor(float f, boolean bl) {
        this.blurFactor = f;
        if (bl) {
            this.updatePreview();
        }
    }

    public boolean isZoomBlur() {
        return this.zoomBlur;
    }

    public void setZoomBlur(boolean bl) {
        this.setZoomBlur(bl, true);
    }

    public void setZoomBlur(boolean bl, boolean bl2) {
        this.zoomBlur = bl;
        if (bl2) {
            this.updatePreview();
        }
    }

    public float getZoomBlurFactor() {
        return this.zoomBlurFactor;
    }

    public void setZoomBlurFactor(float f) {
        this.setZoomBlurFactor(f, true);
    }

    public void setZoomBlurFactor(float f, boolean bl) {
        this.zoomBlurFactor = f;
        if (bl) {
            this.updatePreview();
        }
    }

    public boolean isRotationBlur() {
        return this.rotationBlur;
    }

    public void setRotationBlur(boolean bl) {
        this.setRotationBlur(bl, true);
    }

    public void setRotationBlur(boolean bl, boolean bl2) {
        this.rotationBlur = bl;
        if (bl2) {
            this.updatePreview();
        }
    }

    public float getRotationBlurFactor() {
        return this.rotationBlurFactor;
    }

    public void setRotationBlurFactor(float f) {
        this.setRotationBlurFactor(f, true);
    }

    public void setRotationBlurFactor(float f, boolean bl) {
        this.rotationBlurFactor = f;
        if (bl) {
            this.updatePreview();
        }
    }

    public float getBlurAlignX() {
        return this.blurAlignX;
    }

    public void setBlurAlignX(float f) {
        this.setBlurAlignX(f, true);
    }

    public void setBlurAlignX(float f, boolean bl) {
        this.blurAlignX = f;
        if (bl) {
            this.updatePreview();
        }
    }

    public float getBlurAlignY() {
        return this.blurAlignY;
    }

    public void setBlurAlignY(float f) {
        this.setBlurAlignY(f, true);
    }

    public void setBlurAlignY(float f, boolean bl) {
        this.blurAlignY = f;
        if (bl) {
            this.updatePreview();
        }
    }

    public void updatePreview() {
        BufferedImage bufferedImage = ImageUtils.copy(this.icon.getImage());
        if (this.grayscale) {
            ImageFilterUtils.applyGrayscaleFilter((Image)bufferedImage, (Image)bufferedImage);
        }
        if (this.blur) {
            ImageFilterUtils.applyGaussianFilter((Image)bufferedImage, (Image)bufferedImage, this.blurFactor);
        }
        if (this.zoomBlur && this.rotationBlur) {
            ImageFilterUtils.applyMotionBlurFilter((Image)bufferedImage, (Image)bufferedImage, 0.0f, 0.0f, this.rotationBlurFactor, this.zoomBlurFactor, this.blurAlignX, this.blurAlignY);
        } else if (this.zoomBlur) {
            ImageFilterUtils.applyZoomBlurFilter((Image)bufferedImage, (Image)bufferedImage, this.zoomBlurFactor, this.blurAlignX, this.blurAlignY);
        } else if (this.rotationBlur) {
            ImageFilterUtils.applyRotationBlurFilter((Image)bufferedImage, (Image)bufferedImage, this.rotationBlurFactor, this.blurAlignX, this.blurAlignY);
        }
        if (this.round > 0) {
            bufferedImage = ImageUtils.cutImage((Shape)new RoundRectangle2D.Double(0.0, 0.0, this.icon.getIconWidth(), this.icon.getIconHeight(), this.round * 2, this.round * 2), bufferedImage);
        }
        if (this.shadeWidth > 0 || this.drawGlassLayer || this.drawBorder) {
            Dimension dimension = this.getPreferredSize();
            BufferedImage bufferedImage2 = ImageUtils.createCompatibleImage(dimension.width, dimension.height, 3);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            LafUtils.setupAntialias(graphics2D);
            Shape shape = this.getBorderShape();
            LafUtils.drawShade(graphics2D, shape, WebDecoratedImageStyle.shadeType, new Color(90, 90, 90), this.shadeWidth);
            graphics2D.drawImage((Image)bufferedImage, this.shadeWidth, this.shadeWidth, null);
            if (this.drawGlassLayer) {
                graphics2D.setPaint(new GradientPaint(0.0f, this.shadeWidth, new Color(255, 255, 255, 160), 0.0f, this.shadeWidth + (dimension.height - this.shadeWidth * 2) / 2, new Color(255, 255, 255, 32)));
                graphics2D.fill(this.getGlanceShape());
            }
            if (this.drawBorder) {
                graphics2D.setPaint(this.borderColor);
                graphics2D.draw(shape);
            }
            graphics2D.dispose();
            bufferedImage = bufferedImage2;
        }
        this.previewIcon = new ImageIcon(bufferedImage);
        this.repaintPreview();
    }

    private Shape getGlanceShape() {
        Dimension dimension = this.getPreferredSize();
        if (this.round > 0) {
            return new RoundRectangle2D.Double(this.shadeWidth, this.shadeWidth, dimension.width - this.shadeWidth * 2, (dimension.height - this.shadeWidth * 2) / 2, this.round * 2, this.round * 2);
        }
        return new Rectangle(this.shadeWidth, this.shadeWidth, dimension.width - this.shadeWidth * 2, (dimension.height - this.shadeWidth * 2) / 2);
    }

    private Shape getBorderShape() {
        return this.getBorderShape(0, 0);
    }

    private Shape getBorderShape(int n, int n2) {
        Dimension dimension = this.getPreferredSize();
        if (this.round > 0) {
            return new RoundRectangle2D.Double(n + this.shadeWidth, n2 + this.shadeWidth, dimension.width - this.shadeWidth * 2 - 1, dimension.height - this.shadeWidth * 2 - 1, this.round * 2, this.round * 2);
        }
        return new Rectangle(n + this.shadeWidth, n2 + this.shadeWidth, dimension.width - this.shadeWidth * 2 - 1, dimension.height - this.shadeWidth * 2 - 1);
    }

    private void repaintPreview() {
        if (this.isShowing()) {
            this.repaint();
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.previewIcon != null) {
            Point point = this.getPreviewLocation();
            graphics.drawImage(this.previewIcon.getImage(), point.x, point.y, null);
        }
    }

    private Point getPreviewLocation() {
        int n = this.previewIcon.getIconWidth();
        int n2 = this.previewIcon.getIconHeight();
        int n3 = this.horizontalAlignment == 2 ? 0 : (this.horizontalAlignment == 4 ? this.getWidth() - n : this.getWidth() / 2 - n / 2);
        int n4 = this.verticalAlignment == 1 ? 0 : (this.verticalAlignment == 3 ? this.getHeight() - n2 : this.getHeight() / 2 - n2 / 2);
        return new Point(n3, n4);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.icon != null) {
            return new Dimension(this.shadeWidth * 2 + this.icon.getIconWidth(), this.shadeWidth * 2 + this.icon.getIconHeight());
        }
        return new Dimension(0, 0);
    }

    @Override
    public Shape provideShape() {
        Point point = this.getPreviewLocation();
        return this.getBorderShape(point.x, point.y);
    }
}

