/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.image;

import com.alee.laf.StyleConstants;
import com.alee.laf.scroll.WebScrollPane;
import com.alee.managers.hotkey.Hotkey;
import com.alee.utils.ImageUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.Timer;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class WebImageGallery
extends JComponent {
    private int spacing = 20;
    private int imageLength = 200;
    private int borderWidth = 3;
    private float fadeHeight = 0.7f;
    private int opacity = 125;
    private Color light = new Color(128, 128, 128);
    private Color selectedLight = new Color(255, 255, 255);
    private Color transparent = new Color(128, 128, 128, 0);
    private Color selectedTransparent = new Color(255, 255, 255, 0);
    private int maxWidth = 0;
    private int maxHeight = 0;
    private List<ImageIcon> images = new ArrayList<ImageIcon>();
    private List<BufferedImage> reflections = new ArrayList<BufferedImage>();
    private List<String> descriptions = new ArrayList<String>();
    private int preferredColumnCount = 4;
    private boolean scrollOnSelection = true;
    private int selectedIndex = -1;
    private int oldSelectedIndex = -1;
    private float progress = 0.0f;
    private Timer reflectionMover = null;
    private WebScrollPane view;

    public WebImageGallery() {
        SwingUtils.setOrientation(this);
        this.setFocusable(true);
        this.setFont(new JLabel().getFont().deriveFont(1));
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    WebImageGallery.this.requestFocusInWindow();
                    for (int i = 0; i < WebImageGallery.this.images.size(); ++i) {
                        if (!WebImageGallery.this.getImageRect(i).contains(mouseEvent.getPoint())) continue;
                        WebImageGallery.this.setSelectedIndex(i);
                        break;
                    }
                }
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                int n;
                int n2 = WebImageGallery.this.getSelectedIndex();
                int n3 = WebImageGallery.this.images.size() - 1;
                int n4 = mouseWheelEvent.getWheelRotation();
                if (n4 > 0) {
                    for (n = n2 + n4; n > n3; n -= WebImageGallery.this.images.size()) {
                    }
                } else {
                    for (n = n2 + n4; n < 0; n += WebImageGallery.this.images.size()) {
                    }
                }
                WebImageGallery.this.setSelectedIndex(n);
            }
        };
        this.addMouseListener(mouseAdapter);
        this.addMouseWheelListener(mouseAdapter);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (WebImageGallery.this.images.size() > 0) {
                    int n = WebImageGallery.this.getSelectedIndex();
                    if (Hotkey.LEFT.isTriggered(keyEvent)) {
                        WebImageGallery.this.setSelectedIndex(n == -1 || n == 0 ? WebImageGallery.this.images.size() - 1 : n - 1);
                    } else if (Hotkey.RIGHT.isTriggered(keyEvent)) {
                        WebImageGallery.this.setSelectedIndex(n == -1 || n == WebImageGallery.this.images.size() - 1 ? 0 : n + 1);
                    } else if (Hotkey.HOME.isTriggered(keyEvent)) {
                        WebImageGallery.this.setSelectedIndex(0);
                    } else if (Hotkey.END.isTriggered(keyEvent)) {
                        WebImageGallery.this.setSelectedIndex(WebImageGallery.this.images.size() - 1);
                    }
                }
            }
        });
    }

    public List<ImageIcon> getImages() {
        return this.images;
    }

    public int getPreferredColumnCount() {
        return this.preferredColumnCount;
    }

    public void setPreferredColumnCount(int n) {
        this.preferredColumnCount = n;
    }

    public WebScrollPane getView() {
        return this.getView(true);
    }

    public WebScrollPane getView(boolean bl) {
        if (this.view == null) {
            this.view = new WebScrollPane(this, bl){

                @Override
                public Dimension getPreferredSize() {
                    int n = Math.min(WebImageGallery.this.images.size(), WebImageGallery.this.preferredColumnCount);
                    return new Dimension(WebImageGallery.this.spacing * (n + 1) + n * WebImageGallery.this.maxWidth, WebImageGallery.this.getPreferredSize().height + 13);
                }
            };
            this.view.setHorizontalScrollBarPolicy(31);
            this.view.setVerticalScrollBarPolicy(21);
            InputMap inputMap = this.view.getInputMap(1);
            inputMap.put(KeyStroke.getKeyStroke("UP"), "none");
            inputMap.put(KeyStroke.getKeyStroke("DOWN"), "none");
            inputMap.put(KeyStroke.getKeyStroke("LEFT"), "none");
            inputMap.put(KeyStroke.getKeyStroke("RIGHT"), "none");
        }
        return this.view;
    }

    public int getImageLength() {
        return this.imageLength;
    }

    public void setImageLength(int n) {
        this.imageLength = n;
    }

    public boolean isScrollOnSelection() {
        return this.scrollOnSelection;
    }

    public void setScrollOnSelection(boolean bl) {
        this.scrollOnSelection = bl;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int n) {
        if (this.selectedIndex == n) {
            return;
        }
        this.oldSelectedIndex = this.selectedIndex;
        this.selectedIndex = n;
        this.repaint();
        if (this.scrollOnSelection) {
            Rectangle rectangle = this.getImageRect(n);
            SwingUtils.scrollSmoothly(this.getView(), rectangle.x + rectangle.width / 2 - this.getVisibleRect().width / 2, rectangle.y);
        }
        this.moveReflection();
    }

    private void moveReflection() {
        if (this.reflectionMover != null && this.reflectionMover.isRunning()) {
            this.reflectionMover.stop();
        }
        this.progress = 0.0f;
        this.reflectionMover = new Timer("WebImageGallery.reflectionMoveTimer", (long)StyleConstants.fastAnimationDelay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (WebImageGallery.this.progress < 1.0f) {
                    WebImageGallery.this.progress += 0.08f;
                    WebImageGallery.this.progress = Math.min(WebImageGallery.this.progress, 1.0f);
                    WebImageGallery.this.repaint();
                } else {
                    WebImageGallery.this.reflectionMover.stop();
                }
            }
        });
        this.reflectionMover.start();
    }

    public Rectangle getImageRect(int n) {
        int n2 = this.images.get(n).getIconWidth();
        int n3 = this.images.get(n).getIconHeight();
        Dimension dimension = this.getPreferredSize();
        int n4 = (this.getWidth() > dimension.width ? (this.getWidth() - dimension.width) / 2 : 0) + this.spacing + (this.maxWidth + this.spacing) * n + this.maxWidth / 2;
        int n5 = this.getHeight() / 2 - this.spacing / 2 - n3 / 2;
        return new Rectangle(n4 - n2 / 2, n5 - n3 / 2, n2, n3);
    }

    public void addImage(ImageIcon imageIcon) {
        this.addImage(0, imageIcon);
    }

    public void addImage(int n, ImageIcon imageIcon) {
        try {
            ImageIcon imageIcon2 = ImageUtils.createPreviewIcon(imageIcon, this.imageLength);
            int n2 = imageIcon2.getIconWidth();
            int n3 = imageIcon2.getIconHeight();
            BufferedImage bufferedImage = ImageUtils.createCompatibleImage(n2, n3, 3);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            LafUtils.setupAntialias(graphics2D);
            graphics2D.drawImage(imageIcon2.getImage(), 0, 0, null);
            graphics2D.setComposite(AlphaComposite.getInstance(6));
            graphics2D.setPaint(new GradientPaint(0.0f, (float)n3 * (1.0f - this.fadeHeight), new Color(0, 0, 0, 0), 0.0f, n3, new Color(0, 0, 0, this.opacity)));
            graphics2D.fillRect(0, 0, n2, n3);
            graphics2D.dispose();
            this.images.add(n, imageIcon2);
            this.descriptions.add(n, imageIcon.getIconWidth() + " x " + imageIcon.getIconHeight() + " px");
            this.reflections.add(n, bufferedImage);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.recalcualteMaxSizes();
        this.updateContainer();
    }

    public void removeImage(ImageIcon imageIcon) {
        if (this.images.contains(imageIcon)) {
            this.removeImage(this.images.indexOf(imageIcon));
        }
    }

    public void removeImage(int n) {
        if (n >= 0 && n < this.images.size()) {
            boolean bl = this.getSelectedIndex() == n;
            this.images.remove(n);
            this.descriptions.remove(n);
            this.reflections.remove(n).flush();
            this.recalcualteMaxSizes();
            this.updateContainer();
            if (bl && this.images.size() > 0) {
                this.setSelectedIndex(n < this.images.size() ? n : n - 1);
            }
        }
    }

    private void updateContainer() {
        if (this.getParent() instanceof JComponent) {
            ((JComponent)this.getParent()).revalidate();
        }
        this.repaint();
    }

    private void recalcualteMaxSizes() {
        for (ImageIcon imageIcon : this.images) {
            this.maxWidth = Math.max(this.maxWidth, imageIcon.getIconWidth());
            this.maxHeight = Math.max(this.maxHeight, imageIcon.getIconHeight());
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int n = this.getHeight();
        int n2 = this.getWidth();
        Graphics2D graphics2D = (Graphics2D)graphics;
        LafUtils.setupAntialias(graphics2D);
        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, Color.black, 0.0f, n, Color.darkGray));
        graphics2D.fillRect(0, 0, n2, n);
        Rectangle rectangle = this.getVisibleRect();
        Dimension dimension = this.getPreferredSize();
        Composite composite = graphics2D.getComposite();
        for (int i = 0; i < this.images.size(); ++i) {
            int n3;
            if (!this.getImageRect(i).intersects(rectangle)) continue;
            ImageIcon imageIcon = this.images.get(i);
            BufferedImage bufferedImage = ImageUtils.getBufferedImage(imageIcon);
            int n4 = imageIcon.getIconWidth();
            int n5 = imageIcon.getIconHeight();
            int n6 = (this.getWidth() > dimension.width ? (this.getWidth() - dimension.width) / 2 : 0) + this.spacing + (this.maxWidth + this.spacing) * i + this.maxWidth / 2;
            int n7 = n / 2 - this.spacing / 2 - n5 / 2;
            int n8 = n / 2 + this.spacing / 2 + n5 / 2;
            float f = this.selectedIndex == i ? this.progress * 0.4f : (this.oldSelectedIndex == i ? 0.4f - this.progress * 0.4f : 0.0f);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.6f + f));
            graphics2D.drawImage((Image)bufferedImage, n6 - n4 / 2, n7 - n5 / 2, null);
            graphics2D.setPaint(this.selectedIndex == i ? Color.WHITE : Color.GRAY);
            Area area = new Area(new RoundRectangle2D.Double(n6 - n4 / 2 - this.borderWidth, n7 - n5 / 2 - this.borderWidth, n4 + this.borderWidth * 2, n5 + this.borderWidth * 2, this.borderWidth * 2, this.borderWidth * 2));
            area.subtract(new Area(new Rectangle(n6 - n4 / 2, n7 - n5 / 2, n4, n5)));
            graphics2D.fill(area);
            graphics2D.setComposite(composite);
            if (this.selectedIndex == i || this.oldSelectedIndex == i) {
                float f2 = this.selectedIndex == i ? this.progress : 1.0f - this.progress;
                graphics2D.setComposite(AlphaComposite.getInstance(3, f2));
                graphics2D.setPaint(Color.WHITE);
                String string = this.descriptions.get(i);
                graphics2D.drawString(string, n6 - graphics2D.getFontMetrics().stringWidth(string) / 2, this.getHeight() / 2 + this.spacing / 2 + graphics2D.getFontMetrics().getAscent() / 2);
                graphics2D.setComposite(composite);
            }
            int n9 = n4 + this.borderWidth * 2;
            int n10 = n5 + this.borderWidth * 2;
            int n11 = this.selectedIndex == i ? Math.round(this.progress * (float)this.spacing) : (n3 = this.oldSelectedIndex == i ? this.spacing - Math.round(this.progress * (float)this.spacing) : 0);
            if (this.reflections.get(i) != null) {
                graphics2D.drawImage(this.reflections.get(i), n6 - n4 / 2, n8 + n5 / 2 + n3, n4, -n5, null);
            }
            area = new Area(new RoundRectangle2D.Double(n6 - n9 / 2, n8 - n10 / 2 + n3, n9, n10, this.borderWidth * 2, this.borderWidth * 2));
            area.subtract(new Area(new Rectangle(n6 - n9 / 2 + this.borderWidth, n8 - n10 / 2 + n3 + this.borderWidth, n9 - this.borderWidth * 2, n10 - this.borderWidth * 2)));
            graphics2D.setPaint(new GradientPaint(0.0f, n8 - n5 / 2 + n3, this.selectedIndex == i ? this.selectedLight : this.light, 0.0f, (float)(n8 - n5 / 2 + n3) + (float)n5 * this.fadeHeight, this.selectedIndex == i ? this.selectedTransparent : this.transparent));
            graphics2D.fill(area);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.spacing * (this.images.size() + 1) + this.maxWidth * this.images.size(), this.spacing * 3 + this.maxHeight * 2);
    }
}

