/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.colorchooser;

import com.alee.laf.colorchooser.LineColorChooserPaint;
import com.alee.laf.panel.WebPanel;
import com.alee.utils.CollectionUtils;
import com.alee.utils.SwingUtils;
import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LineColorChooser
extends WebPanel {
    private List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();
    public static final ImageIcon LEFT_ICON = new ImageIcon(LineColorChooser.class.getResource("icons/left.png"));
    public static final ImageIcon RIGHT_ICON = new ImageIcon(LineColorChooser.class.getResource("icons/right.png"));
    private int hue = 0;
    private boolean webOnlyColors = false;
    private LineColorChooserPaint lineColorChooserPaint = new LineColorChooserPaint(2, 256);
    private LinePalette colorLine;

    public LineColorChooser() {
        this.setLayout(new TableLayout(new double[][]{{10.0, -2.0, 10.0}, {3.0, -2.0, 3.0}}));
        this.colorLine = new LinePalette();
        this.add((Component)this.colorLine, (Object)"1,1");
        ColorLineMouseAdapter colorLineMouseAdapter = new ColorLineMouseAdapter();
        this.addMouseListener(colorLineMouseAdapter);
        this.addMouseMotionListener(colorLineMouseAdapter);
    }

    private void setHue(int n, boolean bl) {
        if (this.hue == n) {
            return;
        }
        if (n < 0) {
            n = 0;
        } else if (n > 360) {
            n = 360;
        }
        this.hue = n;
        this.repaint();
        this.firePropertyChanged();
    }

    public int getHue() {
        return 360 - this.hue;
    }

    public void setColor(Color color) {
        this.setHue(360 - Math.round(360.0f * Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null)[0]), false);
    }

    public Color getColor() {
        return this.lineColorChooserPaint.getColor(Math.round((float)(this.colorLine.getHeight() - 4) * (float)this.hue / 360.0f));
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.drawImage(LEFT_ICON.getImage(), 1, 1 + Math.round((float)this.hue / 360.0f * (float)(this.colorLine.getHeight() - 5)), LEFT_ICON.getImageObserver());
        graphics.drawImage(RIGHT_ICON.getImage(), this.getWidth() - RIGHT_ICON.getIconWidth() - 1, 1 + Math.round((float)this.hue / 360.0f * (float)(this.colorLine.getHeight() - 5)), RIGHT_ICON.getImageObserver());
    }

    public boolean isWebOnlyColors() {
        return this.webOnlyColors;
    }

    public void setWebOnlyColors(boolean bl) {
        this.webOnlyColors = bl;
        this.lineColorChooserPaint.setWebSafe(bl);
        this.repaint();
        this.firePropertyChanged();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    private void firePropertyChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : CollectionUtils.copy(this.changeListeners)) {
            changeListener.stateChanged(changeEvent);
        }
    }

    private class ColorLineMouseAdapter
    extends MouseAdapter {
        private ColorLineMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.updateHue(mouseEvent.getY());
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.updateHue(mouseEvent.getY());
        }

        private void updateHue(int n) {
            LineColorChooser.this.setHue(Math.round(360.0f * ((float)(n - 5) / (float)(LineColorChooser.this.colorLine.getHeight() - 4))), true);
        }
    }

    private class LinePalette
    extends JComponent {
        public LinePalette() {
            SwingUtils.setOrientation(this);
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(Color.GRAY);
            graphics2D.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            graphics2D.setPaint(Color.WHITE);
            graphics2D.drawRect(1, 1, this.getWidth() - 3, this.getHeight() - 3);
            graphics2D.setPaint(LineColorChooser.this.lineColorChooserPaint);
            graphics2D.fillRect(2, 2, this.getWidth() - 4, this.getHeight() - 4);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(22, 260);
        }
    }
}

