/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.reflection;

import com.alee.utils.FileUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.reflection.JarEntryType;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import javax.swing.ImageIcon;

public class JarEntry {
    public static final String ID_PREFIX = "JE";
    public static ImageIcon jarIcon = new ImageIcon(JarEntry.class.getResource("icons/jar.png"));
    public static ImageIcon packageIcon = new ImageIcon(JarEntry.class.getResource("icons/package.png"));
    public static ImageIcon classIcon = new ImageIcon(JarEntry.class.getResource("icons/class.png"));
    public static ImageIcon javaIcon = new ImageIcon(JarEntry.class.getResource("icons/java.png"));
    public static ImageIcon fileIcon = new ImageIcon(JarEntry.class.getResource("icons/file.png"));
    private String id;
    private JarEntryType type;
    private String name;
    private ImageIcon icon;
    private JarEntry parent;
    private ZipEntry zipEntry;
    private List<JarEntry> childs = new ArrayList<JarEntry>();

    public JarEntry() {
        this.setParent(null);
    }

    public JarEntry(JarEntryType jarEntryType, String string) {
        this.setType(jarEntryType);
        this.setName(string);
        this.setParent(null);
    }

    public JarEntry(JarEntryType jarEntryType, String string, JarEntry jarEntry) {
        this.setType(jarEntryType);
        this.setName(string);
        this.setParent(jarEntry);
    }

    public JarEntry(JarEntryType jarEntryType, String string, JarEntry jarEntry, List<JarEntry> list) {
        this.setType(jarEntryType);
        this.setName(string);
        this.setParent(jarEntry);
        this.setChilds(list);
    }

    public String getId() {
        if (this.id == null) {
            this.setId();
        }
        return this.id;
    }

    private void setId() {
        this.setId(TextUtils.generateId(ID_PREFIX));
    }

    public void setId(String string) {
        this.id = string;
    }

    public JarEntryType getType() {
        return this.type;
    }

    public void setType(JarEntryType jarEntryType) {
        this.type = jarEntryType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public JarEntry getParent() {
        return this.parent;
    }

    public void setParent(JarEntry jarEntry) {
        this.parent = jarEntry;
    }

    public ZipEntry getZipEntry() {
        return this.zipEntry;
    }

    public void setZipEntry(ZipEntry zipEntry) {
        this.zipEntry = zipEntry;
    }

    public List<JarEntry> getChilds() {
        return this.childs;
    }

    public JarEntry getChild(int n) {
        return this.childs.get(n);
    }

    public JarEntry getChildByName(String string) {
        for (JarEntry jarEntry : this.childs) {
            if (!jarEntry.getName().equals(string)) continue;
            return jarEntry;
        }
        return null;
    }

    public void setChilds(List<JarEntry> list) {
        this.childs = list;
    }

    public void addChild(JarEntry jarEntry) {
        this.childs.add(jarEntry);
    }

    public void addChild(int n, JarEntry jarEntry) {
        this.childs.add(n, jarEntry);
    }

    public void removeChild(JarEntry jarEntry) {
        this.childs.remove(jarEntry);
    }

    public ImageIcon getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        if (this.type.equals((Object)JarEntryType.jarEntry)) {
            return jarIcon;
        }
        if (this.type.equals((Object)JarEntryType.packageEntry)) {
            return packageIcon;
        }
        if (this.type.equals((Object)JarEntryType.javaEntry)) {
            return javaIcon;
        }
        if (this.type.equals((Object)JarEntryType.classEntry)) {
            return classIcon;
        }
        ImageIcon imageIcon = FileUtils.getStandartFileIcon(false, this.getEntryExtension(), 1.0f);
        if (imageIcon != null) {
            return imageIcon;
        }
        return fileIcon;
    }

    public void setIcon(ImageIcon imageIcon) {
        this.icon = imageIcon;
    }

    public String getEntryExtension() {
        return FileUtils.getFileExtPart(this.name, false);
    }

    public boolean isClassEntry(Class clazz) {
        return clazz != null && clazz.getCanonicalName().equals(this.getCanonicalEntryName());
    }

    public String getCanonicalEntryName() {
        String string = this.getName();
        for (JarEntry jarEntry = this.getParent(); jarEntry != null && !jarEntry.getType().equals((Object)JarEntryType.jarEntry); jarEntry = jarEntry.getParent()) {
            string = jarEntry.getName() + "." + string;
        }
        if (this.type.equals((Object)JarEntryType.classEntry) || this.type.equals((Object)JarEntryType.javaEntry)) {
            string = string.substring(0, string.lastIndexOf("."));
        }
        return string;
    }

    public String getCanonicalEntryPath() {
        String string = this.getName();
        for (JarEntry jarEntry = this.getParent(); jarEntry != null && !jarEntry.getType().equals((Object)JarEntryType.jarEntry) && !jarEntry.getParent().getType().equals((Object)JarEntryType.jarEntry); jarEntry = jarEntry.getParent()) {
            string = jarEntry.getName() + "/" + string;
        }
        return string;
    }

    public List<JarEntry> getPath() {
        ArrayList<JarEntry> arrayList = new ArrayList<JarEntry>();
        for (JarEntry jarEntry = this; jarEntry != null && !jarEntry.getType().equals((Object)JarEntryType.jarEntry); jarEntry = jarEntry.getParent()) {
            arrayList.add(0, jarEntry);
        }
        return arrayList;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof JarEntry && ((JarEntry)object).getCanonicalEntryPath().equals(this.getCanonicalEntryPath());
    }

    public String toString() {
        return this.getName() + " (" + (Object)((Object)this.getType()) + ")";
    }
}

