/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JList;

public class ListRolloverSelectionAdapter
implements MouseMotionListener {
    private JList list;

    public ListRolloverSelectionAdapter(JList jList) {
        this.list = jList;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n;
        if (this.list.isEnabled() && (n = this.list.locationToIndex(mouseEvent.getPoint())) != this.list.getSelectedIndex()) {
            this.list.setSelectedIndex(n);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public static ListRolloverSelectionAdapter install(JList jList) {
        ListRolloverSelectionAdapter.uninstall(jList);
        ListRolloverSelectionAdapter listRolloverSelectionAdapter = new ListRolloverSelectionAdapter(jList);
        jList.addMouseMotionListener(listRolloverSelectionAdapter);
        return listRolloverSelectionAdapter;
    }

    public static void uninstall(JList jList) {
        for (MouseMotionListener mouseMotionListener : jList.getMouseMotionListeners()) {
            if (!(mouseMotionListener instanceof ListRolloverSelectionAdapter)) continue;
            jList.removeMouseMotionListener(mouseMotionListener);
        }
    }

    public static boolean isInstalled(JList jList) {
        for (MouseMotionListener mouseMotionListener : jList.getMouseMotionListeners()) {
            if (!(mouseMotionListener instanceof ListRolloverSelectionAdapter)) continue;
            return true;
        }
        return false;
    }
}

