/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import com.alee.utils.CollectionUtils;
import com.alee.utils.swing.ButtonGroupListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;

public class UnselectableButtonGroup
extends ButtonGroup {
    private List<ButtonGroupListener> listeners = new ArrayList<ButtonGroupListener>();
    private boolean unselectable = true;

    public UnselectableButtonGroup() {
    }

    public UnselectableButtonGroup(AbstractButton ... abstractButtonArray) {
        this.add(abstractButtonArray);
    }

    public UnselectableButtonGroup(List<AbstractButton> list) {
        this.add(list);
    }

    public boolean isUnselectable() {
        return this.unselectable;
    }

    public void setUnselectable(boolean bl) {
        this.unselectable = bl;
    }

    @Override
    public void setSelected(ButtonModel buttonModel, boolean bl) {
        if (bl || !this.unselectable) {
            super.setSelected(buttonModel, bl);
        } else {
            this.clearSelection();
        }
        this.fireSelectionChanged();
    }

    public List<AbstractButton> getButtons() {
        return CollectionUtils.copy(this.buttons);
    }

    public void addButtonGroupListener(ButtonGroupListener buttonGroupListener) {
        this.listeners.add(buttonGroupListener);
    }

    public void removeButtonGroupListener(ButtonGroupListener buttonGroupListener) {
        this.listeners.remove(buttonGroupListener);
    }

    public void fireSelectionChanged() {
        for (ButtonGroupListener buttonGroupListener : CollectionUtils.copy(this.listeners)) {
            buttonGroupListener.selectionChanged();
        }
    }

    public void add(AbstractButton ... abstractButtonArray) {
        for (AbstractButton abstractButton : abstractButtonArray) {
            this.add(abstractButton);
        }
    }

    public void add(List<AbstractButton> list) {
        for (AbstractButton abstractButton : list) {
            this.add(abstractButton);
        }
    }

    public static UnselectableButtonGroup group(AbstractButton ... abstractButtonArray) {
        return new UnselectableButtonGroup(abstractButtonArray);
    }

    public static UnselectableButtonGroup group(List<AbstractButton> list) {
        return new UnselectableButtonGroup(list);
    }
}

