/*
 * Decompiled with CFR 0.152.
 */
package com.android.draw9patch.ui;

import com.android.draw9patch.graphics.GraphicsUtilities;
import com.android.draw9patch.ui.ImageTransferHandler;
import com.android.draw9patch.ui.MainFrame;
import com.android.draw9patch.ui.PngFileFilter;
import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class ImageEditorPanel
extends JPanel {
    private static final String EXTENSION_9PATCH = ".9.png";
    private static final int DEFAULT_ZOOM = 8;
    private static final float DEFAULT_SCALE = 2.0f;
    private static final int BLACK_TICK = -16777216;
    private static final int RED_TICK = -65536;
    private String name;
    private BufferedImage image;
    private boolean is9Patch;
    private ImageViewer viewer;
    private StretchesViewer stretchesViewer;
    private JLabel xLabel;
    private JLabel yLabel;
    private TexturePaint texture;
    private List<Rectangle> patches;
    private List<Rectangle> horizontalPatches;
    private List<Rectangle> verticalPatches;
    private List<Rectangle> fixed;
    private boolean verticalStartWithPatch;
    private boolean horizontalStartWithPatch;
    private Pair<Integer> horizontalPadding;
    private Pair<Integer> verticalPadding;

    ImageEditorPanel(MainFrame mainFrame, BufferedImage bufferedImage, String string) {
        this.image = bufferedImage;
        this.name = string;
        this.setTransferHandler(new ImageTransferHandler(mainFrame));
        this.checkImage();
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.loadSupport();
        this.buildImageViewer();
        this.buildStatusPanel();
    }

    private void loadSupport() {
        try {
            URL uRL = this.getClass().getResource("/images/checker.png");
            BufferedImage bufferedImage = GraphicsUtilities.loadCompatibleImage(uRL);
            this.texture = new TexturePaint(bufferedImage, new Rectangle2D.Double(0.0, 0.0, bufferedImage.getWidth(), bufferedImage.getHeight()));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void buildImageViewer() {
        this.viewer = new ImageViewer();
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setResizeWeight(0.8);
        jSplitPane.setBorder(null);
        JScrollPane jScrollPane = new JScrollPane(this.viewer);
        jScrollPane.setOpaque(false);
        jScrollPane.setBorder(null);
        jScrollPane.getViewport().setBorder(null);
        jScrollPane.getViewport().setOpaque(false);
        jSplitPane.setLeftComponent(jScrollPane);
        jSplitPane.setRightComponent(this.buildStretchesViewer());
        this.add(jSplitPane);
    }

    private JComponent buildStretchesViewer() {
        this.stretchesViewer = new StretchesViewer();
        JScrollPane jScrollPane = new JScrollPane(this.stretchesViewer);
        jScrollPane.setBorder(null);
        jScrollPane.getViewport().setBorder(null);
        jScrollPane.setHorizontalScrollBarPolicy(32);
        jScrollPane.setVerticalScrollBarPolicy(22);
        return jScrollPane;
    }

    private void buildStatusPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        JLabel jLabel = new JLabel();
        jLabel.setForeground(Color.WHITE);
        jLabel.setText("Zoom: ");
        jLabel.putClientProperty("JComponent.sizeVariant", "small");
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 6, 0, 0), 0, 0));
        jLabel = new JLabel();
        jLabel.setForeground(Color.WHITE);
        jLabel.setText("100%");
        jLabel.putClientProperty("JComponent.sizeVariant", "small");
        jPanel.add((Component)jLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        JSlider jSlider = new JSlider(1, 16, 8);
        jSlider.setSnapToTicks(true);
        jSlider.putClientProperty("JComponent.sizeVariant", "small");
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ImageEditorPanel.this.viewer.setZoom(((JSlider)changeEvent.getSource()).getValue());
            }
        });
        jPanel.add((Component)jSlider, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel2 = new JLabel();
        jLabel2.setForeground(Color.WHITE);
        jLabel2.putClientProperty("JComponent.sizeVariant", "small");
        jLabel2.setText("800%");
        jPanel.add((Component)jLabel2, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        jLabel = new JLabel();
        jLabel.setForeground(Color.WHITE);
        jLabel.setText("Patch scale: ");
        jLabel.putClientProperty("JComponent.sizeVariant", "small");
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 6, 0, 0), 0, 0));
        jLabel = new JLabel();
        jLabel.setForeground(Color.WHITE);
        jLabel.setText("2x");
        jLabel.putClientProperty("JComponent.sizeVariant", "small");
        jPanel.add((Component)jLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        jSlider = new JSlider(200, 600, 200);
        jSlider.setSnapToTicks(true);
        jSlider.putClientProperty("JComponent.sizeVariant", "small");
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ImageEditorPanel.this.stretchesViewer.setScale((float)((JSlider)changeEvent.getSource()).getValue() / 100.0f);
            }
        });
        jPanel.add((Component)jSlider, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        jLabel2 = new JLabel();
        jLabel2.setForeground(Color.WHITE);
        jLabel2.putClientProperty("JComponent.sizeVariant", "small");
        jLabel2.setText("6x");
        jPanel.add((Component)jLabel2, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        JCheckBox jCheckBox = new JCheckBox("Show lock");
        jCheckBox.setOpaque(false);
        jCheckBox.setForeground(Color.WHITE);
        jCheckBox.setSelected(true);
        jCheckBox.putClientProperty("JComponent.sizeVariant", "small");
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageEditorPanel.this.viewer.setLockVisible(((JCheckBox)actionEvent.getSource()).isSelected());
            }
        });
        jPanel.add((Component)jCheckBox, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 12, 0, 0), 0, 0));
        JCheckBox jCheckBox2 = new JCheckBox("Show patches");
        jCheckBox2.setOpaque(false);
        jCheckBox2.setForeground(Color.WHITE);
        jCheckBox2.putClientProperty("JComponent.sizeVariant", "small");
        jCheckBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageEditorPanel.this.viewer.setPatchesVisible(((JCheckBox)actionEvent.getSource()).isSelected());
            }
        });
        jPanel.add((Component)jCheckBox2, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 12, 0, 0), 0, 0));
        JCheckBox jCheckBox3 = new JCheckBox("Show content");
        jCheckBox3.setOpaque(false);
        jCheckBox3.setForeground(Color.WHITE);
        jCheckBox3.putClientProperty("JComponent.sizeVariant", "small");
        jCheckBox3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageEditorPanel.this.stretchesViewer.setPaddingVisible(((JCheckBox)actionEvent.getSource()).isSelected());
            }
        });
        jPanel.add((Component)jCheckBox3, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 12, 0, 0), 0, 0));
        jPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(6, 0, 1, 1, 1.0, 1.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        jLabel = new JLabel("X: ");
        jLabel.setForeground(Color.WHITE);
        jLabel.putClientProperty("JComponent.sizeVariant", "small");
        jPanel.add((Component)jLabel, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.xLabel = new JLabel("0px");
        this.xLabel.setForeground(Color.WHITE);
        this.xLabel.putClientProperty("JComponent.sizeVariant", "small");
        jPanel.add((Component)this.xLabel, new GridBagConstraints(8, 0, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 6), 0, 0));
        jLabel = new JLabel("Y: ");
        jLabel.setForeground(Color.WHITE);
        jLabel.putClientProperty("JComponent.sizeVariant", "small");
        jPanel.add((Component)jLabel, new GridBagConstraints(7, 1, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.yLabel = new JLabel("0px");
        this.yLabel.setForeground(Color.WHITE);
        this.yLabel.putClientProperty("JComponent.sizeVariant", "small");
        jPanel.add((Component)this.yLabel, new GridBagConstraints(8, 1, 1, 1, 0.0, 0.0, 22, 0, new Insets(0, 0, 0, 6), 0, 0));
        this.add((Component)jPanel, "South");
    }

    private void checkImage() {
        this.is9Patch = this.name.endsWith(EXTENSION_9PATCH);
        if (!this.is9Patch) {
            this.convertTo9Patch();
        } else {
            this.ensure9Patch();
        }
    }

    private void ensure9Patch() {
        int n;
        int n2;
        int n3 = this.image.getWidth();
        int n4 = this.image.getHeight();
        for (n2 = 0; n2 < n3; ++n2) {
            n = this.image.getRGB(n2, 0);
            if (n != 0 && n != -16777216 && n != -65536) {
                this.image.setRGB(n2, 0, 0);
            }
            if ((n = this.image.getRGB(n2, n4 - 1)) == 0 || n == -16777216 || n == -65536) continue;
            this.image.setRGB(n2, n4 - 1, 0);
        }
        for (n2 = 0; n2 < n4; ++n2) {
            n = this.image.getRGB(0, n2);
            if (n != 0 && n != -16777216 && n != -65536) {
                this.image.setRGB(0, n2, 0);
            }
            if ((n = this.image.getRGB(n3 - 1, n2)) == 0 || n == -16777216 || n == -65536) continue;
            this.image.setRGB(n3 - 1, n2, 0);
        }
    }

    private void convertTo9Patch() {
        BufferedImage bufferedImage = GraphicsUtilities.createTranslucentCompatibleImage(this.image.getWidth() + 2, this.image.getHeight() + 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage((Image)this.image, 1, 1, null);
        graphics2D.dispose();
        this.image = bufferedImage;
        this.name = this.name.substring(0, this.name.lastIndexOf(46)) + EXTENSION_9PATCH;
    }

    File chooseSaveFile() {
        if (this.is9Patch) {
            return new File(this.name);
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new PngFileFilter());
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            if (!file.getAbsolutePath().endsWith(EXTENSION_9PATCH)) {
                String string = file.getAbsolutePath();
                string = string.endsWith(".png") ? string.substring(0, string.lastIndexOf(".png")) + EXTENSION_9PATCH : string + EXTENSION_9PATCH;
                this.name = string;
                this.is9Patch = true;
                return new File(string);
            }
            this.is9Patch = true;
            return file;
        }
        return null;
    }

    RenderedImage getImage() {
        return this.image;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Pair<E> {
        E first;
        E second;

        Pair(E e, E e2) {
            this.first = e;
            this.second = e2;
        }

        public String toString() {
            return "Pair[" + this.first + ", " + this.second + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ImageViewer
    extends JComponent {
        private final Color CORRUPTED_COLOR = new Color(1.0f, 0.0f, 0.0f, 0.7f);
        private final Color LOCK_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.7f);
        private final Color STRIPES_COLOR = new Color(1.0f, 0.0f, 0.0f, 0.5f);
        private final Color BACK_COLOR = new Color(0xC0C0C0);
        private final Color HELP_COLOR = new Color(0xFFFFE1);
        private final Color PATCH_COLOR = new Color(1.0f, 0.37f, 0.99f, 0.5f);
        private final Color PATCH_ONEWAY_COLOR = new Color(0.37f, 1.0f, 0.37f, 0.5f);
        private static final float STRIPES_WIDTH = 4.0f;
        private static final double STRIPES_SPACING = 6.0;
        private static final int STRIPES_ANGLE = 45;
        private int zoom = 8;
        private boolean showPatches;
        private boolean showLock = true;
        private final Dimension size;
        private boolean locked;
        private int[] row;
        private int[] column;
        private int lastPositionX;
        private int lastPositionY;
        private int currentButton;
        private boolean showCursor;
        private JLabel helpLabel;
        private boolean eraseMode;
        private JButton checkButton;
        private List<Rectangle> corruptedPatches;
        private boolean showBadPatches;
        private JPanel helpPanel;

        ImageViewer() {
            this.setLayout(new GridBagLayout());
            this.helpPanel = new JPanel(new BorderLayout());
            this.helpPanel.setBorder(new EmptyBorder(0, 6, 0, 6));
            this.helpPanel.setBackground(this.HELP_COLOR);
            this.helpLabel = new JLabel("Press Shift to erase pixels. Press Control to draw layout bounds");
            this.helpLabel.putClientProperty("JComponent.sizeVariant", "small");
            this.helpPanel.add((Component)this.helpLabel, "West");
            this.checkButton = new JButton("Show bad patches");
            this.checkButton.putClientProperty("JComponent.sizeVariant", "small");
            this.checkButton.putClientProperty("JButton.buttonType", "roundRect");
            this.helpPanel.add((Component)this.checkButton, "East");
            this.add((Component)this.helpPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.setOpaque(true);
            this.size = new Dimension(0, 0);
            this.addAncestorListener(new AncestorListener(){

                public void ancestorRemoved(AncestorEvent ancestorEvent) {
                }

                public void ancestorMoved(AncestorEvent ancestorEvent) {
                    ImageEditorPanel.this.viewer.setZoom(8);
                    ImageEditorPanel.this.viewer.removeAncestorListener(this);
                }

                public void ancestorAdded(AncestorEvent ancestorEvent) {
                }
            });
            this.findPatches();
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    ImageViewer.this.currentButton = mouseEvent.isShiftDown() ? 3 : mouseEvent.getButton();
                    ImageViewer.this.currentButton = mouseEvent.isControlDown() ? 2 : ImageViewer.this.currentButton;
                    ImageViewer.this.paint(mouseEvent.getX(), mouseEvent.getY(), ImageViewer.this.currentButton);
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                public void mouseDragged(MouseEvent mouseEvent) {
                    if (!ImageViewer.this.checkLockedRegion(mouseEvent.getX(), mouseEvent.getY())) {
                        ImageViewer.this.paint(mouseEvent.getX(), mouseEvent.getY(), ImageViewer.this.currentButton);
                    }
                }

                public void mouseMoved(MouseEvent mouseEvent) {
                    ImageViewer.this.checkLockedRegion(mouseEvent.getX(), mouseEvent.getY());
                }
            });
            Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

                public void eventDispatched(AWTEvent aWTEvent) {
                    ImageViewer.this.enableEraseMode((KeyEvent)aWTEvent);
                }
            }, 8L);
            this.checkButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (!ImageViewer.this.showBadPatches) {
                        ImageViewer.this.findBadPatches();
                        ImageViewer.this.checkButton.setText("Hide bad patches");
                    } else {
                        ImageViewer.this.checkButton.setText("Show bad patches");
                        ImageViewer.this.corruptedPatches = null;
                    }
                    ImageViewer.this.repaint();
                    ImageViewer.this.showBadPatches = !ImageViewer.this.showBadPatches;
                }
            });
        }

        private void findBadPatches() {
            this.corruptedPatches = new ArrayList<Rectangle>();
            for (Rectangle rectangle : ImageEditorPanel.this.patches) {
                if (!this.corruptPatch(rectangle)) continue;
                this.corruptedPatches.add(rectangle);
            }
            for (Rectangle rectangle : ImageEditorPanel.this.horizontalPatches) {
                if (!this.corruptHorizontalPatch(rectangle)) continue;
                this.corruptedPatches.add(rectangle);
            }
            for (Rectangle rectangle : ImageEditorPanel.this.verticalPatches) {
                if (!this.corruptVerticalPatch(rectangle)) continue;
                this.corruptedPatches.add(rectangle);
            }
        }

        private boolean corruptPatch(Rectangle rectangle) {
            int[] nArray = GraphicsUtilities.getPixels(ImageEditorPanel.this.image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
            if (nArray.length > 0) {
                int n = nArray[0];
                for (int n2 : nArray) {
                    if (n2 == n) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean corruptHorizontalPatch(Rectangle rectangle) {
            int[] nArray = new int[rectangle.height];
            int[] nArray2 = new int[rectangle.height];
            nArray = GraphicsUtilities.getPixels(ImageEditorPanel.this.image, rectangle.x, rectangle.y, 1, rectangle.height, nArray);
            for (int i = 1; i < rectangle.width; ++i) {
                nArray2 = GraphicsUtilities.getPixels(ImageEditorPanel.this.image, rectangle.x + i, rectangle.y, 1, rectangle.height, nArray2);
                if (Arrays.equals(nArray, nArray2)) continue;
                return true;
            }
            return false;
        }

        private boolean corruptVerticalPatch(Rectangle rectangle) {
            int[] nArray = new int[rectangle.width];
            int[] nArray2 = new int[rectangle.width];
            nArray = GraphicsUtilities.getPixels(ImageEditorPanel.this.image, rectangle.x, rectangle.y, rectangle.width, 1, nArray);
            for (int i = 1; i < rectangle.height; ++i) {
                nArray2 = GraphicsUtilities.getPixels(ImageEditorPanel.this.image, rectangle.x, rectangle.y + i, rectangle.width, 1, nArray2);
                if (Arrays.equals(nArray, nArray2)) continue;
                return true;
            }
            return false;
        }

        private void enableEraseMode(KeyEvent keyEvent) {
            boolean bl = this.eraseMode;
            this.eraseMode = keyEvent.isShiftDown();
            if (this.eraseMode != bl) {
                if (this.eraseMode) {
                    this.helpLabel.setText("Release Shift to draw pixels");
                } else {
                    this.helpLabel.setText("Press Shift to erase pixels. Press Control to draw layout bounds");
                }
            }
        }

        private void paint(int n, int n2, int n3) {
            int n4;
            switch (n3) {
                case 1: {
                    n4 = -16777216;
                    break;
                }
                case 2: {
                    n4 = -65536;
                    break;
                }
                case 3: {
                    n4 = 0;
                    break;
                }
                default: {
                    return;
                }
            }
            int n5 = (this.getWidth() - this.size.width) / 2;
            int n6 = this.helpPanel.getHeight() + (this.getHeight() - this.size.height) / 2;
            n = (n - n5) / this.zoom;
            n2 = (n2 - n6) / this.zoom;
            int n7 = ImageEditorPanel.this.image.getWidth();
            int n8 = ImageEditorPanel.this.image.getHeight();
            if ((n == 0 || n == n7 - 1) && n2 > 0 && n2 < n8 - 1 || n > 0 && n < n7 - 1 && (n2 == 0 || n2 == n8 - 1)) {
                ImageEditorPanel.this.image.setRGB(n, n2, n4);
                this.findPatches();
                ImageEditorPanel.this.stretchesViewer.computePatches();
                if (this.showBadPatches) {
                    this.findBadPatches();
                }
                this.repaint();
            }
        }

        private boolean checkLockedRegion(int n, int n2) {
            int n3 = this.lastPositionX;
            int n4 = this.lastPositionY;
            this.lastPositionX = n;
            this.lastPositionY = n2;
            int n5 = (this.getWidth() - this.size.width) / 2;
            int n6 = this.helpPanel.getHeight() + (this.getHeight() - this.size.height) / 2;
            n = (n - n5) / this.zoom;
            n2 = (n2 - n6) / this.zoom;
            int n7 = ImageEditorPanel.this.image.getWidth();
            int n8 = ImageEditorPanel.this.image.getHeight();
            ImageEditorPanel.this.xLabel.setText(Math.max(0, Math.min(n, n7 - 1)) + " px");
            ImageEditorPanel.this.yLabel.setText(Math.max(0, Math.min(n2, n8 - 1)) + " px");
            boolean bl = this.locked;
            this.locked = n > 0 && n < n7 - 1 && n2 > 0 && n2 < n8 - 1;
            boolean bl2 = this.showCursor;
            boolean bl3 = this.showCursor = (n == 0 || n == n7 - 1) && n2 > 0 && n2 < n8 - 1 || n > 0 && n < n7 - 1 && (n2 == 0 || n2 == n8 - 1);
            if (this.locked != bl) {
                this.repaint();
            } else if (this.showCursor || this.showCursor != bl2) {
                Rectangle rectangle = new Rectangle(this.lastPositionX - 1 - this.zoom / 2, this.lastPositionY - 1 - this.zoom / 2, this.zoom + 2, this.zoom + 2);
                rectangle = rectangle.union(new Rectangle(n3 - 1 - this.zoom / 2, n4 - 1 - this.zoom / 2, this.zoom + 2, this.zoom + 2));
                this.repaint(rectangle);
            }
            return this.locked;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            int n = (this.getWidth() - this.size.width) / 2;
            int n2 = this.helpPanel.getHeight() + (this.getHeight() - this.size.height) / 2;
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setColor(this.BACK_COLOR);
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D.translate(n, n2);
            graphics2D.setPaint(ImageEditorPanel.this.texture);
            graphics2D.fillRect(0, 0, this.size.width, this.size.height);
            graphics2D.scale(this.zoom, this.zoom);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            graphics2D.drawImage((Image)ImageEditorPanel.this.image, 0, 0, null);
            if (this.showPatches) {
                graphics2D.setColor(this.PATCH_COLOR);
                for (Rectangle rectangle : ImageEditorPanel.this.patches) {
                    graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                graphics2D.setColor(this.PATCH_ONEWAY_COLOR);
                for (Rectangle rectangle : ImageEditorPanel.this.horizontalPatches) {
                    graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                for (Rectangle rectangle : ImageEditorPanel.this.verticalPatches) {
                    graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            }
            if (this.corruptedPatches != null) {
                graphics2D.setColor(this.CORRUPTED_COLOR);
                graphics2D.setStroke(new BasicStroke(3.0f / (float)this.zoom));
                for (Rectangle rectangle : this.corruptedPatches) {
                    graphics2D.draw(new RoundRectangle2D.Float((float)rectangle.x - 2.0f / (float)this.zoom, (float)rectangle.y - 2.0f / (float)this.zoom, (float)rectangle.width + 2.0f / (float)this.zoom, (float)rectangle.height + 2.0f / (float)this.zoom, 6.0f / (float)this.zoom, 6.0f / (float)this.zoom));
                }
            }
            if (this.showLock && this.locked) {
                int n3 = ImageEditorPanel.this.image.getWidth();
                int n4 = ImageEditorPanel.this.image.getHeight();
                graphics2D.setColor(this.LOCK_COLOR);
                graphics2D.fillRect(1, 1, n3 - 2, n4 - 2);
                graphics2D.setColor(this.STRIPES_COLOR);
                graphics2D.translate(1, 1);
                this.paintStripes(graphics2D, n3 - 2, n4 - 2);
                graphics2D.translate(-1, -1);
            }
            graphics2D.dispose();
            if (this.showCursor) {
                Graphics graphics2 = graphics.create();
                graphics2.setXORMode(Color.WHITE);
                graphics2.setColor(Color.BLACK);
                graphics2.drawRect(this.lastPositionX - this.zoom / 2, this.lastPositionY - this.zoom / 2, this.zoom, this.zoom);
                graphics2.dispose();
            }
        }

        private void paintStripes(Graphics2D graphics2D, int n, int n2) {
            Shape shape = graphics2D.getClip();
            Area area = new Area(new Rectangle(0, 0, n, n2));
            if (shape != null) {
                area = new Area(shape);
            }
            area.intersect(new Area(new Rectangle(0, 0, n, n2)));
            graphics2D.setClip(area);
            graphics2D.setStroke(new BasicStroke(4.0f));
            double d = Math.sqrt(n * n + n2 * n2);
            double d2 = Math.toRadians(45.0);
            graphics2D.rotate(d2);
            double d3 = 6.0;
            int n3 = (int)(d / (d3 += 4.0));
            for (int i = 0; i < n3; ++i) {
                double d4 = (double)i * d3;
                Line2D.Double double_ = new Line2D.Double(d4, -d, d4, d);
                graphics2D.draw(double_);
            }
            graphics2D.setClip(shape);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.size;
        }

        void setZoom(int n) {
            int n2 = ImageEditorPanel.this.image.getWidth();
            int n3 = ImageEditorPanel.this.image.getHeight();
            this.zoom = n;
            if (this.size.height == 0 || this.getHeight() - this.size.height == 0) {
                this.size.setSize(n2 * this.zoom, n3 * this.zoom + this.helpPanel.getHeight());
            } else {
                this.size.setSize(n2 * this.zoom, n3 * this.zoom);
            }
            if (!this.size.equals(this.getSize())) {
                this.setSize(this.size);
                ImageEditorPanel.this.validate();
                this.repaint();
            }
        }

        void setPatchesVisible(boolean bl) {
            this.showPatches = bl;
            this.findPatches();
            this.repaint();
        }

        private void findPatches() {
            int n = ImageEditorPanel.this.image.getWidth();
            int n2 = ImageEditorPanel.this.image.getHeight();
            this.row = GraphicsUtilities.getPixels(ImageEditorPanel.this.image, 0, 0, n, 1, this.row);
            this.column = GraphicsUtilities.getPixels(ImageEditorPanel.this.image, 0, 0, 1, n2, this.column);
            boolean[] blArray = new boolean[1];
            Pair<List<Pair<Integer>>> pair = this.getPatches(this.column, blArray);
            ImageEditorPanel.this.verticalStartWithPatch = blArray[0];
            blArray = new boolean[1];
            Pair<List<Pair<Integer>>> pair2 = this.getPatches(this.row, blArray);
            ImageEditorPanel.this.horizontalStartWithPatch = blArray[0];
            ImageEditorPanel.this.fixed = this.getRectangles((List)pair.first, (List)pair2.first);
            ImageEditorPanel.this.patches = this.getRectangles((List)pair.second, (List)pair2.second);
            if (ImageEditorPanel.this.fixed.size() > 0) {
                ImageEditorPanel.this.horizontalPatches = this.getRectangles((List)pair.first, (List)pair2.second);
                ImageEditorPanel.this.verticalPatches = this.getRectangles((List)pair.second, (List)pair2.first);
            } else if (((List)pair2.first).size() > 0) {
                ImageEditorPanel.this.horizontalPatches = new ArrayList(0);
                ImageEditorPanel.this.verticalPatches = this.getVerticalRectangles((List)pair2.first);
            } else if (((List)pair.first).size() > 0) {
                ImageEditorPanel.this.horizontalPatches = this.getHorizontalRectangles((List)pair.first);
                ImageEditorPanel.this.verticalPatches = new ArrayList(0);
            } else {
                ImageEditorPanel.this.horizontalPatches = (ImageEditorPanel.this.verticalPatches = new ArrayList(0));
            }
            this.row = GraphicsUtilities.getPixels(ImageEditorPanel.this.image, 0, n2 - 1, n, 1, this.row);
            this.column = GraphicsUtilities.getPixels(ImageEditorPanel.this.image, n - 1, 0, 1, n2, this.column);
            pair2 = this.getPatches(this.row, blArray);
            ImageEditorPanel.this.horizontalPadding = this.getPadding((List)pair2.first);
            pair = this.getPatches(this.column, blArray);
            ImageEditorPanel.this.verticalPadding = this.getPadding((List)pair.first);
        }

        private List<Rectangle> getVerticalRectangles(List<Pair<Integer>> list) {
            ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
            for (Pair<Integer> pair : list) {
                int n = (Integer)pair.first;
                int n2 = (Integer)pair.second - (Integer)pair.first;
                arrayList.add(new Rectangle(n, 1, n2, ImageEditorPanel.this.image.getHeight() - 2));
            }
            return arrayList;
        }

        private List<Rectangle> getHorizontalRectangles(List<Pair<Integer>> list) {
            ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
            for (Pair<Integer> pair : list) {
                int n = (Integer)pair.first;
                int n2 = (Integer)pair.second - (Integer)pair.first;
                arrayList.add(new Rectangle(1, n, ImageEditorPanel.this.image.getWidth() - 2, n2));
            }
            return arrayList;
        }

        private Pair<Integer> getPadding(List<Pair<Integer>> list) {
            if (list.size() == 0) {
                return new Pair<Integer>(0, 0);
            }
            if (list.size() == 1) {
                if ((Integer)list.get((int)0).first == 1) {
                    return new Pair<Integer>((Integer)list.get((int)0).second - (Integer)list.get((int)0).first, 0);
                }
                return new Pair<Integer>(0, (Integer)list.get((int)0).second - (Integer)list.get((int)0).first);
            }
            int n = list.size() - 1;
            return new Pair<Integer>((Integer)list.get((int)0).second - (Integer)list.get((int)0).first, (Integer)list.get((int)n).second - (Integer)list.get((int)n).first);
        }

        private List<Rectangle> getRectangles(List<Pair<Integer>> list, List<Pair<Integer>> list2) {
            ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
            for (Pair<Integer> pair : list) {
                int n = (Integer)pair.first;
                int n2 = (Integer)pair.second - (Integer)pair.first;
                for (Pair<Integer> pair2 : list2) {
                    int n3 = (Integer)pair2.first;
                    int n4 = (Integer)pair2.second - (Integer)pair2.first;
                    arrayList.add(new Rectangle(n3, n, n4, n2));
                }
            }
            return arrayList;
        }

        private Pair<List<Pair<Integer>>> getPatches(int[] nArray, boolean[] blArray) {
            int n = 1;
            int n2 = nArray[1];
            boolean bl = true;
            ArrayList<Pair<Integer>> arrayList = new ArrayList<Pair<Integer>>();
            ArrayList<Pair<Integer>> arrayList2 = new ArrayList<Pair<Integer>>();
            for (int i = 1; i < nArray.length - 1; ++i) {
                int n3 = nArray[i];
                if (n3 == n2) continue;
                if (n2 == -16777216) {
                    if (bl) {
                        blArray[0] = true;
                    }
                    arrayList2.add(new Pair<Integer>(n, i));
                } else {
                    arrayList.add(new Pair<Integer>(n, i));
                }
                bl = false;
                n = i;
                n2 = n3;
            }
            if (n2 == -16777216) {
                if (bl) {
                    blArray[0] = true;
                }
                arrayList2.add(new Pair<Integer>(n, nArray.length - 1));
            } else {
                arrayList.add(new Pair<Integer>(n, nArray.length - 1));
            }
            if (arrayList2.size() == 0) {
                arrayList2.add(new Pair<Integer>(1, nArray.length - 1));
                blArray[0] = true;
                arrayList.clear();
            }
            return new Pair<List<Pair<Integer>>>(arrayList, arrayList2);
        }

        void setLockVisible(boolean bl) {
            this.showLock = bl;
            this.repaint();
        }
    }

    private class StretchesViewer
    extends JPanel {
        private static final int MARGIN = 24;
        private StretchView horizontal;
        private StretchView vertical;
        private StretchView both;
        private Dimension size;
        private float horizontalPatchesSum;
        private float verticalPatchesSum;
        private boolean showPadding;

        StretchesViewer() {
            this.setOpaque(false);
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createEmptyBorder(24, 24, 24, 24));
            this.horizontal = new StretchView();
            this.vertical = new StretchView();
            this.both = new StretchView();
            this.setScale(2.0f);
            this.add((Component)this.vertical, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.horizontal, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.both, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setPaint(ImageEditorPanel.this.texture);
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D.dispose();
        }

        void setScale(float f) {
            int n = ImageEditorPanel.this.image.getWidth() - 2;
            int n2 = ImageEditorPanel.this.image.getHeight() - 2;
            int n3 = (int)((float)n * f);
            int n4 = (int)((float)n2 * f);
            this.horizontal.scaledWidth = n3;
            this.vertical.scaledHeight = n4;
            this.both.scaledWidth = n3;
            this.both.scaledHeight = n4;
            this.size = new Dimension(n3, n4);
            this.computePatches();
        }

        void computePatches() {
            int n;
            boolean bl = false;
            boolean bl2 = true;
            int n2 = 0;
            int n3 = 0;
            if (ImageEditorPanel.this.fixed.size() > 0) {
                n = ((Rectangle)((ImageEditorPanel)ImageEditorPanel.this).fixed.get((int)0)).y;
                for (Rectangle rectangle : ImageEditorPanel.this.fixed) {
                    if (rectangle.y > n) {
                        bl2 = true;
                        bl = true;
                    }
                    if (!bl) {
                        n2 += rectangle.width;
                    }
                    if (!bl2) continue;
                    n3 += rectangle.height;
                    bl2 = false;
                    n = rectangle.y;
                }
            }
            this.horizontal.remainderHorizontal = this.horizontal.scaledWidth - n2;
            this.vertical.remainderHorizontal = this.vertical.scaledWidth - n2;
            this.both.remainderHorizontal = this.both.scaledWidth - n2;
            this.horizontal.remainderVertical = this.horizontal.scaledHeight - n3;
            this.vertical.remainderVertical = this.vertical.scaledHeight - n3;
            this.both.remainderVertical = this.both.scaledHeight - n3;
            this.horizontalPatchesSum = 0.0f;
            if (ImageEditorPanel.this.horizontalPatches.size() > 0) {
                n = -1;
                for (Rectangle rectangle : ImageEditorPanel.this.horizontalPatches) {
                    if (rectangle.x <= n) continue;
                    this.horizontalPatchesSum += (float)rectangle.width;
                    n = rectangle.x;
                }
            } else {
                n = -1;
                for (Rectangle rectangle : ImageEditorPanel.this.patches) {
                    if (rectangle.x <= n) continue;
                    this.horizontalPatchesSum += (float)rectangle.width;
                    n = rectangle.x;
                }
            }
            this.verticalPatchesSum = 0.0f;
            if (ImageEditorPanel.this.verticalPatches.size() > 0) {
                n = -1;
                for (Rectangle rectangle : ImageEditorPanel.this.verticalPatches) {
                    if (rectangle.y <= n) continue;
                    this.verticalPatchesSum += (float)rectangle.height;
                    n = rectangle.y;
                }
            } else {
                n = -1;
                for (Rectangle rectangle : ImageEditorPanel.this.patches) {
                    if (rectangle.y <= n) continue;
                    this.verticalPatchesSum += (float)rectangle.height;
                    n = rectangle.y;
                }
            }
            this.setSize(this.size);
            ImageEditorPanel.this.validate();
            this.repaint();
        }

        void setPaddingVisible(boolean bl) {
            this.showPadding = bl;
            this.repaint();
        }

        private class StretchView
        extends JComponent {
            private final Color PADDING_COLOR = new Color(0.37f, 0.37f, 1.0f, 0.5f);
            int scaledWidth;
            int scaledHeight;
            int remainderHorizontal;
            int remainderVertical;

            StretchView() {
                this.scaledWidth = ImageEditorPanel.this.image.getWidth();
                this.scaledHeight = ImageEditorPanel.this.image.getHeight();
            }

            protected void paintComponent(Graphics graphics) {
                int n = (this.getWidth() - this.scaledWidth) / 2;
                int n2 = (this.getHeight() - this.scaledHeight) / 2;
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                graphics.translate(n, n2);
                n = 0;
                n2 = 0;
                if (ImageEditorPanel.this.patches.size() == 0) {
                    graphics.drawImage(ImageEditorPanel.this.image, 0, 0, this.scaledWidth, this.scaledHeight, null);
                    graphics2D.dispose();
                    return;
                }
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                float f = 1.0f;
                float f2 = this.remainderVertical;
                boolean bl = ImageEditorPanel.this.verticalStartWithPatch;
                while (n2 < this.scaledHeight - 1) {
                    boolean bl2 = ImageEditorPanel.this.horizontalStartWithPatch;
                    int n7 = 0;
                    float f3 = 0.0f;
                    float f4 = 1.0f;
                    float f5 = this.remainderHorizontal;
                    while (n < this.scaledWidth - 1) {
                        int n8;
                        float f6;
                        Rectangle rectangle;
                        if (!bl) {
                            if (bl2) {
                                rectangle = (Rectangle)ImageEditorPanel.this.horizontalPatches.get(n4++);
                                f6 = (float)rectangle.width / StretchesViewer.this.horizontalPatchesSum;
                                n8 = (int)(f6 * f5 / f4);
                                f4 -= f6;
                                f5 -= (float)n8;
                                graphics.drawImage(ImageEditorPanel.this.image, n, n2, n + n8, n2 + rectangle.height, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, null);
                                n += n8;
                            } else {
                                rectangle = (Rectangle)ImageEditorPanel.this.fixed.get(n3++);
                                graphics.drawImage(ImageEditorPanel.this.image, n, n2, n + rectangle.width, n2 + rectangle.height, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, null);
                                n += rectangle.width;
                            }
                            n7 = rectangle.height;
                        } else if (bl2) {
                            rectangle = (Rectangle)ImageEditorPanel.this.patches.get(n6++);
                            f3 = (float)rectangle.height / StretchesViewer.this.verticalPatchesSum;
                            n7 = (int)(f3 * f2 / f);
                            f6 = (float)rectangle.width / StretchesViewer.this.horizontalPatchesSum;
                            n8 = (int)(f6 * f5 / f4);
                            f4 -= f6;
                            f5 -= (float)n8;
                            graphics.drawImage(ImageEditorPanel.this.image, n, n2, n + n8, n2 + n7, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, null);
                            n += n8;
                        } else {
                            rectangle = (Rectangle)ImageEditorPanel.this.verticalPatches.get(n5++);
                            f3 = (float)rectangle.height / StretchesViewer.this.verticalPatchesSum;
                            n7 = (int)(f3 * f2 / f);
                            graphics.drawImage(ImageEditorPanel.this.image, n, n2, n + rectangle.width, n2 + n7, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, null);
                            n += rectangle.width;
                        }
                        bl2 = !bl2;
                    }
                    n = 0;
                    n2 += n7;
                    if (bl) {
                        f -= f3;
                        f2 -= (float)n7;
                    }
                    bl = !bl;
                }
                if (StretchesViewer.this.showPadding) {
                    graphics.setColor(this.PADDING_COLOR);
                    graphics.fillRect((Integer)((ImageEditorPanel)ImageEditorPanel.this).horizontalPadding.first, (Integer)((ImageEditorPanel)ImageEditorPanel.this).verticalPadding.first, this.scaledWidth - (Integer)((ImageEditorPanel)ImageEditorPanel.this).horizontalPadding.first - (Integer)((ImageEditorPanel)ImageEditorPanel.this).horizontalPadding.second, this.scaledHeight - (Integer)((ImageEditorPanel)ImageEditorPanel.this).verticalPadding.first - (Integer)((ImageEditorPanel)ImageEditorPanel.this).verticalPadding.second);
                }
                graphics2D.dispose();
            }

            public Dimension getPreferredSize() {
                return StretchesViewer.this.size;
            }
        }
    }
}

