/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.ModelDestination;
import com.sun.media.sound.ModelSource;
import java.util.Arrays;

public class ModelConnectionBlock {
    private static final ModelSource[] no_sources = new ModelSource[0];
    private ModelSource[] sources = no_sources;
    private double scale = 1.0;
    private ModelDestination destination;

    public ModelConnectionBlock() {
    }

    public ModelConnectionBlock(double d, ModelDestination modelDestination) {
        this.scale = d;
        this.destination = modelDestination;
    }

    public ModelConnectionBlock(ModelSource modelSource, ModelDestination modelDestination) {
        if (modelSource != null) {
            this.sources = new ModelSource[1];
            this.sources[0] = modelSource;
        }
        this.destination = modelDestination;
    }

    public ModelConnectionBlock(ModelSource modelSource, double d, ModelDestination modelDestination) {
        if (modelSource != null) {
            this.sources = new ModelSource[1];
            this.sources[0] = modelSource;
        }
        this.scale = d;
        this.destination = modelDestination;
    }

    public ModelConnectionBlock(ModelSource modelSource, ModelSource modelSource2, ModelDestination modelDestination) {
        if (modelSource != null) {
            if (modelSource2 == null) {
                this.sources = new ModelSource[1];
                this.sources[0] = modelSource;
            } else {
                this.sources = new ModelSource[2];
                this.sources[0] = modelSource;
                this.sources[1] = modelSource2;
            }
        }
        this.destination = modelDestination;
    }

    public ModelConnectionBlock(ModelSource modelSource, ModelSource modelSource2, double d, ModelDestination modelDestination) {
        if (modelSource != null) {
            if (modelSource2 == null) {
                this.sources = new ModelSource[1];
                this.sources[0] = modelSource;
            } else {
                this.sources = new ModelSource[2];
                this.sources[0] = modelSource;
                this.sources[1] = modelSource2;
            }
        }
        this.scale = d;
        this.destination = modelDestination;
    }

    public ModelDestination getDestination() {
        return this.destination;
    }

    public void setDestination(ModelDestination modelDestination) {
        this.destination = modelDestination;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double d) {
        this.scale = d;
    }

    public ModelSource[] getSources() {
        return Arrays.copyOf(this.sources, this.sources.length);
    }

    public void setSources(ModelSource[] modelSourceArray) {
        this.sources = modelSourceArray == null ? no_sources : Arrays.copyOf(modelSourceArray, modelSourceArray.length);
    }

    public void addSource(ModelSource modelSource) {
        ModelSource[] modelSourceArray = this.sources;
        this.sources = new ModelSource[modelSourceArray.length + 1];
        System.arraycopy(modelSourceArray, 0, this.sources, 0, modelSourceArray.length);
        this.sources[this.sources.length - 1] = modelSource;
    }
}

