/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.text.Normalizer;
import sun.nio.cs.ThreadLocalCoders;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class URI
implements Comparable<URI>,
Serializable {
    static final long serialVersionUID = -6052424284110960213L;
    private transient String scheme;
    private transient String fragment;
    private transient String authority;
    private transient String userInfo;
    private transient String host;
    private transient int port = -1;
    private transient String path;
    private transient String query;
    private volatile transient String schemeSpecificPart;
    private volatile transient int hash;
    private volatile transient String decodedUserInfo = null;
    private volatile transient String decodedAuthority = null;
    private volatile transient String decodedPath = null;
    private volatile transient String decodedQuery = null;
    private volatile transient String decodedFragment = null;
    private volatile transient String decodedSchemeSpecificPart = null;
    private volatile String string;
    private static final long L_DIGIT = URI.lowMask('0', '9');
    private static final long H_DIGIT = 0L;
    private static final long L_UPALPHA = 0L;
    private static final long H_UPALPHA = URI.highMask('A', 'Z');
    private static final long L_LOWALPHA = 0L;
    private static final long H_LOWALPHA = URI.highMask('a', 'z');
    private static final long L_ALPHA = 0L;
    private static final long H_ALPHA = H_LOWALPHA | H_UPALPHA;
    private static final long L_ALPHANUM = L_DIGIT | 0L;
    private static final long H_ALPHANUM = 0L | H_ALPHA;
    private static final long L_HEX = L_DIGIT;
    private static final long H_HEX = URI.highMask('A', 'F') | URI.highMask('a', 'f');
    private static final long L_MARK = URI.lowMask("-_.!~*'()");
    private static final long H_MARK = URI.highMask("-_.!~*'()");
    private static final long L_UNRESERVED = L_ALPHANUM | L_MARK;
    private static final long H_UNRESERVED = H_ALPHANUM | H_MARK;
    private static final long L_RESERVED = URI.lowMask(";/?:@&=+$,[]");
    private static final long H_RESERVED = URI.highMask(";/?:@&=+$,[]");
    private static final long L_ESCAPED = 1L;
    private static final long H_ESCAPED = 0L;
    private static final long L_URIC = L_RESERVED | L_UNRESERVED | 1L;
    private static final long H_URIC = H_RESERVED | H_UNRESERVED | 0L;
    private static final long L_PCHAR = L_UNRESERVED | 1L | URI.lowMask(":@&=+$,");
    private static final long H_PCHAR = H_UNRESERVED | 0L | URI.highMask(":@&=+$,");
    private static final long L_PATH = L_PCHAR | URI.lowMask(";/");
    private static final long H_PATH = H_PCHAR | URI.highMask(";/");
    private static final long L_DASH = URI.lowMask("-");
    private static final long H_DASH = URI.highMask("-");
    private static final long L_DOT = URI.lowMask(".");
    private static final long H_DOT = URI.highMask(".");
    private static final long L_USERINFO = L_UNRESERVED | 1L | URI.lowMask(";:&=+$,");
    private static final long H_USERINFO = H_UNRESERVED | 0L | URI.highMask(";:&=+$,");
    private static final long L_REG_NAME = L_UNRESERVED | 1L | URI.lowMask("$,;:@&=+");
    private static final long H_REG_NAME = H_UNRESERVED | 0L | URI.highMask("$,;:@&=+");
    private static final long L_SERVER = L_USERINFO | L_ALPHANUM | L_DASH | URI.lowMask(".:@[]");
    private static final long H_SERVER = H_USERINFO | H_ALPHANUM | H_DASH | URI.highMask(".:@[]");
    private static final long L_SERVER_PERCENT = L_SERVER | URI.lowMask("%");
    private static final long H_SERVER_PERCENT = H_SERVER | URI.highMask("%");
    private static final long L_LEFT_BRACKET = URI.lowMask("[");
    private static final long H_LEFT_BRACKET = URI.highMask("[");
    private static final long L_SCHEME = 0L | L_DIGIT | URI.lowMask("+-.");
    private static final long H_SCHEME = H_ALPHA | 0L | URI.highMask("+-.");
    private static final long L_URIC_NO_SLASH = L_UNRESERVED | 1L | URI.lowMask(";?:@&=+$,");
    private static final long H_URIC_NO_SLASH = H_UNRESERVED | 0L | URI.highMask(";?:@&=+$,");
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private URI() {
    }

    public URI(String string) throws URISyntaxException {
        new Parser(string).parse(false);
    }

    public URI(String string, String string2, String string3, int n, String string4, String string5, String string6) throws URISyntaxException {
        String string7 = this.toString(string, null, null, string2, string3, n, string4, string5, string6);
        URI.checkPath(string7, string, string4);
        new Parser(string7).parse(true);
    }

    public URI(String string, String string2, String string3, String string4, String string5) throws URISyntaxException {
        String string6 = this.toString(string, null, string2, null, null, -1, string3, string4, string5);
        URI.checkPath(string6, string, string3);
        new Parser(string6).parse(false);
    }

    public URI(String string, String string2, String string3, String string4) throws URISyntaxException {
        this(string, null, string2, -1, string3, null, string4);
    }

    public URI(String string, String string2, String string3) throws URISyntaxException {
        new Parser(this.toString(string, string2, null, null, null, -1, null, null, string3)).parse(false);
    }

    public static URI create(String string) {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            illegalArgumentException.initCause(uRISyntaxException);
            throw illegalArgumentException;
        }
    }

    public URI parseServerAuthority() throws URISyntaxException {
        if (this.host != null || this.authority == null) {
            return this;
        }
        this.defineString();
        new Parser(this.string).parse(true);
        return this;
    }

    public URI normalize() {
        return URI.normalize(this);
    }

    public URI resolve(URI uRI) {
        return URI.resolve(this, uRI);
    }

    public URI resolve(String string) {
        return this.resolve(URI.create(string));
    }

    public URI relativize(URI uRI) {
        return URI.relativize(this, uRI);
    }

    public URL toURL() throws MalformedURLException {
        if (!this.isAbsolute()) {
            throw new IllegalArgumentException("URI is not absolute");
        }
        return new URL(this.toString());
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean isAbsolute() {
        return this.scheme != null;
    }

    public boolean isOpaque() {
        return this.path == null;
    }

    public String getRawSchemeSpecificPart() {
        this.defineSchemeSpecificPart();
        return this.schemeSpecificPart;
    }

    public String getSchemeSpecificPart() {
        if (this.decodedSchemeSpecificPart == null) {
            this.decodedSchemeSpecificPart = URI.decode(this.getRawSchemeSpecificPart());
        }
        return this.decodedSchemeSpecificPart;
    }

    public String getRawAuthority() {
        return this.authority;
    }

    public String getAuthority() {
        if (this.decodedAuthority == null) {
            this.decodedAuthority = URI.decode(this.authority);
        }
        return this.decodedAuthority;
    }

    public String getRawUserInfo() {
        return this.userInfo;
    }

    public String getUserInfo() {
        if (this.decodedUserInfo == null && this.userInfo != null) {
            this.decodedUserInfo = URI.decode(this.userInfo);
        }
        return this.decodedUserInfo;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getRawPath() {
        return this.path;
    }

    public String getPath() {
        if (this.decodedPath == null && this.path != null) {
            this.decodedPath = URI.decode(this.path);
        }
        return this.decodedPath;
    }

    public String getRawQuery() {
        return this.query;
    }

    public String getQuery() {
        if (this.decodedQuery == null && this.query != null) {
            this.decodedQuery = URI.decode(this.query);
        }
        return this.decodedQuery;
    }

    public String getRawFragment() {
        return this.fragment;
    }

    public String getFragment() {
        if (this.decodedFragment == null && this.fragment != null) {
            this.decodedFragment = URI.decode(this.fragment);
        }
        return this.decodedFragment;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof URI)) {
            return false;
        }
        URI uRI = (URI)object;
        if (this.isOpaque() != uRI.isOpaque()) {
            return false;
        }
        if (!URI.equalIgnoringCase(this.scheme, uRI.scheme)) {
            return false;
        }
        if (!URI.equal(this.fragment, uRI.fragment)) {
            return false;
        }
        if (this.isOpaque()) {
            return URI.equal(this.schemeSpecificPart, uRI.schemeSpecificPart);
        }
        if (!URI.equal(this.path, uRI.path)) {
            return false;
        }
        if (!URI.equal(this.query, uRI.query)) {
            return false;
        }
        if (this.authority == uRI.authority) {
            return true;
        }
        if (this.host != null) {
            if (!URI.equal(this.userInfo, uRI.userInfo)) {
                return false;
            }
            if (!URI.equalIgnoringCase(this.host, uRI.host)) {
                return false;
            }
            if (this.port != uRI.port) {
                return false;
            }
        } else if (this.authority != null ? !URI.equal(this.authority, uRI.authority) : this.authority != uRI.authority) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int n = URI.hashIgnoringCase(0, this.scheme);
        n = URI.hash(n, this.fragment);
        if (this.isOpaque()) {
            n = URI.hash(n, this.schemeSpecificPart);
        } else {
            n = URI.hash(n, this.path);
            n = URI.hash(n, this.query);
            if (this.host != null) {
                n = URI.hash(n, this.userInfo);
                n = URI.hashIgnoringCase(n, this.host);
                n += 1949 * this.port;
            } else {
                n = URI.hash(n, this.authority);
            }
        }
        this.hash = n;
        return n;
    }

    @Override
    public int compareTo(URI uRI) {
        int n = URI.compareIgnoringCase(this.scheme, uRI.scheme);
        if (n != 0) {
            return n;
        }
        if (this.isOpaque()) {
            if (uRI.isOpaque()) {
                n = URI.compare(this.schemeSpecificPart, uRI.schemeSpecificPart);
                if (n != 0) {
                    return n;
                }
                return URI.compare(this.fragment, uRI.fragment);
            }
            return 1;
        }
        if (uRI.isOpaque()) {
            return -1;
        }
        if (this.host != null && uRI.host != null) {
            n = URI.compare(this.userInfo, uRI.userInfo);
            if (n != 0) {
                return n;
            }
            n = URI.compareIgnoringCase(this.host, uRI.host);
            if (n != 0) {
                return n;
            }
            n = this.port - uRI.port;
            if (n != 0) {
                return n;
            }
        } else {
            n = URI.compare(this.authority, uRI.authority);
            if (n != 0) {
                return n;
            }
        }
        if ((n = URI.compare(this.path, uRI.path)) != 0) {
            return n;
        }
        n = URI.compare(this.query, uRI.query);
        if (n != 0) {
            return n;
        }
        return URI.compare(this.fragment, uRI.fragment);
    }

    public String toString() {
        this.defineString();
        return this.string;
    }

    public String toASCIIString() {
        this.defineString();
        return URI.encode(this.string);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.defineString();
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.port = -1;
        objectInputStream.defaultReadObject();
        try {
            new Parser(this.string).parse(false);
        }
        catch (URISyntaxException uRISyntaxException) {
            InvalidObjectException invalidObjectException = new InvalidObjectException("Invalid URI");
            invalidObjectException.initCause(uRISyntaxException);
            throw invalidObjectException;
        }
    }

    private static int toLower(char c) {
        if (c >= 'A' && c <= 'Z') {
            return c + 32;
        }
        return c;
    }

    private static boolean equal(String string, String string2) {
        if (string == string2) {
            return true;
        }
        if (string != null && string2 != null) {
            if (string.length() != string2.length()) {
                return false;
            }
            if (string.indexOf(37) < 0) {
                return string.equals(string2);
            }
            int n = string.length();
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                char c2 = string2.charAt(n2);
                if (c != '%') {
                    if (c != c2) {
                        return false;
                    }
                    ++n2;
                    continue;
                }
                if (c2 != '%') {
                    return false;
                }
                if (URI.toLower(string.charAt(++n2)) != URI.toLower(string2.charAt(n2))) {
                    return false;
                }
                if (URI.toLower(string.charAt(++n2)) != URI.toLower(string2.charAt(n2))) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    private static boolean equalIgnoringCase(String string, String string2) {
        if (string == string2) {
            return true;
        }
        if (string != null && string2 != null) {
            int n = string.length();
            if (string2.length() != n) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (URI.toLower(string.charAt(i)) == URI.toLower(string2.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static int hash(int n, String string) {
        if (string == null) {
            return n;
        }
        return n * 127 + string.hashCode();
    }

    private static int hashIgnoringCase(int n, String string) {
        if (string == null) {
            return n;
        }
        int n2 = n;
        int n3 = string.length();
        for (int i = 0; i < n3; ++i) {
            n2 = 31 * n2 + URI.toLower(string.charAt(i));
        }
        return n2;
    }

    private static int compare(String string, String string2) {
        if (string == string2) {
            return 0;
        }
        if (string != null) {
            if (string2 != null) {
                return string.compareTo(string2);
            }
            return 1;
        }
        return -1;
    }

    private static int compareIgnoringCase(String string, String string2) {
        if (string == string2) {
            return 0;
        }
        if (string != null) {
            if (string2 != null) {
                int n;
                int n2 = string.length();
                int n3 = n2 < (n = string2.length()) ? n2 : n;
                for (int i = 0; i < n3; ++i) {
                    int n4 = URI.toLower(string.charAt(i)) - URI.toLower(string2.charAt(i));
                    if (n4 == 0) continue;
                    return n4;
                }
                return n2 - n;
            }
            return 1;
        }
        return -1;
    }

    private static void checkPath(String string, String string2, String string3) throws URISyntaxException {
        if (string2 != null && string3 != null && string3.length() > 0 && string3.charAt(0) != '/') {
            throw new URISyntaxException(string, "Relative path in absolute URI");
        }
    }

    private void appendAuthority(StringBuffer stringBuffer, String string, String string2, String string3, int n) {
        if (string3 != null) {
            boolean bl;
            stringBuffer.append("//");
            if (string2 != null) {
                stringBuffer.append(URI.quote(string2, L_USERINFO, H_USERINFO));
                stringBuffer.append('@');
            }
            boolean bl2 = bl = string3.indexOf(58) >= 0 && !string3.startsWith("[") && !string3.endsWith("]");
            if (bl) {
                stringBuffer.append('[');
            }
            stringBuffer.append(string3);
            if (bl) {
                stringBuffer.append(']');
            }
            if (n != -1) {
                stringBuffer.append(':');
                stringBuffer.append(n);
            }
        } else if (string != null) {
            stringBuffer.append("//");
            if (string.startsWith("[")) {
                int n2 = string.indexOf("]");
                if (n2 != -1 && string.indexOf(":") != -1) {
                    String string4;
                    String string5;
                    if (n2 == string.length()) {
                        string5 = string;
                        string4 = "";
                    } else {
                        string5 = string.substring(0, n2 + 1);
                        string4 = string.substring(n2 + 1);
                    }
                    stringBuffer.append(string5);
                    stringBuffer.append(URI.quote(string4, L_REG_NAME | L_SERVER, H_REG_NAME | H_SERVER));
                }
            } else {
                stringBuffer.append(URI.quote(string, L_REG_NAME | L_SERVER, H_REG_NAME | H_SERVER));
            }
        }
    }

    private void appendSchemeSpecificPart(StringBuffer stringBuffer, String string, String string2, String string3, String string4, int n, String string5, String string6) {
        if (string != null) {
            if (string.startsWith("//[")) {
                int n2 = string.indexOf("]");
                if (n2 != -1 && string.indexOf(":") != -1) {
                    String string7;
                    String string8;
                    if (n2 == string.length()) {
                        string8 = string;
                        string7 = "";
                    } else {
                        string8 = string.substring(0, n2 + 1);
                        string7 = string.substring(n2 + 1);
                    }
                    stringBuffer.append(string8);
                    stringBuffer.append(URI.quote(string7, L_URIC, H_URIC));
                }
            } else {
                stringBuffer.append(URI.quote(string, L_URIC, H_URIC));
            }
        } else {
            this.appendAuthority(stringBuffer, string2, string3, string4, n);
            if (string5 != null) {
                stringBuffer.append(URI.quote(string5, L_PATH, H_PATH));
            }
            if (string6 != null) {
                stringBuffer.append('?');
                stringBuffer.append(URI.quote(string6, L_URIC, H_URIC));
            }
        }
    }

    private void appendFragment(StringBuffer stringBuffer, String string) {
        if (string != null) {
            stringBuffer.append('#');
            stringBuffer.append(URI.quote(string, L_URIC, H_URIC));
        }
    }

    private String toString(String string, String string2, String string3, String string4, String string5, int n, String string6, String string7, String string8) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append(':');
        }
        this.appendSchemeSpecificPart(stringBuffer, string2, string3, string4, string5, n, string6, string7);
        this.appendFragment(stringBuffer, string8);
        return stringBuffer.toString();
    }

    private void defineSchemeSpecificPart() {
        if (this.schemeSpecificPart != null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.appendSchemeSpecificPart(stringBuffer, null, this.getAuthority(), this.getUserInfo(), this.host, this.port, this.getPath(), this.getQuery());
        if (stringBuffer.length() == 0) {
            return;
        }
        this.schemeSpecificPart = stringBuffer.toString();
    }

    private void defineString() {
        if (this.string != null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.scheme != null) {
            stringBuffer.append(this.scheme);
            stringBuffer.append(':');
        }
        if (this.isOpaque()) {
            stringBuffer.append(this.schemeSpecificPart);
        } else {
            if (this.host != null) {
                boolean bl;
                stringBuffer.append("//");
                if (this.userInfo != null) {
                    stringBuffer.append(this.userInfo);
                    stringBuffer.append('@');
                }
                boolean bl2 = bl = this.host.indexOf(58) >= 0 && !this.host.startsWith("[") && !this.host.endsWith("]");
                if (bl) {
                    stringBuffer.append('[');
                }
                stringBuffer.append(this.host);
                if (bl) {
                    stringBuffer.append(']');
                }
                if (this.port != -1) {
                    stringBuffer.append(':');
                    stringBuffer.append(this.port);
                }
            } else if (this.authority != null) {
                stringBuffer.append("//");
                stringBuffer.append(this.authority);
            }
            if (this.path != null) {
                stringBuffer.append(this.path);
            }
            if (this.query != null) {
                stringBuffer.append('?');
                stringBuffer.append(this.query);
            }
        }
        if (this.fragment != null) {
            stringBuffer.append('#');
            stringBuffer.append(this.fragment);
        }
        this.string = stringBuffer.toString();
    }

    private static String resolvePath(String string, String string2, boolean bl) {
        CharSequence charSequence;
        int n = string.lastIndexOf(47);
        int n2 = string2.length();
        String string3 = "";
        if (n2 == 0) {
            if (n >= 0) {
                string3 = string.substring(0, n + 1);
            }
        } else {
            charSequence = new StringBuffer(string.length() + n2);
            if (n >= 0) {
                ((StringBuffer)charSequence).append(string.substring(0, n + 1));
            }
            ((StringBuffer)charSequence).append(string2);
            string3 = ((StringBuffer)charSequence).toString();
        }
        charSequence = URI.normalize(string3);
        return charSequence;
    }

    private static URI resolve(URI uRI, URI uRI2) {
        if (uRI2.isOpaque() || uRI.isOpaque()) {
            return uRI2;
        }
        if (uRI2.scheme == null && uRI2.authority == null && uRI2.path.equals("") && uRI2.fragment != null && uRI2.query == null) {
            if (uRI.fragment != null && uRI2.fragment.equals(uRI.fragment)) {
                return uRI;
            }
            URI uRI3 = new URI();
            uRI3.scheme = uRI.scheme;
            uRI3.authority = uRI.authority;
            uRI3.userInfo = uRI.userInfo;
            uRI3.host = uRI.host;
            uRI3.port = uRI.port;
            uRI3.path = uRI.path;
            uRI3.fragment = uRI2.fragment;
            uRI3.query = uRI.query;
            return uRI3;
        }
        if (uRI2.scheme != null) {
            return uRI2;
        }
        URI uRI4 = new URI();
        uRI4.scheme = uRI.scheme;
        uRI4.query = uRI2.query;
        uRI4.fragment = uRI2.fragment;
        if (uRI2.authority == null) {
            String string;
            uRI4.authority = uRI.authority;
            uRI4.host = uRI.host;
            uRI4.userInfo = uRI.userInfo;
            uRI4.port = uRI.port;
            String string2 = string = uRI2.path == null ? "" : uRI2.path;
            uRI4.path = string.length() > 0 && string.charAt(0) == '/' ? uRI2.path : URI.resolvePath(uRI.path, string, uRI.isAbsolute());
        } else {
            uRI4.authority = uRI2.authority;
            uRI4.host = uRI2.host;
            uRI4.userInfo = uRI2.userInfo;
            uRI4.host = uRI2.host;
            uRI4.port = uRI2.port;
            uRI4.path = uRI2.path;
        }
        return uRI4;
    }

    private static URI normalize(URI uRI) {
        if (uRI.isOpaque() || uRI.path == null || uRI.path.length() == 0) {
            return uRI;
        }
        String string = URI.normalize(uRI.path);
        if (string == uRI.path) {
            return uRI;
        }
        URI uRI2 = new URI();
        uRI2.scheme = uRI.scheme;
        uRI2.fragment = uRI.fragment;
        uRI2.authority = uRI.authority;
        uRI2.userInfo = uRI.userInfo;
        uRI2.host = uRI.host;
        uRI2.port = uRI.port;
        uRI2.path = string;
        uRI2.query = uRI.query;
        return uRI2;
    }

    private static URI relativize(URI uRI, URI uRI2) {
        String string;
        if (uRI2.isOpaque() || uRI.isOpaque()) {
            return uRI2;
        }
        if (!URI.equalIgnoringCase(uRI.scheme, uRI2.scheme) || !URI.equal(uRI.authority, uRI2.authority)) {
            return uRI2;
        }
        String string2 = URI.normalize(uRI.path);
        if (!string2.equals(string = URI.normalize(uRI2.path))) {
            if (!string2.endsWith("/")) {
                string2 = string2 + "/";
            }
            if (!string.startsWith(string2)) {
                return uRI2;
            }
        }
        URI uRI3 = new URI();
        uRI3.path = string.substring(string2.length());
        uRI3.query = uRI2.query;
        uRI3.fragment = uRI2.fragment;
        return uRI3;
    }

    private static int needsNormalization(String string) {
        int n;
        boolean bl = true;
        int n2 = 0;
        int n3 = string.length() - 1;
        for (n = 0; n <= n3 && string.charAt(n) == '/'; ++n) {
        }
        if (n > 1) {
            bl = false;
        }
        block1: while (n <= n3) {
            if (string.charAt(n) == '.' && (n == n3 || string.charAt(n + 1) == '/' || string.charAt(n + 1) == '.' && (n + 1 == n3 || string.charAt(n + 2) == '/'))) {
                bl = false;
            }
            ++n2;
            while (n <= n3) {
                if (string.charAt(n++) != '/') continue;
                while (n <= n3 && string.charAt(n) == '/') {
                    bl = false;
                    ++n;
                }
                continue block1;
            }
        }
        return bl ? -1 : n2;
    }

    private static void split(char[] cArray, int[] nArray) {
        int n;
        int n2 = cArray.length - 1;
        int n3 = 0;
        for (n = 0; n <= n2 && cArray[n] == '/'; ++n) {
            cArray[n] = '\u0000';
        }
        block1: while (n <= n2) {
            nArray[n3++] = n++;
            while (n <= n2) {
                if (cArray[n++] != '/') continue;
                cArray[n - 1] = '\u0000';
                while (n <= n2 && cArray[n] == '/') {
                    cArray[n++] = '\u0000';
                }
                continue block1;
            }
        }
        if (n3 != nArray.length) {
            throw new InternalError();
        }
    }

    private static int join(char[] cArray, int[] nArray) {
        int n = nArray.length;
        int n2 = cArray.length - 1;
        int n3 = 0;
        if (cArray[n3] == '\u0000') {
            cArray[n3++] = 47;
        }
        for (int i = 0; i < n; ++i) {
            int n4 = nArray[i];
            if (n4 == -1) continue;
            if (n3 == n4) {
                while (n3 <= n2 && cArray[n3] != '\u0000') {
                    ++n3;
                }
                if (n3 > n2) continue;
                cArray[n3++] = 47;
                continue;
            }
            if (n3 < n4) {
                while (n4 <= n2 && cArray[n4] != '\u0000') {
                    cArray[n3++] = cArray[n4++];
                }
                if (n4 > n2) continue;
                cArray[n3++] = 47;
                continue;
            }
            throw new InternalError();
        }
        return n3;
    }

    private static void removeDots(char[] cArray, int[] nArray) {
        int n = nArray.length;
        int n2 = cArray.length - 1;
        for (int i = 0; i < n; ++i) {
            int n3;
            int n4;
            int n5 = 0;
            do {
                if (cArray[n4 = nArray[i]] != '.') continue;
                if (n4 == n2) {
                    n5 = 1;
                    break;
                }
                if (cArray[n4 + 1] == '\u0000') {
                    n5 = 1;
                    break;
                }
                if (cArray[n4 + 1] != '.' || n4 + 1 != n2 && cArray[n4 + 2] != '\u0000') continue;
                n5 = 2;
                break;
            } while (++i < n);
            if (i > n || n5 == 0) break;
            if (n5 == 1) {
                nArray[i] = -1;
                continue;
            }
            for (n4 = i - 1; n4 >= 0 && nArray[n4] == -1; --n4) {
            }
            if (n4 < 0 || cArray[n3 = nArray[n4]] == '.' && cArray[n3 + 1] == '.' && cArray[n3 + 2] == '\u0000') continue;
            nArray[i] = -1;
            nArray[n4] = -1;
        }
    }

    private static void maybeAddLeadingDot(char[] cArray, int[] nArray) {
        int n;
        int n2;
        if (cArray[0] == '\u0000') {
            return;
        }
        int n3 = nArray.length;
        for (n2 = 0; n2 < n3 && nArray[n2] < 0; ++n2) {
        }
        if (n2 >= n3 || n2 == 0) {
            return;
        }
        for (n = nArray[n2]; n < cArray.length && cArray[n] != ':' && cArray[n] != '\u0000'; ++n) {
        }
        if (n >= cArray.length || cArray[n] == '\u0000') {
            return;
        }
        cArray[0] = 46;
        cArray[1] = '\u0000';
        nArray[0] = 0;
    }

    private static String normalize(String string) {
        int n = URI.needsNormalization(string);
        if (n < 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int[] nArray = new int[n];
        URI.split(cArray, nArray);
        URI.removeDots(cArray, nArray);
        URI.maybeAddLeadingDot(cArray, nArray);
        String string2 = new String(cArray, 0, URI.join(cArray, nArray));
        if (string2.equals(string)) {
            return string;
        }
        return string2;
    }

    private static long lowMask(String string) {
        int n = string.length();
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '@') continue;
            l |= 1L << c;
        }
        return l;
    }

    private static long highMask(String string) {
        int n = string.length();
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < '@' || c >= '\u0080') continue;
            l |= 1L << c - 64;
        }
        return l;
    }

    private static long lowMask(char c, char c2) {
        long l = 0L;
        int n = Math.max(Math.min(c, 63), 0);
        int n2 = Math.max(Math.min(c2, 63), 0);
        for (int i = n; i <= n2; ++i) {
            l |= 1L << i;
        }
        return l;
    }

    private static long highMask(char c, char c2) {
        long l = 0L;
        int n = Math.max(Math.min(c, 127), 64) - 64;
        int n2 = Math.max(Math.min(c2, 127), 64) - 64;
        for (int i = n; i <= n2; ++i) {
            l |= 1L << i;
        }
        return l;
    }

    private static boolean match(char c, long l, long l2) {
        if (c < '@') {
            return (1L << c & l) != 0L;
        }
        if (c < '\u0080') {
            return (1L << c - 64 & l2) != 0L;
        }
        return false;
    }

    private static void appendEscape(StringBuffer stringBuffer, byte by) {
        stringBuffer.append('%');
        stringBuffer.append(hexDigits[by >> 4 & 0xF]);
        stringBuffer.append(hexDigits[by >> 0 & 0xF]);
    }

    private static void appendEncoded(StringBuffer stringBuffer, char c) {
        Buffer buffer;
        block4: {
            buffer = null;
            try {
                buffer = ThreadLocalCoders.encoderFor("UTF-8").encode(CharBuffer.wrap("" + c));
            }
            catch (CharacterCodingException characterCodingException) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        while (buffer.hasRemaining()) {
            int n = ((ByteBuffer)buffer).get() & 0xFF;
            if (n >= 128) {
                URI.appendEscape(stringBuffer, (byte)n);
                continue;
            }
            stringBuffer.append((char)n);
        }
    }

    private static String quote(String string, long l, long l2) {
        int n = string.length();
        StringBuffer stringBuffer = null;
        boolean bl = (l & 1L) != 0L;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < '\u0080') {
                if (!URI.match(c, l, l2)) {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                        stringBuffer.append(string.substring(0, i));
                    }
                    URI.appendEscape(stringBuffer, (byte)c);
                    continue;
                }
                if (stringBuffer == null) continue;
                stringBuffer.append(c);
                continue;
            }
            if (bl && (Character.isSpaceChar(c) || Character.isISOControl(c))) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(string.substring(0, i));
                }
                URI.appendEncoded(stringBuffer, c);
                continue;
            }
            if (stringBuffer == null) continue;
            stringBuffer.append(c);
        }
        return stringBuffer == null ? string : stringBuffer.toString();
    }

    private static String encode(String string) {
        ByteBuffer byteBuffer;
        block6: {
            int n = string.length();
            if (n == 0) {
                return string;
            }
            int n2 = 0;
            while (string.charAt(n2) < '\u0080') {
                if (++n2 < n) continue;
                return string;
            }
            String string2 = Normalizer.normalize(string, Normalizer.Form.NFC);
            byteBuffer = null;
            try {
                byteBuffer = ThreadLocalCoders.encoderFor("UTF-8").encode(CharBuffer.wrap(string2));
            }
            catch (CharacterCodingException characterCodingException) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (byteBuffer.hasRemaining()) {
            int n = byteBuffer.get() & 0xFF;
            if (n >= 128) {
                URI.appendEscape(stringBuffer, (byte)n);
                continue;
            }
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    private static int decode(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        assert (false);
        return -1;
    }

    private static byte decode(char c, char c2) {
        return (byte)((URI.decode(c) & 0xF) << 4 | (URI.decode(c2) & 0xF) << 0);
    }

    private static String decode(String string) {
        if (string == null) {
            return string;
        }
        int n = string.length();
        if (n == 0) {
            return string;
        }
        if (string.indexOf(37) < 0) {
            return string;
        }
        byte[] byArray = new byte[n];
        StringBuffer stringBuffer = new StringBuffer(n);
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        CharBuffer charBuffer = CharBuffer.allocate(n);
        CharsetDecoder charsetDecoder = ThreadLocalCoders.decoderFor("UTF-8").onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        char c = string.charAt(0);
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            assert (c == string.charAt(n2));
            if (c == '[') {
                bl = true;
            } else if (bl && c == ']') {
                bl = false;
            }
            if (c != '%' || bl) {
                stringBuffer.append(c);
                if (++n2 >= n) break;
                c = string.charAt(n2);
                continue;
            }
            byteBuffer.clear();
            int n3 = n2;
            do {
                assert (n - n2 >= 2);
                byteBuffer.put(URI.decode(string.charAt(++n2), string.charAt(++n2)));
            } while (++n2 < n && (c = string.charAt(n2)) == '%');
            byteBuffer.flip();
            charBuffer.clear();
            charsetDecoder.reset();
            CoderResult coderResult = charsetDecoder.decode(byteBuffer, charBuffer, true);
            assert (coderResult.isUnderflow());
            coderResult = charsetDecoder.flush(charBuffer);
            assert (coderResult.isUnderflow());
            stringBuffer.append(charBuffer.flip().toString());
        }
        return stringBuffer.toString();
    }

    private class Parser {
        private String input;
        private boolean requireServerAuthority = false;
        private int ipv6byteCount = 0;

        Parser(String string) {
            this.input = string;
            URI.this.string = string;
        }

        private void fail(String string) throws URISyntaxException {
            throw new URISyntaxException(this.input, string);
        }

        private void fail(String string, int n) throws URISyntaxException {
            throw new URISyntaxException(this.input, string, n);
        }

        private void failExpecting(String string, int n) throws URISyntaxException {
            this.fail("Expected " + string, n);
        }

        private void failExpecting(String string, String string2, int n) throws URISyntaxException {
            this.fail("Expected " + string + " following " + string2, n);
        }

        private String substring(int n, int n2) {
            return this.input.substring(n, n2);
        }

        private char charAt(int n) {
            return this.input.charAt(n);
        }

        private boolean at(int n, int n2, char c) {
            return n < n2 && this.charAt(n) == c;
        }

        private boolean at(int n, int n2, String string) {
            int n3;
            int n4 = n;
            int n5 = string.length();
            if (n5 > n2 - n4) {
                return false;
            }
            for (n3 = 0; n3 < n5 && this.charAt(n4++) == string.charAt(n3); ++n3) {
            }
            return n3 == n5;
        }

        private int scan(int n, int n2, char c) {
            if (n < n2 && this.charAt(n) == c) {
                return n + 1;
            }
            return n;
        }

        private int scan(int n, int n2, String string, String string2) {
            int n3;
            for (n3 = n; n3 < n2; ++n3) {
                char c = this.charAt(n3);
                if (string.indexOf(c) >= 0) {
                    return -1;
                }
                if (string2.indexOf(c) >= 0) break;
            }
            return n3;
        }

        private int scanEscape(int n, int n2, char c) throws URISyntaxException {
            int n3 = n;
            char c2 = c;
            if (c2 == '%') {
                if (n3 + 3 <= n2 && URI.match(this.charAt(n3 + 1), L_HEX, H_HEX) && URI.match(this.charAt(n3 + 2), L_HEX, H_HEX)) {
                    return n3 + 3;
                }
                this.fail("Malformed escape pair", n3);
            } else if (c2 > '\u0080' && !Character.isSpaceChar(c2) && !Character.isISOControl(c2)) {
                return n3 + 1;
            }
            return n3;
        }

        private int scan(int n, int n2, long l, long l2) throws URISyntaxException {
            int n3 = n;
            while (n3 < n2) {
                int n4;
                char c = this.charAt(n3);
                if (URI.match(c, l, l2)) {
                    ++n3;
                    continue;
                }
                if ((l & 1L) == 0L || (n4 = this.scanEscape(n3, n2, c)) <= n3) break;
                n3 = n4;
            }
            return n3;
        }

        private void checkChars(int n, int n2, long l, long l2, String string) throws URISyntaxException {
            int n3 = this.scan(n, n2, l, l2);
            if (n3 < n2) {
                this.fail("Illegal character in " + string, n3);
            }
        }

        private void checkChar(int n, long l, long l2, String string) throws URISyntaxException {
            this.checkChars(n, n + 1, l, l2, string);
        }

        void parse(boolean bl) throws URISyntaxException {
            int n;
            this.requireServerAuthority = bl;
            int n2 = this.input.length();
            int n3 = this.scan(0, n2, "/?#", ":");
            if (n3 >= 0 && this.at(n3, n2, ':')) {
                if (n3 == 0) {
                    this.failExpecting("scheme name", 0);
                }
                this.checkChar(0, 0L, H_ALPHA, "scheme name");
                this.checkChars(1, n3, L_SCHEME, H_SCHEME, "scheme name");
                URI.this.scheme = this.substring(0, n3);
                n = ++n3;
                if (this.at(n3, n2, '/')) {
                    n3 = this.parseHierarchical(n3, n2);
                } else {
                    int n4 = this.scan(n3, n2, "", "#");
                    if (n4 <= n3) {
                        this.failExpecting("scheme-specific part", n3);
                    }
                    this.checkChars(n3, n4, L_URIC, H_URIC, "opaque part");
                    n3 = n4;
                }
            } else {
                n = 0;
                n3 = this.parseHierarchical(0, n2);
            }
            URI.this.schemeSpecificPart = this.substring(n, n3);
            if (this.at(n3, n2, '#')) {
                this.checkChars(n3 + 1, n2, L_URIC, H_URIC, "fragment");
                URI.this.fragment = this.substring(n3 + 1, n2);
                n3 = n2;
            }
            if (n3 < n2) {
                this.fail("end of URI", n3);
            }
        }

        private int parseHierarchical(int n, int n2) throws URISyntaxException {
            int n3;
            int n4 = n;
            if (this.at(n4, n2, '/') && this.at(n4 + 1, n2, '/')) {
                n3 = this.scan(n4 += 2, n2, "", "/?#");
                if (n3 > n4) {
                    n4 = this.parseAuthority(n4, n3);
                } else if (n3 >= n2) {
                    this.failExpecting("authority", n4);
                }
            }
            n3 = this.scan(n4, n2, "", "?#");
            this.checkChars(n4, n3, L_PATH, H_PATH, "path");
            URI.this.path = this.substring(n4, n3);
            n4 = n3;
            if (this.at(n4, n2, '?')) {
                n3 = this.scan(++n4, n2, "", "#");
                this.checkChars(n4, n3, L_URIC, H_URIC, "query");
                URI.this.query = this.substring(n4, n3);
                n4 = n3;
            }
            return n4;
        }

        private int parseAuthority(int n, int n2) throws URISyntaxException {
            boolean bl;
            int n3;
            int n4 = n3 = n;
            URISyntaxException uRISyntaxException = null;
            boolean bl2 = this.scan(n3, n2, "", "]") > n3 ? this.scan(n3, n2, L_SERVER_PERCENT, H_SERVER_PERCENT) == n2 : this.scan(n3, n2, L_SERVER, H_SERVER) == n2;
            boolean bl3 = bl = this.scan(n3, n2, L_REG_NAME, H_REG_NAME) == n2;
            if (bl && !bl2) {
                URI.this.authority = this.substring(n3, n2);
                return n2;
            }
            if (bl2) {
                try {
                    n4 = this.parseServer(n3, n2);
                    if (n4 < n2) {
                        this.failExpecting("end of authority", n4);
                    }
                    URI.this.authority = this.substring(n3, n2);
                }
                catch (URISyntaxException uRISyntaxException2) {
                    URI.this.userInfo = null;
                    URI.this.host = null;
                    URI.this.port = -1;
                    if (this.requireServerAuthority) {
                        throw uRISyntaxException2;
                    }
                    uRISyntaxException = uRISyntaxException2;
                    n4 = n3;
                }
            }
            if (n4 < n2) {
                if (bl) {
                    URI.this.authority = this.substring(n3, n2);
                } else {
                    if (uRISyntaxException != null) {
                        throw uRISyntaxException;
                    }
                    this.fail("Illegal character in authority", n4);
                }
            }
            return n2;
        }

        private int parseServer(int n, int n2) throws URISyntaxException {
            int n3 = n;
            int n4 = this.scan(n3, n2, "/?#", "@");
            if (n4 >= n3 && this.at(n4, n2, '@')) {
                this.checkChars(n3, n4, L_USERINFO, H_USERINFO, "user info");
                URI.this.userInfo = this.substring(n3, n4);
                n3 = n4 + 1;
            }
            if (this.at(n3, n2, '[')) {
                if ((n4 = this.scan(++n3, n2, "/?#", "]")) > n3 && this.at(n4, n2, ']')) {
                    int n5 = this.scan(n3, n4, "", "%");
                    if (n5 > n3) {
                        this.parseIPv6Reference(n3, n5);
                        if (n5 + 1 == n4) {
                            this.fail("scope id expected");
                        }
                        this.checkChars(n5 + 1, n4, L_ALPHANUM, H_ALPHANUM, "scope id");
                    } else {
                        this.parseIPv6Reference(n3, n4);
                    }
                    URI.this.host = this.substring(n3 - 1, n4 + 1);
                    n3 = n4 + 1;
                } else {
                    this.failExpecting("closing bracket for IPv6 address", n4);
                }
            } else {
                n4 = this.parseIPv4Address(n3, n2);
                if (n4 <= n3) {
                    n4 = this.parseHostname(n3, n2);
                }
                n3 = n4;
            }
            if (this.at(n3, n2, ':') && (n4 = this.scan(++n3, n2, "", "/")) > n3) {
                this.checkChars(n3, n4, L_DIGIT, 0L, "port number");
                try {
                    URI.this.port = Integer.parseInt(this.substring(n3, n4));
                }
                catch (NumberFormatException numberFormatException) {
                    this.fail("Malformed port number", n3);
                }
                n3 = n4;
            }
            if (n3 < n2) {
                this.failExpecting("port number", n3);
            }
            return n3;
        }

        private int scanByte(int n, int n2) throws URISyntaxException {
            int n3 = n;
            int n4 = this.scan(n3, n2, L_DIGIT, 0L);
            if (n4 <= n3) {
                return n4;
            }
            if (Integer.parseInt(this.substring(n3, n4)) > 255) {
                return n3;
            }
            return n4;
        }

        private int scanIPv4Address(int n, int n2, boolean bl) throws URISyntaxException {
            int n3 = n;
            int n4 = this.scan(n3, n2, L_DIGIT | L_DOT, 0L | H_DOT);
            if (n4 <= n3 || bl && n4 != n2) {
                return -1;
            }
            int n5 = this.scanByte(n3, n4);
            if (n5 > n3 && (n5 = this.scan(n3 = n5, n4, '.')) > n3 && (n5 = this.scanByte(n3 = n5, n4)) > n3 && (n5 = this.scan(n3 = n5, n4, '.')) > n3 && (n5 = this.scanByte(n3 = n5, n4)) > n3 && (n5 = this.scan(n3 = n5, n4, '.')) > n3 && (n5 = this.scanByte(n3 = n5, n4)) > n3) {
                n3 = n5;
                if (n5 >= n4) {
                    return n5;
                }
            }
            this.fail("Malformed IPv4 address", n5);
            return -1;
        }

        private int takeIPv4Address(int n, int n2, String string) throws URISyntaxException {
            int n3 = this.scanIPv4Address(n, n2, true);
            if (n3 <= n) {
                this.failExpecting(string, n);
            }
            return n3;
        }

        private int parseIPv4Address(int n, int n2) {
            int n3;
            try {
                n3 = this.scanIPv4Address(n, n2, false);
            }
            catch (URISyntaxException uRISyntaxException) {
                return -1;
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
            if (n3 > n && n3 < n2 && this.charAt(n3) != ':') {
                n3 = -1;
            }
            if (n3 > n) {
                URI.this.host = this.substring(n, n3);
            }
            return n3;
        }

        private int parseHostname(int n, int n2) throws URISyntaxException {
            int n3;
            int n4 = n;
            int n5 = -1;
            while ((n3 = this.scan(n4, n2, L_ALPHANUM, H_ALPHANUM)) > n4) {
                n5 = n4;
                if (n3 > n4 && (n3 = this.scan(n4 = n3, n2, L_ALPHANUM | L_DASH, H_ALPHANUM | H_DASH)) > n4) {
                    if (this.charAt(n3 - 1) == '-') {
                        this.fail("Illegal character in hostname", n3 - 1);
                    }
                    n4 = n3;
                }
                if ((n3 = this.scan(n4, n2, '.')) > n4 && (n4 = n3) < n2) continue;
            }
            if (n4 < n2 && !this.at(n4, n2, ':')) {
                this.fail("Illegal character in hostname", n4);
            }
            if (n5 < 0) {
                this.failExpecting("hostname", n);
            }
            if (n5 > n && !URI.match(this.charAt(n5), 0L, H_ALPHA)) {
                this.fail("Illegal character in hostname", n5);
            }
            URI.this.host = this.substring(n, n4);
            return n4;
        }

        private int parseIPv6Reference(int n, int n2) throws URISyntaxException {
            int n3 = n;
            boolean bl = false;
            int n4 = this.scanHexSeq(n3, n2);
            if (n4 > n3) {
                n3 = n4;
                if (this.at(n3, n2, "::")) {
                    bl = true;
                    n3 = this.scanHexPost(n3 + 2, n2);
                } else if (this.at(n3, n2, ':')) {
                    n3 = this.takeIPv4Address(n3 + 1, n2, "IPv4 address");
                    this.ipv6byteCount += 4;
                }
            } else if (this.at(n3, n2, "::")) {
                bl = true;
                n3 = this.scanHexPost(n3 + 2, n2);
            }
            if (n3 < n2) {
                this.fail("Malformed IPv6 address", n);
            }
            if (this.ipv6byteCount > 16) {
                this.fail("IPv6 address too long", n);
            }
            if (!bl && this.ipv6byteCount < 16) {
                this.fail("IPv6 address too short", n);
            }
            if (bl && this.ipv6byteCount == 16) {
                this.fail("Malformed IPv6 address", n);
            }
            return n3;
        }

        private int scanHexPost(int n, int n2) throws URISyntaxException {
            int n3 = n;
            if (n3 == n2) {
                return n3;
            }
            int n4 = this.scanHexSeq(n3, n2);
            if (n4 > n3) {
                n3 = n4;
                if (this.at(n3, n2, ':')) {
                    ++n3;
                    n3 = this.takeIPv4Address(n3, n2, "hex digits or IPv4 address");
                    this.ipv6byteCount += 4;
                }
            } else {
                n3 = this.takeIPv4Address(n3, n2, "hex digits or IPv4 address");
                this.ipv6byteCount += 4;
            }
            return n3;
        }

        private int scanHexSeq(int n, int n2) throws URISyntaxException {
            int n3 = n;
            int n4 = this.scan(n3, n2, L_HEX, H_HEX);
            if (n4 <= n3) {
                return -1;
            }
            if (this.at(n4, n2, '.')) {
                return -1;
            }
            if (n4 > n3 + 4) {
                this.fail("IPv6 hexadecimal digit sequence too long", n3);
            }
            this.ipv6byteCount += 2;
            n3 = n4;
            while (n3 < n2 && this.at(n3, n2, ':') && !this.at(n3 + 1, n2, ':')) {
                if ((n4 = this.scan(++n3, n2, L_HEX, H_HEX)) <= n3) {
                    this.failExpecting("digits for an IPv6 address", n3);
                }
                if (this.at(n4, n2, '.')) {
                    --n3;
                    break;
                }
                if (n4 > n3 + 4) {
                    this.fail("IPv6 hexadecimal digit sequence too long", n3);
                }
                this.ipv6byteCount += 2;
                n3 = n4;
            }
            return n3;
        }
    }
}

