/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.BadPacketException;
import com.android.ddmlib.ChunkHandler;
import com.android.ddmlib.Log;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;

final class JdwpPacket {
    public static final int JDWP_HEADER_LEN = 11;
    public static final int HANDSHAKE_GOOD = 1;
    public static final int HANDSHAKE_NOTYET = 2;
    public static final int HANDSHAKE_BAD = 3;
    private static final int DDMS_CMD_SET = 199;
    private static final int DDMS_CMD = 1;
    private static final int REPLY_PACKET = 128;
    private static final byte[] mHandshake = new byte[]{74, 68, 87, 80, 45, 72, 97, 110, 100, 115, 104, 97, 107, 101};
    public static final int HANDSHAKE_LEN = mHandshake.length;
    private ByteBuffer mBuffer;
    private int mLength;
    private int mId;
    private int mFlags;
    private int mCmdSet;
    private int mCmd;
    private int mErrCode;
    private boolean mIsNew;
    private static int mSerialId = 0x40000000;

    JdwpPacket(ByteBuffer buf) {
        this.mBuffer = buf;
        this.mIsNew = true;
    }

    void finishPacket(int payloadLength) {
        assert (this.mIsNew);
        ByteOrder oldOrder = this.mBuffer.order();
        this.mBuffer.order(ChunkHandler.CHUNK_ORDER);
        this.mLength = 11 + payloadLength;
        this.mId = JdwpPacket.getNextSerial();
        this.mFlags = 0;
        this.mCmdSet = 199;
        this.mCmd = 1;
        this.mBuffer.putInt(0, this.mLength);
        this.mBuffer.putInt(4, this.mId);
        this.mBuffer.put(8, (byte)this.mFlags);
        this.mBuffer.put(9, (byte)this.mCmdSet);
        this.mBuffer.put(10, (byte)this.mCmd);
        this.mBuffer.order(oldOrder);
        this.mBuffer.position(this.mLength);
    }

    private static synchronized int getNextSerial() {
        return mSerialId++;
    }

    ByteBuffer getPayload() {
        int oldPosn = this.mBuffer.position();
        this.mBuffer.position(11);
        ByteBuffer buf = this.mBuffer.slice();
        this.mBuffer.position(oldPosn);
        if (this.mLength > 0) {
            buf.limit(this.mLength - 11);
        } else assert (this.mIsNew);
        buf.order(ChunkHandler.CHUNK_ORDER);
        return buf;
    }

    boolean isDdmPacket() {
        return (this.mFlags & 0x80) == 0 && this.mCmdSet == 199 && this.mCmd == 1;
    }

    boolean isReply() {
        return (this.mFlags & 0x80) != 0;
    }

    boolean isError() {
        return this.isReply() && this.mErrCode != 0;
    }

    boolean isEmpty() {
        return this.mLength == 11;
    }

    int getId() {
        return this.mId;
    }

    int getLength() {
        return this.mLength;
    }

    void writeAndConsume(SocketChannel chan) throws IOException {
        assert (this.mLength > 0);
        this.mBuffer.flip();
        int oldLimit = this.mBuffer.limit();
        this.mBuffer.limit(this.mLength);
        while (this.mBuffer.position() != this.mBuffer.limit()) {
            chan.write(this.mBuffer);
        }
        assert (this.mBuffer.position() == this.mLength);
        this.mBuffer.limit(oldLimit);
        this.mBuffer.compact();
    }

    void movePacket(ByteBuffer buf) {
        Log.v("ddms", "moving " + this.mLength + " bytes");
        int oldPosn = this.mBuffer.position();
        this.mBuffer.position(0);
        this.mBuffer.limit(this.mLength);
        buf.put(this.mBuffer);
        this.mBuffer.position(this.mLength);
        this.mBuffer.limit(oldPosn);
        this.mBuffer.compact();
    }

    void consume() {
        this.mBuffer.flip();
        this.mBuffer.position(this.mLength);
        this.mBuffer.compact();
        this.mLength = 0;
    }

    static JdwpPacket findPacket(ByteBuffer buf) {
        int count = buf.position();
        if (count < 11) {
            return null;
        }
        ByteOrder oldOrder = buf.order();
        buf.order(ChunkHandler.CHUNK_ORDER);
        int length = buf.getInt(0);
        int id = buf.getInt(4);
        int flags = buf.get(8) & 0xFF;
        int cmdSet = buf.get(9) & 0xFF;
        int cmd = buf.get(10) & 0xFF;
        buf.order(oldOrder);
        if (length < 11) {
            throw new BadPacketException();
        }
        if (count < length) {
            return null;
        }
        JdwpPacket pkt = new JdwpPacket(buf);
        pkt.mLength = length;
        pkt.mId = id;
        pkt.mFlags = flags;
        if ((flags & 0x80) == 0) {
            pkt.mCmdSet = cmdSet;
            pkt.mCmd = cmd;
            pkt.mErrCode = -1;
        } else {
            pkt.mCmdSet = -1;
            pkt.mCmd = -1;
            pkt.mErrCode = cmdSet | cmd << 8;
        }
        return pkt;
    }

    static int findHandshake(ByteBuffer buf) {
        int count = buf.position();
        if (count < mHandshake.length) {
            return 2;
        }
        int i = mHandshake.length - 1;
        while (i >= 0) {
            if (buf.get(i) != mHandshake[i]) {
                return 3;
            }
            --i;
        }
        return 1;
    }

    static void consumeHandshake(ByteBuffer buf) {
        buf.flip();
        buf.position(mHandshake.length);
        buf.compact();
    }

    static void putHandshake(ByteBuffer buf) {
        buf.put(mHandshake);
    }
}

