/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.compress;

import com.miui.theme.tool.compress.ZipCompressor;
import com.miui.theme.tool.gui.CopyableDialog;
import com.miui.theme.tool.ninepatch.NinePatchDecoder;
import com.miui.theme.tool.ninepatch.NinePatchUtils;
import com.miui.theme.tool.os.OS;
import com.miui.theme.tool.util.MD5Util;
import com.miui.theme.tool.util.PreCompress;
import com.miui.theme.tool.util.ThemeHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class MtzCompressor {
    public static final String[] sNoCompressDirs = new String[]{"wallpaper", "fonts", "boots", "ringtones", "audioeffect", "preview"};
    public static final String FONT = "fonts";
    public static final String BOOTS = "boots";
    public static final String ICONS = "icons";
    public static final String BOOTANIMATION = "bootanimation";
    public static final String BOOTANIMATION_DOT_ZIP = "bootanimation.zip";
    public static final String WIN_RABBISH = "Thumbs.db";
    private String mSrcPath;
    private File mSrcFile;
    private String mCacheDirPath;
    private String mTmpDirPath;
    private String mDestPath;
    private boolean mEncode9PatchFlag = true;
    private boolean mCompressFontFlag = false;
    private boolean mFullCompressFlag = false;
    private long mStartTime;
    private long mLastTime;
    private HashSet<String> mRepackagedSet;
    private HashSet<String> mNinePatchWrongs = new HashSet();

    public static boolean isNoCompressDir(String dirName) {
        int i = 0;
        while (i < sNoCompressDirs.length) {
            if (dirName.equals(sNoCompressDirs[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setSrcPath(String path) {
        this.mSrcPath = path;
        this.mSrcFile = new File(this.mSrcPath);
        this.mCacheDirPath = ThemeHelper.getTmpFolder() + File.separator + "compress_cache" + File.separator + this.mSrcFile.getName() + "_" + MD5Util.md5(this.mSrcFile.getAbsolutePath());
        File cacheDirFile = new File(this.mCacheDirPath);
        cacheDirFile.mkdirs();
        this.mTmpDirPath = ThemeHelper.getTmpFolder() + File.separator + "compress_temp" + File.separator + this.mSrcFile.getName() + "_" + MD5Util.md5(this.mSrcFile.getAbsolutePath());
    }

    public void setDestPath(String path) {
        this.mDestPath = path;
    }

    public void setEncodeNinePatch(boolean flag) {
        this.mEncode9PatchFlag = flag;
    }

    public void setCompressFont(boolean flag) {
        this.mCompressFontFlag = flag;
    }

    public void setFullCompress(boolean flag) {
        this.mFullCompressFlag = flag;
    }

    public void generate() {
        PreCompress.checkAndFixDialerDimen();
        ThemeHelper.searchAndDelete(WIN_RABBISH, this.mSrcFile);
        this.generateCache();
        if (this.mNinePatchWrongs.size() > 0) {
            StringBuilder text = new StringBuilder();
            for (String str : this.mNinePatchWrongs) {
                text.append(String.valueOf(str) + "\n");
            }
            new CopyableDialog(text.toString()).setVisible(true);
            throw new RuntimeException("generate cache error");
        }
        this.generateMtz();
    }

    public void generateCache() {
        if (!this.mSrcFile.exists() && !this.mSrcFile.isDirectory()) {
            return;
        }
        new File(this.mCacheDirPath).mkdirs();
        this.mStartTime = System.currentTimeMillis();
        this.mLastTime = System.currentTimeMillis();
        this.mRepackagedSet = new HashSet();
        File[] fileArray = this.mSrcFile.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            block19: {
                File curFile;
                block21: {
                    block20: {
                        curFile = fileArray[n2];
                        boolean needCompressFlag = false;
                        File cacheFile = new File(String.valueOf(this.mCacheDirPath) + File.separator + curFile.getName());
                        if (!needCompressFlag && !cacheFile.exists()) {
                            needCompressFlag = true;
                        }
                        if (!needCompressFlag && curFile.getName().equals("description.xml")) {
                            needCompressFlag = true;
                        }
                        HashMap<String, Long> map = new HashMap<String, Long>();
                        String hint = "";
                        if (!needCompressFlag) {
                            if (cacheFile.isDirectory()) {
                                this.getFileMapRecursive(cacheFile, "", map);
                            } else {
                                this.getFileMapFromZip(cacheFile, map);
                            }
                            hint = String.valueOf(curFile.getName()) + "count before:" + map.size();
                            needCompressFlag = this.checkFileByMapRecursive(curFile, "", map);
                        }
                        if (!needCompressFlag && map.keySet().size() > 0) {
                            System.out.println(String.valueOf(hint) + " count after:" + map.size());
                            needCompressFlag = true;
                        }
                        if (!needCompressFlag) break block19;
                        this.mRepackagedSet.add(curFile.getName());
                        this.removePackage(cacheFile);
                        if (!curFile.isFile()) break block20;
                        this.copyFile(String.valueOf(this.mSrcPath) + File.separator + curFile.getName(), String.valueOf(this.mCacheDirPath) + File.separator + curFile.getName(), this.mEncode9PatchFlag);
                        break block21;
                    }
                    if (curFile.listFiles().length == 0) break block19;
                    String dirName = curFile.getName();
                    if (MtzCompressor.isNoCompressDir(dirName)) {
                        new File(String.valueOf(this.mCacheDirPath) + File.separator + dirName).mkdir();
                        if (dirName.equals(BOOTS)) {
                            File[] fileArray2 = curFile.listFiles();
                            int n3 = fileArray2.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                File bootFile = fileArray2[n4];
                                if (bootFile.isDirectory() && bootFile.getName().equals(BOOTANIMATION)) {
                                    ZipCompressor bootanimationZip = new ZipCompressor(String.valueOf(this.mCacheDirPath) + File.separator + BOOTS + File.separator + BOOTANIMATION_DOT_ZIP);
                                    bootanimationZip.compressContent(String.valueOf(this.mSrcPath) + File.separator + BOOTS + File.separator + BOOTANIMATION);
                                } else if (bootFile.isFile()) {
                                    this.copyDirectory(String.valueOf(this.mSrcPath) + File.separator + dirName, String.valueOf(this.mCacheDirPath) + File.separator + BOOTS, this.mEncode9PatchFlag);
                                }
                                ++n4;
                            }
                        } else {
                            this.copyDirectory(String.valueOf(this.mSrcPath) + File.separator + dirName, String.valueOf(this.mCacheDirPath) + File.separator + dirName, this.mEncode9PatchFlag);
                        }
                    } else {
                        String fileName = curFile.getName();
                        ZipCompressor fileToZip = new ZipCompressor(String.valueOf(this.mCacheDirPath) + File.separator + fileName, this.mEncode9PatchFlag);
                        HashSet<String> set = fileToZip.compressContent(String.valueOf(this.mSrcPath) + File.separator + fileName);
                        this.mNinePatchWrongs.addAll(set);
                    }
                }
                long timeSpend = System.currentTimeMillis() - this.mLastTime;
                this.mLastTime = System.currentTimeMillis();
                long totalSpend = System.currentTimeMillis() - this.mStartTime;
                System.out.println("spend:" + timeSpend + " total:" + totalSpend + "      " + curFile.getName());
            }
            ++n2;
        }
    }

    private void getFileMapFromZip(File cacheFile, HashMap<String, Long> map) {
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(cacheFile.getAbsolutePath());
                Enumeration entries = zipFile.getEntries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = (ZipEntry)entries.nextElement();
                    if (entry.isDirectory()) continue;
                    map.put(entry.getName(), entry.getTime());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void getFileMapRecursive(File cacheFile, String path, HashMap<String, Long> map) {
        File[] files = new File(String.valueOf(cacheFile.getAbsolutePath()) + File.separator + path).listFiles();
        if (files == null) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                String key = path;
                key = path.isEmpty() ? String.valueOf(key) + file.getName() : String.valueOf(key) + File.separator + file.getName();
                key = ThemeHelper.assurePath(key, "/");
                map.put(key, file.lastModified());
            } else {
                this.getFileMapRecursive(cacheFile, String.valueOf(path) + File.separator + file.getName(), map);
            }
            ++n2;
        }
    }

    private boolean checkFileByMapRecursive(File curFile, String path, HashMap<String, Long> map) {
        File[] files = new File(String.valueOf(curFile.getAbsolutePath()) + File.separator + path).listFiles();
        if (files == null) {
            return false;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String key = path;
            key = path.isEmpty() ? String.valueOf(key) + file.getName() : String.valueOf(key) + File.separator + file.getName();
            if (file.isFile()) {
                if (!map.containsKey(key = ThemeHelper.assurePath(key, "/"))) {
                    System.out.println(String.valueOf(file.getName()) + " " + file.lastModified() + "~ empty");
                    return true;
                }
                if (!this.fileTimeEqual(file.lastModified(), map.get(key))) {
                    System.out.println(String.valueOf(file.getName()) + " " + file.lastModified() + "~" + map.get(key));
                    return true;
                }
                map.remove(key);
            } else if (this.checkFileByMapRecursive(curFile, key, map)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean fileTimeEqual(long t1, long t2) {
        return Math.abs(t1 - t2) <= 2001L;
    }

    private void removePackage(File f) {
        if (f.isFile()) {
            f.delete();
        } else {
            OS.rmDir(f.getAbsolutePath());
        }
    }

    public void printTime(long time) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH mm ss E");
        System.out.println(formatter.format(new Date(time)));
    }

    public void generateMtz() {
        HashSet<String> toComressSet;
        File mCacheDirFile = new File(this.mCacheDirPath);
        File[] fileArray = mCacheDirFile.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (!new File(String.valueOf(this.mSrcPath) + File.separator + f.getName()).exists()) {
                this.removePackage(f);
            }
            ++n2;
        }
        new File(this.mTmpDirPath).mkdirs();
        if (this.mFullCompressFlag) {
            toComressSet = new HashSet();
            File[] fileArray2 = new File(this.mCacheDirPath).listFiles();
            int n3 = fileArray2.length;
            n = 0;
            while (n < n3) {
                File f = fileArray2[n];
                toComressSet.add(f.getName());
                ++n;
            }
        } else {
            toComressSet = this.mRepackagedSet;
        }
        for (String packageName : toComressSet) {
            if (packageName.equals(FONT) && !this.mCompressFontFlag) continue;
            File packageFile = new File(String.valueOf(this.mCacheDirPath) + File.separator + packageName);
            if (packageFile.isFile()) {
                this.copyFile(packageFile.getAbsolutePath(), String.valueOf(this.mTmpDirPath) + File.separator + packageName, false);
                continue;
            }
            this.copyDirectory(packageFile.getAbsolutePath(), String.valueOf(this.mTmpDirPath) + File.separator + packageName, false);
        }
        ZipCompressor zipFile = new ZipCompressor(this.mDestPath);
        zipFile.compressContent(this.mTmpDirPath);
        long timeSpend = System.currentTimeMillis() - this.mLastTime;
        this.mLastTime = System.currentTimeMillis();
        long totalSpend = System.currentTimeMillis() - this.mStartTime;
        System.out.println("spend:" + timeSpend + " total:" + totalSpend + "      " + this.mDestPath);
        OS.rmDir(this.mTmpDirPath);
    }

    private void copyFile(String sourceFilePath, String targetFilePath, boolean isEncode9Patch) {
        FileInputStream fin = null;
        FileOutputStream fout = null;
        try {
            if (isEncode9Patch && ThemeHelper.isNinePatchName(sourceFilePath) && !NinePatchDecoder.decode(sourceFilePath, false)) {
                fout = new FileOutputStream(targetFilePath);
                NinePatchUtils.compileSinglePng(sourceFilePath, fout);
                return;
            }
            try {
                File sourceFile = new File(sourceFilePath);
                File targetFile = new File(targetFilePath);
                ThemeHelper.copyFile(sourceFile, targetFile);
                targetFile.setLastModified(sourceFile.lastModified());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.mNinePatchWrongs.add(String.valueOf(e.getMessage()) + sourceFilePath.substring(new File(ThemeHelper.sThemeFolderPath).getParent().length() + 1));
            }
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void copyDirectory(String sourceDir, String targetDir, boolean isEncode9Patch) {
        new File(targetDir).mkdirs();
        File[] files = new File(sourceDir).listFiles();
        if (files == null) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isFile()) {
                File sourceFile = f;
                File targetFile = new File(String.valueOf(new File(targetDir).getAbsolutePath()) + File.separator + f.getName());
                this.copyFile(sourceFile.getAbsolutePath(), targetFile.getAbsolutePath(), isEncode9Patch);
            } else if (f.isDirectory()) {
                String dir1 = String.valueOf(sourceDir) + File.separator + f.getName();
                String dir2 = String.valueOf(targetDir) + File.separator + f.getName();
                this.copyDirectory(dir1, dir2, isEncode9Patch);
            }
            ++n2;
        }
    }
}

