/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.freestyle;

import com.miui.home.launcher.upsidescene.data.Screen;
import com.miui.home.launcher.upsidescene.data.Sprite;
import com.miui.theme.tool.freestyle.FreeStylePanel;
import com.miui.theme.tool.freestyle.ScenePreviewPanel;
import com.miui.theme.tool.resourceeditor.PointRectangle;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;

public class DragableScenePreviewPanel
extends ScenePreviewPanel {
    public MouseAdapter mSelectAdapter = new MouseAdapter(){
        private boolean mDragingFlag;

        @Override
        public void mouseDragged(MouseEvent e) {
            this.mDragingFlag = true;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.mDragingFlag) {
                Vector<Rectangle> select = new Vector<Rectangle>();
                for (Rectangle r : DragableScenePreviewPanel.this.mRectangleSpritesMap.keySet()) {
                    if (!r.contains(e.getX(), e.getY())) continue;
                    select.add(r);
                }
                if (select.size() > 0) {
                    Collections.sort(select, new Comparator<Rectangle>(){

                        @Override
                        public int compare(Rectangle r1, Rectangle r2) {
                            return DragableScenePreviewPanel.this.compareSprite((Sprite)(this).DragableScenePreviewPanel.this.mRectangleSpritesMap.get(r1), (Sprite)(this).DragableScenePreviewPanel.this.mRectangleSpritesMap.get(r2));
                        }
                    });
                    DragableScenePreviewPanel.this.mFreeStylePanel.setCurrentObject(DragableScenePreviewPanel.this.mRectangleSpritesMap.get(select.get(0)));
                    DragableScenePreviewPanel.this.mSelection = new PointRectangle((Rectangle)select.get(0));
                } else {
                    DragableScenePreviewPanel.this.mFreeStylePanel.setCurrentObject(null);
                }
                DragableScenePreviewPanel.this.mFreeStylePanel.refreshAll();
                DragableScenePreviewPanel.this.setCursor(Cursor.getPredefinedCursor(13));
            }
            DragableScenePreviewPanel.this.repaint();
            this.mDragingFlag = false;
        }
    };
    public PointRectangle mSelection;
    private PointRectangle mStartSelection;
    public int mActiveHandle;
    public MouseAdapter mDragAdapter = new MouseAdapter(){
        private int x;
        private int y;

        @Override
        public void mouseReleased(MouseEvent e) {
            if (DragableScenePreviewPanel.this.mActiveHandle >= 0) {
                DragableScenePreviewPanel.this.wipeSelection();
                DragableScenePreviewPanel.this.mFreeStylePanel.initEditPanel();
                DragableScenePreviewPanel.this.mActiveHandle = -1;
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.x = e.getX();
            this.y = e.getY();
            DragableScenePreviewPanel.this.mStartSelection = DragableScenePreviewPanel.this.mSelection;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (DragableScenePreviewPanel.this.mSelection != null && DragableScenePreviewPanel.this.mSelection.contains(e.getX(), e.getY())) {
                DragableScenePreviewPanel.this.setCursor(Cursor.getPredefinedCursor(13));
                DragableScenePreviewPanel.this.mActiveHandle = 0;
                return;
            }
            DragableScenePreviewPanel.this.mActiveHandle = -1;
            DragableScenePreviewPanel.this.setCursor(Cursor.getPredefinedCursor(0));
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (DragableScenePreviewPanel.this.mActiveHandle >= 0) {
                if (DragableScenePreviewPanel.this.mSelection != null) {
                    DragableScenePreviewPanel.this.wipeSelection();
                    int xMove = e.getX() - this.x;
                    int yMove = e.getY() - this.y;
                    DragableScenePreviewPanel.this.mSelection = new PointRectangle(((DragableScenePreviewPanel)DragableScenePreviewPanel.this).mStartSelection.x1 + xMove, ((DragableScenePreviewPanel)DragableScenePreviewPanel.this).mStartSelection.y1 + yMove, ((DragableScenePreviewPanel)DragableScenePreviewPanel.this).mStartSelection.x2 + xMove, ((DragableScenePreviewPanel)DragableScenePreviewPanel.this).mStartSelection.y2 + yMove);
                    DragableScenePreviewPanel.this.refreshSprite(DragableScenePreviewPanel.this.mSelection);
                }
            } else {
                return;
            }
        }
    };

    @Override
    public void drawSelectionBySprite(Graphics2D g) {
        super.drawSelectionBySprite(g);
        Rectangle r = this.getSelectedRectangle();
        if (r != null) {
            this.mSelection = new PointRectangle(r);
        }
    }

    public DragableScenePreviewPanel() {
        this.addMouseListener(this.mSelectAdapter);
        this.addMouseMotionListener(this.mSelectAdapter);
        this.addMouseListener(this.mDragAdapter);
        this.addMouseMotionListener(this.mDragAdapter);
    }

    public int compareSprite(Sprite s1, Sprite s2) {
        int i = 0;
        while (i < FreeStylePanel.screenTypes.length) {
            Screen screen = this.mFreeStyle.getSpecifyScreen(FreeStylePanel.screenTypes[i]);
            for (Sprite s : screen.getSprites()) {
                if (s.equals(s1)) {
                    return 1;
                }
                if (!s.equals(s2)) continue;
                return -1;
            }
            ++i;
        }
        return 0;
    }

    protected void refreshSprite(PointRectangle selection) {
        Object currentObject = this.mFreeStylePanel.getCurrentObject();
        if (currentObject instanceof Sprite) {
            Sprite s = (Sprite)currentObject;
            s.mLeft = (int)Math.round((double)selection.x / this.sScale);
            s.mTop = (int)Math.round((double)selection.y / this.sScale);
        }
    }

    private void wipeSelection() {
        this.repaint();
    }
}

