/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.freestyle;

import android.content.ComponentName;
import com.miui.home.launcher.upsidescene.data.Appearance;
import com.miui.home.launcher.upsidescene.data.FreeStyle;
import com.miui.home.launcher.upsidescene.data.Function;
import com.miui.home.launcher.upsidescene.data.Screen;
import com.miui.home.launcher.upsidescene.data.Sprite;
import com.miui.theme.tool.apk.Activity;
import com.miui.theme.tool.apk.CacheActivityManager;
import com.miui.theme.tool.freestyle.FreeStylePanel;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.ThemeHelper;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import miui.util.FileAccessable;

public class ScenePreviewPanel
extends JPanel {
    FreeStyle mFreeStyle;
    FreeStylePanel mFreeStylePanel;
    public double sScale = 0.5;
    private int mScaledPreviewWidth;
    private int mScaledPreviewHeight;
    private Timer mTimer;
    private TimerTask mTimerTask;
    protected HashMap<Rectangle, Sprite> mRectangleSpritesMap;
    public static final Color mSelectionColor = Color.RED;
    private static HashMap<String, BufferedImage> imageCache = new HashMap();
    public static final String MTZ_PREVIEW_PATH = "preview" + File.separator + "0.png";
    private long mStart;

    public ScenePreviewPanel() {
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                ScenePreviewPanel.this.sScale = e.getWheelRotation() < 0 ? (ScenePreviewPanel.this.sScale += 0.1) : (ScenePreviewPanel.this.sScale -= 0.1);
                if (ScenePreviewPanel.this.sScale >= 1.0) {
                    ScenePreviewPanel.this.sScale = 1.0;
                }
                if (ScenePreviewPanel.this.sScale <= 0.2) {
                    ScenePreviewPanel.this.sScale = 0.2;
                }
                e.consume();
                ScenePreviewPanel.this.refresh();
            }
        });
        this.setToolTipText(ResourceFactory.getString("scroll_to_scale"));
    }

    public void setFreeStyle(FreeStyle freeStyle) {
        this.mFreeStyle = freeStyle;
        this.refresh();
    }

    public synchronized void refresh() {
        this.mScaledPreviewWidth = this.scale(this.mFreeStyle.getDriftScreen().getWidth());
        this.mScaledPreviewHeight = this.scale(this.mFreeStyle.mHeight);
        GUIUtil.fixSize(this, new Dimension(this.mScaledPreviewWidth, this.mScaledPreviewHeight));
        this.validate();
        this.updateUI();
        this.repaint();
    }

    public void prepareRefresh() {
        if (this.mTimer != null) {
            this.mTimer.cancel();
        }
        this.mTimer = new Timer();
        this.mTimerTask = new RefreshTimer();
        this.mTimer.scheduleAtFixedRate(this.mTimerTask, 500L, 99999999L);
        this.refresh();
    }

    public void drawSelectionBySprite(Graphics2D g) {
        Rectangle r = this.getSelectedRectangle();
        if (r != null) {
            this.drawSelection(r, g);
        }
    }

    public Rectangle getSelectedRectangle() {
        Object sprite = this.mFreeStylePanel.getCurrentObject();
        if (sprite instanceof Sprite) {
            for (Map.Entry<Rectangle, Sprite> set : this.mRectangleSpritesMap.entrySet()) {
                if (!set.getValue().equals(sprite)) continue;
                return set.getKey();
            }
        }
        return null;
    }

    protected void drawSelection(Rectangle selection, Graphics2D graphics) {
        if (graphics == null) {
            graphics = (Graphics2D)this.getGraphics().create();
        }
        graphics.setPaint(mSelectionColor);
        graphics.setStroke(new BasicStroke(1.0f, 0, 1, 1.0f, new float[]{5.0f}, 0.0f));
        graphics.draw(selection);
    }

    private int scale(int val) {
        return (int)((double)val * this.sScale);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintScene(g);
    }

    protected void paintScene(Graphics g) {
        this.mStart = System.currentTimeMillis();
        Graphics2D g2d = (Graphics2D)g;
        this.mRectangleSpritesMap = new HashMap();
        int i = 0;
        while (i < FreeStylePanel.screenTypes.length) {
            this.renderScreen(this.mFreeStyle.getSpecifyScreen(FreeStylePanel.screenTypes[i]), g2d);
            ++i;
        }
        this.drawSelectionBySprite(g2d);
    }

    private BufferedImage renderScreen(Screen s, Graphics2D g) {
        return this.renderScreen(s, g, 0);
    }

    private BufferedImage renderScreen(Screen s, Graphics2D g, int left) {
        BufferedImage screenImage = null;
        if (g == null) {
            screenImage = new BufferedImage(s.getWidth(), this.mFreeStyle.mHeight, 6);
            g = (Graphics2D)screenImage.getGraphics();
        }
        for (Sprite sprite : s.getSprites()) {
            BufferedImage spriteImage = ScenePreviewPanel.renderSprite(sprite);
            if (spriteImage == null) continue;
            int width = 100;
            int height = 100;
            if (spriteImage != null) {
                width = spriteImage.getWidth();
                height = spriteImage.getHeight();
            }
            if (1 == sprite.getAppearance().getType()) {
                width = sprite.mRawWidth == 0 ? spriteImage.getWidth() : sprite.mRawWidth;
                height = sprite.mRawHeight == 0 ? spriteImage.getHeight() : sprite.mRawHeight;
            }
            this.mRectangleSpritesMap.put(new Rectangle(this.scale(sprite.mLeft), this.scale(sprite.mTop), this.scale(width), this.scale(height)), sprite);
            g.drawImage(spriteImage, this.scale(sprite.mLeft), this.scale(sprite.mTop), this.scale(width), this.scale(height), null);
        }
        return screenImage;
    }

    public static void clearCachedImage() {
        imageCache = new HashMap();
    }

    private static BufferedImage getCachedImage(File f) {
        if (!imageCache.containsKey(f.getAbsolutePath())) {
            imageCache.put(f.getAbsolutePath(), GUIUtil.getImage(f));
        }
        return imageCache.get(f.getAbsolutePath());
    }

    public static BufferedImage renderSprite(Sprite sprite) {
        Appearance.FreeButtonAppearance fba;
        FileAccessable.DeskFile fa;
        BufferedImage bi = null;
        Appearance appearance = sprite.getAppearance();
        Function function = sprite.getFunction();
        String appearancePath = String.valueOf(FreeStylePanel.getFreeStylePath()) + File.separator + appearance.toString();
        if (1 == appearance.getType()) {
            File imageFile = new File(appearancePath);
            if (imageFile.exists()) {
                bi = ScenePreviewPanel.getCachedImage(imageFile);
            }
        } else if (2 == appearance.getType() && (fa = (FileAccessable.DeskFile)(fba = (Appearance.FreeButtonAppearance)appearance).getFreeButtonInfo().getPreviewImageFile()) != null) {
            bi = GUIUtil.getImage(fa.getFile());
        }
        if (bi != null) {
            return bi;
        }
        if (1 == function.getType()) {
            Activity ac;
            Function.AppFunction func = (Function.AppFunction)function;
            ComponentName componentName = func.getComponentName();
            BufferedImage img = null;
            String path = ThemeHelper.getIconByFileName(String.valueOf(componentName.getClassName()) + ".png");
            if (path != null) {
                img = GUIUtil.getImage(path);
            }
            if (img == null && !(ac = new Activity(componentName.getPackageName(), componentName.getClassName())).getName().startsWith(ac.getPkgName()) && (path = ThemeHelper.getIconByFileName(ac.getThemeIcon())) != null) {
                img = GUIUtil.getImage(path);
            }
            CacheActivityManager fam = CacheActivityManager.getInstance();
            if (img == null && (path = fam.getIconPathByComponentNameClassFirst(new com.miui.theme.tool.upsidescene.screen.ComponentName(componentName.getPackageName(), componentName.getClassName()))) != null) {
                img = GUIUtil.getImage(path);
            }
            if (img == null && (path = ThemeHelper.getIconByFileName(String.valueOf(componentName.getPackageName()) + ".png")) != null) {
                img = GUIUtil.getImage(path);
            }
            if (img == null && (path = fam.getIconPathByComponentName(new com.miui.theme.tool.upsidescene.screen.ComponentName(componentName.getPackageName(), componentName.getClassName()))) != null) {
                img = GUIUtil.getImage(path);
            }
            bi = img;
        } else if (6 == function.getType()) {
            Function.MtzGadgetFunction mgf = (Function.MtzGadgetFunction)function;
            String path = String.valueOf(FreeStylePanel.getFreeStylePath()) + File.separator + mgf.getMtzRelativePath() + File.separator + MTZ_PREVIEW_PATH;
            bi = GUIUtil.getImage(path);
        } else if (7 == function.getType()) {
            Function.ToggleFunction tf = (Function.ToggleFunction)function;
            String name = tf.getToggleShortcutName();
            try {
                bi = ImageIO.read(ResourceFactory.getInstance().getImageSream(String.valueOf(name) + ".png"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return bi;
    }

    public class RefreshTimer
    extends TimerTask {
        @Override
        public void run() {
            ScenePreviewPanel.this.refresh();
            this.cancel();
        }
    }
}

