/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.gui;

import com.miui.theme.tool.compress.MtzCompressor;
import com.miui.theme.tool.extract.Extractor;
import com.miui.theme.tool.gui.CompressAndApplySettingsDialog;
import com.miui.theme.tool.gui.NewThemeDialog;
import com.miui.theme.tool.gui.SelectThemeFolderDialog;
import com.miui.theme.tool.gui.ShortcutManager;
import com.miui.theme.tool.gui.StateBar;
import com.miui.theme.tool.gui.ThemeEditPanel;
import com.miui.theme.tool.gui.ThemeInitHelperDialog;
import com.miui.theme.tool.ninepatch.NinePatchUtils;
import com.miui.theme.tool.os.CmdUtils;
import com.miui.theme.tool.os.OS;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.resourceeditor.Screenshot;
import com.miui.theme.tool.update.CheckUpdateThread;
import com.miui.theme.tool.util.ConstantsHelper;
import com.miui.theme.tool.util.FileDrop;
import com.miui.theme.tool.util.FullResolutionMatchManager;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.GridBagHelper;
import com.miui.theme.tool.util.ThemeConf;
import com.miui.theme.tool.util.ThemeHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class MainFrame
extends JFrame
implements ActionListener,
Observer {
    public static boolean auto = false;
    static Logger logger = Logger.getLogger(MainFrame.class.getName());
    private int FRAME_WIDTH = 1024;
    private int FRAME_HEIGHT = 768;
    private final String FRM_TITLE = ResourceFactory.getString("tool_title");
    public BufferedImage mMainFrameIcon = ResourceFactory.getInstance().getImage("MIUIThemeEditorIcon.png");
    private JButton mChooseMtzOutFolderButton;
    protected JTextField mOutputCompressText;
    private JLabel mOutputCompressLabel;
    private JMenuBar mMenuBar;
    private JMenu mMenu;
    protected JMenu mMenuHelp;
    protected JMenu mMenuLang;
    protected JMenuItem mMenuLang_zh;
    protected JMenuItem mMenuLang_en;
    protected JMenuItem itemScreenCapture;
    protected JMenuItem itemInitHelper;
    protected JMenu mMenuGuide;
    private JMenuItem itemBBS;
    private JMenuItem itemDesigner;
    protected JMenuItem itemAbout;
    protected JMenuItem itemExit;
    protected JMenuItem itemNew;
    protected JMenuItem itemOpen;
    protected JMenu mMenuAdapter;
    private JMenuItem itemAdaptXhdpiToAll;
    private String mOutputMtz;
    private JButton mFullCompressButton;
    private JButton mReloadThemeButton;
    public JPanel mCompressChoicePanel;
    protected ThemeEditPanel mThemeEditPanel;
    public static PrintStream out = null;
    private Container mMainFrameContainer;
    private JLabel mStateLabel;
    MenuActionListener menuaction = new MenuActionListener();
    GridBagLayout gridbag;
    GridBagConstraints c;
    GridBagConstraints gc;
    private JButton mCheckUpdate;
    private JButton mLoadLastTheme;
    private JButton mOpenInExplorerButton;
    public FileDrop.Listener mFileDropListener = new FileDrop.Listener(){

        @Override
        public void filesDropped(File[] files) {
            MainFrame.this.onFileSelected(files[0]);
        }
    };
    private JButton mApplyButton;
    private JButton mFullApplyButton;
    private JButton mCompressSettingButton;
    public static final String STABLE_VERSION_PREFIX_ICS = "ICS";
    public static final String STABLE_VERSION_PREFIX_JLB = "JLB";
    private static volatile MainFrame single;
    private boolean isClosing = false;
    private JButton mSaveButton;

    static {
        ThemeHelper.readLastClosedInfo();
    }

    public ThemeEditPanel getThemeEditPanel() {
        return this.mThemeEditPanel;
    }

    public MainFrame() {
        try {
            if (OS.getOS() != 2) {
                String lookAndFeel = UIManager.getSystemLookAndFeelClassName();
                UIManager.setLookAndFeel(lookAndFeel);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        SwingUtilities.updateComponentTreeUI(this.getContentPane());
        this.enableEvents(64L);
        this.setIconImage(this.mMainFrameIcon);
        this.showMainFrame();
    }

    public void showMainFrame() {
        this.resetTitle();
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        String autoVal = ThemeConf.getConf("common", "auto");
        auto = autoVal.isEmpty() ? false : Boolean.parseBoolean(autoVal);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.FRAME_WIDTH = d.width * 2 / 3;
        this.FRAME_HEIGHT = d.height * 2 / 3;
        this.setBounds((d.width - this.FRAME_WIDTH) / 2, (d.height - this.FRAME_HEIGHT) / 2, this.FRAME_WIDTH, this.FRAME_HEIGHT);
        this.setPreferredSize(new Dimension(this.FRAME_WIDTH, this.FRAME_HEIGHT));
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
        this.setResizable(true);
        this.mMainFrameContainer = this.getContentPane();
        this.mMainFrameContainer.setPreferredSize(new Dimension(this.FRAME_WIDTH, this.FRAME_HEIGHT));
        this.initMenuBar();
        this.updateLanguageMenu(ThemeHelper.sLastClosedInfo.get("language"));
        this.gridbag = new GridBagLayout();
        this.c = new GridBagConstraints();
        this.gc = new GridBagConstraints();
        this.mMainFrameContainer.setLayout(this.gridbag);
        this.initFirstPage();
        this.initKeyListener();
        this.validate();
        if (ThemeHelper.sLastClosedInfo.containsKey("frameWidth") && ThemeHelper.sLastClosedInfo.containsKey("frameHeight") && ThemeHelper.sLastClosedInfo.containsKey("frameX") && ThemeHelper.sLastClosedInfo.containsKey("frameY")) {
            int width = Integer.parseInt(ThemeHelper.sLastClosedInfo.get("frameWidth"));
            int height = Integer.parseInt(ThemeHelper.sLastClosedInfo.get("frameHeight"));
            int x = Integer.parseInt(ThemeHelper.sLastClosedInfo.get("frameX"));
            int y = Integer.parseInt(ThemeHelper.sLastClosedInfo.get("frameY"));
            this.setBounds(x, y, width, height);
        }
        this.setVisible(true);
    }

    private void initKeyListener() {
        ShortcutManager sm = ShortcutManager.getInstance();
        sm.addShortcutListener(new ShortcutManager.ShortcutListener(){

            @Override
            public void handle() {
                ThemeHelper.setInnerUserMode();
                GUIUtil.alert("Hello MIUI :)");
                System.exit(0);
            }
        }, 17, 18, 69);
        sm.addShortcutListener(new ShortcutManager.ShortcutListener(){

            @Override
            public void handle() {
                if (!ThemeHelper.isInnerUserMode()) {
                    return;
                }
                if (ThemeHelper.isKeepRingtoneMode()) {
                    ThemeHelper.setKeepRingtoneMode(false);
                    GUIUtil.alert("Exit Keep Ringtone Mode!!");
                } else {
                    ThemeHelper.setKeepRingtoneMode(true);
                    GUIUtil.alert("Enter Keep Ringtone Mode!!");
                }
            }
        }, 17, 18, 82);
        sm.addShortcutListener(new ShortcutManager.ShortcutListener(){

            @Override
            public void handle() {
                MainFrame.this.mSaveButton.doClick();
            }
        }, 17, 83);
        sm.addShortcutListener(new ShortcutManager.ShortcutListener(){

            @Override
            public void handle() {
                MainFrame.this.mFullApplyButton.doClick();
            }
        }, 17, 10);
        sm.addShortcutListener(new ShortcutManager.ShortcutListener(){

            @Override
            public void handle() {
                MainFrame.this.screenCapture();
            }
        }, 17, 37);
    }

    private void openLastTheme() {
        String fileName;
        File f;
        if (ThemeHelper.sLastClosedInfo.containsKey("mtzPath") && ThemeHelper.sLastClosedInfo.containsKey("mtzName") && (f = new File(fileName = String.valueOf(ThemeHelper.sLastClosedInfo.get("mtzPath")) + File.separator + ThemeHelper.sLastClosedInfo.get("mtzName"))).exists()) {
            this.onFileSelected(f);
        }
    }

    public void initFirstPage() {
        this.initDrag(this.getContentPane());
        JPanel panel = new JPanel();
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.fill = 1;
        this.gridbag.setConstraints(panel, gc);
        this.mMainFrameContainer.add(panel);
        this.mMainFrameContainer.validate();
        JLabel dropHereLabel = new JLabel(ResourceFactory.getString("drop_here_label"));
        Font font2 = dropHereLabel.getFont();
        dropHereLabel.setFont(font2.deriveFont(1, 24.0f));
        dropHereLabel.setBackground(Color.GRAY);
        dropHereLabel.setOpaque(true);
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        GridBagHelper.addComponent(panel, dropHereLabel, 0, 1, 1, 1, 1, 0, 0.0, 0.0, 2, 10);
        this.mLoadLastTheme = new JButton(ResourceFactory.getString("load_last_theme"));
        this.mLoadLastTheme.setFont(font2.deriveFont(1, 24.0f));
        this.mLoadLastTheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.openLastTheme();
            }
        });
        String fileName = String.valueOf(ThemeHelper.sLastClosedInfo.get("mtzPath")) + File.separator + ThemeHelper.sLastClosedInfo.get("mtzName");
        File f = new File(fileName);
        if (f.exists() && f.isDirectory()) {
            this.mLoadLastTheme.setEnabled(true);
        } else {
            this.mLoadLastTheme.setEnabled(false);
        }
        GridBagHelper.addComponent(panel, this.mLoadLastTheme, 0, 2, 1, 1, 1, 0, 0.0, 0.0, 2, 10);
        this.mCheckUpdate = new JButton(ResourceFactory.getString("check_update"));
        this.mCheckUpdate.setFont(font2.deriveFont(1, 24.0f));
        this.mCheckUpdate.setVisible(false);
        new CheckUpdateThread(this.mCheckUpdate).start();
        GridBagHelper.addComponent(panel, this.mCheckUpdate, 0, 3, 1, 1, 1, 0, 0.0, 0.0, 2, 10);
        this.mMainFrameContainer.validate();
        this.runAdbOnce();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!auto) {
                    return;
                }
                MainFrame.this.mLoadLastTheme.doClick();
            }
        });
    }

    private void runAdbOnce() {
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                CmdUtils.adb_devices();
            }
        }.start();
    }

    public boolean checkOpenMtz(File f) {
        if (f.getName().endsWith("mtz")) {
            this.onFileSelected(f);
            return true;
        }
        return false;
    }

    private void initDrag(Component jc) {
        new FileDrop(out, jc, null, true, this.mFileDropListener);
    }

    public boolean checkAndSave(boolean check) {
        if (ThemeHelper.sThemeFolderPath.trim().equals("")) {
            return true;
        }
        int checkResult = check ? JOptionPane.showConfirmDialog(this, ResourceFactory.getString("global_saved_question")) : 0;
        if (2 == checkResult) {
            StateBar.getInstance().setText(ResourceFactory.getString("global_saved_cancel"));
            return false;
        }
        if (checkResult == 0) {
            if (this.mThemeEditPanel.saveAllData()) {
                StateBar.getInstance().setText(ResourceFactory.getString("global_saved"));
                return true;
            }
            StateBar.getInstance().setText(ResourceFactory.getString("global_saved_failed"));
            return false;
        }
        if (1 == checkResult) {
            StateBar.getInstance().setText(ResourceFactory.getString("global_saved_no"));
            return true;
        }
        return true;
    }

    public void onFileSelected(File f) {
        if (!this.checkAndSave(true)) {
            return;
        }
        this.openFile(f);
    }

    private void openFile(File f) {
        String srcFolder = null;
        ThemeHelper.sVcSelected = null;
        if (f.isDirectory()) {
            ThemeHelper.saveMtzInfo(f);
            if (ThemeHelper.sIsEditMtz) {
                OS.rmDir(ThemeHelper.sThemeFolderPath);
                ThemeHelper.sIsEditMtz = false;
            }
            ThemeHelper.sThemeFolderPath = srcFolder = f.getAbsolutePath().trim();
            ThemeHelper.sThemeName = f.getName();
            this.getContentPane().removeAll();
            this.initEditThemePanel();
            this.initCompressChoicePanel();
            this.changeTitle("");
            this.validate();
        } else if (f.isFile()) {
            if (ThemeHelper.sIsEditMtz) {
                OS.rmDir(ThemeHelper.sThemeFolderPath);
                ThemeHelper.sIsEditMtz = false;
            }
            if (!f.getAbsolutePath().toLowerCase().endsWith(".mtz")) {
                JOptionPane.showMessageDialog(this, ResourceFactory.getString("open_theme_format_error"));
                return;
            }
            SelectThemeFolderDialog dialog = new SelectThemeFolderDialog(this, f.getParent(), f.getName());
            dialog.addObserver(this);
            dialog.openDialog();
        }
    }

    private void initMenuBar() {
        this.mMenuBar = new JMenuBar();
        this.mMenu = new JMenu(ResourceFactory.getString("menu_file"));
        this.itemNew = new JMenuItem(ResourceFactory.getString("menu_file_newtheme"));
        this.itemNew.addActionListener(this.menuaction);
        this.mMenu.add(this.itemNew);
        this.itemOpen = new JMenuItem(ResourceFactory.getString("menu_file_opentheme"));
        this.itemOpen.addActionListener(this.menuaction);
        this.mMenu.add(this.itemOpen);
        this.itemExit = new JMenuItem(ResourceFactory.getString("menu_file_exit"));
        this.itemExit.addActionListener(this.menuaction);
        this.mMenu.add(this.itemExit);
        this.mMenuBar.add(this.mMenu);
        this.mMenuHelp = new JMenu(ResourceFactory.getString("menu_help"));
        this.mMenuBar.add(this.mMenuHelp);
        this.itemScreenCapture = new JMenuItem(ResourceFactory.getString("menu_help_screencapture"));
        this.itemScreenCapture.addActionListener(this.menuaction);
        this.itemInitHelper = new JMenuItem(ResourceFactory.getString("menu_help_inithelper"));
        this.itemInitHelper.addActionListener(this.menuaction);
        this.itemAbout = new JMenuItem(ResourceFactory.getString("menu_help_about"));
        this.itemAbout.addActionListener(this.menuaction);
        this.mMenuGuide = new JMenu(ResourceFactory.getString("menu_help_guide"));
        this.itemBBS = new JMenuItem(ResourceFactory.getString("menu_help_themeguide"));
        this.itemBBS.addActionListener(this.menuaction);
        this.mMenuGuide.add(this.itemBBS);
        this.itemDesigner = new JMenuItem(ResourceFactory.getString("menu_help_themedesigner"));
        this.itemDesigner.addActionListener(this.menuaction);
        this.mMenuGuide.add(this.itemDesigner);
        this.mMenuHelp.add(this.itemScreenCapture);
        this.mMenuHelp.add(this.itemInitHelper);
        this.mMenuHelp.add(this.itemAbout);
        this.mMenuHelp.add(this.mMenuGuide);
        this.mMenuLang = new JMenu(ResourceFactory.getString("language"), true);
        this.mMenuLang_zh = new JMenuItem("\u4e2d\u6587");
        this.mMenuLang_zh.setName("zh_CN");
        this.mMenuLang_zh.addActionListener(this.menuaction);
        this.mMenuLang_en = new JMenuItem("English");
        this.mMenuLang_en.setName("en_US");
        this.mMenuLang_en.addActionListener(this.menuaction);
        this.mMenuLang.add(this.mMenuLang_zh);
        this.mMenuLang.add(this.mMenuLang_en);
        this.mMenuHelp.add(this.mMenuLang);
        this.mMenuAdapter = new JMenu(ResourceFactory.getString("menu_adapter"));
        this.mMenuBar.add(this.mMenuAdapter);
        this.itemAdaptXhdpiToAll = new JMenuItem(ResourceFactory.getString("menu_adapter_xhdpi_to_all"));
        this.itemAdaptXhdpiToAll.addActionListener(this.menuaction);
        this.mMenuAdapter.add(this.itemAdaptXhdpiToAll);
        this.setJMenuBar(this.mMenuBar);
    }

    public void initEditThemePanel() {
        this.mThemeEditPanel = new ThemeEditPanel();
        this.mThemeEditPanel.addObserver(this);
        this.gc.gridx = 0;
        this.gc.gridy = 0;
        this.gc.weightx = 1.0;
        this.gc.weighty = 0.9;
        this.gc.fill = 1;
        this.gridbag.setConstraints(this.mThemeEditPanel.getPanel(), this.gc);
        this.mMainFrameContainer.add(this.mThemeEditPanel.getPanel());
        this.mMainFrameContainer.validate();
    }

    public void initCompressChoicePanel() {
        this.mCompressChoicePanel = new JPanel();
        this.mCompressChoicePanel.setBorder(new TitledBorder(null, ResourceFactory.getString("compress_choice_title"), 4, 2, null, null));
        GridBagLayout compressChoice_panel_gridbag = new GridBagLayout();
        this.mCompressChoicePanel.setLayout(compressChoice_panel_gridbag);
        this.mOutputCompressLabel = new JLabel(ResourceFactory.getString("compress_choice_output_mtz"));
        this.mOutputCompressText = new JTextField(String.valueOf(ThemeHelper.sThemeFolderPath) + ".mtz");
        this.mChooseMtzOutFolderButton = new JButton(ResourceFactory.getString("global_scan"));
        this.mChooseMtzOutFolderButton.addActionListener(this);
        this.mSaveButton = new JButton(ResourceFactory.getString("compress_choice_save"));
        this.mSaveButton.addActionListener(this);
        this.mFullCompressButton = new JButton(ResourceFactory.getString("compress_full_compress"));
        this.mFullCompressButton.addActionListener(this);
        this.mReloadThemeButton = new JButton(ResourceFactory.getString("compress_choice_reload"));
        this.mReloadThemeButton.addActionListener(this);
        this.mStateLabel = new JLabel();
        StateBar.getInstance().set(this.mStateLabel);
        this.mStateLabel.setForeground(Color.red);
        this.mOpenInExplorerButton = new JButton(ResourceFactory.getString("item_openinexplorer"));
        this.mOpenInExplorerButton.addActionListener(this);
        this.mApplyButton = new JButton(ResourceFactory.getString("item_apply"));
        this.mApplyButton.addActionListener(this);
        this.mFullApplyButton = new JButton(ResourceFactory.getString("item_full_apply"));
        this.mFullApplyButton.addActionListener(this);
        this.mCompressSettingButton = new JButton(ResourceFactory.getString("item_setting"));
        this.mCompressSettingButton.addActionListener(this);
        int x = 0;
        int y = 0;
        x = 0;
        y = 2;
        GridBagHelper.addComponent(this.mCompressChoicePanel, this.mSaveButton, x, y, 1, 1, 0, 0, 5, 5, 0.0, 0.0, 1, 17);
        GridBagHelper.addComponent(this.mCompressChoicePanel, this.mFullCompressButton, ++x, y, 1, 1, 0, 0, 5, 5, 0.0, 0.0, 1, 17);
        GridBagHelper.addComponent(this.mCompressChoicePanel, this.mApplyButton, ++x, y, 1, 1, 0, 0, 5, 5, 0.0, 0.0, 1, 17);
        GridBagHelper.addComponent(this.mCompressChoicePanel, this.mFullApplyButton, ++x, y, 1, 1, 0, 0, 5, 5, 0.0, 0.0, 1, 17);
        GridBagHelper.addComponent(this.mCompressChoicePanel, this.mReloadThemeButton, ++x, y, 1, 1, 0, 0, 5, 5, 0.0, 0.0, 1, 17);
        GridBagHelper.addComponent(this.mCompressChoicePanel, this.mOpenInExplorerButton, ++x, y, 1, 1, 0, 0, 5, 5, 0.0, 0.0, 1, 17);
        GridBagHelper.addComponent(this.mCompressChoicePanel, this.mCompressSettingButton, ++x, y, 1, 1, 0, 0, 5, 5, 0.0, 0.0, 1, 17);
        GridBagHelper.addComponent(this.mCompressChoicePanel, this.mStateLabel, ++x, y, 1, 1, 0, 0, 5, 5, 0.0, 0.0, 1, 17);
        int len = ++x;
        x = 0;
        y = 1;
        GridBagHelper.addComponent(this.mCompressChoicePanel, this.mOutputCompressLabel, x, y, 1, 1, 0, 0, 5, 5, 0.0, 0.0, 1, 17);
        GridBagHelper.addComponent(this.mCompressChoicePanel, this.mOutputCompressText, ++x, y, len, 1, 0, 0, 5, 5, 1.0, 0.0, 1, 17);
        GridBagHelper.addComponent(this.mCompressChoicePanel, this.mChooseMtzOutFolderButton, x += len, y, 1, 1, 0, 0, 5, 5, 0.0, 0.0, 1, 17);
        this.gc.gridx = 0;
        this.gc.gridy = 1;
        this.gc.weightx = 1.0;
        this.gc.weighty = 0.0;
        this.gridbag.setConstraints(this.mCompressChoicePanel, this.gc);
        this.mMainFrameContainer.add(this.mCompressChoicePanel);
        this.mMainFrameContainer.validate();
    }

    public boolean checkExistChosenItems() {
        String[] stringArray = new File(ThemeHelper.sThemeFolderPath).list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            if (!fileName.equals("description.xml") && !fileName.equals("preview")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.mChooseMtzOutFolderButton) {
            JFileChooser jfc = new JFileChooser();
            jfc.setBounds(20, 20, 300, 300);
            jfc.setVisible(true);
            jfc.setDialogTitle(ResourceFactory.getString("choose_theme_out_folder"));
            jfc.setCurrentDirectory(new File(ThemeHelper.sLastClosedInfo.get("mtzPath")));
            jfc.setFileSelectionMode(1);
            jfc.addActionListener(this);
            int state = jfc.showOpenDialog(null);
            if (state == 0) {
                File f = jfc.getSelectedFile();
                this.mOutputMtz = f.getAbsolutePath().trim();
                this.mOutputCompressText.setText(String.valueOf(this.mOutputMtz) + File.separator + ThemeHelper.sThemeName + ".mtz");
                if (f.getParent() != null) {
                    ThemeHelper.sLastClosedInfo.put("mtzPath", f.getParent());
                }
            }
        } else if (e.getSource() == this.mFullCompressButton) {
            new Thread(){

                @Override
                public void run() {
                    MainFrame.this.compressMtz(true);
                }
            }.start();
        } else if (e.getSource() == this.mApplyButton) {
            new Thread(){

                @Override
                public void run() {
                    MainFrame.this.applyTheme(false);
                }
            }.start();
        } else if (e.getSource() == this.mFullApplyButton) {
            new Thread(){

                @Override
                public void run() {
                    MainFrame.this.applyTheme(true);
                }
            }.start();
        } else if (e.getSource() == this.mCompressSettingButton) {
            new CompressAndApplySettingsDialog();
        } else if (e.getSource() == this.mReloadThemeButton) {
            this.reloadEditor();
        } else if (e.getSource() == this.mOutputCompressText) {
            this.mOutputMtz = this.mOutputCompressText.getText().trim();
        } else if (e.getSource() == this.mOpenInExplorerButton) {
            File folderToOpen = new File(ThemeHelper.sThemeFolderPath);
            ThemeHelper.openInExplorer(folderToOpen);
        } else if (e.getSource() == this.mSaveButton) {
            StateBar.getInstance().setText("");
            if (this.mThemeEditPanel != null) {
                if (this.mThemeEditPanel.saveAllData()) {
                    StateBar.getInstance().setText(ResourceFactory.getString("global_saved"));
                } else {
                    StateBar.getInstance().setText(ResourceFactory.getString("global_saved_failed"));
                }
            }
        }
    }

    public void reloadEditor() {
        this.mMainFrameContainer.removeAll();
        this.initEditThemePanel();
        this.initCompressChoicePanel();
        this.changeTitle("");
        this.validate();
    }

    private void screenCapture() {
        Calendar c = Calendar.getInstance();
        SimpleDateFormat f = new SimpleDateFormat("yyyy_MM_dd_hh_mm_ss");
        String screenshotDir = ThemeHelper.getTmpFolder() + File.separator + "screenshot";
        File screenshotDirFile = new File(screenshotDir);
        if (!screenshotDirFile.exists()) {
            screenshotDirFile.mkdirs();
        }
        String screenshotPath = String.valueOf(screenshotDir) + File.separator + f.format(c.getTime()) + ".png";
        try {
            Screenshot.captureScreen(screenshotPath);
            StateBar.getInstance().setText(screenshotPath);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void applyTheme(boolean fullApply) {
        int romVersion = ThemeHelper.getRomUIVersion();
        if (romVersion > 0 && romVersion != ThemeHelper.sThemeVersion) {
            Object[] options = new Object[]{ResourceFactory.getString("global_yes"), ResourceFactory.getString("global_no")};
            int response = JOptionPane.showOptionDialog(null, ResourceFactory.getString("compress_themeversion_phoneversion_inconsistent_tip"), ResourceFactory.getString("compress_themeversion_phoneversion_inconsistent"), 0, 1, null, options, options[0]);
            if (response == 1) {
                return;
            }
        }
        if (!this.compressMtz(fullApply)) {
            return;
        }
        long startTime = System.currentTimeMillis();
        boolean isStable = true;
        String iVersion = ThemeHelper.getRomIncrementalVersion();
        if (!iVersion.startsWith(STABLE_VERSION_PREFIX_JLB) && !iVersion.startsWith(STABLE_VERSION_PREFIX_ICS)) {
            isStable = false;
        }
        if (isStable && !ThemeHelper.isInnerUserMode()) {
            GUIUtil.alert(ResourceFactory.getString("please_update_phone"));
        } else {
            this.pushToPhone(this.mOutputMtz, fullApply);
            long totalSpend = System.currentTimeMillis() - startTime;
            System.out.println("push time:" + totalSpend);
        }
        if (!fullApply) {
            new File(this.mOutputMtz).delete();
        }
    }

    private boolean compressMtz(boolean fullCompress) {
        this.mApplyButton.setEnabled(false);
        this.mFullApplyButton.setEnabled(false);
        this.mFullCompressButton.setEnabled(false);
        if (!this.checkAndSave(false)) {
            return false;
        }
        this.mOutputMtz = this.mOutputCompressText.getText().trim();
        if (!this.checkTextOutputCompress()) {
            JOptionPane.showMessageDialog(this, ResourceFactory.getString("compress_out_need_mtz_tip"));
        }
        StateBar.getInstance().setText(ResourceFactory.getString("compressing"));
        boolean flag = this.startCompress(ThemeHelper.sThemeFolderPath, this.mOutputMtz, fullCompress);
        this.mApplyButton.setEnabled(true);
        this.mFullApplyButton.setEnabled(true);
        this.mFullCompressButton.setEnabled(true);
        return flag;
    }

    private void extractTheme(String srcFile, String desFile) {
        if (srcFile == null || srcFile.trim().isEmpty() || !new File(srcFile).exists() || new File(srcFile).isDirectory()) {
            JOptionPane.showMessageDialog(this, ResourceFactory.getString("extract_no_theme_tip"));
        } else {
            boolean result = true;
            try {
                ThemeHelper.sExtractMtzCompleted = false;
                long s1 = System.currentTimeMillis();
                new Extractor(srcFile, desFile).unzipTheme();
                long s2 = System.currentTimeMillis();
                logger.debug("Extract time cost: " + (s2 - s1));
                NinePatchUtils.decompile(desFile);
                long s3 = System.currentTimeMillis();
                logger.debug("Decode Time Cost: " + (s3 - s2));
            }
            catch (Exception e) {
                result = false;
                e.printStackTrace();
            }
            if (result) {
                logger.debug("Completed");
                ThemeHelper.sExtractMtzCompleted = true;
            } else {
                logger.error("Error happend");
            }
        }
    }

    private boolean startCompress(String src, String outputMtz, boolean fullCompress) {
        boolean completed;
        block11: {
            this.setCursor(Cursor.getPredefinedCursor(3));
            boolean result = true;
            completed = false;
            try {
                try {
                    MtzCompressor mcu = new MtzCompressor();
                    mcu.setSrcPath(src);
                    mcu.setDestPath(outputMtz);
                    mcu.setCompressFont(CompressAndApplySettingsDialog.sCompressFontCheckBox.isSelected());
                    mcu.setFullCompress(fullCompress);
                    mcu.generate();
                    completed = true;
                }
                catch (Exception e) {
                    result = false;
                    e.printStackTrace();
                    this.setCursor(new Cursor(0));
                    if (result) {
                        StateBar.getInstance().setText(ResourceFactory.getString("compress_success"));
                    } else {
                        StateBar.getInstance().setText(ResourceFactory.getString("compress_faild"));
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                this.setCursor(new Cursor(0));
                if (result) {
                    StateBar.getInstance().setText(ResourceFactory.getString("compress_success"));
                } else {
                    StateBar.getInstance().setText(ResourceFactory.getString("compress_faild"));
                }
                throw throwable;
            }
            this.setCursor(new Cursor(0));
            if (result) {
                StateBar.getInstance().setText(ResourceFactory.getString("compress_success"));
            } else {
                StateBar.getInstance().setText(ResourceFactory.getString("compress_faild"));
            }
        }
        return completed;
    }

    private boolean pushToPhoneSpecial(String outputMtz) {
        String tmpPath = ThemeHelper.getTmpFolder() + File.separator + "themetmp";
        File tmpFile = new File(tmpPath);
        if (tmpFile.exists()) {
            OS.rmDir(tmpPath);
        }
        tmpFile.mkdirs();
        ThemeHelper.unzip(new File(outputMtz), tmpFile);
        boolean flag = CmdUtils.adb_shell_applyThemeSpecial(tmpPath);
        OS.rmDir(tmpPath);
        return flag;
    }

    private boolean pushToPhone(String outputMtz, boolean fullApply) {
        if (new File(outputMtz).exists() && new File(outputMtz).isFile()) {
            StateBar.getInstance().setText(ResourceFactory.getString("pushing_to_phone"));
            boolean flag = CmdUtils.adb_push_MIUIThemeToolGenerated(new File(outputMtz).getAbsolutePath());
            if (!flag) {
                StateBar.getInstance().setText(ResourceFactory.getString("push_to_phone_fail"));
                return false;
            }
            StateBar.getInstance().setText(ResourceFactory.getString("push_to_phone_success"));
            long applyFlag = 0L;
            Map<String, String> identityCodeMap = ConstantsHelper.getComponentIdentityCodeMap();
            try {
                ZipFile zipFile = new ZipFile(outputMtz);
                Enumeration entries = zipFile.getEntries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = (ZipEntry)entries.nextElement();
                    if (entry.isDirectory()) continue;
                    if (identityCodeMap.containsKey(entry.getName())) {
                        applyFlag |= ConstantsHelper.getComponentType(identityCodeMap.get(entry.getName()));
                        continue;
                    }
                    if (entry.getName().equals("icons")) {
                        applyFlag |= ConstantsHelper.getComponentType("icons");
                        continue;
                    }
                    applyFlag |= 0x10000000L;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!CompressAndApplySettingsDialog.sCompressFontCheckBox.isSelected()) {
                applyFlag &= 0xFFFFFFFFFFFFFFEFL;
            }
            if (fullApply) {
                if (ThemeHelper.isKeepRingtoneMode()) {
                    applyFlag = 0xFFFFFFFFFFFFFEFFL | applyFlag & 0x100L;
                    flag = CmdUtils.adb_shell_applyTheme(false, applyFlag);
                } else {
                    flag = CmdUtils.adb_shell_applyTheme(true, 0L);
                }
            } else {
                flag = CmdUtils.adb_shell_applyTheme(false, applyFlag);
            }
            if (!flag) {
                StateBar.getInstance().setText(ResourceFactory.getString("phone_open_debug_tip"));
            }
            return true;
        }
        StateBar.getInstance().setText(String.valueOf(new File(outputMtz).getAbsolutePath()) + ResourceFactory.getString("not_found"));
        return false;
    }

    public boolean checkTextOutputCompress() {
        String s = this.mOutputCompressText.getText().trim();
        if (s != null && !s.equals("")) {
            if (!s.toLowerCase().endsWith(".mtz")) {
                return false;
            }
            File f = new File(s);
            String strParent = f.getParent();
            File fparent = new File(strParent);
            if (fparent != null && fparent.exists() && fparent.isDirectory()) {
                return true;
            }
            fparent.mkdirs();
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        MainFrame.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MainFrame getInstance() {
        if (single != null) return single;
        Class<MainFrame> clazz = MainFrame.class;
        synchronized (MainFrame.class) {
            if (single != null) return single;
            single = new MainFrame();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    @Override
    public void update(Observable observable, Object obj) {
        if (observable instanceof NewThemeDialog) {
            this.reloadEditor();
        } else if (observable instanceof SelectThemeFolderDialog) {
            if (obj instanceof File) {
                this.openFile((File)obj);
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.extractTheme(obj.toString(), ThemeHelper.sThemeFolderPath);
            this.setCursor(Cursor.getDefaultCursor());
            this.reloadEditor();
        } else if (observable instanceof ThemeEditPanel) {
            this.changeTitle(obj.toString());
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent pEvent) {
        if (pEvent.getID() == 201) {
            if (this.isClosing) {
                return;
            }
            this.isClosing = true;
            this.savingOnExit();
        }
        super.processWindowEvent(pEvent);
    }

    public void savingOnExit() {
        Rectangle bounds = this.getBounds();
        ThemeHelper.sLastClosedInfo.put("frameWidth", String.valueOf(bounds.width));
        ThemeHelper.sLastClosedInfo.put("frameHeight", String.valueOf(bounds.height));
        ThemeHelper.sLastClosedInfo.put("frameX", String.valueOf(bounds.x));
        ThemeHelper.sLastClosedInfo.put("frameY", String.valueOf(bounds.y));
        ThemeHelper.writeLastClosedInfo();
        if (ThemeHelper.sIsEditMtz) {
            OS.rmDir(ThemeHelper.sThemeFolderPath);
            ThemeHelper.sIsEditMtz = false;
        }
        this.dispose();
    }

    public void resetTitle() {
        this.setTitle(this.FRM_TITLE);
    }

    public void changeTitle(String subTitle) {
        if (ThemeHelper.sIsEditMtz) {
            this.setTitle(String.valueOf(this.FRM_TITLE) + "(" + ThemeHelper.sThemeFilePath.substring(0, ThemeHelper.sThemeFilePath.length() - 4) + File.separator + subTitle + ")");
        } else {
            this.setTitle(String.valueOf(this.FRM_TITLE) + "(" + ThemeHelper.sThemeFolderPath + File.separator + subTitle + ")");
        }
    }

    protected void updateLanguageMenu(String s) {
        int i = 0;
        while (i < this.mMenuLang.getItemCount()) {
            JMenuItem item = this.mMenuLang.getItem(i);
            String label = item.getLabel();
            if (label.startsWith("* ")) {
                label = label.substring(2);
            }
            if (s.equals(item.getName())) {
                label = "* " + label;
            }
            item.setLabel(label);
            ++i;
        }
    }

    protected boolean isLanguageSwitched(String s) {
        int i = 0;
        while (i < this.mMenuLang.getItemCount()) {
            JMenuItem item = this.mMenuLang.getItem(i);
            String label = item.getLabel();
            if (label.startsWith("* ") && item.getName().equals(s)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    class MenuActionListener
    implements ActionListener {
        private MainFrame mFrame;

        public MenuActionListener() {
            this.mFrame = MainFrame.this;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.mFrame.itemAbout) {
                JOptionPane.showMessageDialog(this.mFrame, "MIUIThemeEditor " + ThemeHelper.getVersion());
            } else if (e.getSource() == this.mFrame.itemScreenCapture) {
                MainFrame.this.screenCapture();
            } else if (e.getSource() == this.mFrame.itemInitHelper) {
                if (ThemeHelper.getS_themeFolderPath().isEmpty()) {
                    GUIUtil.alert(ResourceFactory.getString("open_theme_first"));
                } else {
                    new ThemeInitHelperDialog();
                }
            } else if (e.getSource() == this.mFrame.itemBBS) {
                ThemeHelper.browse(ResourceFactory.getString("menu_help_themeguide_url"));
            } else if (e.getSource() == this.mFrame.itemDesigner) {
                ThemeHelper.browse(ResourceFactory.getString("menu_help_themedesigner_url"));
            } else if (e.getSource() == this.mFrame.itemExit) {
                if (ThemeHelper.sIsEditMtz) {
                    OS.rmDir(ThemeHelper.sThemeFolderPath);
                    ThemeHelper.sIsEditMtz = false;
                }
                this.mFrame.savingOnExit();
            } else if (e.getSource() == this.mFrame.itemNew) {
                if (ThemeHelper.sIsEditMtz) {
                    OS.rmDir(ThemeHelper.sThemeFolderPath);
                    ThemeHelper.sIsEditMtz = false;
                }
                NewThemeDialog newThemeDialog = new NewThemeDialog(this.mFrame);
                newThemeDialog.addObserver(this.mFrame);
                newThemeDialog.openDialog();
                ThemeHelper.sVcSelected = null;
            } else if (e.getSource() == this.mFrame.itemOpen) {
                JFileChooser jfc = new JFileChooser();
                jfc.setBounds(20, 20, 300, 300);
                jfc.setVisible(true);
                jfc.setDialogTitle(ResourceFactory.getString("edit_theme_choose_theme_title"));
                jfc.setCurrentDirectory(new File(ThemeHelper.sLastClosedInfo.get("mtzPath")));
                jfc.setFileSelectionMode(2);
                jfc.addChoosableFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isFile() && file.getName().toLowerCase().endsWith(".mtz") || file.isDirectory();
                    }

                    @Override
                    public String getDescription() {
                        return "mtz theme file";
                    }
                });
                jfc.addActionListener(this);
                int state = jfc.showOpenDialog(null);
                if (state == 0) {
                    try {
                        this.mFrame.onFileSelected(jfc.getSelectedFile());
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            } else if (e.getSource() == this.mFrame.mMenuLang_zh) {
                this.languageSwitched("zh", "CN");
            } else if (e.getSource() == this.mFrame.mMenuLang_en) {
                this.languageSwitched("en", "US");
            } else if (e.getSource() == this.mFrame.itemAdaptXhdpiToAll) {
                Vector<File> resultHdpi = FullResolutionMatchManager.adaptAllXhdpi(ThemeHelper.sThemeFolderPath, "drawable-hdpi");
                Vector<File> resultXxhdpi = FullResolutionMatchManager.adaptAllXhdpi(ThemeHelper.sThemeFolderPath, "drawable-xxhdpi");
                HashSet<File> adapted = new HashSet<File>();
                FullResolutionMatchManager.adaptAllPressed(new File(ThemeHelper.sThemeFolderPath), adapted);
                for (File f : resultXxhdpi) {
                    resultHdpi.add(f);
                }
                resultHdpi.addAll(adapted);
                FullResolutionMatchManager.showAdaptResult(resultHdpi);
            }
        }

        private void languageSwitched(String lang, String country) {
            if (this.mFrame.isLanguageSwitched(String.valueOf(lang) + "_" + country)) {
                ThemeHelper.sLastClosedInfo.put("language", String.valueOf(lang) + "_" + country);
                Object[] options = new Object[]{ResourceFactory.getString("global_yes"), ResourceFactory.getString("global_no")};
                int response = JOptionPane.showOptionDialog(this.mFrame, ResourceFactory.getString("language_switch"), ResourceFactory.getString("global_confirm_dlg_title"), 0, 1, null, options, options[1]);
                if (response == 0) {
                    this.mFrame.savingOnExit();
                    String shellFileName = String.valueOf(System.getProperty("user.dir")) + File.separator;
                    if (OS.getOS() == 3) {
                        shellFileName = String.valueOf(shellFileName) + "run-mac.command";
                    } else if (OS.getOS() == 1) {
                        shellFileName = String.valueOf(shellFileName) + "run-windows.bat";
                    } else if (OS.getOS() == 2) {
                        shellFileName = String.valueOf(shellFileName) + "run-linux.sh";
                    }
                    CmdUtils.runShell(shellFileName, null);
                }
            }
        }
    }
}

