/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.gui;

import com.miui.theme.tool.gui.MainFrame;
import com.miui.theme.tool.gui.StateBar;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.resourceeditor.ImagePreview;
import com.miui.theme.tool.util.FileDrop;
import com.miui.theme.tool.util.FullResolutionMatchManager;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.GridBagHelper;
import com.miui.theme.tool.util.ThemeHelper;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ResourceReplacePanel
extends JPanel {
    private static File mLastDir;
    private String mName;
    private File mCatalogFile;
    private File mReplaceFile;
    private ReplaceActionListener mReplaceActionListener;
    private static BufferedImage unreplaceImage;
    public static ArrayList<String> sResourceSuffixList;
    AdaptXhdpi2Hdpi ax2all = new AdaptXhdpi2Hdpi();
    EditNinePatchActionListener enpal = new EditNinePatchActionListener();
    DeleteFileActionListener dfal = new DeleteFileActionListener();

    static {
        unreplaceImage = null;
        sResourceSuffixList = new ArrayList();
        sResourceSuffixList.add(".png");
        sResourceSuffixList.add(".jpg");
    }

    public ResourceReplacePanel(String name, File catalogFile, File replaceFile, ReplaceActionListener replaceActionListener) {
        this.mName = name;
        this.mCatalogFile = catalogFile;
        this.mReplaceFile = replaceFile;
        this.mReplaceActionListener = replaceActionListener;
        this.initPanel();
    }

    private void initPanel() {
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        JLabel pathLabel = new JLabel(this.mName);
        ImageIcon catalogResourceIcon = GUIUtil.getIcon(this.mCatalogFile);
        JLabel catalogIconLabel = new JLabel(catalogResourceIcon, 0);
        catalogIconLabel.setOpaque(false);
        catalogIconLabel.setToolTipText(this.mCatalogFile.getName());
        catalogIconLabel.setHorizontalAlignment(2);
        catalogIconLabel.addMouseListener(new CatalogIconMouseAdapter(this.mCatalogFile));
        int xWidth = 4;
        int level = 1;
        int gap = 25;
        int x = 0;
        GridBagHelper.addComponent(this, pathLabel, x, level++, xWidth, 1, 0, 0, new Insets(0, gap, 0, 0), 0.0, 0.0, 0, 17);
        x = 0;
        GridBagHelper.addComponent(this, catalogIconLabel, x, level, 1, 1, 0, 0, new Insets(0, gap, 0, 0), 0.0, 0.0, 0, 13);
        ImageIcon replaceResourceIcon = this.mReplaceFile.exists() ? GUIUtil.getIcon(this.mReplaceFile) : ResourceReplacePanel.getUnreplaceIcon();
        JButton copyResourceButton = new JButton(ResourceFactory.getString("copy_to_right"));
        copyResourceButton.addActionListener(new CopyResourceActionListener(this.mCatalogFile.getAbsolutePath(), this.mReplaceFile.getAbsolutePath()));
        GridBagHelper.addComponent(this, copyResourceButton, ++x, level, 1, 1, 0, 0, 0, 0, 0.0, 0.0, 0, 17);
        JLabel replacedIconLabel = new JLabel(replaceResourceIcon);
        replacedIconLabel.setPreferredSize(new Dimension(GUIUtil.HDPI_SIZE, GUIUtil.HDPI_SIZE));
        replacedIconLabel.setOpaque(false);
        replacedIconLabel.setToolTipText(this.mReplaceFile.getAbsolutePath());
        replacedIconLabel.setHorizontalAlignment(2);
        replacedIconLabel.setCursor(Cursor.getPredefinedCursor(12));
        replacedIconLabel.addMouseListener(new ReplaceIconMouseAdapter(this.mReplaceFile));
        new FileDrop(MainFrame.out, (Component)replacedIconLabel, replacedIconLabel.getBorder(), (FileDrop.Listener)new FileDropListener(this.mReplaceFile));
        GridBagHelper.addComponent(this, replacedIconLabel, ++x, level++, 1, 1, 0, 0, new Insets(0, 0, 0, 0), 1.0, 0.0, 0, 17);
        GridBagHelper.addComponent(this, new JLabel(), 0, level++, xWidth, 1, 0, 0, gap, 0, 0.0, 0.0, 0, 17);
        JPanel editPanel = this.getEditPanel(this.mCatalogFile.getAbsolutePath(), this.mReplaceFile.getAbsolutePath(), this.mReplaceFile.exists());
        GridBagHelper.addComponent(this, editPanel, 2, level++, 3, 1, 0, 0, 0, 0, 0.0, 0.0, 0, 17);
    }

    private static ImageIcon getUnreplaceIcon() {
        if (unreplaceImage != null) {
            return new ImageIcon(unreplaceImage);
        }
        InputStream is = ResourceFactory.getInstance().getImageSream("unreplace.png");
        try {
            unreplaceImage = ImageIO.read(is);
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new ImageIcon(GUIUtil.scaleImage(unreplaceImage, GUIUtil.HDPI_SIZE));
    }

    private JPanel getEditPanel(String catalogResourcePath, String replaceResourcePath, boolean replaceFileExists) {
        JPanel editPanel = new JPanel();
        editPanel.setOpaque(false);
        editPanel.setLayout(new FlowLayout(0));
        JButton pasteButton = new JButton(ResourceFactory.getString("paste"));
        pasteButton.addActionListener(new PasteActionListener(replaceResourcePath));
        editPanel.add(pasteButton);
        JButton openButton = new JButton(ResourceFactory.getString("open"));
        openButton.addActionListener(new OpenActionListener(replaceResourcePath));
        editPanel.add(openButton);
        JButton openFolderButton = new JButton(ResourceFactory.getString("open_folder"));
        openFolderButton.addActionListener(new OpenThemeResourceFolderActionListener(replaceResourcePath));
        editPanel.add(openFolderButton);
        JButton delButton = new JButton(ResourceFactory.getString("delete"));
        delButton.setActionCommand(replaceResourcePath);
        delButton.addActionListener(this.dfal);
        editPanel.add(delButton);
        if (!replaceFileExists) {
            openButton.setEnabled(false);
            openFolderButton.setEnabled(false);
            delButton.setEnabled(false);
            return editPanel;
        }
        if (replaceResourcePath.endsWith(".9.png")) {
            JButton editNinePatchButton = new JButton(ResourceFactory.getString("edit_nine_patch"));
            editNinePatchButton.setActionCommand(replaceResourcePath);
            editNinePatchButton.addActionListener(this.enpal);
            editPanel.add(editNinePatchButton);
        }
        File replaceResource = new File(replaceResourcePath);
        if (replaceResourcePath.contains("drawable-xhdpi") && FullResolutionMatchManager.checkNeedFullResolutionMatch(replaceResource)) {
            JButton xhdpi2all = new JButton(ResourceFactory.getString("adapt_xhdpi_all"));
            xhdpi2all.setActionCommand(replaceResourcePath);
            xhdpi2all.addActionListener(this.ax2all);
            editPanel.add(xhdpi2all);
        }
        return editPanel;
    }

    private void replaceResource(File target, File source) {
        int result;
        if (!this.isRightSuffix(source.getName())) {
            GUIUtil.alert(ResourceFactory.getString("wrong_resource_type"));
            return;
        }
        try {
            File replaceDir = target.getParentFile();
            if (!replaceDir.exists()) {
                replaceDir.mkdirs();
            }
            ThemeHelper.copyFile(source, target);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        HashSet<File> adapted = new HashSet<File>();
        FullResolutionMatchManager.checkAdaptPressed(target, adapted);
        if (target.getAbsolutePath().contains("drawable-xhdpi") && FullResolutionMatchManager.checkNeedFullResolutionMatch(target) && (result = JOptionPane.showConfirmDialog(MainFrame.getInstance(), ResourceFactory.getString("confirm_adapt_all"))) == 0) {
            FullResolutionMatchManager.adaptXhdpiToHdpi(target);
            FullResolutionMatchManager.adaptXhdpiToXxhdpi(target);
        }
        this.mReplaceActionListener.onRefresh();
    }

    private boolean isRightSuffix(String name) {
        int i = 0;
        while (i < sResourceSuffixList.size()) {
            if (name.endsWith(sResourceSuffixList.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    class AdaptXhdpi2Hdpi
    implements ActionListener {
        AdaptXhdpi2Hdpi() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FullResolutionMatchManager.adaptXhdpiToHdpi(new File(e.getActionCommand()));
            FullResolutionMatchManager.adaptXhdpiToXxhdpi(new File(e.getActionCommand()));
            ResourceReplacePanel.this.mReplaceActionListener.onRefresh();
            StateBar.getInstance().setText(ResourceFactory.getString("adapt_success"));
        }
    }

    class CatalogIconMouseAdapter
    extends MouseAdapter {
        private File mCatalogFile;

        public CatalogIconMouseAdapter(File catalogFile) {
            this.mCatalogFile = catalogFile;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            File target = this.mCatalogFile;
            if (!target.exists()) {
                return;
            }
            ThemeHelper.openInExplorer(target);
            ResourceReplacePanel.this.mReplaceActionListener.onRefresh();
            ResourceReplacePanel.this.mReplaceActionListener.onWait();
        }
    }

    class CopyResourceActionListener
    implements ActionListener {
        private String mCatalogResourcePath;
        private String mReplaceResourcePath;

        public CopyResourceActionListener(String catalogResourcePath, String replaceResourcePath) {
            this.mCatalogResourcePath = catalogResourcePath;
            this.mReplaceResourcePath = replaceResourcePath;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File target = new File(this.mReplaceResourcePath);
            ResourceReplacePanel.this.replaceResource(target, new File(this.mCatalogResourcePath));
            ResourceReplacePanel.this.mReplaceActionListener.onRefresh();
        }
    }

    class DeleteFileActionListener
    implements ActionListener {
        DeleteFileActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File f = new File(e.getActionCommand());
            f.delete();
            ResourceReplacePanel.this.mReplaceActionListener.onRefresh();
        }
    }

    class EditNinePatchActionListener
    implements ActionListener {
        EditNinePatchActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GUIUtil.openNinePatch(e.getActionCommand());
            ResourceReplacePanel.this.mReplaceActionListener.onWait();
        }
    }

    class FileDropListener
    implements FileDrop.Listener {
        private File mReplaceFile;

        public FileDropListener(File replaceFile) {
            this.mReplaceFile = replaceFile;
        }

        @Override
        public void filesDropped(File[] files) {
            File f = files[0];
            if (f.isDirectory()) {
                return;
            }
            if (MainFrame.getInstance().checkOpenMtz(f)) {
                return;
            }
            ResourceReplacePanel.this.replaceResource(this.mReplaceFile, f);
        }
    }

    class OpenActionListener
    implements ActionListener {
        private String mReplaceResourcePath;

        public OpenActionListener(String replaceResourcePath) {
            this.mReplaceResourcePath = replaceResourcePath;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ThemeHelper.open(new File(this.mReplaceResourcePath));
            ResourceReplacePanel.this.mReplaceActionListener.onRefresh();
        }
    }

    class OpenThemeResourceFolderActionListener
    implements ActionListener {
        private String mReplaceResourcePath;

        public OpenThemeResourceFolderActionListener(String replaceResourcePath) {
            this.mReplaceResourcePath = replaceResourcePath;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ThemeHelper.openInExplorer(new File(this.mReplaceResourcePath));
            ResourceReplacePanel.this.mReplaceActionListener.onRefresh();
        }
    }

    class PasteActionListener
    implements ActionListener {
        private String mReplaceResourcePath;

        public PasteActionListener(String replaceResourcePath) {
            this.mReplaceResourcePath = replaceResourcePath;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Clipboard sc = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable t = sc.getContents(null);
            if (t == null || !t.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                GUIUtil.alert(ResourceFactory.getString("no_image_in_clipboard"));
                return;
            }
            try {
                BufferedImage image = (BufferedImage)sc.getData(DataFlavor.imageFlavor);
                GUIUtil.saveImage(image, new File(this.mReplaceResourcePath));
                ResourceReplacePanel.this.mReplaceActionListener.onRefresh();
                return;
            }
            catch (UnsupportedFlavorException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            GUIUtil.alert(ResourceFactory.getString("paste_wrong"));
        }
    }

    public static interface ReplaceActionListener {
        public void onRefresh();

        public void onWait();
    }

    class ReplaceIconMouseAdapter
    extends MouseAdapter {
        private File mReplaceFile;

        public ReplaceIconMouseAdapter(File replaceFile) {
            this.mReplaceFile = replaceFile;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JFileChooser jfc = new JFileChooser();
            jfc.setBounds(20, 20, 400, 400);
            jfc.setVisible(true);
            jfc.setDialogTitle(ResourceFactory.getString("select_a_resource"));
            if (mLastDir != null) {
                jfc.setCurrentDirectory(mLastDir);
            }
            jfc.setFileSelectionMode(0);
            jfc.setMultiSelectionEnabled(false);
            ImagePreview preview = new ImagePreview(jfc);
            jfc.addPropertyChangeListener(preview);
            jfc.setAccessory(preview);
            int state = jfc.showOpenDialog(null);
            if (state == 0) {
                File f = jfc.getSelectedFile();
                mLastDir = f.getParentFile();
                if (f.isDirectory()) {
                    return;
                }
                ResourceReplacePanel.this.replaceResource(this.mReplaceFile, f);
                ((JLabel)e.getSource()).setIcon(GUIUtil.getIcon(this.mReplaceFile));
            }
        }
    }
}

