/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.icons;

import com.android.ddmlib.utils.VerticalFlowLayout;
import com.miui.theme.tool.gui.ApkSelectDialog;
import com.miui.theme.tool.gui.MainFrame;
import com.miui.theme.tool.gui.ResourceReplacePanel;
import com.miui.theme.tool.gui.StateBar;
import com.miui.theme.tool.icons.IconEditCell;
import com.miui.theme.tool.icons.IconManager;
import com.miui.theme.tool.icons.IconsTransformDialog;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.FileDrop;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.GridBagHelper;
import com.miui.theme.tool.util.ThemeHelper;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class IconReplacePanel
extends JPanel
implements ActionListener {
    private JTabbedPane mShowIconsPanel;
    private JButton mSyncIconsButton;
    private JButton mIconsTransformButton;
    private HashMap<String, File> mSystemIconsMap = new HashMap();
    private HashMap<String, File> mDefaultIconsMap = new HashMap();
    private HashMap<String, File> mIconsMap = new HashMap();
    private HashMap<String, IconEditCell> mIconsCellHashMap;
    private FileFilter mIconsFileFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".png");
        }
    };
    private JPanel mSystemIconPanel;
    private JPanel mDefaultIconPanel;
    private JPanel mIconPanel;
    private static HashSet<String> sSystemIcons = new HashSet();
    private IconEditCell mCurrentCell;
    MouseListener ml = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            IconReplacePanel.this.onChangeIcon((IconEditCell)e.getSource());
        }
    };
    public static int icons_per_line;
    boolean mSyncingFlag = false;
    private JScrollPane mSystemIconPanelScroll;
    private JScrollPane mDefaultIconPanelScroll;
    private JScrollPane mIconPanelScroll;
    private EditIconPanel mEditIconPanel;
    private JButton mIconsCleanButton;

    static {
        String systemIcon = ThemeHelper.readFromFile(new File(ThemeHelper.getDataFolder() + File.separator + "system_icon.txt"));
        String[] systemIcons = systemIcon.split("\n");
        if (systemIcons != null) {
            int i = 0;
            while (i < systemIcons.length) {
                sSystemIcons.add(systemIcons[i]);
                ++i;
            }
        }
        icons_per_line = 8;
    }

    public IconReplacePanel() {
        this.migrateIcons();
        this.initBaseStructure();
        this.fillPanelContent();
    }

    private void migrateIcons() {
        String icons = String.valueOf(ThemeHelper.sThemeFolderPath) + File.separator + "icons";
        File[] iconFiles = new File(icons).listFiles();
        if (iconFiles == null) {
            return;
        }
        File[] fileArray = iconFiles;
        int n = iconFiles.length;
        int n2 = 0;
        while (n2 < n) {
            block8: {
                File icon = fileArray[n2];
                if (icon.isFile() && icon.getName().endsWith(".png")) {
                    try {
                        try {
                            this.replaceResource(icon, icon.getName());
                        }
                        catch (NullPointerException e) {
                            e.printStackTrace();
                            icon.delete();
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        icon.delete();
                        throw throwable;
                    }
                    icon.delete();
                }
            }
            ++n2;
        }
    }

    private void fillPanelContent() {
        new Thread(){

            @Override
            public void run() {
                IconReplacePanel.this.fillData();
                IconReplacePanel.this.mIconsCellHashMap = new HashMap();
                IconReplacePanel.this.fillIconPanel(IconReplacePanel.this.mSystemIconsMap, IconReplacePanel.this.mSystemIconPanel);
                IconReplacePanel.this.fillIconPanel(IconReplacePanel.this.mDefaultIconsMap, IconReplacePanel.this.mDefaultIconPanel);
                IconReplacePanel.this.fillIconPanel(IconReplacePanel.this.mIconsMap, IconReplacePanel.this.mIconPanel);
                IconReplacePanel.this.bindIconsCellMouse();
                IconReplacePanel.this.validate();
            }
        }.start();
    }

    private void bindIconsCellMouse() {
        for (String key : this.mIconsCellHashMap.keySet()) {
            IconEditCell cell = this.mIconsCellHashMap.get(key);
            cell.addMouseListener(this.ml);
        }
    }

    private void onChangeIcon(IconEditCell iconEditCell) {
        if (this.mCurrentCell != null) {
            this.mCurrentCell.setDefaultBackground();
        }
        this.mCurrentCell = iconEditCell;
        this.mCurrentCell.setSelectedBackground();
        this.mEditIconPanel.init();
        this.validate();
        this.repaint();
        this.updateUI();
    }

    private void fillIconPanel(HashMap<String, File> map, JPanel panel) {
        int line = map.size() / icons_per_line + 1;
        panel.removeAll();
        panel.setLayout(new GridLayout(line, icons_per_line, 0, 0));
        Object[] keys = new String[map.keySet().size()];
        map.keySet().toArray(keys);
        Arrays.sort(keys);
        int i = 0;
        while (i < keys.length) {
            File iconCatalogFile = map.get(keys[i]);
            try {
                IconEditCell iconEditCell = new IconEditCell(iconCatalogFile);
                this.mIconsCellHashMap.put((String)keys[i], iconEditCell);
                panel.add(iconEditCell);
                new FileDrop(MainFrame.out, (Component)iconEditCell, iconEditCell.getBorder(), (FileDrop.Listener)new FileDropListener(iconEditCell, iconCatalogFile.getName()));
            }
            catch (NullPointerException npe) {
                System.out.println("Icon " + (String)keys[i] + " load fail!");
            }
            ++i;
        }
    }

    private void fillData() {
        this.mSystemIconsMap.clear();
        this.mDefaultIconsMap.clear();
        this.mIconsMap.clear();
        File defaultIconsFolder = new File(IconManager.getThemeIconsCatalogDefault());
        File[] files = defaultIconsFolder.listFiles(this.mIconsFileFilter);
        HashSet<String> systemIcons = this.getSystemIcons();
        if (files == null) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File df = fileArray[n2];
            boolean isSystemFlag = false;
            for (String packageName : systemIcons) {
                if (!df.getName().startsWith(packageName)) continue;
                isSystemFlag = true;
                this.mSystemIconsMap.put(df.getName(), df);
                break;
            }
            if (!isSystemFlag) {
                this.mDefaultIconsMap.put(df.getName(), df);
            }
            ++n2;
        }
        File iconsFolder = new File(IconManager.getThemeIconsCatalog());
        files = iconsFolder.listFiles(this.mIconsFileFilter);
        if (files == null) {
            return;
        }
        File[] fileArray2 = files;
        int n3 = files.length;
        n = 0;
        while (n < n3) {
            File f = fileArray2[n];
            if (!this.mSystemIconsMap.containsKey(f.getName()) && !this.mDefaultIconsMap.containsKey(f.getName())) {
                this.mIconsMap.put(f.getName(), f);
            }
            ++n;
        }
    }

    private HashSet<String> getSystemIcons() {
        Vector<String> vcSystemList = new Vector<String>();
        try {
            ApkSelectDialog.getHashMapApps(vcSystemList, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        HashSet<String> systemIcons = new HashSet<String>(sSystemIcons);
        for (String name : vcSystemList) {
            systemIcons.add(ThemeHelper.clearDesc(name));
        }
        return systemIcons;
    }

    private void initBaseStructure() {
        int gap = 10;
        int x = 0;
        int y = 0;
        int len = 3;
        this.setLayout(new GridBagLayout());
        this.mShowIconsPanel = new JTabbedPane(1);
        this.mSystemIconPanel = new JPanel();
        this.mDefaultIconPanel = new JPanel();
        this.mIconPanel = new JPanel();
        this.mSystemIconPanelScroll = new JScrollPane();
        this.mDefaultIconPanelScroll = new JScrollPane();
        this.mIconPanelScroll = new JScrollPane();
        this.mSystemIconPanelScroll.setViewportView(this.mSystemIconPanel);
        this.mDefaultIconPanelScroll.setViewportView(this.mDefaultIconPanel);
        this.mIconPanelScroll.setViewportView(this.mIconPanel);
        this.mShowIconsPanel.addTab(ResourceFactory.getString("tab_system_icon"), null, this.mSystemIconPanelScroll, null);
        this.mShowIconsPanel.addTab(ResourceFactory.getString("tab_default_icon"), null, this.mDefaultIconPanelScroll, null);
        this.mShowIconsPanel.addTab(ResourceFactory.getString("tab_other_icon"), null, this.mIconPanelScroll, null);
        GridBagHelper.addComponent(this, this.mShowIconsPanel, x, y, len, 1, 0, 0, gap, gap, 1.0, 1.0, 1, 10);
        this.mEditIconPanel = new EditIconPanel();
        this.mEditIconPanel.setLayout(new VerticalFlowLayout());
        GridBagHelper.addComponent(this, this.mEditIconPanel, x += len, y, 1, 1, 0, 0, 0.0, 1.0, 1, 10);
        x = 0;
        this.mSyncIconsButton = new JButton(ResourceFactory.getString("icon_sync"));
        this.mSyncIconsButton.addActionListener(this);
        GridBagHelper.addComponent(this, this.mSyncIconsButton, x, ++y, 1, 1, 0, 0, 1.0, 0.0, 0, 13);
        this.mIconsTransformButton = new JButton(ResourceFactory.getString("icon_transform"));
        this.mIconsTransformButton.addActionListener(this);
        GridBagHelper.addComponent(this, this.mIconsTransformButton, ++x, y, 1, 1, 0, 0, 0.0, 0.0, 0, 10);
        this.mIconsCleanButton = new JButton(ResourceFactory.getString("icon_clean"));
        this.mIconsCleanButton.addActionListener(this);
        GridBagHelper.addComponent(this, this.mIconsCleanButton, ++x, y, 1, 1, 0, 0, 1.0, 0.0, 0, 17);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton source = (JButton)e.getSource();
        if (source == this.mSyncIconsButton) {
            if (this.mSyncingFlag) {
                GUIUtil.alert(ResourceFactory.getString("syncing"));
                return;
            }
            StateBar.getInstance().setText(ResourceFactory.getString("syncing"));
            new Thread(){

                @Override
                public void run() {
                    IconReplacePanel.this.mSyncingFlag = true;
                    IconReplacePanel.this.mSyncIconsButton.setCursor(Cursor.getPredefinedCursor(3));
                    if (IconManager.syncIcons()) {
                        StateBar.getInstance().setText(ResourceFactory.getString("complete"));
                    } else {
                        StateBar.getInstance().setText(ResourceFactory.getString("phone_open_debug_tip"));
                    }
                    IconReplacePanel.this.mSyncingFlag = false;
                    IconReplacePanel.this.fillPanelContent();
                    IconReplacePanel.this.mSyncIconsButton.setCursor(Cursor.getPredefinedCursor(0));
                }
            }.start();
        } else if (source == this.mIconsTransformButton) {
            new IconsTransformDialog();
        } else if (source == this.mIconsCleanButton) {
            IconManager.cleanIcons();
            GUIUtil.alert(ResourceFactory.getString("clean_compelete"));
            this.fillPanelContent();
        }
    }

    private void replaceResource(File source, String fileName) {
        BufferedImage image = GUIUtil.getImage(source);
        String path = image.getWidth() < (GUIUtil.XHDPI_SIZE + GUIUtil.HDPI_SIZE) / 2 ? String.valueOf(ThemeHelper.sThemeFolderPath) + File.separator + IconManager.PATH_HDPI : String.valueOf(ThemeHelper.sThemeFolderPath) + File.separator + IconManager.PATH_XHDPI;
        path = String.valueOf(path) + File.separator + fileName;
        File target = new File(path);
        try {
            File replaceDir = target.getParentFile();
            if (!replaceDir.exists()) {
                replaceDir.mkdirs();
            }
            ThemeHelper.copyFile(source, target);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    class EditIconPanel
    extends JPanel {
        private File mIconHdpiFile;
        private File mIconXhdpiFile;
        ResourceReplacePanel.ReplaceActionListener ral = new ResourceReplacePanel.ReplaceActionListener(){

            @Override
            public void onWait() {
            }

            @Override
            public void onRefresh() {
                EditIconPanel.this.initPanel();
            }
        };

        EditIconPanel() {
        }

        public void init() {
            this.mIconXhdpiFile = new File(String.valueOf(ThemeHelper.sThemeFolderPath) + File.separator + IconManager.PATH_XHDPI + File.separator + IconReplacePanel.this.mCurrentCell.getFileName());
            this.mIconHdpiFile = new File(String.valueOf(ThemeHelper.sThemeFolderPath) + File.separator + IconManager.PATH_HDPI + File.separator + IconReplacePanel.this.mCurrentCell.getFileName());
            this.initPanel();
        }

        private void initPanel() {
            this.removeAll();
            this.setLayout(new GridBagLayout());
            int level = 1;
            int gap = 15;
            String name = IconManager.PATH_XHDPI;
            ResourceReplacePanel rrp = new ResourceReplacePanel(name, IconReplacePanel.this.mCurrentCell.getFile(), this.mIconXhdpiFile, this.ral);
            GridBagHelper.addComponent(this, rrp, 0, level++, 1, 1, 0, 0, 0, gap, 1.0, 0.0, 0, 17);
            name = String.valueOf(IconManager.PATH_HDPI) + File.separator;
            rrp = new ResourceReplacePanel(name, IconReplacePanel.this.mCurrentCell.getFile(), this.mIconHdpiFile, this.ral);
            GridBagHelper.addComponent(this, rrp, 0, level++, 1, 1, 0, 0, 0, gap, 1.0, 0.0, 0, 17);
            IconReplacePanel.this.validate();
        }
    }

    class FileDropListener
    implements FileDrop.Listener {
        private IconEditCell mIconEditCell;
        private String mFileName;

        public FileDropListener(IconEditCell iconEditCell, String fileName) {
            this.mIconEditCell = iconEditCell;
            this.mFileName = fileName;
        }

        @Override
        public void filesDropped(File[] files) {
            File f = files[0];
            if (f.isDirectory()) {
                return;
            }
            if (MainFrame.getInstance().checkOpenMtz(f)) {
                return;
            }
            IconReplacePanel.this.replaceResource(f, this.mFileName);
            IconReplacePanel.this.onChangeIcon(this.mIconEditCell);
        }
    }
}

