/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.update;

import com.miui.theme.tool.gui.MainFrame;
import com.miui.theme.tool.os.CmdUtils;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.update.VersionFile;
import com.miui.theme.tool.util.DownloadProgressListener;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.GridBagHelper;
import com.miui.theme.tool.util.InternetDownloadTask;
import com.miui.theme.tool.util.ThemeHelper;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class UpdateFrame
extends JFrame
implements ActionListener {
    public static final String NAME_PREFIX = "MIUIThemeEditor_";
    public static final String NAME_SUFFIX = ".zip";
    public static final String INNER_URL = "http://mi.tlightsky.com/MIUIThemeEditor/";
    public static final String OUTTER_URL = "http://themeeditor.xiaomi.com/MIUIThemeEditor/";
    public static final String URL_SEP = "/";
    public static final String NAME_VERSION = "version.txt";
    public static final String NAME_TMP_VERSION = "version.new";
    private File mUpdateVersionFile;
    private File mCurrentVersionFile;
    private VersionFile mUpdateVF;
    private VersionFile mCurrentVF;
    private JLabel mInfoLabel;
    private JTextArea mInfoTextArea;
    private JButton mUpdateButton;
    private JButton mConfirmButton;
    private JButton mStopButton;
    private JProgressBar mProgressBar;
    private File mUpdatePackageFile;
    private InternetDownloadTask mInternetDownloadTask;
    public static final int WIDTH = 500;
    public static final int HEIGHT = 600;
    private DownloadProgressListener dpl = new DownloadProgressListener(){

        @Override
        public void progress(long current, long total) {
            UpdateFrame.this.mProgressBar.setMaximum((int)(total / 4096L));
            UpdateFrame.this.mProgressBar.setMinimum(0);
            UpdateFrame.this.mProgressBar.setValue((int)(current / 4096L));
        }

        @Override
        public void done(Object o) {
            UpdateFrame.this.mStopButton.setEnabled(false);
            UpdateFrame.this.mStopButton.setText(ResourceFactory.getString("unzipping"));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    boolean successFlag = ThemeHelper.unzip(UpdateFrame.this.mUpdatePackageFile, new File(ThemeHelper.getUserDir()).getParentFile());
                    UpdateFrame.this.mStopButton.setVisible(false);
                    UpdateFrame.this.mConfirmButton.setVisible(true);
                    if (successFlag) {
                        UpdateFrame.this.deleteOld();
                        UpdateFrame.this.transport();
                        CmdUtils.startEditor();
                        UpdateFrame.this.exit();
                    } else {
                        GUIUtil.alert(ResourceFactory.getString("update_unzip_error"), UpdateFrame.this);
                        String updatePath = String.valueOf(new File(ThemeHelper.getUserDir()).getParent()) + File.separator + UpdateFrame.this.mUpdateVF.getVersionString() + File.separator;
                        CmdUtils.deleteDir(updatePath);
                    }
                }
            });
        }

        @Override
        public void cancelled() {
            UpdateFrame.this.mStopButton.setVisible(false);
            UpdateFrame.this.mConfirmButton.setVisible(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GUIUtil.alert(ResourceFactory.getString("update_download_cancelled"), UpdateFrame.this);
                }
            });
        }
    };

    public UpdateFrame() {
        this.initFrame();
    }

    private void initFrame() {
        MainFrame mainFrame = MainFrame.getInstance();
        this.setBounds(mainFrame.getX() + (mainFrame.getWidth() - 500) / 2, mainFrame.getY() + (mainFrame.getHeight() - 600) / 2, 500, 600);
        this.mInfoLabel = new JLabel();
        this.mInfoTextArea = new JTextArea();
        this.mConfirmButton = new JButton(ResourceFactory.getString("ok"));
        this.mConfirmButton.addActionListener(this);
        this.setLayout(new GridBagLayout());
        int x = 0;
        int y = 0;
        int gap = 5;
        GridBagHelper.addComponent(this.getContentPane(), this.mInfoLabel, x, y++, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 17);
        GridBagHelper.addComponent(this.getContentPane(), this.mInfoTextArea, x, y++, 1, 1, 0, 0, gap, gap, 1.0, 1.0, 1, 17);
        if (this.needUpdate()) {
            this.mInfoTextArea.setText(this.mUpdateVF.mContent);
            this.setTitle(ResourceFactory.getString("update_available"));
            this.mInfoLabel.setText(ResourceFactory.getString("update_info"));
            this.mProgressBar = new JProgressBar();
            GridBagHelper.addComponent(this.getContentPane(), this.mProgressBar, x, y++, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 17);
            this.mUpdateButton = new JButton(ResourceFactory.getString("download_update"));
            this.mUpdateButton.addActionListener(this);
            GridBagHelper.addComponent(this.getContentPane(), this.mUpdateButton, x, y++, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 17);
            this.mStopButton = new JButton(ResourceFactory.getString("stop_download_update"));
            this.mStopButton.addActionListener(this);
            this.mStopButton.setVisible(false);
            GridBagHelper.addComponent(this.getContentPane(), this.mStopButton, x, y++, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 17);
            this.mConfirmButton.setVisible(false);
            GridBagHelper.addComponent(this.getContentPane(), this.mConfirmButton, x, y++, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 17);
        } else {
            this.mInfoTextArea.setText(this.mCurrentVF.mContent);
            this.setTitle(ResourceFactory.getString("update_unavailable"));
            this.mInfoLabel.setText(ResourceFactory.getString("version_info"));
            GridBagHelper.addComponent(this.getContentPane(), this.mConfirmButton, x, y++, 1, 1, 0, 0, gap, gap, 1.0, 0.0, 1, 17);
        }
    }

    public boolean needUpdate() {
        this.mUpdateVersionFile = new File(String.valueOf(ThemeHelper.getUserDir()) + File.separator + NAME_TMP_VERSION);
        this.mCurrentVersionFile = new File(String.valueOf(ThemeHelper.getUserDir()) + File.separator + NAME_VERSION);
        this.mUpdateVF = VersionFile.parse(this.mUpdateVersionFile);
        this.mCurrentVF = VersionFile.parse(this.mCurrentVersionFile);
        return this.mUpdateVF.compareTo(this.mCurrentVF) > 0;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.mUpdateButton)) {
            this.mUpdateButton.setVisible(false);
            this.mStopButton.setVisible(true);
            this.downloadUpdate();
        } else if (e.getSource().equals(this.mConfirmButton)) {
            this.exit();
        } else if (e.getSource().equals(this.mStopButton)) {
            this.mInternetDownloadTask.cancel(true);
        }
    }

    private void exit() {
        this.dispose();
        System.exit(0);
    }

    private void downloadUpdate() {
        this.mUpdatePackageFile = new File(String.valueOf(ThemeHelper.getUserDir()) + File.separator + NAME_PREFIX + this.mUpdateVF.getVersionString() + NAME_SUFFIX);
        String url = ThemeHelper.isInnerUserMode() ? "http://mi.tlightsky.com/MIUIThemeEditor/MIUIThemeEditor_" + this.mUpdateVF.getVersionString() + NAME_SUFFIX : "http://themeeditor.xiaomi.com/MIUIThemeEditor/MIUIThemeEditor_" + this.mUpdateVF.getVersionString() + NAME_SUFFIX;
        try {
            this.mInternetDownloadTask = new InternetDownloadTask(url, new FileOutputStream(this.mUpdatePackageFile));
            this.mInternetDownloadTask.setDownloadProgressListener(this.dpl);
            this.mInternetDownloadTask.execute();
        }
        catch (IOException ioe) {
            GUIUtil.alert(ResourceFactory.getString("update_download_error"), this);
            ioe.printStackTrace();
        }
    }

    private void transport() {
        this.mStopButton.setText(ResourceFactory.getString("transporting"));
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.mConfirmButton.setEnabled(false);
        String currentPath = String.valueOf(ThemeHelper.getUserDir()) + File.separator;
        String updatePath = String.valueOf(new File(ThemeHelper.getUserDir()).getParent()) + File.separator + this.mUpdateVF.getVersionString() + File.separator;
        String configuration = "configuration";
        CmdUtils.copyDir(String.valueOf(currentPath) + configuration, String.valueOf(updatePath) + configuration);
        this.setCursor(Cursor.getDefaultCursor());
        this.mConfirmButton.setEnabled(true);
        GUIUtil.alert(ResourceFactory.getString("update_transport_done"), this);
    }

    private void deleteOld() {
        File rootDir = new File(ThemeHelper.getUserDir()).getParentFile();
        Vector<VersionFile> vfs = new Vector<VersionFile>();
        File[] fileArray = rootDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            VersionFile vf = VersionFile.parse(f.getName());
            if (vf != null) {
                vfs.add(vf);
            }
            ++n2;
        }
        Collections.sort(vfs);
        int i = 0;
        while (i < vfs.size() - 2) {
            CmdUtils.deleteDir(String.valueOf(rootDir.getAbsolutePath()) + File.separator + ((VersionFile)vfs.get(i)).getVersionString());
            System.out.println("deleting " + ((VersionFile)vfs.get(i)).getVersionString());
            ++i;
        }
    }
}

