/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.update;

import com.miui.theme.tool.util.ThemeHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionFile
implements Comparable<VersionFile> {
    public int mYear;
    public int mMonth;
    public int mDay;
    public int mStamp;
    String mContent;
    public static String lineSeparator = "\n";

    public static VersionFile parse(String version) {
        VersionFile vf = new VersionFile();
        if (VersionFile.fillVersionFile(vf, version)) {
            return vf;
        }
        return null;
    }

    private static boolean fillVersionFile(VersionFile vf, String version) {
        Pattern pattern = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)_(\\d+)$");
        Matcher matcher = pattern.matcher(version);
        if (!matcher.find()) {
            return false;
        }
        vf.mYear = Integer.parseInt(matcher.group(1));
        vf.mMonth = Integer.parseInt(matcher.group(2));
        vf.mDay = Integer.parseInt(matcher.group(3));
        vf.mStamp = Integer.parseInt(matcher.group(4));
        return true;
    }

    public static VersionFile parse(File f) {
        String line;
        StringBuilder sb;
        BufferedReader br;
        VersionFile vf;
        block4: {
            vf = new VersionFile();
            FileInputStream fis = new FileInputStream(f);
            br = new BufferedReader(new InputStreamReader((InputStream)fis, ThemeHelper.CHARSET));
            sb = new StringBuilder();
            line = br.readLine();
            if (VersionFile.fillVersionFile(vf, line)) break block4;
            return null;
        }
        try {
            sb.append(line);
            while ((line = br.readLine()) != null) {
                sb.append(String.valueOf(lineSeparator) + line);
            }
            vf.mContent = sb.toString();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return vf;
    }

    public String getVersionString() {
        return String.valueOf(this.mYear) + "." + this.mMonth + "." + this.mDay + "_" + this.mStamp;
    }

    @Override
    public int compareTo(VersionFile vf) {
        if (this.mYear != vf.mYear) {
            return this.mYear - vf.mYear;
        }
        if (this.mMonth != vf.mMonth) {
            return this.mMonth - vf.mMonth;
        }
        if (this.mDay != vf.mDay) {
            return this.mDay - vf.mDay;
        }
        if (this.mStamp != vf.mStamp) {
            return this.mStamp - vf.mStamp;
        }
        return 0;
    }
}

