/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.upsidescene;

import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.upsidescene.Manager;
import com.miui.theme.tool.upsidescene.TreeHelper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class AddTagToolbar
extends JToolBar
implements Observer {
    private Manager mManager;
    private ArrayList<JButton> buttons = new ArrayList();
    int start = 0;

    public AddTagToolbar(Manager mManager) {
        this.mManager = mManager;
        this.setFloatable(false);
    }

    private void init() {
        ArrayList<String> childs = this.mManager.fetchChilds();
        this.removeAll();
        this.buttons.clear();
        if (childs == null) {
            this.updateUI();
            return;
        }
        for (String child : childs) {
            JButton button = new JButton();
            button.setVerticalTextPosition(0);
            button.setText(String.valueOf(ResourceFactory.getString("add")) + child);
            button.setActionCommand(child);
            button.setName(child);
            button.setToolTipText(this.mManager.fetchChildrDescription(child));
            this.buttons.add(button);
            button.addActionListener(new ButtonAction());
            button.addMouseListener(new ButtonPressListener());
        }
        this.add(new JButton());
        for (JButton button : this.buttons) {
            this.add(button);
        }
        this.updateUI();
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        if (arg1 != null && arg1.getClass() == TreeHelper.MutableTreeNode.class) {
            TreeHelper.MutableTreeNode node = (TreeHelper.MutableTreeNode)arg1;
            if (node.getStartPos() != 0) {
                this.start = node.getStartPos();
            }
            this.init();
        }
    }

    private class ButtonAction
    implements ActionListener {
        private ButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AddTagToolbar.this.mManager.updateCurrent(AddTagToolbar.this.start + 4);
            AddTagToolbar.this.mManager.mSendNotify(e);
        }
    }

    private class ButtonPressListener
    implements MouseListener {
        private ButtonPressListener() {
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }
    }
}

