/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.upsidescene;

import com.miui.theme.tool.schema.Attribute;
import com.miui.theme.tool.schema.Schema;
import com.miui.theme.tool.upsidescene.AttributesModel;
import com.miui.theme.tool.upsidescene.Manager;
import com.miui.theme.tool.upsidescene.ShortcutCellEditor;
import com.miui.theme.tool.upsidescene.TreeHelper;
import com.miui.theme.tool.util.ColumnResizer;
import com.miui.theme.tool.xmlparser.Attributes;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class AttributesTable
extends JTable
implements Observer {
    private Manager mManager;
    private Schema mSchema;
    private AttributesModel mModel;

    public AttributesTable(Manager manager) {
        this.mManager = manager;
        this.mSchema = Schema.getInstance();
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        if (arg1 != null && arg1.getClass() == TreeHelper.MutableTreeNode.class) {
            TreeHelper.MutableTreeNode node = (TreeHelper.MutableTreeNode)arg1;
            int end = node.getEndPos();
            this.mManager.updateCurrent(end - 4);
            if (this.mManager.getCurrentElement() == null) {
                return;
            }
            ArrayList<String> descriptions = new ArrayList<String>();
            ArrayList<Attribute> attributes = this.mManager.fetchAtributesSchema();
            for (Attribute attribute : attributes) {
                descriptions.add("desc." + this.mManager.getCurrentElement().getTAG_NAME() + "." + attribute.getName());
            }
            Attributes attrs = this.mManager.getCurrentElement().getAttributes();
            this.mModel = new AttributesModel(attributes, attrs, this.mManager, descriptions);
            this.setModel(this.mModel);
            ColumnResizer.adjustColumnPreferredWidths(this);
        }
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        if (this.mModel.getAttributes(row).getOptions() != null) {
            return new DefaultCellEditor(new JComboBox<String>(this.mModel.getAttributes(row).getOptions()));
        }
        if (this.mModel.getValueAt(row, 0).equals("_content") && this.mModel.attributes.getValue("type").equals("shortcut")) {
            return new ShortcutCellEditor();
        }
        return super.getCellEditor(row, column);
    }
}

