/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.upsidescene;

import com.miui.theme.tool.errorManager.Error;
import com.miui.theme.tool.errorManager.ErrorManager;
import com.miui.theme.tool.upsidescene.Manager;
import com.miui.theme.tool.upsidescene.TextArea;
import com.miui.theme.tool.upsidescene.TextColouring;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

class EditorListener
implements DocumentListener {
    private Set<String> mKeywords;
    private Style mKeywordStyle;
    private Style mNormalStyle;
    private Style mErrorlStyle;
    private Manager mManager;
    private boolean isFirst = true;
    private int changeCount = 0;
    private int start;
    private Timer timer;
    private TimerTask task;
    private DocumentEvent event;

    public EditorListener(TextArea editor) {
        this.mKeywordStyle = ((StyledDocument)editor.getDocument()).addStyle("Keyword_Style", null);
        this.mNormalStyle = ((StyledDocument)editor.getDocument()).addStyle("NormalStyle", null);
        this.mErrorlStyle = ((StyledDocument)editor.getDocument()).addStyle("ErrorlStyle", null);
        StyleConstants.setForeground(this.mKeywordStyle, Color.BLUE);
        StyleConstants.setFontSize(this.mKeywordStyle, 15);
        StyleConstants.setFontFamily(this.mKeywordStyle, "lucida bright italic");
        StyleConstants.setForeground(this.mNormalStyle, Color.BLACK);
        StyleConstants.setFontFamily(this.mNormalStyle, "lucida typewriter bold");
        StyleConstants.setFontSize(this.mNormalStyle, 15);
        StyleConstants.setForeground(this.mErrorlStyle, Color.BLACK);
        StyleConstants.setFontFamily(this.mErrorlStyle, "lucida typewriter bold");
        StyleConstants.setForeground(this.mErrorlStyle, Color.RED);
        StyleConstants.setFontSize(this.mErrorlStyle, 15);
        StyleConstants.setUnderline(this.mErrorlStyle, true);
        this.mKeywords = new HashSet<String>();
        this.mManager = editor.getmManager();
        for (String keyword : this.mManager.getAllTags()) {
            this.mKeywords.add(keyword);
        }
        this.timer = new Timer();
    }

    public void colouring(StyledDocument mDoc, int mPos, int mLen) throws BadLocationException {
        int start = this.indexOfWordStart(mDoc, mPos);
        int end = this.indexOfWordEnd(mDoc, mPos + mLen);
        while (start < end) {
            char ch = this.getCharAt(mDoc, start);
            if (Character.isLetter(ch) || ch == '_') {
                start = this.colouringWord(mDoc, start);
                continue;
            }
            SwingUtilities.invokeLater(new TextColouring(mDoc, start, 1, this.mNormalStyle));
            ++start;
        }
    }

    public int colouringWord(StyledDocument mDoc, int mPos) throws BadLocationException {
        int wordEnd = this.indexOfWordEnd(mDoc, mPos);
        String word = mDoc.getText(mPos, wordEnd - mPos);
        if (this.mKeywords.contains(word)) {
            SwingUtilities.invokeLater(new TextColouring(mDoc, mPos, wordEnd - mPos, this.mKeywordStyle));
        } else {
            SwingUtilities.invokeLater(new TextColouring(mDoc, mPos, wordEnd - mPos, this.mNormalStyle));
        }
        return wordEnd;
    }

    public char getCharAt(Document mDoc, int mPos) throws BadLocationException {
        return mDoc.getText(mPos, 1).charAt(0);
    }

    public int indexOfWordStart(Document mDoc, int mPos) throws BadLocationException {
        while (mPos > 0 && this.isWordCharacter(mDoc, mPos - 1)) {
            --mPos;
        }
        return mPos;
    }

    public int indexOfWordEnd(Document mDoc, int mPos) throws BadLocationException {
        while (this.isWordCharacter(mDoc, mPos)) {
            ++mPos;
        }
        return mPos;
    }

    public boolean isWordCharacter(Document mDoc, int mPos) throws BadLocationException {
        char ch = this.getCharAt(mDoc, mPos);
        return Character.isLetter(ch) || Character.isDigit(ch) || ch == '_';
    }

    public void coloringError(Document mDoc) {
        ArrayList<Error> errors = ErrorManager.getInstance().getErrors();
        Element root = mDoc.getDefaultRootElement();
        try {
            this.colouring((StyledDocument)mDoc, 0, mDoc.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        for (Error error : errors) {
            int row = error.getmErrorRow() - 1;
            Element para = root.getElement(row);
            if (para == null) {
                return;
            }
            int start = para.getStartOffset();
            int end = para.getEndOffset();
            SwingUtilities.invokeLater(new TextColouring((StyledDocument)mDoc, start, end - start, this.mErrorlStyle));
        }
        ErrorManager.getInstance().clearError();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        ++this.changeCount;
    }

    @Override
    public synchronized void insertUpdate(DocumentEvent e) {
        String text = null;
        try {
            if (this.isFirst) {
                text = e.getDocument().getText(0, e.getDocument().getLength() + 1);
                this.mManager.setArticle(text);
                this.coloringError(e.getDocument());
                this.isFirst = false;
            } else {
                this.event = e;
                this.timer.cancel();
                this.timer = new Timer();
                this.task = new LockTimer();
                this.timer.scheduleAtFixedRate(this.task, 500L, 99999999L);
            }
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public synchronized void removeUpdate(DocumentEvent e) {
        String text = null;
        try {
            if (this.isFirst) {
                this.colouring((StyledDocument)e.getDocument(), e.getOffset(), e.getLength());
                text = e.getDocument().getText(0, e.getDocument().getLength() + 1);
                this.mManager.setArticle(text);
                this.coloringError(e.getDocument());
                this.isFirst = false;
            } else {
                this.event = e;
                this.timer.cancel();
                this.timer = new Timer();
                this.task = new LockTimerForDelete();
                this.timer.scheduleAtFixedRate(this.task, 500L, 99999999L);
            }
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
    }

    public void actionInsert(StyledDocument mDoc, String insert, int mPos) throws BadLocationException {
        mDoc.insertString(mPos, insert, null);
    }

    public void actionRemove(StyledDocument mDoc, int mStart, int mEnd) throws BadLocationException {
        mDoc.remove(mStart, mEnd - mStart);
    }

    public int getChangeCount() {
        return this.changeCount;
    }

    public void setChangeCount(int changeCount) {
        this.changeCount = changeCount;
    }

    public void decreaseChanged() {
        if (this.changeCount > 0) {
            --this.changeCount;
        }
    }

    public void stopTimmer() {
        this.timer.cancel();
    }

    public void manuallyReSet(Document mDoc) {
        String text = null;
        try {
            text = mDoc.getText(0, mDoc.getLength() + 1);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        this.mManager.setArticle(text);
        this.stopTimmer();
    }

    public class LockTimer
    extends TimerTask {
        @Override
        public void run() {
            if (EditorListener.this.event != null) {
                String text = null;
                try {
                    text = EditorListener.this.event.getDocument().getText(0, EditorListener.this.event.getDocument().getLength() + 1);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                EditorListener.this.mManager.setArticle(text);
                EditorListener.this.coloringError(EditorListener.this.event.getDocument());
                this.cancel();
            }
        }
    }

    public class LockTimerForDelete
    extends TimerTask {
        @Override
        public void run() {
            if (EditorListener.this.event != null) {
                String text = null;
                try {
                    text = EditorListener.this.event.getDocument().getText(0, EditorListener.this.event.getDocument().getLength() + 1);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                EditorListener.this.mManager.setArticle(text);
                EditorListener.this.coloringError(EditorListener.this.event.getDocument());
                this.cancel();
            }
        }
    }
}

