/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.upsidescene;

import com.miui.theme.tool.gui.StateBar;
import com.miui.theme.tool.schema.Attribute;
import com.miui.theme.tool.schema.Schema;
import com.miui.theme.tool.schema.SchemaElement;
import com.miui.theme.tool.schema.Variable;
import com.miui.theme.tool.tagTreeBuilder.BaseElement;
import com.miui.theme.tool.tagTreeBuilder.TreeBuilder;
import com.miui.theme.tool.upsidescene.TreeHelper;
import com.miui.theme.tool.upsidescene.screen.SceneData;
import java.util.ArrayList;
import java.util.Observable;
import javax.swing.tree.DefaultMutableTreeNode;
import org.xmlpull.v1.XmlPullParserException;

public class Manager
extends Observable {
    private Schema mSchema;
    private BaseElement mRootElement;
    private TreeBuilder mBuilder;
    private BaseElement mCurrentElement;
    private TreeHelper mHelper;

    public Manager() {
        this.init();
    }

    public void setArticle(String in) {
        try {
            this.mBuilder = new TreeBuilder(in);
            this.mRootElement = this.mBuilder.getRootPoint();
            SceneData.getInstance().loadData(in);
        }
        catch (XmlPullParserException e) {
            StateBar.getInstance().setText(e.toString());
            e.printStackTrace();
        }
        this.mSendNotify();
    }

    private void init() {
        this.mSchema = Schema.getInstance();
        this.mBuilder = null;
    }

    public ArrayList<Attribute> fetchAtributesSchema() {
        if (this.mSchema == null || this.mCurrentElement == null || this.mRootElement == null) {
            return null;
        }
        ArrayList<Object> atrs = new ArrayList();
        String name = this.mCurrentElement.getTAG_NAME();
        int count = this.mSchema.tagLength(name);
        if (count == 1) {
            atrs = this.mSchema.fetchAtributes(name);
        } else if (count == 2) {
            atrs = this.mSchema.fetchAtributes(name, this.mCurrentElement.getFatherNode().getTAG_NAME());
        }
        if (atrs == null) {
            return null;
        }
        if (atrs.size() == 0) {
            return null;
        }
        return atrs;
    }

    public ArrayList<String> fetchChilds() {
        if (this.mSchema == null || this.mCurrentElement == null || this.mRootElement == null) {
            return null;
        }
        ArrayList<Object> childs = new ArrayList();
        ArrayList<String> childsList = new ArrayList<String>();
        String name = this.mCurrentElement.getTAG_NAME();
        int count = this.mSchema.tagLength(name);
        if (count == 1) {
            childs = this.mSchema.fetchChilds(name);
        } else if (count == 2) {
            childs = this.mSchema.fetchChilds(name, this.mCurrentElement.getFatherNode().getTAG_NAME());
        }
        if (childs.size() == 0) {
            return null;
        }
        for (SchemaElement.Childs childs2 : childs) {
            if (childs2.getMaxCount() != -1 && this.mCurrentElement.childCount(childs2.getName()) >= childs2.getMaxCount()) continue;
            childsList.add(childs2.getName());
        }
        return childsList;
    }

    public String fetchAttrDescription(String id) {
        if (this.mSchema == null || this.mCurrentElement == null || this.mRootElement == null) {
            return null;
        }
        String name = this.mCurrentElement.getTAG_NAME();
        return this.mSchema.fetchAttrDescription(name, id);
    }

    public String fetchChildrDescription(String id) {
        if (this.mSchema == null || this.mCurrentElement == null || this.mRootElement == null) {
            return null;
        }
        String name = this.mCurrentElement.getTAG_NAME();
        int count = this.mSchema.tagLength(name);
        if (count == 1) {
            return this.mSchema.fetchChildDescription(name, id);
        }
        if (count == 2) {
            return this.mSchema.fetchChildDescription(name, this.mCurrentElement.getFatherNode().getTAG_NAME(), id);
        }
        return null;
    }

    public void updateCurrent(int pos) {
        if (this.mRootElement != null) {
            this.mCurrentElement = this.mRootElement.fetch(pos);
            this.mSendNotify(pos);
        }
    }

    public int insertAtrPos() {
        int pos = 0;
        if (this.mCurrentElement != null) {
            int start = this.mCurrentElement.getStartPos();
            pos = start + this.mCurrentElement.getTAG_NAME().length();
        }
        return pos + 1;
    }

    public int insertChildRow() {
        int row = 0;
        if (this.mCurrentElement != null) {
            row = this.mCurrentElement.getStartRow();
        }
        return row;
    }

    public void mSendNotify() {
        this.mHelper = new TreeHelper(this.mRootElement, this.mSchema);
        this.setChanged();
        this.notifyObservers();
    }

    public void mSendNotify(Object o) {
        this.setChanged();
        this.notifyObservers(o);
    }

    public DefaultMutableTreeNode getDefaultTreeNode() {
        if (this.mHelper != null) {
            return this.mHelper.getRootTreeNode();
        }
        return null;
    }

    public ArrayList<String> getAllTags() {
        ArrayList<String> set = new ArrayList<String>();
        for (SchemaElement ele : this.mSchema.getTable()) {
            set.add(ele.getName());
        }
        return set;
    }

    public BaseElement getCurrentElement() {
        return this.mCurrentElement;
    }

    public ArrayList<Attribute> fetchNecessaryAtr(String name) {
        int count = this.mSchema.tagLength(name);
        ArrayList<Object> results = new ArrayList();
        ArrayList<Attribute> returnResults = new ArrayList<Attribute>();
        results = count == 1 ? this.mSchema.fetchAtributes(name) : this.mSchema.fetchAtributes(name, this.getCurrentElement().getTAG_NAME());
        if (results != null) {
            for (Attribute attribute : results) {
                if (!attribute.isNecessary()) continue;
                returnResults.add(attribute);
            }
            return returnResults;
        }
        return null;
    }

    public boolean hasSubElement(String name) {
        return this.mSchema.fetchChilds(name).size() != 0;
    }

    public ArrayList<Variable> getVariableList() {
        return this.mSchema.getmVariableList();
    }
}

