/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.upsidescene.screen;

import com.miui.theme.tool.apk.Activity;
import com.miui.theme.tool.apk.CacheActivityManager;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.upsidescene.screen.ComponentName;
import com.miui.theme.tool.util.ThemeHelper;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class SceneData
extends Observable {
    private static final String BOOLEAN_TRUE_VAL = "true";
    private static final int SCREEN_W = 720;
    private static final int SCREEM_H = 1280;
    public String selectedResource = "";
    public Vector<BufferedImage> selectedImages = new Vector();
    public static String ICON_TMP_PATH = "tmp" + File.separator + "icons";
    private static final String SCENE_DESCRIPTION_FILE = "scene.xml";
    private static final String SCENE_TAG = "scene";
    private static final String SCENE_SCREEN_TAG = "screen";
    private static final String SCENE_NAME_ATTR = "name";
    private static final String SCENE_VERSION_ATTR = "version";
    private static final String SCENE_WIDTH_ATTR = "width";
    private static final String SCENE_HEIGHT_ATTR = "height";
    private static final String SIZE_VAL_MATCH_PARENT = "match_parent";
    private static final int SIZE_VAL_MATCH_PARENT_VAL = -1;
    private boolean mDataLoaded = false;
    private String mName;
    private String mVersion;
    private int mWidth;
    private int mHeight;
    private float mSceneScale;
    private Screen mBackground;
    private Screen mDrift;
    private Screen mForeground;
    private Screen mDock;
    private HashMap<String, BufferedImage> mImageCache = new HashMap();
    private static volatile SceneData single;
    private static final int DEFAULT_CELL_SIZE = 135;
    private String lastData;

    private static BufferedImage resizeBufferedImage(BufferedImage source, int targetW, int targetH, boolean flag) {
        int type = source.getType();
        BufferedImage target = null;
        double sx = (double)targetW / (double)source.getWidth();
        double sy = (double)targetH / (double)source.getHeight();
        if (flag && sx > sy) {
            sx = sy;
            targetW = (int)(sx * (double)source.getWidth());
        } else if (flag && sx <= sy) {
            sy = sx;
            targetH = (int)(sy * (double)source.getHeight());
        }
        if (type == 0) {
            ColorModel cm = source.getColorModel();
            WritableRaster raster = cm.createCompatibleWritableRaster(targetW, targetH);
            boolean alphaPremultiplied = cm.isAlphaPremultiplied();
            target = new BufferedImage(cm, raster, alphaPremultiplied, null);
        } else {
            target = new BufferedImage(targetW, targetH, type);
        }
        Graphics2D g = target.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.drawRenderedImage(source, AffineTransform.getScaleInstance(sx, sy));
        g.dispose();
        return target;
    }

    public void drawImage(Graphics g, BufferedImage img, int left, int top, double rotation, double scale, boolean selectedFlag) {
        AffineTransform at = new AffineTransform();
        at.translate(left + img.getWidth() / 2, top + img.getHeight() / 2);
        rotation = rotation / 180.0 * Math.PI;
        at.rotate(rotation);
        at.scale(scale, scale);
        at.translate(-img.getWidth() / 2, -img.getHeight() / 2);
        Graphics2D g2d = (Graphics2D)g;
        g2d.drawImage(img, at, null);
        if (selectedFlag) {
            this.drawSelectedIcon(g, left, top, img.getWidth(), img.getHeight());
        }
    }

    public void addSelectedImage(BufferedImage img) {
        if (img == null) {
            return;
        }
        if (!this.selectedImages.contains(img)) {
            this.selectedImages.add(img);
        }
    }

    public void drawSelectedIcon(Graphics g, int left, int top, int width, int height) {
        g.setColor(Color.GREEN);
        int i = 0;
        while (i < 6) {
            g.drawRect(left + i, top + i, width - 2 * i, height - 2 * i);
            ++i;
        }
    }

    private SceneData() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SceneData getInstance() {
        if (single != null) return single;
        Class<SceneData> clazz = SceneData.class;
        synchronized (SceneData.class) {
            if (single != null) return single;
            single = new SceneData();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    private static BufferedImage getImageByPath(String path) {
        File f;
        block4: {
            if (path == null) {
                return null;
            }
            try {
                f = new File(path);
                if (f.exists()) break block4;
                return null;
            }
            catch (IOException e) {
                System.out.print("+");
                return null;
            }
        }
        return ImageIO.read(f);
    }

    private BufferedImage getPictureByName(String name) {
        File f;
        block3: {
            try {
                f = new File(String.valueOf(SceneData.getSceneLocation()) + File.separator + name);
                if (f.exists()) break block3;
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return ImageIO.read(f);
    }

    public static String getSceneLocation() {
        return String.valueOf(ThemeHelper.getS_themeFolderPath()) + File.separator + SceneData.getSceneFolderName();
    }

    public static String getSceneFolderName() {
        return "com.miui.home.upside";
    }

    public Screen getDriftScreen() {
        return this.mDrift;
    }

    public Screen getBackgroundScreen() {
        return this.mBackground;
    }

    public Screen getForegroundScreen() {
        return this.mForeground;
    }

    public Screen getDock() {
        return this.mDock;
    }

    public int getScreenWidth() {
        return this.mWidth;
    }

    public int getScreenHeight() {
        return this.mHeight;
    }

    private boolean copyStreamToFileIfNotExist(InputStream is, String dstFileName) {
        byte[] buffer = new byte[1024];
        int size = 0;
        OutputStream os = null;
        try {
            try {
                File outFile = new File(dstFileName);
                if (!outFile.exists()) {
                    os = new FileOutputStream(outFile);
                    while ((size = is.read(buffer)) > 0) {
                        os.write(buffer, 0, size);
                    }
                }
            }
            catch (IOException e) {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return false;
            }
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    private boolean isDigital(String d) {
        try {
            Integer.parseInt(d);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    protected int getCellSizeByScene(int cellCnt) {
        return Math.round((float)(135 * cellCnt) * this.mSceneScale);
    }

    public boolean moveToNextStartTag(XmlPullParser parser) throws XmlPullParserException, IOException {
        int eventType;
        while ((eventType = parser.next()) != 2 && eventType != 1) {
        }
        return eventType != 1;
    }

    public String getAttributeValue(XmlPullParser parser, String name) {
        String value = null;
        int i = parser.getAttributeCount() - 1;
        while (i >= 0) {
            if (name.equals(parser.getAttributeName(i))) {
                value = parser.getAttributeValue(i);
            }
            --i;
        }
        return value;
    }

    public int parseSizeValue(String value) {
        if (value.equals(SIZE_VAL_MATCH_PARENT)) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    public synchronized boolean loadData(String data) {
        this.lastData = data;
        this.mDataLoaded = false;
        try {
            this.mImageCache.clear();
            this.mBackground = null;
            this.mForeground = null;
            this.mDock = null;
            this.mSceneScale = 0.0f;
            KXmlParser parser = new KXmlParser();
            parser.setInput((Reader)new StringReader(data));
            boolean moveToNext = true;
            while (!moveToNext || this.moveToNextStartTag((XmlPullParser)parser)) {
                if (parser.getEventType() != 2) {
                    moveToNext = true;
                    continue;
                }
                String tag = parser.getName().trim();
                if (tag == null) break;
                if (SCENE_TAG.equals(tag)) {
                    int i = parser.getAttributeCount() - 1;
                    while (i >= 0) {
                        if (SCENE_NAME_ATTR.equals(parser.getAttributeName(i))) {
                            this.mName = parser.getAttributeValue(i);
                        } else if (SCENE_VERSION_ATTR.equals(parser.getAttributeName(i))) {
                            this.mVersion = parser.getAttributeValue(i);
                        } else if (SCENE_WIDTH_ATTR.equals(parser.getAttributeName(i))) {
                            this.mWidth = Integer.parseInt(parser.getAttributeValue(i));
                        } else if (SCENE_HEIGHT_ATTR.equals(parser.getAttributeName(i))) {
                            this.mHeight = Integer.parseInt(parser.getAttributeValue(i));
                        }
                        --i;
                    }
                    continue;
                }
                if (!SCENE_SCREEN_TAG.equals(tag)) continue;
                if (this.mName != null && this.mVersion != null && this.mWidth > 0 && this.mHeight > 0) {
                    Screen screen = new Screen();
                    if (screen.load((XmlPullParser)parser)) {
                        switch (screen.getType()) {
                            case 1: {
                                this.mDrift = screen;
                                break;
                            }
                            case 2: {
                                this.mBackground = screen;
                                break;
                            }
                            case 3: {
                                this.mForeground = screen;
                                break;
                            }
                            case 4: {
                                this.mDock = screen;
                            }
                        }
                        if (screen.mWidth == -1) {
                            screen.mWidth = this.mWidth;
                        }
                        if (screen.mHeight == -1) {
                            screen.mHeight = this.mHeight;
                        }
                        moveToNext = false;
                        continue;
                    }
                    parser.next();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
        }
        catch (XmlPullParserException e) {
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        boolean bl = this.mDataLoaded = this.mDrift != null;
        if (this.mDataLoaded) {
            this.setChanged();
            this.notifyObservers();
        }
        return this.mDataLoaded;
    }

    public BufferedImage[] getImages() {
        if (!this.mDataLoaded) {
            return null;
        }
        int pages = this.mDrift.mWidth / 720;
        BufferedImage drift = null;
        BufferedImage back = null;
        BufferedImage fore = null;
        BufferedImage dock = null;
        if (this.mDrift != null) {
            drift = this.mDrift.getImage();
        }
        if (this.mBackground != null) {
            back = this.mBackground.getImage();
        }
        if (this.mForeground != null) {
            fore = this.mForeground.getImage();
        }
        if (this.mDock != null) {
            dock = this.mDock.getImage();
        }
        BufferedImage[] bis = new BufferedImage[pages];
        int i = 0;
        while (i < bis.length) {
            bis[i] = new BufferedImage(this.mWidth, this.mHeight, 6);
            Graphics g = bis[i].getGraphics();
            if (back != null) {
                g.drawImage(back, 0, 0, this.mWidth, this.mHeight, (this.mBackground.mWidth - this.mWidth) * i / (pages - 1), 0, (this.mBackground.mWidth - this.mWidth) * i / (pages - 1) + this.mWidth, this.mBackground.mHeight, null);
            }
            if (drift != null) {
                g.drawImage(drift, 0, 0, this.mWidth, this.mHeight, this.mDrift.mWidth * i / pages, 0, this.mDrift.mWidth * (i + 1) / pages, this.mDrift.mHeight, null);
            }
            if (dock != null) {
                g.drawImage(dock, 0, 0, null);
            }
            if (fore != null) {
                g.drawImage(fore, 0, 0, this.mWidth, this.mHeight, (this.mForeground.mWidth - this.mWidth) * i / (pages - 1), 0, (this.mForeground.mWidth - this.mWidth) * i / (pages - 1) + this.mWidth, this.mForeground.mHeight, null);
            }
            ++i;
        }
        return bis;
    }

    public void refresh() {
        this.loadData(this.lastData);
        if (this.mDataLoaded) {
            this.notifyObservers();
        }
        this.selectedResource = "";
    }

    String getNextText(XmlPullParser xpp) {
        try {
            xpp.next();
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return xpp.getText();
    }

    public static interface Persistence {
        public static final int BUFFER_SIZE = 1024;

        public boolean load(XmlPullParser var1) throws XmlPullParserException, IOException;

        public boolean checkValidate();
    }

    public class Screen
    implements Persistence {
        private static final String SCREEN_SPRITE_TAG = "sprite";
        private static final String SCREEN_TYPE_ATTR = "type";
        private static final String SCREEN_TYPE_DRIFT_VAL = "drift";
        private static final String SCREEN_TYPE_BACKGROUND_VAL = "background";
        private static final String SCREEN_TYPE_FOREGROUND_VAL = "foreground";
        private static final String SCREEN_TYPE_DOCK_VAL = "dock";
        private static final String SCREEN_INDEX_ATTR = "index";
        private static final String SCREEN_WIDTH_ATTR = "width";
        private static final String SCREEN_HEIGHT_ATTR = "height";
        private static final String SCREEN_INTERACTION_ATTR = "interaction";
        private static final String SCREEN_PREVIEW_ATTR = "preview";
        public static final int SCREEN_TYPE_DRIFT = 1;
        public static final int SCREEN_TYPE_BACKGROUND = 2;
        public static final int SCREEN_TYPE_FOREGROUND = 3;
        public static final int SCREEN_TYPE_DOCK = 4;
        private int mType;
        private int mIndex;
        private int mWidth;
        private int mHeight;
        private boolean mInteraction = false;
        private boolean mPreview = true;
        private final SpriteComparator SC = new SpriteComparator();
        private LinkedList<Sprite> mSprites = new LinkedList();

        public int getType() {
            return this.mType;
        }

        public int getIndex() {
            return this.mIndex;
        }

        public int getWidth() {
            return this.mWidth;
        }

        public int getHeight() {
            return this.mHeight;
        }

        public boolean canInteraction() {
            return this.mInteraction;
        }

        public Collection<Sprite> getSprites() {
            return this.mSprites;
        }

        public BufferedImage getImage() {
            if (!this.mPreview) {
                return null;
            }
            BufferedImage bi = new BufferedImage(this.mWidth, this.mHeight, 6);
            for (Sprite s : this.mSprites) {
                try {
                    s.paint(bi.getGraphics());
                }
                catch (Sprite.NoPreviewException noPreviewException) {
                    // empty catch block
                }
            }
            return bi;
        }

        @Override
        public boolean checkValidate() {
            return this.mType >= 1 && this.mType <= 4;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        public boolean load(XmlPullParser parser) throws XmlPullParserException, IOException {
            i = parser.getAttributeCount() - 1;
            while (i >= 0) {
                name = parser.getAttributeName(i);
                if ("type".equals(name)) {
                    type = parser.getAttributeValue(i);
                    if (type.equals("drift")) {
                        this.mType = 1;
                    } else if (type.equals("background")) {
                        this.mType = 2;
                    } else if (type.equals("foreground")) {
                        this.mType = 3;
                    } else if (type.equals("dock")) {
                        this.mType = 4;
                    }
                } else if ("index".equals(name)) {
                    this.mIndex = Integer.parseInt(parser.getAttributeValue(i));
                } else if ("width".equals(name)) {
                    this.mWidth = SceneData.this.parseSizeValue(parser.getAttributeValue(i));
                } else if ("height".equals(name)) {
                    this.mHeight = SceneData.this.parseSizeValue(parser.getAttributeValue(i));
                } else if ("interaction".equals(name)) {
                    this.mInteraction = "true".equals(parser.getAttributeValue(i));
                } else if ("preview".equals(name)) {
                    this.mPreview = Boolean.parseBoolean(parser.getAttributeValue(i));
                }
                --i;
            }
            if (this.checkValidate()) ** GOTO lbl56
            return false;
lbl-1000:
            // 1 sources

            {
                tag = parser.getName().trim();
                sprite /* !! */  = null;
                if (!"sprite".equals(tag)) break;
                type = SceneData.this.getAttributeValue(parser, "type");
                if ("picture".equals(type)) {
                    sprite /* !! */  = new SpritePicture();
                } else if ("shortcut".equals(type)) {
                    sprite /* !! */  = new SpriteShortcut();
                } else if ("picture".equals(type)) {
                    sprite /* !! */  = new SpritePicture();
                } else if ("button".equals(type)) {
                    sprite /* !! */  = new SpriteButton();
                } else if ("widget".equals(type)) {
                    sprite /* !! */  = new SpriteWidget();
                }
                if (sprite /* !! */  == null || !sprite /* !! */ .load(parser)) continue;
                this.mSprites.push(sprite /* !! */ );
lbl56:
                // 3 sources

                ** while (SceneData.this.moveToNextStartTag((XmlPullParser)parser))
            }
lbl57:
            // 2 sources

            if (!this.mSprites.isEmpty()) {
                Collections.sort(this.mSprites, this.SC);
            }
            return true;
        }

        public String toString() {
            return "Screen:type=" + this.mType + ",index=" + this.mIndex + ",width=" + this.mWidth + ",height=" + this.mHeight + ",interaction=" + this.mInteraction + ",sprites:" + this.mSprites;
        }

        public class SpriteComparator
        implements Comparator<Sprite> {
            @Override
            public int compare(Sprite s1, Sprite s2) {
                return s1.getIndex() < s2.getIndex() ? -1 : 1;
            }
        }
    }

    public abstract class Sprite
    implements Persistence {
        private static final String SPRITE_TYPE_ATTR = "type";
        private static final String SPRITE_TYPE_PICTURE_VAL = "picture";
        private static final String SPRITE_TYPE_SHORTCUT_VAL = "shortcut";
        private static final String SPRITE_TYPE_BUTTON_VAL = "button";
        private static final String SPRITE_TYPE_WIDGET_VAL = "widget";
        public static final int SPRITE_TYPE_PICTURE = 1;
        public static final int SPRITE_TYPE_SHORTCUT = 2;
        public static final int SPRITE_TYPE_BUTTON = 3;
        public static final int SPRITE_TYPE_WIDGET = 4;
        private static final String SPRITE_INDEX_ATTR = "index";
        private static final String SPRITE_LEFT_ATTR = "left";
        private static final String SPRITE_TOP_ATTR = "top";
        private static final String SPRITE_ROTATION_ATTR = "rotation";
        private static final String SPRITE_SCALE_ATTR = "rotation";
        private static final String SPRITE_PREVIEW_ATTR = "preview";
        private int mLeft = -1;
        private int mTop = -1;
        protected int mRight = -1;
        protected int mBottom = -1;
        private int mIndex = -1;
        private double mRotation = 0.0;
        private double mScale = 1.0;
        private boolean mPreview = true;

        public abstract int getType();

        public double getRotation() {
            return this.mRotation;
        }

        public double getScale() {
            return this.mScale;
        }

        public int getLeft() {
            return this.mLeft;
        }

        public int getTop() {
            return this.mTop;
        }

        public int getRight() {
            return this.mRight;
        }

        public int getBottom() {
            return this.mBottom;
        }

        public int getIndex() {
            return this.mIndex;
        }

        public void paint(Graphics g) throws NoPreviewException {
            if (!this.mPreview) {
                throw new NoPreviewException();
            }
        }

        @Override
        public boolean load(XmlPullParser parser) throws XmlPullParserException, IOException {
            int i = parser.getAttributeCount() - 1;
            while (i >= 0) {
                String name = parser.getAttributeName(i);
                if (SPRITE_INDEX_ATTR.equals(name)) {
                    this.mIndex = Integer.parseInt(parser.getAttributeValue(i));
                } else if (SPRITE_LEFT_ATTR.equals(name)) {
                    this.mLeft = Integer.parseInt(parser.getAttributeValue(i));
                } else if (SPRITE_TOP_ATTR.equals(name)) {
                    this.mTop = Integer.parseInt(parser.getAttributeValue(i));
                } else if ("rotation".equals(name)) {
                    this.mRotation = Double.parseDouble(parser.getAttributeValue(i));
                } else if ("rotation".equals(name)) {
                    this.mScale = Double.parseDouble(parser.getAttributeValue(i));
                } else if (SPRITE_PREVIEW_ATTR.equals(name)) {
                    this.mPreview = Boolean.parseBoolean(parser.getAttributeValue(i));
                }
                --i;
            }
            return true;
        }

        @Override
        public boolean checkValidate() {
            return this.mLeft != -1 && this.mTop != -1 && this.mRight != 1 && this.mBottom != 1 && this.mIndex != -1;
        }

        class NoPreviewException
        extends Exception {
            NoPreviewException() {
            }
        }
    }

    public class SpriteButton
    extends Sprite {
        private static final String SPRITE_NORMAL_ATTR = "normal";
        private static final String SPRITE_PRESSED_ATTR = "pressed";
        private BufferedImage mNormal;
        private BufferedImage mPressed;
        private String mIntent;

        public BufferedImage getNormal() {
            return this.mNormal;
        }

        public BufferedImage getPressed() {
            return this.mPressed;
        }

        public String getIntent() {
            return this.mIntent;
        }

        @Override
        public boolean load(XmlPullParser parser) throws IOException, XmlPullParserException {
            if (super.load(parser)) {
                String normal = SceneData.this.getAttributeValue(parser, SPRITE_NORMAL_ATTR);
                String pressed = SceneData.this.getAttributeValue(parser, SPRITE_PRESSED_ATTR);
                this.mNormal = SceneData.this.getPictureByName(normal);
                this.mPressed = SceneData.this.getPictureByName(pressed);
                this.mIntent = null;
                String intent = SceneData.this.getNextText(parser);
                if (intent != null) {
                    this.mIntent = intent.trim();
                }
                int width = 0;
                int height = 0;
                if (this.mNormal != null) {
                    width = this.mNormal.getWidth();
                    height = this.mNormal.getHeight();
                }
                if (this.mPressed != null) {
                    width = Math.max(width, this.mPressed.getWidth());
                    height = Math.max(height, this.mPressed.getHeight());
                }
                this.mRight = this.getLeft() + width;
                this.mBottom = this.getTop() + height;
                if (this.checkValidate()) {
                    return true;
                }
                this.mNormal = null;
                this.mPressed = null;
                this.mIntent = null;
            }
            return false;
        }

        @Override
        public int getType() {
            return 3;
        }

        @Override
        public boolean checkValidate() {
            if (super.checkValidate()) {
                return this.mIntent != null;
            }
            return false;
        }

        @Override
        public void paint(Graphics g) throws Sprite.NoPreviewException {
            super.paint(g);
            if (this.mNormal == null) {
                return;
            }
            if (SceneData.this.selectedResource.equals(this.mIntent)) {
                SceneData.this.addSelectedImage(this.mNormal);
                SceneData.this.addSelectedImage(this.mPressed);
                SceneData.this.drawImage(g, this.mNormal, this.getLeft(), this.getTop(), this.getRotation(), this.getScale(), true);
            } else {
                SceneData.this.drawImage(g, this.mNormal, this.getLeft(), this.getTop(), this.getRotation(), this.getScale(), false);
            }
        }
    }

    public class SpritePicture
    extends Sprite {
        private BufferedImage mPicture;
        private String picturePath;

        public BufferedImage getPicture() {
            return this.mPicture;
        }

        @Override
        public boolean load(XmlPullParser parser) throws XmlPullParserException, IOException {
            this.mPicture = null;
            if (super.load(parser)) {
                this.picturePath = SceneData.this.getNextText(parser);
                if (this.picturePath != null) {
                    this.mPicture = SceneData.this.getPictureByName(this.picturePath);
                }
                if (this.mPicture != null) {
                    this.mRight = this.getLeft() + this.mPicture.getWidth();
                    this.mBottom = this.getTop() + this.mPicture.getHeight();
                }
                return this.checkValidate();
            }
            return false;
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public boolean checkValidate() {
            if (super.checkValidate()) {
                return this.mPicture != null;
            }
            return false;
        }

        @Override
        public void paint(Graphics g) throws Sprite.NoPreviewException {
            super.paint(g);
            if (SceneData.this.selectedResource.equals(this.picturePath)) {
                SceneData.this.addSelectedImage(this.mPicture);
                SceneData.this.drawImage(g, this.mPicture, this.getLeft(), this.getTop(), this.getRotation(), this.getScale(), true);
            } else {
                SceneData.this.drawImage(g, this.mPicture, this.getLeft(), this.getTop(), this.getRotation(), this.getScale(), false);
            }
        }
    }

    public class SpriteShortcut
    extends Sprite {
        private static final String SHOW_TITLE_ATTR = "show_title";
        private static final String SHOW_ICON_ATTR = "show_icon";
        private boolean mShowTitle = true;
        private boolean mShowIcon = true;
        private ComponentName mComponentName;
        private String component;
        private static final int SHORTCUT_SIZE = 135;
        private static final int SHORTCUT_CELL_SIZE = 160;

        public ComponentName getComponentName() {
            return this.mComponentName;
        }

        public void setComponentName(ComponentName name) {
            this.mComponentName = name;
        }

        public String getPackageName() {
            return this.mComponentName.getPackageName();
        }

        public String getClassName() {
            return this.mComponentName.getClassName();
        }

        public boolean isShowTitle() {
            return this.mShowTitle;
        }

        public boolean isShowIcon() {
            return this.mShowIcon;
        }

        @Override
        public boolean load(XmlPullParser parser) throws XmlPullParserException, IOException {
            if (super.load(parser)) {
                String val = SceneData.this.getAttributeValue(parser, SHOW_TITLE_ATTR);
                this.mShowTitle = SceneData.BOOLEAN_TRUE_VAL.equals(val);
                val = SceneData.this.getAttributeValue(parser, SHOW_ICON_ATTR);
                this.mShowIcon = SceneData.BOOLEAN_TRUE_VAL.equals(val);
                parser.next();
                this.component = parser.getText().trim();
                if (this.component != null) {
                    this.mComponentName = ComponentName.unflattenFromString(this.component);
                }
                return this.checkValidate();
            }
            return false;
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public boolean checkValidate() {
            if (super.checkValidate()) {
                return this.mComponentName != null;
            }
            return false;
        }

        @Override
        public void paint(Graphics g) throws Sprite.NoPreviewException {
            Activity ac;
            super.paint(g);
            int adjustX = 12;
            int adjustY = adjustX - 3;
            String path = ThemeHelper.getIconByFileName(String.valueOf(this.getClassName()) + ".png");
            BufferedImage img = SceneData.getImageByPath(path);
            if (img == null && !(ac = new Activity(this.getPackageName(), this.getClassName())).getName().startsWith(ac.getPkgName()) && (path = ThemeHelper.getIconByFileName(ac.getThemeIcon())) != null) {
                img = SceneData.getImageByPath(path);
            }
            CacheActivityManager fam = CacheActivityManager.getInstance();
            if (img == null && (path = fam.getIconPathByComponentNameClassFirst(this.mComponentName)) != null) {
                img = SceneData.getImageByPath(path);
            }
            if (img == null && (path = ThemeHelper.getIconByFileName(String.valueOf(this.getPackageName()) + ".png")) != null) {
                img = SceneData.getImageByPath(path);
            }
            if (img == null && (path = fam.getIconPathByComponentName(this.mComponentName)) != null) {
                img = SceneData.getImageByPath(path);
            }
            if (img != null) {
                img = SceneData.resizeBufferedImage(img, 135, 135, false);
                if (SceneData.this.selectedResource.equals(this.component)) {
                    SceneData.this.addSelectedImage(img);
                }
                SceneData.this.drawImage(g, img, this.getLeft() + adjustX, this.getTop() + adjustY, this.getRotation(), this.getScale(), false);
                if (SceneData.this.selectedResource.equals(this.component)) {
                    SceneData.this.drawSelectedIcon(g, this.getLeft(), this.getTop(), 160, 160);
                }
                return;
            }
            g.setColor(Color.ORANGE);
            g.drawRect(this.getLeft() + adjustX, this.getTop() + adjustY, 135, 135);
            InputStream is = ResourceFactory.getInstance().getImageSream("placeholder.png");
            try {
                BufferedImage bi = ImageIO.read(is);
                g.drawImage(bi, this.getLeft() + adjustX, this.getTop() + adjustY, 135, 135, null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (SceneData.this.selectedResource.equals(this.component)) {
                SceneData.this.drawSelectedIcon(g, this.getLeft(), this.getTop(), 160, 160);
            }
        }
    }

    public class SpriteWidget
    extends Sprite {
        private static final String SPANX_ATTR = "spanx";
        private static final String SPANY_ATTR = "spany";
        private String mWidgetLocation;
        private int spanx = 1;
        private int spany = 1;

        public int getSystemWidgetId() {
            int widgetId = -1;
            try {
                widgetId = Integer.parseInt(this.mWidgetLocation);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return widgetId;
        }

        public String getWidgetLocation() {
            return this.mWidgetLocation;
        }

        public void setSystemWidgetId(int id) {
            this.mWidgetLocation = String.valueOf(id);
        }

        public void setWidgetLocation(String location) {
            this.mWidgetLocation = location;
        }

        @Override
        public boolean load(XmlPullParser parser) throws XmlPullParserException, IOException {
            if (super.load(parser)) {
                String widget;
                this.mWidgetLocation = null;
                int i = parser.getAttributeCount() - 1;
                while (i >= 0) {
                    String name = parser.getAttributeName(i);
                    if (SPANX_ATTR.equals(name)) {
                        this.spanx = Integer.parseInt(parser.getAttributeValue(i));
                    } else if (SPANY_ATTR.equals(name)) {
                        this.spany = Integer.parseInt(parser.getAttributeValue(i));
                    }
                    --i;
                }
                if (this.mWidgetLocation == null && (widget = SceneData.this.getNextText(parser).trim()) != null) {
                    this.mWidgetLocation = widget;
                }
                return this.checkValidate();
            }
            return false;
        }

        @Override
        public int getType() {
            return 4;
        }

        @Override
        public boolean checkValidate() {
            if (super.checkValidate()) {
                return this.mWidgetLocation != null;
            }
            return false;
        }

        @Override
        public void paint(Graphics g) throws Sprite.NoPreviewException {
            super.paint(g);
            int width = 135 * this.spanx;
            int height = 135 * this.spany;
            String path = String.valueOf(SceneData.getSceneLocation()) + File.separator + this.mWidgetLocation;
            File f = new File(path);
            ZipFile zf = null;
            if (f.exists()) {
                try {
                    zf = new ZipFile(f);
                    ZipEntry entryPreview = this.getCover(zf);
                    if (!entryPreview.isDirectory()) {
                        InputStream is = zf.getInputStream(entryPreview);
                        BufferedImage img = ImageIO.read(is);
                        if (SceneData.this.selectedResource.equals(this.mWidgetLocation)) {
                            SceneData.this.addSelectedImage(img);
                            SceneData.this.drawImage(g, img, this.getLeft(), this.getTop(), this.getRotation(), this.getScale(), true);
                        } else {
                            SceneData.this.drawImage(g, img, this.getLeft(), this.getTop(), this.getRotation(), this.getScale(), false);
                        }
                        return;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (NullPointerException e) {
                    System.out.print("w");
                }
                finally {
                    try {
                        if (zf != null) {
                            zf.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            g.setColor(Color.ORANGE);
            g.fillRect(this.getLeft(), this.getTop(), width, height);
            SceneData.this.drawSelectedIcon(g, this.getLeft(), this.getTop(), width, height);
        }

        private ZipEntry getCover(ZipFile zf) {
            ZipEntry entryPreview = zf.getEntry("preview/cover.jpg");
            if (entryPreview == null) {
                entryPreview = zf.getEntry("preview/cover.png");
            }
            if (entryPreview == null) {
                entryPreview = zf.getEntry("preview/0.jpg");
            }
            if (entryPreview == null) {
                entryPreview = zf.getEntry("preview/0.png");
            }
            return entryPreview;
        }
    }
}

