/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.util;

import com.miui.theme.tool.util.ThemeResourceConstants;
import java.util.HashMap;
import java.util.Map;

public class ConstantsHelper
implements ThemeResourceConstants {
    private static Map<String, Long> sCodeTypeMap = new HashMap<String, Long>();
    private static Map<String, String> sCodeIdentityMap = new HashMap<String, String>();
    private static Map<String, String> sCodePreviewAliasMap = new HashMap<String, String>();
    private static Map<String, Integer> sCodeVersionMap = new HashMap<String, Integer>();
    private static Map<String, String> sCodeStampMap = new HashMap<String, String>();
    private static Map<Long, String> sTypeCodeMap = new HashMap<Long, String>();
    private static Map<String, String> sIdentityCodeMap = new HashMap<String, String>();

    static {
        sCodeTypeMap.put("theme", -1L);
        sCodeTypeMap.put("alarm", 1024L);
        sCodeTypeMap.put("audioeffect", 32768L);
        sCodeTypeMap.put("bootanimation", 32L);
        sCodeTypeMap.put("bootaudio", 64L);
        sCodeTypeMap.put("clock_", 65536L);
        sCodeTypeMap.put("contact", 2048L);
        sCodeTypeMap.put("fonts", 16L);
        sCodeTypeMap.put("fonts_fallback", 262144L);
        sCodeTypeMap.put("framework", 1L);
        sCodeTypeMap.put("icons", 8L);
        sCodeTypeMap.put("launcher", 16384L);
        sCodeTypeMap.put("lockscreen", 4L);
        sCodeTypeMap.put("lockstyle", 4096L);
        sCodeTypeMap.put("mms", 128L);
        sCodeTypeMap.put("notification", 512L);
        sCodeTypeMap.put("photoframe_", 131072L);
        sCodeTypeMap.put("ringtone", 256L);
        sCodeTypeMap.put("statusbar", 8192L);
        sCodeTypeMap.put("wallpaper", 2L);
        for (String code : sCodeTypeMap.keySet()) {
            sTypeCodeMap.put(sCodeTypeMap.get(code), code);
        }
        sCodeTypeMap.put("clock_1x2", 65536L);
        sCodeTypeMap.put("clock_2x2", 65536L);
        sCodeTypeMap.put("clock_2x4", 65536L);
        sCodeTypeMap.put("clock_4x4", 65536L);
        sCodeTypeMap.put("photoframe_1x2", 131072L);
        sCodeTypeMap.put("photoframe_2x2", 131072L);
        sCodeTypeMap.put("photoframe_2x4", 131072L);
        sCodeTypeMap.put("photoframe_4x4", 131072L);
        sCodeTypeMap.put("com.miui.home.upside", 16384L);
        sCodeIdentityMap.put("alarm", COMPONENT_IDENTITY_ALARM);
        sCodeIdentityMap.put("bootanimation", COMPONENT_IDENTITY_BOOT_ANIMATION);
        sCodeIdentityMap.put("bootaudio", COMPONENT_IDENTITY_BOOT_AUDIO);
        sCodeIdentityMap.put("contact", "com.android.contacts");
        sCodeIdentityMap.put("fonts", COMPONENT_IDENTITY_FONT);
        sCodeIdentityMap.put("fonts_fallback", COMPONENT_IDENTITY_FONT_FALLBACK);
        sCodeIdentityMap.put("framework", "framework-res");
        sCodeIdentityMap.put("launcher", "com.miui.home");
        sCodeIdentityMap.put("lockscreen", COMPONENT_IDENTITY_LOCKSCREEN);
        sCodeIdentityMap.put("lockstyle", "lockscreen");
        sCodeIdentityMap.put("mms", "com.android.mms");
        sCodeIdentityMap.put("notification", COMPONENT_IDENTITY_NOTIFICATION);
        sCodeIdentityMap.put("ringtone", COMPONENT_IDENTITY_RINGTONE);
        sCodeIdentityMap.put("statusbar", "com.android.systemui");
        sCodeIdentityMap.put("wallpaper", COMPONENT_IDENTITY_WALLPAPER);
        sCodePreviewAliasMap.put("bootanimation", "preview_animation_");
        sCodePreviewAliasMap.put("clock_", "preview_clock_");
        sCodePreviewAliasMap.put("contact", "preview_contact_");
        sCodePreviewAliasMap.put("fonts", "preview_fonts_");
        sCodePreviewAliasMap.put("framework", "preview_");
        sCodePreviewAliasMap.put("icons", "preview_icons_");
        sCodePreviewAliasMap.put("launcher", "preview_launcher_");
        sCodePreviewAliasMap.put("lockstyle", "preview_lockscreen_");
        sCodePreviewAliasMap.put("mms", "preview_mms_");
        sCodePreviewAliasMap.put("photoframe_", "preview_photo_frame_");
        sCodePreviewAliasMap.put("statusbar", "preview_statusbar_");
        sCodeStampMap.put("theme", "Compound");
        sCodeStampMap.put("alarm", "AlarmAudio");
        sCodeStampMap.put("audioeffect", "AudioEffect");
        sCodeStampMap.put("bootanimation", "BootAnimation");
        sCodeStampMap.put("bootaudio", "BootAudio");
        sCodeStampMap.put("clock_", "Clock");
        sCodeStampMap.put("contact", "Contact");
        sCodeStampMap.put("fonts", "Font");
        sCodeStampMap.put("fonts_fallback", "FontFallback");
        sCodeStampMap.put("framework", "FrameWork");
        sCodeStampMap.put("icons", "Icon");
        sCodeStampMap.put("launcher", "Launcher");
        sCodeStampMap.put("lockscreen", "LockScreenWallpaper");
        sCodeStampMap.put("lockstyle", "LockStyle");
        sCodeStampMap.put("mms", "Mms");
        sCodeStampMap.put("notification", "NotificationAudio");
        sCodeStampMap.put("photoframe_", "PhotoFrame");
        sCodeStampMap.put("ringtone", "RingtoneAudio");
        sCodeStampMap.put("statusbar", "StatusBar");
        sCodeStampMap.put("wallpaper", "DeskWallpaper");
        sCodeVersionMap.put("theme", 2);
        sCodeVersionMap.put("alarm", 0);
        sCodeVersionMap.put("audioeffect", 0);
        sCodeVersionMap.put("bootanimation", 0);
        sCodeVersionMap.put("bootaudio", 0);
        sCodeVersionMap.put("clock_", 0);
        sCodeVersionMap.put("contact", 2);
        sCodeVersionMap.put("fonts", 0);
        sCodeVersionMap.put("fonts_fallback", 0);
        sCodeVersionMap.put("framework", 0);
        sCodeVersionMap.put("icons", 0);
        sCodeVersionMap.put("launcher", 1);
        sCodeVersionMap.put("lockscreen", 0);
        sCodeVersionMap.put("lockstyle", 0);
        sCodeVersionMap.put("mms", 2);
        sCodeVersionMap.put("notification", 0);
        sCodeVersionMap.put("photoframe_", 2);
        sCodeVersionMap.put("ringtone", 0);
        sCodeVersionMap.put("statusbar", 2);
        sCodeVersionMap.put("wallpaper", 0);
        for (String code : sCodeIdentityMap.keySet()) {
            sIdentityCodeMap.put(sCodeIdentityMap.get(code), code);
        }
    }

    private ConstantsHelper() {
    }

    public static Map<String, String> getComponentIdentityCodeMap() {
        return sIdentityCodeMap;
    }

    public static long getComponentType(String code) {
        Long type = sCodeTypeMap.get(code);
        return type != null ? type : 0L;
    }

    public static String getComponentCode(long type) {
        String result = sTypeCodeMap.get(type);
        return result != null ? result : "";
    }

    public static String getComponentCode(String identity) {
        String result = sIdentityCodeMap.get(identity);
        return result != null ? result : identity;
    }

    public static String getComponentIdentity(long type) {
        return ConstantsHelper.getComponentIdentity(ConstantsHelper.getComponentCode(type));
    }

    public static String getComponentIdentity(String code) {
        String result = sCodeIdentityMap.get(code);
        return result != null ? result : code;
    }

    public static String getComponentStamp(long type) {
        return ConstantsHelper.getComponentStamp(ConstantsHelper.getComponentCode(type));
    }

    public static String getComponentStamp(String code) {
        String result = sCodeStampMap.get(code);
        return result != null ? result : code;
    }

    public static int getComponentUIVersion(long type) {
        return ConstantsHelper.getComponentUIVersion(ConstantsHelper.getComponentCode(type));
    }

    public static int getComponentUIVersion(String code) {
        Integer result = sCodeVersionMap.get(code);
        return result != null ? result : 0;
    }

    public static String getComponentPreviewPrefix(long type) {
        String code = ConstantsHelper.getComponentCode(type);
        return ConstantsHelper.getComponentPreviewPrefix(code);
    }

    public static String getComponentPreviewPrefix(String code) {
        String result = sCodePreviewAliasMap.get(code);
        return result != null ? result : "preview_" + code + '_';
    }
}

