/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.util;

import com.miui.theme.tool.gui.MainFrame;
import com.miui.theme.tool.util.JPEGOutputUtil;
import com.miui.theme.tool.util.NinePatchEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class GUIUtil {
    public static final Color BLACK = GUIUtil.hex2color("#FF000000");
    public static int HDPI_SIZE = 90;
    public static int XHDPI_SIZE = 136;

    public static void alert(String str) {
        JOptionPane.showMessageDialog(MainFrame.getInstance(), str);
    }

    public static void alert(String str, Component c) {
        JOptionPane.showMessageDialog(c, str);
    }

    public static void fixSize(Container c, Dimension d) {
        c.setPreferredSize(d);
        c.setMinimumSize(d);
        c.setMaximumSize(d);
        c.setSize(d);
    }

    public static ImageIcon getIcon(File f) {
        return GUIUtil.getIcon(f, 4);
    }

    public static ImageIcon getIcon(File f, int scaleType) {
        return GUIUtil.getIcon(f, HDPI_SIZE, scaleType);
    }

    public static ImageIcon getIcon(File f, int maxSize, int scaleType) {
        if (!f.exists()) {
            return new ImageIcon();
        }
        return GUIUtil.getIcon(GUIUtil.getImage(f), maxSize, scaleType);
    }

    public static ImageIcon getIcon(Image image, int maxSize, int scaleType) {
        return new ImageIcon(GUIUtil.scaleImage(image, maxSize, scaleType));
    }

    public static Image scaleImage(Image image, int maxSize) {
        return GUIUtil.scaleImage(image, maxSize, 4);
    }

    public static Image scaleImage(Image image, int maxSize, int scaleType) {
        if (image.getWidth(null) > maxSize) {
            int h = (int)(1.0 * (double)image.getHeight(null) / (double)image.getWidth(null) * (double)maxSize);
            if (h <= 0) {
                h = image.getHeight(null);
            }
            image = image.getScaledInstance(maxSize, h, 4);
        }
        if (image.getHeight(null) > maxSize) {
            int w = (int)(1.0 * (double)image.getWidth(null) / (double)image.getHeight(null) * (double)maxSize);
            if (w <= 0) {
                w = image.getWidth(null);
            }
            image = image.getScaledInstance(w, maxSize, scaleType);
        }
        return image;
    }

    public static BufferedImage getImage(InputStream is) {
        try {
            BufferedImage image = ImageIO.read(is);
            is.close();
            return image;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedImage getImage(File f) {
        if (!f.exists()) {
            return null;
        }
        try {
            FileInputStream fis = new FileInputStream(f);
            BufferedImage image = ImageIO.read(fis);
            fis.close();
            return image;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedImage getImage(String path) {
        return GUIUtil.getImage(new File(path));
    }

    public static void fixPosition(Container c, int w, int h) {
        int x = MainFrame.getInstance().getX();
        int y = MainFrame.getInstance().getY();
        int width = MainFrame.getInstance().getWidth();
        int height = MainFrame.getInstance().getHeight();
        if (width > w) {
            x += (width - w) / 2;
        }
        if (height > h) {
            y += (height - h) / 2;
        }
        c.setBounds(x, y, w, h);
    }

    public static void saveImage(Image image, File f) {
        BufferedImage bi = new BufferedImage(image.getWidth(null), image.getHeight(null), 6);
        Graphics2D g2 = (Graphics2D)bi.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(image, 0, 0, null);
        g2.dispose();
        GUIUtil.saveImage(bi, f);
    }

    public static void saveImage(BufferedImage bi, File f) {
        GUIUtil.saveImage(bi, f, 1.0f);
    }

    public static void saveImage(BufferedImage bi, File f, float quality) {
        try {
            f.getParentFile().mkdirs();
            String filePath = f.getAbsolutePath();
            if (filePath.endsWith(".jpg")) {
                JPEGOutputUtil.compressJpegFile(f, bi, quality);
            } else if (filePath.endsWith(".png")) {
                FileOutputStream fos = new FileOutputStream(f);
                if (!ImageIO.write((RenderedImage)bi, "PNG", fos)) {
                    fos.close();
                    throw new IOException("Failed to find png writer");
                }
                fos.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Color hex2color(String colorStr) {
        if (colorStr == null) {
            return null;
        }
        if (!colorStr.startsWith("#")) {
            return null;
        }
        if (colorStr.length() == 7) {
            return new Color(Integer.valueOf(colorStr.substring(1, 3), 16), Integer.valueOf(colorStr.substring(3, 5), 16), Integer.valueOf(colorStr.substring(5, 7), 16));
        }
        if (colorStr.length() == 9) {
            return new Color(Integer.valueOf(colorStr.substring(3, 5), 16), Integer.valueOf(colorStr.substring(5, 7), 16), Integer.valueOf(colorStr.substring(7, 9), 16), Integer.valueOf(colorStr.substring(1, 3), 16));
        }
        return null;
    }

    public static String color2hex(Color color) {
        StringBuffer sb = new StringBuffer();
        String A = Integer.toHexString(color.getAlpha());
        String R = Integer.toHexString(color.getRed());
        String G = Integer.toHexString(color.getGreen());
        String B = Integer.toHexString(color.getBlue());
        A = A.length() == 1 ? "0" + A : A;
        R = R.length() == 1 ? "0" + R : R;
        G = G.length() == 1 ? "0" + G : G;
        B = B.length() == 1 ? "0" + B : B;
        sb.append("#");
        sb.append(A);
        sb.append(R);
        sb.append(G);
        sb.append(B);
        return sb.toString();
    }

    public static String color2hexNoAlpha(Color color) {
        StringBuffer sb = new StringBuffer();
        String R = Integer.toHexString(color.getRed());
        String G = Integer.toHexString(color.getGreen());
        String B = Integer.toHexString(color.getBlue());
        R = R.length() == 1 ? "0" + R : R;
        G = G.length() == 1 ? "0" + G : G;
        B = B.length() == 1 ? "0" + B : B;
        sb.append("#");
        sb.append(R);
        sb.append(G);
        sb.append(B);
        return sb.toString();
    }

    public static void openNinePatch(String imgPath) {
        NinePatchEditor npe = new NinePatchEditor(imgPath);
        npe.setVisible(true);
    }

    public static void layout(Window w, Window parent, int width, int height) {
        w.setBounds(parent.getX() + (parent.getWidth() - width) / 2, parent.getY() + (parent.getHeight() - height) / 2, width, height);
    }
}

