/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.util;

import com.miui.theme.tool.util.ImageHelper;
import java.awt.image.BufferedImage;

public class SimilarImageSearch {
    public static int hammingDistance(String sourceHashCode, String hashCode) {
        int difference = 0;
        int len = sourceHashCode.length();
        int i = 0;
        while (i < len) {
            if (sourceHashCode.charAt(i) != hashCode.charAt(i)) {
                ++difference;
            }
            ++i;
        }
        return difference;
    }

    public static String produceFingerPrint(BufferedImage source) {
        int width = 8;
        int height = 8;
        BufferedImage thumb = ImageHelper.thumb(source, width, height, false);
        int[] pixels = new int[width * height];
        int i = 0;
        while (i < width) {
            int j = 0;
            while (j < height) {
                pixels[i * height + j] = ImageHelper.rgbToGray(thumb.getRGB(i, j));
                ++j;
            }
            ++i;
        }
        int avgPixel = ImageHelper.average(pixels);
        int[] comps = new int[width * height];
        int i2 = 0;
        while (i2 < comps.length) {
            comps[i2] = pixels[i2] >= avgPixel ? 1 : 0;
            ++i2;
        }
        StringBuffer hashCode = new StringBuffer();
        int i3 = 0;
        while (i3 < comps.length) {
            int result = comps[i3] * (int)Math.pow(2.0, 3.0) + comps[i3 + 1] * (int)Math.pow(2.0, 2.0) + comps[i3 + 2] * (int)Math.pow(2.0, 1.0) + comps[i3 + 2];
            hashCode.append(SimilarImageSearch.binaryToHex(result));
            i3 += 4;
        }
        return hashCode.toString();
    }

    private static char binaryToHex(int binary) {
        char ch = ' ';
        switch (binary) {
            case 0: {
                ch = '0';
                break;
            }
            case 1: {
                ch = '1';
                break;
            }
            case 2: {
                ch = '2';
                break;
            }
            case 3: {
                ch = '3';
                break;
            }
            case 4: {
                ch = '4';
                break;
            }
            case 5: {
                ch = '5';
                break;
            }
            case 6: {
                ch = '6';
                break;
            }
            case 7: {
                ch = '7';
                break;
            }
            case 8: {
                ch = '8';
                break;
            }
            case 9: {
                ch = '9';
                break;
            }
            case 10: {
                ch = 'a';
                break;
            }
            case 11: {
                ch = 'b';
                break;
            }
            case 12: {
                ch = 'c';
                break;
            }
            case 13: {
                ch = 'd';
                break;
            }
            case 14: {
                ch = 'e';
                break;
            }
            case 15: {
                ch = 'f';
                break;
            }
            default: {
                ch = ' ';
            }
        }
        return ch;
    }
}

