/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.util;

import com.miui.theme.tool.icons.IconManager;
import com.miui.theme.tool.os.CmdUtils;
import com.miui.theme.tool.os.OS;
import com.miui.theme.tool.update.VersionFile;
import com.miui.theme.tool.util.ThemeConf;
import java.awt.Desktop;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;

public class ThemeHelper {
    public static String CHARSET = "utf-8";
    public static String DATA_FOLDER = "data";
    public static final String PNGSuffix = ".png";
    public static final String JPEGSuffix = ".jpg";
    public static final String COMPONENT_IDENTITY_ICON = "icons";
    public static final String COMPONENT_IDENTITY_FRAMEWORK_MIUI = "framework-miui-res";
    public static final String COMPONENT_IDENTITY_FRAMEWORK = "framework-res";
    public static final String THEME_VALUES_FILE = "theme_values.xml";
    public static final String THEME_VALUES_PACKAGE_ANDROID = "android";
    public static final String THEME_VALUES_PACKAGE_MIUI = "miui";
    public static final String DRAWABLE_XXHDPI = "drawable-xxhdpi";
    public static final String DRAWABLE_XHDPI = "drawable-xhdpi";
    public static final String DRAWABLE_HDPI = "drawable-hdpi";
    public static final String WIKI_URL_DOMAIN = "wiki.dev.xiaomi.com";
    public static final String WIKI_URL_SCRIPT = "";
    public static final String WIKI_URL_SITEENDPOINT = "http://wiki.dev.xiaomi.com";
    public static final String WIKI_URL_BROWSEENDPOINT = "http://wiki.dev.xiaomi.com/index.php?title=";
    public static final String THEME_VALUES = "theme_values/";
    private static final String LAST_CLOSED = "configuration" + File.separator + "lastclosed";
    public static final int ROM_VERSION_2_3 = 1;
    public static final int ROM_VERSION_4_0 = 2;
    public static final int ROM_VERSION_5_0 = 3;
    public static final int ROM_VERSION_UNKNOWN = -1;
    public static final String[] UI_VERSION_LABEL = new String[]{"2.3", "V4", "V5"};
    public static final String[] UI_VERSION_VALUE = new String[]{"1", "2", "3"};
    public static HashMap<String, String> sUiVersionMap = new HashMap();
    public static int sThemeVersion;
    public static HashMap<String, String> sLastClosedInfo;
    public static final String LASTCLOSEDINFO_MTZ_PATH = "mtzPath";
    public static final String LASTCLOSEDINFO_MTZ_NAME = "mtzName";
    public static final String LASTCLOSEDINFO_ICON_PATH = "iconPath";
    public static final String LASTCLOSEDINFO_APK_PATH = "apkPath";
    public static final String LASTCLOSEDINFO_LANGUAGE = "language";
    public static final String LASTCLOSEDINFO_FRAME_HEIGHT = "frameHeight";
    public static final String LASTCLOSEDINFO_FRAME_WIDTH = "frameWidth";
    public static final String LASTCLOSEDINFO_FRAME_X = "frameX";
    public static final String LASTCLOSEDINFO_FRAME_Y = "frameY";
    public static String sThemeFolderPath;
    public static String sThemeFilePath;
    public static boolean sIsEditMtz;
    public static boolean sExtractMtzCompleted;
    public static Vector<String> sVcSelected;
    public static String sThemeName;
    public static HashMap<String, String> sEng2CnMap;
    private static final String LASTCLOSED_SEP = "\n";
    static boolean sReadFlag;
    public static String NINE_PATCH_SUFFIX;
    static HashMap<String, String> sIconsMapToOld;
    public static final String COMPLETE_FLAG_FILE = "complete";

    static {
        sUiVersionMap.put(UI_VERSION_VALUE[0], UI_VERSION_LABEL[0]);
        sUiVersionMap.put(UI_VERSION_VALUE[1], UI_VERSION_LABEL[1]);
        sUiVersionMap.put(UI_VERSION_VALUE[2], UI_VERSION_LABEL[2]);
        sThemeVersion = 1;
        sLastClosedInfo = new HashMap();
        sThemeFolderPath = WIKI_URL_SCRIPT;
        sThemeFilePath = WIKI_URL_SCRIPT;
        sIsEditMtz = false;
        sExtractMtzCompleted = false;
        sVcSelected = null;
        sThemeName = WIKI_URL_SCRIPT;
        sEng2CnMap = new HashMap();
        sReadFlag = false;
        NINE_PATCH_SUFFIX = ".9.png";
        sIconsMapToOld = new HashMap();
        sIconsMapToOld.put("com.wali.miui.networkassistant.png", "com.android.monitor.png");
        sIconsMapToOld.put("com.xiaomi.market.png", "com.miui.supermarket.png");
    }

    public static String getS_themeFolderPath() {
        return sThemeFolderPath;
    }

    public static void readLastClosedInfo() {
        if (sReadFlag) {
            return;
        }
        sReadFlag = true;
        try {
            String str = WIKI_URL_SCRIPT;
            sLastClosedInfo.put(LASTCLOSEDINFO_MTZ_PATH, ThemeHelper.getUserDir());
            File file = new File(LAST_CLOSED);
            if (!file.exists()) {
                file.createNewFile();
            } else {
                String[] infos;
                FileInputStream fis = new FileInputStream(file);
                str = IOUtils.toString(fis);
                fis.close();
                if (str != null && (infos = str.split(LASTCLOSED_SEP)) != null) {
                    int i = 0;
                    while (i < infos.length) {
                        String s = infos[i];
                        String[] keyValue = s.split("\\$\\$");
                        if (keyValue != null && keyValue.length == 2) {
                            sLastClosedInfo.put(keyValue[0], keyValue[1]);
                        }
                        ++i;
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeLastClosedInfo() {
        try {
            if (sLastClosedInfo == null || sLastClosedInfo.isEmpty()) {
                return;
            }
            Set<String> keys = sLastClosedInfo.keySet();
            String str = WIKI_URL_SCRIPT;
            for (String key : keys) {
                str = String.valueOf(str) + key + "$$" + sLastClosedInfo.get(key);
                str = String.valueOf(str) + LASTCLOSED_SEP;
            }
            if (str.endsWith(LASTCLOSED_SEP)) {
                str = str.substring(0, str.length() - LASTCLOSED_SEP.length());
            }
            FileOutputStream fout = new FileOutputStream(LAST_CLOSED);
            fout.write(str.getBytes());
            fout.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isNinePatchName(String name) {
        return name.toLowerCase().endsWith(NINE_PATCH_SUFFIX);
    }

    public static boolean isLegalThemeFolder(String themePath) {
        if (themePath == null || WIKI_URL_SCRIPT.equals(themePath) || !new File(themePath).exists() || !new File(themePath).isDirectory()) {
            return false;
        }
        return new File(String.valueOf(themePath) + File.separator + "description.xml").exists();
    }

    public static int getRomUIVersion() {
        int version = -1;
        boolean flag = CmdUtils.adb_pull("/system/build.prop");
        if (!flag) {
            return version;
        }
        String val = ThemeHelper.getBuildProp("ro.miui.ui.version.code");
        if (val != null) {
            try {
                return Integer.parseInt(val);
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
        }
        if ((val = ThemeHelper.getBuildProp("ro.build.version.release")) != null) {
            if (val.startsWith("2")) {
                version = 1;
            } else if (val.startsWith("4")) {
                version = 2;
            }
        }
        return version;
    }

    public static String getBuildProp(String key) {
        boolean flag = CmdUtils.adb_pull("/system/build.prop");
        if (!flag) {
            return null;
        }
        File f = new File("build.prop");
        if (f.exists()) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
                String line = br.readLine();
                while (line != null && !line.contains(key)) {
                    line = br.readLine();
                }
                if (line != null && line.contains("=")) {
                    String string = line.substring(line.indexOf("=") + 1, line.length());
                    return string;
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                OS.rmFile("build.prop");
            }
        }
        return null;
    }

    public static String getRomIncrementalVersion() {
        String incrementalVersion = ThemeHelper.getBuildProp("ro.build.version.incremental");
        if (incrementalVersion == null) {
            incrementalVersion = WIKI_URL_SCRIPT;
        }
        return incrementalVersion;
    }

    public static boolean isLegalThemeFile(File file) {
        if (file == null) {
            return false;
        }
        if (!file.getName().toLowerCase().endsWith(".mtz")) {
            return false;
        }
        return file.isFile();
    }

    public static void saveMtzInfo(File f) {
        if (f.getParent() != null) {
            sLastClosedInfo.put(LASTCLOSEDINFO_MTZ_PATH, f.getParent());
            sLastClosedInfo.put(LASTCLOSEDINFO_MTZ_NAME, f.getName());
        }
    }

    public static boolean startWidthNetName(String name) {
        String[] nameList = new String[]{"com", "org", "net", "info", "gov", "edu", "tv", "cn", "cc", "me"};
        int i = 0;
        while (i < nameList.length) {
            if (name.startsWith(String.valueOf(nameList[i]) + ".")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String getIconByFileName(String name) {
        String path = String.valueOf(sThemeFolderPath) + File.separator + IconManager.PATH_XHDPI + File.separator + name;
        File f = new File(path);
        if (f.exists()) {
            return f.getAbsolutePath();
        }
        path = String.valueOf(sThemeFolderPath) + File.separator + IconManager.PATH_HDPI + File.separator + name;
        f = new File(path);
        if (f.exists()) {
            return f.getAbsolutePath();
        }
        path = String.valueOf(sThemeFolderPath) + File.separator + COMPONENT_IDENTITY_ICON + File.separator + name;
        f = new File(path);
        if (f.exists()) {
            return f.getAbsolutePath();
        }
        if (sIconsMapToOld.get(name) != null) {
            return ThemeHelper.getIconByFileName(sIconsMapToOld.get(name));
        }
        return null;
    }

    public static String getUserDir() {
        return System.getProperty("user.dir");
    }

    public static void copyFile(File sourceFile, File targetFile) throws IOException {
        BufferedInputStream inBuff = null;
        FilterOutputStream outBuff = null;
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            int len;
            fis = new FileInputStream(sourceFile);
            inBuff = new BufferedInputStream(fis);
            fos = new FileOutputStream(targetFile);
            outBuff = new BufferedOutputStream(fos);
            byte[] b = new byte[5120];
            while ((len = inBuff.read(b)) != -1) {
                ((BufferedOutputStream)outBuff).write(b, 0, len);
            }
            ((BufferedOutputStream)outBuff).flush();
            fos.close();
        }
        finally {
            if (inBuff != null) {
                inBuff.close();
                fis.close();
            }
            if (outBuff != null) {
                outBuff.close();
                fos.close();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long getFileSizes(File f) {
        long s = 0L;
        if (!f.exists()) return -1L;
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(f);
                s = fis.available();
                fis.close();
                return s;
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (fis == null) return s;
                    fis.close();
                    return s;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            return s;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String formetFileSize(long fileS) {
        DecimalFormat df = new DecimalFormat("#.00");
        String fileSizeString = WIKI_URL_SCRIPT;
        fileSizeString = fileS < 1024L ? String.valueOf(df.format((double)fileS)) + "B" : (fileS < 0x100000L ? String.valueOf(df.format((double)fileS / 1024.0)) + "K" : (fileS < 0x40000000L ? String.valueOf(df.format((double)fileS / 1048576.0)) + "M" : String.valueOf(df.format((double)fileS / 1.073741824E9)) + "G"));
        return fileSizeString;
    }

    public static String getTemplatePath() {
        File templatesDir;
        String templatesPath = ThemeHelper.getUserDir();
        String templatesConfPath = ThemeConf.getConf("common", "template");
        if (!templatesConfPath.isEmpty()) {
            templatesPath = templatesConfPath;
        }
        if (!(templatesDir = new File(templatesPath = String.valueOf(templatesPath) + File.separator + "templates_" + sUiVersionMap.get(WIKI_URL_SCRIPT + sThemeVersion))).exists()) {
            templatesDir.mkdirs();
        }
        return templatesPath;
    }

    public static String getResourceCatalogPath() {
        String resourceLibPath = String.valueOf(new File(ThemeHelper.getUserDir()).getParentFile().getAbsolutePath()) + File.separator + "resourceCatalog_" + sUiVersionMap.get(WIKI_URL_SCRIPT + sThemeVersion);
        File resourceLibDir = new File(resourceLibPath);
        if (!resourceLibDir.exists()) {
            resourceLibDir.mkdirs();
        }
        return resourceLibPath;
    }

    public static String getImportResourceCatalogPath() {
        String resourceLibPath;
        File resourceLibDir;
        int uiVersion = ThemeHelper.getRomUIVersion();
        if (uiVersion == -1) {
            uiVersion = sThemeVersion;
        }
        if (!(resourceLibDir = new File(resourceLibPath = String.valueOf(new File(ThemeHelper.getUserDir()).getParentFile().getAbsolutePath()) + File.separator + "resourceCatalog_" + sUiVersionMap.get(WIKI_URL_SCRIPT + uiVersion))).exists()) {
            resourceLibDir.mkdirs();
        }
        return resourceLibPath;
    }

    public static boolean unzip(File archive, File destinationDir) {
        int BUFFER_SIZE = 1024;
        FilterOutputStream dest = null;
        FileInputStream fis = null;
        ZipInputStream zis = null;
        try {
            try {
                ZipEntry entry;
                fis = new FileInputStream(archive);
                zis = new ZipInputStream(new BufferedInputStream(fis));
                while ((entry = zis.getNextEntry()) != null) {
                    int count;
                    File destFile = new File(destinationDir + File.separator + entry.getName());
                    if (entry.isDirectory()) {
                        destFile.mkdirs();
                        continue;
                    }
                    byte[] data = new byte[1024];
                    destFile.getParentFile().mkdirs();
                    FileOutputStream fos = new FileOutputStream(destFile);
                    destFile.setLastModified(entry.getTime());
                    dest = new BufferedOutputStream(fos, 1024);
                    while ((count = zis.read(data, 0, 1024)) != -1) {
                        ((BufferedOutputStream)dest).write(data, 0, count);
                    }
                    dest.close();
                    fos.close();
                }
                zis.close();
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (dest != null) {
                        dest.close();
                    }
                    if (zis != null) {
                        zis.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                return false;
            }
        }
        finally {
            try {
                if (dest != null) {
                    dest.close();
                }
                if (zis != null) {
                    zis.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return true;
    }

    public static void setInnerUserMode() {
        ThemeConf.setConf("common", "xiaomi", Boolean.TRUE.toString());
        ThemeConf.writeConf("common");
    }

    public static boolean isInnerUserMode() {
        return ThemeConf.getConf("common", "xiaomi").equals(Boolean.TRUE.toString());
    }

    public static void setKeepRingtoneMode(Boolean mode) {
        ThemeConf.setConf("common", "keep_ringtone", mode.toString());
        ThemeConf.writeConf("common");
    }

    public static boolean isKeepRingtoneMode() {
        return ThemeConf.getConf("common", "keep_ringtone").equals(Boolean.TRUE.toString());
    }

    public static boolean isFreeThemeManager() {
        VersionFile vf1030 = VersionFile.parse("2.10.30_0");
        String version = ThemeHelper.getRomIncrementalVersion();
        VersionFile vfCurrent = VersionFile.parse(String.valueOf(version) + "_0");
        if (vfCurrent == null) {
            return false;
        }
        return vfCurrent.compareTo(vf1030) < 0;
    }

    public static File getTmpFolder() {
        return new File(String.valueOf(ThemeHelper.getUserDir()) + File.separator + "tmp");
    }

    public static File getDataFolder() {
        return new File(String.valueOf(ThemeHelper.getUserDir()) + File.separator + "data");
    }

    public static void writeToFile(File target, String content) {
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        try {
            try {
                fos = new FileOutputStream(target);
                osw = new OutputStreamWriter((OutputStream)fos, CHARSET);
                osw.write(content);
                osw.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (osw != null) {
                        osw.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (osw != null) {
                    osw.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String readFromFile(File target) {
        FileInputStream fis = null;
        InputStreamReader isr = null;
        try {
            fis = new FileInputStream(target);
            isr = new InputStreamReader((InputStream)fis, CHARSET);
            String string = IOUtils.toString(isr);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (isr != null) {
                    isr.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static boolean waitForCompleteFile(String phonePath) {
        boolean flag = false;
        String localPath = ThemeHelper.getTmpFolder() + File.separator + COMPLETE_FLAG_FILE;
        int i = 0;
        while (i < 60) {
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            flag = CmdUtils.adb_pull(phonePath, localPath);
            if (flag) break;
            ++i;
        }
        if (!flag) {
            return false;
        }
        new File(localPath).delete();
        return true;
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static String clearDesc(String str) {
        int i = str.indexOf(40);
        if (i < 0) {
            return str.substring(i + 1, str.length());
        }
        return str.substring(i + 1, str.length() - 1);
    }

    public static String cutSuffix(String fileName) {
        return fileName.substring(0, fileName.lastIndexOf("."));
    }

    public static String assurePath(String path) {
        return ThemeHelper.assurePath(path, File.separator);
    }

    public static String assurePath(String path, String sep) {
        path = path.replace("\\", sep);
        path = path.replace("/", sep);
        return path;
    }

    public static void openInExplorer(File target) {
        if (target.isFile()) {
            if (1 == OS.getOS()) {
                CmdUtils.openAndSelectFileInWindows(target.getAbsolutePath());
            } else {
                try {
                    Desktop.getDesktop().open(target.getParentFile());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            ThemeHelper.open(target);
        }
    }

    public static void open(File target) {
        try {
            Desktop.getDesktop().open(target);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public static void browse(String url) {
        try {
            Desktop.getDesktop().browse(URI.create(url));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public static void searchAndDelete(String name, File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    ThemeHelper.searchAndDelete(name, file);
                } else if (file.getName().equals(name)) {
                    file.delete();
                }
                ++n2;
            }
        }
    }

    public static String getVersion() {
        return ThemeHelper.readFromFile(new File(String.valueOf(ThemeHelper.getUserDir()) + File.separator + "version.txt")).trim();
    }

    public static String getFolderName(String path) {
        return new File(path).getParentFile().getName();
    }

    public static String getFileName(String path) {
        return new File(path).getName();
    }

    public static File getCatalogFileFromReplaceFile(File replace) {
        String relativePath = ThemeHelper.getRelativePathFromReplace(replace.getAbsolutePath());
        if (relativePath == null) {
            return null;
        }
        return new File(String.valueOf(ThemeHelper.getResourceCatalogPath()) + File.separator + relativePath);
    }

    public static String getRelativePathFromReplace(String path) {
        if (!path.startsWith(sThemeFolderPath)) {
            return null;
        }
        return path.substring(sThemeFolderPath.length() + 1);
    }
}

