/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.xmlparser;

import java.util.ArrayList;

public class Attributes {
    private ArrayList<String> mNames = new ArrayList();
    private ArrayList<String> mValues = new ArrayList();

    public void setAttributeList(Attributes atts) {
        int count = atts.getLength();
        this.clear();
        int i = 0;
        while (i < count) {
            this.addAttribute(atts.getName(i), atts.getValue(i));
            ++i;
        }
    }

    public void addAttribute(String name, String value) {
        this.mNames.add(name);
        this.mValues.add(value);
    }

    public void removeAttribute(String name) {
        int i = this.mNames.indexOf(name);
        if (i != -1) {
            this.mNames.remove(i);
            this.mValues.remove(i);
        }
    }

    public void clear() {
        this.mNames.clear();
        this.mValues.clear();
    }

    public int getLength() {
        return this.mNames.size();
    }

    public String getName(int i) {
        if (i < 0 || i >= this.mNames.size()) {
            return null;
        }
        return this.mNames.get(i);
    }

    public String getValue(int i) {
        if (i < 0 || i >= this.mValues.size()) {
            return null;
        }
        return this.mValues.get(i);
    }

    public String getValue(String name) {
        return this.getValue(this.mNames.indexOf(name));
    }

    public Attributes clone() {
        Attributes attr = new Attributes();
        int i = 0;
        while (i < this.mNames.size()) {
            attr.addAttribute(this.mNames.get(i), this.mValues.get(i));
            ++i;
        }
        return attr;
    }

    public void setValue(String name, String value) {
        int i = this.mNames.indexOf(name);
        this.mValues.set(i, value);
    }

    public void setValue(int i, String value) {
        this.mValues.set(i, value);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.getLength()) {
            sb.append(this.mNames.get(i));
            sb.append(":");
            sb.append(this.mValues.get(i));
            sb.append(" ");
            ++i;
        }
        return sb.toString();
    }
}

