/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.colorchooser;

import com.alee.utils.SwingUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Color;
import java.io.Serializable;

@XStreamAlias(value="GradientColorData")
public class GradientColorData
implements Serializable,
Cloneable {
    @XStreamAsAttribute
    private float location;
    @XStreamAsAttribute
    private Color color;

    public GradientColorData() {
        this.location = 0.0f;
        this.color = Color.WHITE;
    }

    public GradientColorData(float f, Color color) {
        this.location = f;
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public float getLocation() {
        return this.location;
    }

    public void setLocation(float f) {
        this.location = f;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof GradientColorData)) {
            return false;
        }
        GradientColorData gradientColorData = (GradientColorData)object;
        return Float.compare(this.getLocation(), gradientColorData.getLocation()) == 0 && this.getColor().equals(gradientColorData.getColor());
    }

    public GradientColorData clone() {
        return new GradientColorData(this.location, SwingUtils.copy(this.color));
    }
}

