/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.colorchooser;

import com.alee.extended.colorchooser.GradientColorData;
import com.alee.extended.colorchooser.GradientColorDataComparator;
import com.alee.managers.settings.DefaultValue;
import com.alee.utils.CollectionUtils;
import com.alee.utils.ColorUtils;
import com.alee.utils.SwingUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@XStreamAlias(value="GradientData")
public class GradientData
implements Serializable,
Cloneable,
DefaultValue {
    private static final transient GradientColorDataComparator locationsComparator = new GradientColorDataComparator();
    @XStreamImplicit(itemFieldName="Color")
    private List<GradientColorData> gradientColorsData;

    public GradientData() {
        this.gradientColorsData = new ArrayList<GradientColorData>();
    }

    public GradientData(List<GradientColorData> list) {
        this.setGradientColorsData(list);
    }

    public boolean containtsLocation(float f) {
        for (GradientColorData gradientColorData : this.gradientColorsData) {
            if (gradientColorData.getLocation() != f) continue;
            return true;
        }
        return false;
    }

    public void addGradientColorData(GradientColorData gradientColorData) {
        this.gradientColorsData.add(gradientColorData);
        this.sort();
    }

    public void addGradientColorData(float f, Color color) {
        this.gradientColorsData.add(new GradientColorData(f, color));
        this.sort();
    }

    public void removeGradientColorData(GradientColorData gradientColorData) {
        this.gradientColorsData.remove(gradientColorData);
        this.sort();
    }

    public List<GradientColorData> getGradientColorsData() {
        this.sort();
        return this.gradientColorsData;
    }

    public void setGradientColorsData(List<GradientColorData> list) {
        this.gradientColorsData = list;
        this.sort();
    }

    public float[] getFractions() {
        this.sort();
        float[] fArray = new float[this.gradientColorsData.size()];
        for (int i = 0; i < this.gradientColorsData.size(); ++i) {
            fArray[i] = this.gradientColorsData.get(i).getLocation();
        }
        return fArray;
    }

    public Color[] getColors() {
        this.sort();
        Color[] colorArray = new Color[this.gradientColorsData.size()];
        for (int i = 0; i < this.gradientColorsData.size(); ++i) {
            colorArray[i] = this.gradientColorsData.get(i).getColor();
        }
        return colorArray;
    }

    public int size() {
        return this.gradientColorsData.size();
    }

    public GradientColorData get(int n) {
        return this.gradientColorsData.get(n);
    }

    public float getLocation(int n) {
        return this.get(n).getLocation();
    }

    public Color getColor(int n) {
        return this.get(n).getColor();
    }

    public GradientColorData getFirst() {
        return this.size() > 0 ? this.gradientColorsData.get(0) : null;
    }

    public GradientColorData getLast() {
        return this.size() > 0 ? this.gradientColorsData.get(this.size() - 1) : null;
    }

    public Color getColorForLocation(float f) {
        if (this.size() == 0) {
            return null;
        }
        if (f <= this.getFirst().getLocation()) {
            return SwingUtils.copy(this.get(0).getColor());
        }
        if (f >= this.getLast().getLocation()) {
            return SwingUtils.copy(this.getLast().getColor());
        }
        int n = -1;
        for (int i = 0; i < this.size(); ++i) {
            if (!(this.getLocation(i) > f)) continue;
            n = i;
            break;
        }
        float f2 = this.getLocation(n - 1);
        float f3 = f - f2;
        float f4 = this.getLocation(n) - f2;
        float f5 = f3 / f4;
        Color color = this.getColor(n - 1);
        Color color2 = this.getColor(n);
        return ColorUtils.getIntermediateColor(color, color2, f5);
    }

    public void sort() {
        Collections.sort(this.gradientColorsData, locationsComparator);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof GradientData)) {
            return false;
        }
        GradientData gradientData = (GradientData)object;
        if (this.size() != gradientData.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).equals(gradientData.get(i))) continue;
            return false;
        }
        return true;
    }

    public GradientData clone() {
        return new GradientData(CollectionUtils.clone(this.gradientColorsData));
    }

    public static GradientData getDefaultValue() {
        GradientData gradientData = new GradientData();
        gradientData.addGradientColorData(0.0f, Color.RED);
        gradientData.addGradientColorData(0.25f, Color.YELLOW);
        gradientData.addGradientColorData(0.5f, Color.GREEN);
        gradientData.addGradientColorData(0.75f, Color.CYAN);
        gradientData.addGradientColorData(1.0f, Color.BLUE);
        return gradientData;
    }
}

