/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.date;

import com.alee.extended.date.DateCustomizer;
import com.alee.extended.date.DateSelectionListener;
import com.alee.extended.transition.ComponentTransition;
import com.alee.extended.transition.TransitionAdapter;
import com.alee.extended.transition.effects.Direction;
import com.alee.extended.transition.effects.fade.FadeTransitionEffect;
import com.alee.extended.transition.effects.slide.SlideTransitionEffect;
import com.alee.extended.transition.effects.slide.SlideType;
import com.alee.laf.StyleConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.button.WebToggleButton;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.separator.WebSeparator;
import com.alee.utils.CollectionUtils;
import com.alee.utils.CompareUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.TimeUtils;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class WebCalendar
extends WebPanel {
    public static final ImageIcon previousSkipIcon = new ImageIcon(WebCalendar.class.getResource("icons/previous_skip.png"));
    public static final ImageIcon previousIcon = new ImageIcon(WebCalendar.class.getResource("icons/previous.png"));
    public static final ImageIcon nextIcon = new ImageIcon(WebCalendar.class.getResource("icons/next.png"));
    public static final ImageIcon nextSkipIcon = new ImageIcon(WebCalendar.class.getResource("icons/next_skip.png"));
    private List<DateSelectionListener> dateSelectionListeners = new ArrayList<DateSelectionListener>();
    private SimpleDateFormat titleFormat = new SimpleDateFormat("MMMM yyyy");
    private Date date = new Date(System.currentTimeMillis());
    private Date shownDate = new Date(this.date.getTime());
    private Date oldShownDate = new Date(System.currentTimeMillis());
    private boolean startWeekFromSunday = false;
    private boolean animate = true;
    private boolean horizontalSlide = true;
    private DateCustomizer dateCustomizer = null;
    private Color otherMonthColor = new Color(90, 90, 90);
    private Color weekendsColor = new Color(160, 0, 0);
    private WebButton previousSkip;
    private WebButton previous;
    private ComponentTransition titlePanel;
    private WebButton next;
    private WebButton nextSkip;
    private WebPanel weekHeaders;
    private WebPanel monthDays;
    private ComponentTransition monthDaysTransition;
    private WebToggleButton lastSelectedDayButton;

    public WebCalendar() {
        this((Date)null);
    }

    public WebCalendar(Date date) {
        super(true);
        this.setDrawFocus(true);
        this.setRound(StyleConstants.smallRound);
        this.putClientProperty("HANDLES_ENABLE_STATE", true);
        if (date != null) {
            this.date = date;
            this.shownDate = date;
        }
        this.setLayout(new BorderLayout(0, 0));
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BorderLayout(0, 0));
        this.add((Component)jPanel, (Object)"Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        jPanel2.setLayout(new BorderLayout());
        this.add((Component)jPanel2, (Object)"North");
        this.previousSkip = WebButton.createIconWebButton(previousSkipIcon, StyleConstants.smallRound, true);
        this.previousSkip.setDrawFocus(false);
        this.previousSkip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebCalendar.this.changeYear(-1);
            }
        });
        this.previous = WebButton.createIconWebButton(previousIcon, StyleConstants.smallRound, true);
        this.previous.setDrawFocus(false);
        this.previous.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebCalendar.this.changeMonth(-1);
            }
        });
        WebPanel webPanel = new WebPanel(new BorderLayout());
        webPanel.setOpaque(false);
        webPanel.add((Component)this.previousSkip, (Object)"West");
        webPanel.add((Component)this.previous, (Object)"East");
        jPanel2.add((Component)webPanel, "West");
        this.titlePanel = new ComponentTransition(this.createTitleLabel());
        this.titlePanel.setOpaque(false);
        this.titlePanel.setTransitionEffect(new FadeTransitionEffect());
        this.titlePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    WebCalendar.this.setDate(new Date());
                }
            }
        });
        jPanel2.add((Component)this.titlePanel, "Center");
        this.next = WebButton.createIconWebButton(nextIcon, StyleConstants.smallRound, true);
        this.next.setDrawFocus(false);
        this.next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebCalendar.this.changeMonth(1);
            }
        });
        this.nextSkip = WebButton.createIconWebButton(nextSkipIcon, StyleConstants.smallRound, true);
        this.nextSkip.setDrawFocus(false);
        this.nextSkip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebCalendar.this.changeYear(1);
            }
        });
        WebPanel webPanel2 = new WebPanel(new BorderLayout());
        webPanel2.setOpaque(false);
        webPanel2.add((Component)this.next, (Object)"West");
        webPanel2.add((Component)this.nextSkip, (Object)"East");
        jPanel2.add((Component)webPanel2, "East");
        this.weekHeaders = new WebPanel();
        this.weekHeaders.setUndecorated(false);
        this.weekHeaders.setDrawSides(true, false, true, false);
        this.weekHeaders.setShadeWidth(0);
        this.weekHeaders.setOpaque(false);
        this.weekHeaders.setMargin(StyleConstants.shadeWidth, StyleConstants.shadeWidth - 1, StyleConstants.shadeWidth + 1, StyleConstants.shadeWidth - 1);
        this.weekHeaders.setLayout(new TableLayout(new double[][]{{-1.0, -2.0, -1.0, -2.0, -1.0, -2.0, -1.0, -2.0, -1.0, -2.0, -1.0, -2.0, -1.0}, {-2.0}}));
        jPanel.add((Component)this.weekHeaders, "North");
        this.updateWeekHeaders();
        this.monthDays = this.createMonthDaysPanel();
        this.updateMonthDays(this.monthDays);
        this.monthDaysTransition = new ComponentTransition(this.monthDays);
        this.monthDaysTransition.setOpaque(false);
        this.monthDaysTransition.addTransitionListener(new TransitionAdapter(){

            @Override
            public void transitionFinished() {
                WebCalendar.this.requestFocusToSelected();
            }
        });
        jPanel.add((Component)this.monthDaysTransition, "Center");
    }

    private WebLabel createTitleLabel() {
        return this.createTitleLabel(this.titleFormat.format(this.shownDate));
    }

    private WebLabel createTitleLabel(String string) {
        WebLabel webLabel = new WebLabel(string);
        webLabel.setDrawShade(true);
        webLabel.setHorizontalAlignment(0);
        webLabel.setVerticalAlignment(0);
        SwingUtils.setBoldFont(webLabel);
        return webLabel;
    }

    private void changeMonth(int n) {
        if (!this.getComponentOrientation().isLeftToRight()) {
            n = -n;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.shownDate);
        calendar.set(2, calendar.get(2) + n);
        this.setShownDate(calendar.getTime(), true);
    }

    private void changeYear(int n) {
        if (!this.getComponentOrientation().isLeftToRight()) {
            n = -n;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.shownDate);
        calendar.set(1, calendar.get(1) + n);
        this.setShownDate(calendar.getTime(), true);
    }

    private WebPanel createMonthDaysPanel() {
        WebPanel webPanel = new WebPanel();
        webPanel.setOpaque(false);
        webPanel.setMargin(StyleConstants.shadeWidth - 1, StyleConstants.shadeWidth - 1, StyleConstants.shadeWidth - 1, StyleConstants.shadeWidth - 1);
        TableLayout tableLayout = new TableLayout(new double[][]{{-1.0, -2.0, -1.0, -2.0, -1.0, -2.0, -1.0, -2.0, -1.0, -2.0, -1.0, -2.0, -1.0}, {-1.0, -1.0, -1.0, -1.0, -1.0, -1.0}});
        tableLayout.setHGap(0);
        tableLayout.setVGap(0);
        webPanel.setLayout(tableLayout);
        return webPanel;
    }

    private void switchMonthDays(boolean bl) {
        if (this.animate && bl) {
            WebPanel webPanel = this.createMonthDaysPanel();
            this.updateMonthDays(webPanel);
            boolean bl2 = this.getComponentOrientation().isLeftToRight();
            SlideTransitionEffect slideTransitionEffect = new SlideTransitionEffect();
            slideTransitionEffect.setType(SlideType.moveBoth);
            slideTransitionEffect.setDirection(this.oldShownDate.getTime() > this.shownDate.getTime() ? this.getNextDirection(bl2) : this.getPrevDirection(bl2));
            slideTransitionEffect.setSpeed(20);
            this.monthDaysTransition.setTransitionEffect(slideTransitionEffect);
            this.monthDaysTransition.performTransition(webPanel);
        } else {
            this.updateMonthDays(this.monthDays);
            this.requestFocusToSelected();
        }
    }

    private void requestFocusToSelected() {
        if (this.lastSelectedDayButton != null) {
            this.lastSelectedDayButton.requestFocusInWindow();
        }
    }

    private Direction getNextDirection(boolean bl) {
        if (this.horizontalSlide) {
            return bl ? Direction.right : Direction.left;
        }
        return Direction.up;
    }

    private Direction getPrevDirection(boolean bl) {
        if (this.horizontalSlide) {
            return bl ? Direction.left : Direction.right;
        }
        return Direction.down;
    }

    private void updateMonthDays(JPanel jPanel) {
        WebToggleButton webToggleButton;
        Date date;
        int n;
        int n2;
        int n3;
        jPanel.removeAll();
        this.lastSelectedDayButton = null;
        jPanel.add((Component)new WebSeparator(1), "1,0,1,5");
        jPanel.add((Component)new WebSeparator(1), "3,0,3,5");
        jPanel.add((Component)new WebSeparator(1), "5,0,5,5");
        jPanel.add((Component)new WebSeparator(1), "7,0,7,5");
        jPanel.add((Component)new WebSeparator(1), "9,0,9,5");
        jPanel.add((Component)new WebSeparator(1), "11,0,11,5");
        ButtonGroup buttonGroup = new ButtonGroup();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.shownDate);
        calendar.set(5, 1);
        int n4 = 0;
        int n5 = 0;
        int n6 = calendar.get(7);
        switch (n6) {
            case 2: {
                n3 = this.startWeekFromSunday ? 1 : 7;
                break;
            }
            case 3: {
                n3 = this.startWeekFromSunday ? 2 : 1;
                break;
            }
            case 4: {
                n3 = this.startWeekFromSunday ? 3 : 2;
                break;
            }
            case 5: {
                n3 = this.startWeekFromSunday ? 4 : 3;
                break;
            }
            case 6: {
                n3 = this.startWeekFromSunday ? 5 : 4;
                break;
            }
            case 7: {
                n3 = this.startWeekFromSunday ? 6 : 5;
                break;
            }
            case 1: {
                n3 = this.startWeekFromSunday ? 7 : 6;
                break;
            }
            default: {
                n3 = 0;
            }
        }
        TimeUtils.changeByDays(calendar, -n3);
        while (calendar.get(5) > 1) {
            final Date date2 = calendar.getTime();
            final WebToggleButton webToggleButton2 = new WebToggleButton();
            webToggleButton2.setFont(webToggleButton2.getFont().deriveFont(0));
            webToggleButton2.setForeground(this.otherMonthColor);
            webToggleButton2.setText("" + calendar.get(5));
            webToggleButton2.setRolloverDecoratedOnly(true);
            webToggleButton2.setHorizontalAlignment(4);
            webToggleButton2.setRound(StyleConstants.smallRound);
            webToggleButton2.setDrawFocus(false);
            webToggleButton2.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    webToggleButton2.setFont(webToggleButton2.isSelected() ? webToggleButton2.getFont().deriveFont(1) : webToggleButton2.getFont().deriveFont(0));
                    if (webToggleButton2.isSelected()) {
                        WebCalendar.this.setDateImpl(date2, WebCalendar.this.animate);
                    }
                }
            });
            if (this.dateCustomizer != null) {
                this.dateCustomizer.customize(webToggleButton2, date2);
            }
            jPanel.add((Component)webToggleButton2, n4 * 2 + "," + n5);
            buttonGroup.add(webToggleButton2);
            TimeUtils.increaseByDay(calendar);
            if (++n4 <= 6) continue;
            n4 = 0;
            ++n5;
        }
        do {
            n2 = calendar.get(7) == 1 || calendar.get(7) == 7 ? 1 : 0;
            n = TimeUtils.isSameDay(calendar, (Long)this.date.getTime());
            date = calendar.getTime();
            webToggleButton = new WebToggleButton();
            webToggleButton.setFont(n != 0 ? webToggleButton.getFont().deriveFont(1) : webToggleButton.getFont().deriveFont(0));
            webToggleButton.setForeground(n2 != 0 ? this.weekendsColor : Color.BLACK);
            webToggleButton.setText("" + calendar.get(5));
            webToggleButton.setSelected(n != 0);
            webToggleButton.setRolloverDecoratedOnly(true);
            webToggleButton.setHorizontalAlignment(4);
            webToggleButton.setRound(StyleConstants.smallRound);
            webToggleButton.setDrawFocus(false);
            webToggleButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    webToggleButton.setFont(webToggleButton.isSelected() ? webToggleButton.getFont().deriveFont(1) : webToggleButton.getFont().deriveFont(0));
                }
            });
            webToggleButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WebCalendar.this.lastSelectedDayButton = webToggleButton;
                    WebCalendar.this.setDateImpl(date, WebCalendar.this.animate);
                }
            });
            if (this.dateCustomizer != null) {
                this.dateCustomizer.customize(webToggleButton, date);
            }
            jPanel.add((Component)webToggleButton, n4 * 2 + "," + n5);
            buttonGroup.add(webToggleButton);
            if (n != 0) {
                this.lastSelectedDayButton = webToggleButton;
            }
            TimeUtils.increaseByDay(calendar);
            if (++n4 <= 6) continue;
            n4 = 0;
            ++n5;
        } while (calendar.get(5) > 1);
        n2 = 42 - (jPanel.getComponentCount() - 6);
        for (n = 1; n <= n2; ++n) {
            date = calendar.getTime();
            webToggleButton = new WebToggleButton();
            webToggleButton.setFont(webToggleButton.getFont().deriveFont(0));
            webToggleButton.setForeground(this.otherMonthColor);
            webToggleButton.setText("" + calendar.get(5));
            webToggleButton.setRolloverDecoratedOnly(true);
            webToggleButton.setHorizontalAlignment(4);
            webToggleButton.setRound(StyleConstants.smallRound);
            webToggleButton.setDrawFocus(false);
            webToggleButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    webToggleButton.setFont(webToggleButton.isSelected() ? webToggleButton.getFont().deriveFont(1) : webToggleButton.getFont().deriveFont(0));
                    if (webToggleButton.isSelected()) {
                        WebCalendar.this.setDateImpl(date, WebCalendar.this.animate);
                    }
                }
            });
            if (this.dateCustomizer != null) {
                this.dateCustomizer.customize(webToggleButton, date);
            }
            jPanel.add((Component)webToggleButton, n4 * 2 + "," + n5);
            buttonGroup.add(webToggleButton);
            TimeUtils.increaseByDay(calendar);
            if (++n4 <= 6) continue;
            n4 = 0;
            ++n5;
        }
        jPanel.revalidate();
    }

    private void updateWeekHeaders() {
        this.weekHeaders.removeAll();
        for (int i = 1; i <= 7; ++i) {
            int n = this.startWeekFromSunday ? (i == 1 ? 7 : i - 1) : i;
            WebLabel webLabel = new WebLabel();
            webLabel.setLanguage("weblaf.ex.calendar.dayOfWeek." + n, new Object[0]);
            webLabel.setDrawShade(true);
            webLabel.setHorizontalAlignment(0);
            webLabel.setFont(webLabel.getFont().deriveFont(10.0f).deriveFont(1));
            this.weekHeaders.add((Component)webLabel, (Object)((i - 1) * 2 + ",0"));
            if (i >= 7) continue;
            this.weekHeaders.add((Component)new WebSeparator(1), (Object)((i - 1) * 2 + 1 + ",0"));
        }
        this.weekHeaders.revalidate();
    }

    private void updateTitleLabel() {
        this.titlePanel.performTransition(this.createTitleLabel());
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.setDate(date, this.animate);
    }

    public void setDate(Date date, boolean bl) {
        if (!CompareUtils.equals(this.date, date)) {
            this.setDateImpl(date, bl);
        }
    }

    private void setDateImpl(Date date, boolean bl) {
        this.date = date;
        this.setShownDate(date, bl);
        this.fireDateSelected(date);
    }

    public Date getShownDate() {
        return this.shownDate;
    }

    public void setShownDate(Date date, boolean bl) {
        this.oldShownDate = this.shownDate;
        this.shownDate = date;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.oldShownDate);
        int n = calendar.get(2);
        int n2 = calendar.get(1);
        calendar.setTime(date);
        int n3 = calendar.get(2);
        int n4 = calendar.get(1);
        if (n != n3 || n2 != n4) {
            this.updateTitleLabel();
            this.switchMonthDays(bl);
        }
    }

    public boolean isStartWeekFromSunday() {
        return this.startWeekFromSunday;
    }

    public void setStartWeekFromSunday(boolean bl) {
        this.startWeekFromSunday = bl;
        this.updateWeekHeaders();
        this.updateMonthDays(this.monthDays);
    }

    public boolean isAnimate() {
        return this.animate;
    }

    public void setAnimate(boolean bl) {
        this.animate = bl;
    }

    public boolean isHorizontalSlide() {
        return this.horizontalSlide;
    }

    public void setHorizontalSlide(boolean bl) {
        this.horizontalSlide = bl;
    }

    public Color getOtherMonthColor() {
        return this.otherMonthColor;
    }

    public void setOtherMonthColor(Color color) {
        this.otherMonthColor = color;
        this.updateMonthDays(this.monthDays);
    }

    public Color getWeekendsColor() {
        return this.weekendsColor;
    }

    public void setWeekendsColor(Color color) {
        this.weekendsColor = color;
        this.updateMonthDays(this.monthDays);
    }

    public DateCustomizer getDateCustomizer() {
        return this.dateCustomizer;
    }

    public void setDateCustomizer(DateCustomizer dateCustomizer) {
        this.dateCustomizer = dateCustomizer;
        this.updateMonthDays(this.monthDays);
    }

    @Override
    public void setEnabled(boolean bl) {
        SwingUtils.setEnabledRecursively(this, bl, true);
        super.setEnabled(bl);
    }

    public void addDateSelectionListener(DateSelectionListener dateSelectionListener) {
        this.dateSelectionListeners.add(dateSelectionListener);
    }

    public void removeDateSelectionListener(DateSelectionListener dateSelectionListener) {
        this.dateSelectionListeners.remove(dateSelectionListener);
    }

    private void fireDateSelected(Date date) {
        for (DateSelectionListener dateSelectionListener : CollectionUtils.copy(this.dateSelectionListeners)) {
            dateSelectionListener.dateSelected(date);
        }
    }
}

