/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.date;

import com.alee.extended.date.DateSelectionListener;
import com.alee.extended.date.WebCalendar;
import com.alee.extended.date.WebDateFieldStyle;
import com.alee.laf.StyleConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.rootpane.WebWindow;
import com.alee.laf.text.WebFormattedTextField;
import com.alee.managers.hotkey.Hotkey;
import com.alee.utils.CollectionUtils;
import com.alee.utils.CompareUtils;
import com.alee.utils.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class WebDateField
extends WebFormattedTextField {
    public static final ImageIcon selectDateIcon = new ImageIcon(WebDateField.class.getResource("icons/date.png"));
    private List<DateSelectionListener> dateSelectionListeners = new ArrayList<DateSelectionListener>();
    private SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
    private Date date = null;
    private int preferredWidth = -1;
    private WebButton popupButton;
    private WebWindow popup;
    private WebCalendar calendar;

    public WebDateField() {
        this((Date)null);
    }

    public WebDateField(boolean bl) {
        this(bl, null);
    }

    public WebDateField(Date date) {
        this(WebDateFieldStyle.drawBorder, date);
    }

    public WebDateField(boolean bl, Date date) {
        this.date = date;
        this.setOpaque(false);
        this.setWebColored(WebDateFieldStyle.webColored);
        this.setDrawBackground(WebDateFieldStyle.drawBackground);
        this.setBackground(WebDateFieldStyle.backgroundColor);
        this.setWebColored(WebDateFieldStyle.webColored);
        this.setDrawFocus(WebDateFieldStyle.drawFocus);
        this.popupButton = WebButton.createIconWebButton(selectDateIcon, WebDateFieldStyle.round);
        this.popupButton.setFocusable(false);
        this.popupButton.setShadeWidth(0);
        this.popupButton.setMoveIconOnPress(false);
        this.popupButton.setRolloverDecoratedOnly(true);
        this.popupButton.setCursor(Cursor.getDefaultCursor());
        this.popupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebDateField.this.showCalendarPopup();
            }
        });
        this.setTrailingComponent(this.popupButton);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebDateField.this.updateDateFromField();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (WebDateField.this.isEnabled() && SwingUtilities.isRightMouseButton(mouseEvent)) {
                    WebDateField.this.showCalendarPopup();
                }
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                WebDateField.this.updateDateFromField();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (WebDateField.this.isEnabled()) {
                    if (Hotkey.ESCAPE.isTriggered(keyEvent)) {
                        WebDateField.this.updateFieldFromDate();
                    } else if (Hotkey.DOWN.isTriggered(keyEvent)) {
                        WebDateField.this.showCalendarPopup();
                    }
                }
            }
        });
        this.updateFieldFromDate();
        this.setDrawBorder(bl);
        this.setRound(WebDateFieldStyle.round);
        this.setShadeWidth(WebDateFieldStyle.shadeWidth);
    }

    @Override
    public void setRound(int n) {
        super.setRound(n);
        this.popupButton.setRound(n);
    }

    @Override
    public void setDrawBorder(boolean bl) {
        super.setDrawBorder(bl);
        this.updateMargin();
    }

    private void updateMargin() {
        this.setMargin(this.isDrawBorder() ? WebDateFieldStyle.margin : WebDateFieldStyle.undecoratedMargin);
    }

    private void showCalendarPopup() {
        if (!this.requestFocusInWindow() && !this.isFocusOwner()) {
            return;
        }
        this.updateDateFromField();
        if (this.popup == null || this.calendar == null) {
            Window window = SwingUtils.getWindowAncestor(this);
            this.calendar = new WebCalendar(this.date);
            this.calendar.setDrawFocus(false);
            this.calendar.setRound(StyleConstants.smallRound);
            this.calendar.setShadeWidth(0);
            this.popup = new WebWindow(window);
            this.popup.setLayout(new BorderLayout());
            this.popup.add(this.calendar);
            this.popup.setCloseOnFocusLoss(true);
            this.popup.pack();
            SwingUtils.setWindowOpaque(this.popup, false);
            this.updatePopupLocation();
            window.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentMoved(ComponentEvent componentEvent) {
                    if (WebDateField.this.popup.isShowing()) {
                        WebDateField.this.updatePopupLocation();
                    }
                }

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    if (WebDateField.this.popup.isShowing()) {
                        WebDateField.this.updatePopupLocation();
                    }
                }
            });
            window.addPropertyChangeListener("componentOrientation", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (WebDateField.this.popup.isShowing()) {
                        WebDateField.this.updatePopupLocation();
                    }
                }
            });
            this.calendar.addDateSelectionListener(new DateSelectionListener(){

                @Override
                public void dateSelected(Date date) {
                    WebDateField.this.popup.setVisible(false);
                    WebDateField.this.setDate(date);
                    WebDateField.this.requestFocusInWindow();
                }
            });
        } else {
            this.updatePopupLocation();
            this.calendar.setDate(this.date != null ? this.date : new Date(), false);
        }
        SwingUtils.copyOrientation(this, this.popup);
        this.popup.setVisible(true);
        this.calendar.requestFocusInWindow();
    }

    private void updatePopupLocation() {
        Point point = this.getLocationOnScreen();
        Rectangle rectangle = this.popup.getGraphicsConfiguration().getBounds();
        int n = this.isDrawBorder() ? this.getShadeWidth() : 0;
        boolean bl = this.getComponentOrientation().isLeftToRight();
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        int n4 = bl ? (point.x + n + this.popup.getWidth() <= rectangle.x + rectangle.width ? point.x + n : point.x + n2 - n - this.popup.getWidth()) : (point.x + n2 - n - this.popup.getWidth() >= rectangle.x ? point.x + n2 - n - this.popup.getWidth() : point.x + n);
        int n5 = point.y + n3 + this.popup.getHeight() <= rectangle.y + rectangle.height ? point.y + n3 + (this.isDrawBorder() ? 0 : 1) : point.y - this.popup.getHeight() - (this.isDrawBorder() ? 0 : 1);
        this.popup.setLocation(n4, n5);
    }

    private void updateDateFromField() {
        this.setDate(this.getDateFromField());
    }

    private Date getDateFromField() {
        try {
            String string = this.getText();
            if (string != null && !string.trim().equals("")) {
                return this.dateFormat.parse(string);
            }
            return null;
        }
        catch (Throwable throwable) {
            return this.date;
        }
    }

    private void updateFieldFromDate() {
        this.setText(this.getTextDate());
    }

    private String getTextDate() {
        return this.date != null ? this.dateFormat.format(this.date) : "";
    }

    public Date getDate() {
        return this.getDateFromField();
    }

    public void setDate(Date date) {
        if (!CompareUtils.equals(this.date, date)) {
            this.date = date;
            this.fireDateSelected(date);
        }
        this.updateFieldFromDate();
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(SimpleDateFormat simpleDateFormat) {
        this.dateFormat = simpleDateFormat;
        this.updateFieldFromDate();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.popupButton.setEnabled(bl);
    }

    public WebButton getPopupButton() {
        return this.popupButton;
    }

    public void addDateSelectionListener(DateSelectionListener dateSelectionListener) {
        this.dateSelectionListeners.add(dateSelectionListener);
    }

    public void removeDateSelectionListener(DateSelectionListener dateSelectionListener) {
        this.dateSelectionListeners.remove(dateSelectionListener);
    }

    private void fireDateSelected(Date date) {
        for (DateSelectionListener dateSelectionListener : CollectionUtils.copy(this.dateSelectionListeners)) {
            dateSelectionListener.dateSelected(date);
        }
    }

    public void setPreferredWidth(int n) {
        this.preferredWidth = n;
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.preferredWidth != -1) {
            dimension.width = this.preferredWidth;
        }
        return dimension;
    }
}

