/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.drag;

import com.alee.utils.ImageUtils;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;

public class ImageDragHandler
extends TransferHandler {
    private static final DataFlavor[] imageFlavor = new DataFlavor[]{DataFlavor.imageFlavor};
    private BufferedImage image;
    private boolean defaultBehavior = true;

    public ImageDragHandler(JComponent jComponent, ImageIcon imageIcon) {
        this(jComponent, ImageUtils.getBufferedImage(imageIcon));
    }

    public ImageDragHandler(JComponent jComponent, Image image) {
        this(jComponent, ImageUtils.getBufferedImage(image));
    }

    public ImageDragHandler(final JComponent jComponent, BufferedImage bufferedImage) {
        this.setImage(bufferedImage);
        jComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (ImageDragHandler.this.isDefaultBehavior() && SwingUtilities.isLeftMouseButton(mouseEvent) && jComponent.isEnabled()) {
                    ImageDragHandler.this.exportAsDrag(jComponent, mouseEvent, ImageDragHandler.this.getSourceActions(jComponent));
                }
            }
        });
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
    }

    public boolean isDefaultBehavior() {
        return this.defaultBehavior;
    }

    public void setDefaultBehavior(boolean bl) {
        this.defaultBehavior = bl;
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 1;
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        return new Transferable(){

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return imageFlavor;
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                return dataFlavor.equals(DataFlavor.imageFlavor);
            }

            @Override
            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                if (this.isDataFlavorSupported(dataFlavor)) {
                    return ImageDragHandler.this.image;
                }
                return null;
            }
        };
    }
}

