/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.filechooser;

import com.alee.extended.filechooser.DirectoryChooserListener;
import com.alee.extended.filechooser.WebDirectoryChooserPanel;
import com.alee.extended.panel.GroupPanel;
import com.alee.laf.StyleConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.rootpane.WebDialog;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.hotkey.HotkeyCondition;
import com.alee.managers.hotkey.HotkeyManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;

public class WebDirectoryChooser
extends WebDialog {
    private static final ImageIcon ICON = new ImageIcon(WebDirectoryChooser.class.getResource("icons/dir_icon.png"));
    private static final ImageIcon SETTINGS_ICON = new ImageIcon(WebDirectoryChooser.class.getResource("icons/settings.png"));
    private static final ImageIcon OK_ICON = new ImageIcon(WebDirectoryChooser.class.getResource("icons/ok.png"));
    private static final ImageIcon CANCEL_ICON = new ImageIcon(WebDirectoryChooser.class.getResource("icons/cancel.png"));
    private List<ActionListener> listeners = new ArrayList<ActionListener>();
    private WebDirectoryChooserPanel directoryChooserPanel;
    private WebButton ok;
    private WebButton cancel;
    private int result = -2;

    public WebDirectoryChooser(Window window) {
        this(window, (String)null);
    }

    public WebDirectoryChooser(Window window, String string) {
        super(window, string != null ? string : "");
        this.setIconImage(ICON.getImage());
        if (string == null) {
            this.setLanguage("weblaf.ex.dirchooser.title", new Object[0]);
        }
        HotkeyManager.installShowAllHotkeysAction(this, Hotkey.F1);
        this.getContentPane().setBackground(Color.WHITE);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.directoryChooserPanel = new WebDirectoryChooserPanel();
        this.getContentPane().add((Component)this.directoryChooserPanel, "Center");
        HotkeyManager.addContainerHotkeyCondition(this, new HotkeyCondition(){

            @Override
            public boolean checkCondition(Component component) {
                return WebDirectoryChooser.this.directoryChooserPanel.allowHotkeys();
            }
        });
        WebPanel webPanel = new WebPanel();
        webPanel.setOpaque(false);
        webPanel.setMargin(0, 3, 3, 3);
        webPanel.setLayout(new BorderLayout(0, 0));
        this.getContentPane().add((Component)webPanel, "South");
        this.ok = new WebButton("", OK_ICON);
        this.ok.setLanguage("weblaf.ex.dirchooser.choose", new Object[0]);
        this.ok.addHotkey(this, Hotkey.CTRL_ENTER);
        if (StyleConstants.highlightControlButtons) {
            this.ok.setShineColor(StyleConstants.greenHighlight);
        }
        this.ok.putClientProperty("fill.component.cell", true);
        this.ok.setEnabled(false);
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebDirectoryChooser.this.result = 0;
                WebDirectoryChooser.this.dispose();
            }
        });
        this.cancel = new WebButton("", CANCEL_ICON);
        this.cancel.setLanguage("weblaf.ex.dirchooser.cancel", new Object[0]);
        this.cancel.addHotkey(this, Hotkey.ESCAPE);
        if (StyleConstants.highlightControlButtons) {
            this.cancel.setShineColor(StyleConstants.redHighlight);
        }
        this.cancel.putClientProperty("fill.component.cell", true);
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebDirectoryChooser.this.result = 1;
                WebDirectoryChooser.this.dispose();
            }
        });
        webPanel.add((Component)new GroupPanel(4, this.ok, this.cancel), (Object)"After");
        this.directoryChooserPanel.addWebDirectoryChooserListener(new DirectoryChooserListener(){

            @Override
            public void selectionChanged(File file) {
                WebDirectoryChooser.this.updateButtons(file);
            }
        });
        this.updateButtons(this.directoryChooserPanel.getSelectedFolder());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                WebDirectoryChooser.this.result = -1;
            }
        });
        this.setModal(true);
        this.pack();
        this.setDefaultCloseOperation(2);
    }

    private void updateButtons(File file) {
        this.ok.setEnabled(file != null);
    }

    public int getResult() {
        return this.result;
    }

    public File getSelectedFolder() {
        return this.directoryChooserPanel.getSelectedFolder();
    }

    public void setSelectedFolder(File file) {
        this.directoryChooserPanel.setSelectedFolder(file);
    }

    public void addWebDirectoryChooserListener(DirectoryChooserListener directoryChooserListener) {
        this.directoryChooserPanel.addWebDirectoryChooserListener(directoryChooserListener);
    }

    public void removeWebDirectoryChooserListener(DirectoryChooserListener directoryChooserListener) {
        this.directoryChooserPanel.removeWebDirectoryChooserListener(directoryChooserListener);
    }

    public int showDialog() {
        this.setVisible(true);
        return this.getResult();
    }

    public static File showDialog(Window window, String string) {
        WebDirectoryChooser webDirectoryChooser = new WebDirectoryChooser(window, string);
        webDirectoryChooser.setVisible(true);
        if (webDirectoryChooser.getResult() == 0) {
            return webDirectoryChooser.getSelectedFolder();
        }
        return null;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.result = -2;
            this.setLocationRelativeTo(this.getOwner());
        }
        super.setVisible(bl);
    }
}

