/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.filechooser;

import com.alee.laf.StyleConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.utils.CollectionUtils;
import com.alee.utils.FileUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.swing.AncestorAdapter;
import com.alee.utils.swing.Timer;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;

public class WebFilePlate
extends WebPanel {
    public static final ImageIcon CROSS_ICON = new ImageIcon(WebFilePlate.class.getResource("icons/cross.png"));
    private List<ActionListener> closeListeners = new ArrayList<ActionListener>();
    private boolean showRemoveButton = true;
    private boolean showFileExtensions = false;
    private boolean animate = StyleConstants.animate;
    private File file;
    private Timer animator = null;
    private float opacity = 0.0f;
    private WebLabel fileName;
    private WebButton remove = null;

    public WebFilePlate(File file) {
        this(file, true);
    }

    public WebFilePlate(File file, boolean bl) {
        super(bl);
        this.file = file;
        this.setMargin(0, 3, 0, 0);
        TableLayout tableLayout = new TableLayout(new double[][]{{-1.0, -2.0}, {-2.0}});
        tableLayout.setHGap(0);
        tableLayout.setVGap(0);
        this.setLayout(tableLayout);
        this.fileName = new WebLabel();
        this.fileName.setMargin(0, 0, 0, this.showRemoveButton ? 1 : 0);
        this.add((Component)this.fileName, (Object)"0,0");
        this.updateFileName();
        if (this.showRemoveButton) {
            this.add((Component)this.getRemoveButton(), (Object)"1,0");
        }
        this.addAncestorListener(new AncestorAdapter(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
                if (WebFilePlate.this.animator != null && WebFilePlate.this.animator.isRunning()) {
                    WebFilePlate.this.animator.stop();
                }
                if (WebFilePlate.this.animate) {
                    WebFilePlate.this.animator = new Timer("WebFilePlate.fadeInTimer", (long)StyleConstants.animationDelay, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            WebFilePlate.this.opacity += 0.1f;
                            if (WebFilePlate.this.opacity < 1.0f) {
                                WebFilePlate.this.repaint();
                            } else {
                                WebFilePlate.this.opacity = 1.0f;
                                WebFilePlate.this.repaint();
                                WebFilePlate.this.animator.stop();
                            }
                        }
                    });
                    WebFilePlate.this.animator.start();
                } else {
                    WebFilePlate.this.opacity = 1.0f;
                    WebFilePlate.this.repaint();
                }
            }
        });
    }

    private void updateFileName() {
        this.fileName.setIcon(this.getDisplayIcon(this.file));
        this.fileName.setText(this.getDisplayName(this.file));
    }

    private WebButton getRemoveButton() {
        if (this.remove == null) {
            this.remove = WebButton.createIconWebButton(CROSS_ICON, StyleConstants.smallRound, 3, 2, true, false);
            this.remove.setFocusable(false);
            this.remove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(final ActionEvent actionEvent) {
                    if (WebFilePlate.this.animator != null && WebFilePlate.this.animator.isRunning()) {
                        WebFilePlate.this.animator.stop();
                    }
                    if (WebFilePlate.this.animate) {
                        WebFilePlate.this.animator = new Timer("WebFilePlate.fadeOutTimer", (long)StyleConstants.animationDelay, new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent2) {
                                WebFilePlate.this.opacity -= 0.1f;
                                if (WebFilePlate.this.opacity > 0.0f) {
                                    WebFilePlate.this.repaint();
                                } else {
                                    WebFilePlate.this.removeFromParent();
                                    WebFilePlate.this.fireActionPerformed(actionEvent);
                                    WebFilePlate.this.animator.stop();
                                }
                            }
                        });
                        WebFilePlate.this.animator.start();
                    } else {
                        WebFilePlate.this.removeFromParent();
                    }
                }
            });
        }
        return this.remove;
    }

    private void removeFromParent() {
        this.opacity = 0.0f;
        Container container = this.getParent();
        if (container != null && container instanceof JComponent) {
            JComponent jComponent = (JComponent)container;
            jComponent.remove(this);
            jComponent.revalidate();
            jComponent.repaint();
        }
    }

    private ImageIcon getDisplayIcon(File file) {
        return FileUtils.getFileIcon(file, false);
    }

    private String getDisplayName(File file) {
        String string = FileUtils.getDisplayFileName(file);
        return this.showFileExtensions || file.isDirectory() ? string : FileUtils.getFileNamePart(string);
    }

    public boolean isShowRemoveButton() {
        return this.showRemoveButton;
    }

    public void setShowRemoveButton(boolean bl) {
        if (this.showRemoveButton != bl) {
            this.showRemoveButton = bl;
            if (bl) {
                this.add((Component)this.getRemoveButton(), (Object)"1,0");
            } else {
                this.remove(this.getRemoveButton());
            }
            this.revalidate();
        }
    }

    public boolean isShowFileExtensions() {
        return this.showFileExtensions;
    }

    public void setShowFileExtensions(boolean bl) {
        this.showFileExtensions = bl;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        LafUtils.setupAlphaComposite((Graphics2D)graphics, this.opacity, this.opacity < 1.0f);
        super.paintComponent(graphics);
    }

    public void addCloseListener(ActionListener actionListener) {
        this.closeListeners.add(actionListener);
    }

    public void removeCloseListener(ActionListener actionListener) {
        this.closeListeners.remove(actionListener);
    }

    private void fireActionPerformed(ActionEvent actionEvent) {
        for (ActionListener actionListener : CollectionUtils.copy(this.closeListeners)) {
            actionListener.actionPerformed(actionEvent);
        }
    }
}

